/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.rooms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.hibernate.Transaction;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomFeatureType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.RoomDeptDAO;
import org.unitime.timetable.model.dao.RoomFeatureDAO;
import org.unitime.timetable.model.dao.RoomFeatureTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.rooms.RoomDetailsBackend;

@GwtRpcImplements(value=RoomInterface.UpdateRoomFeatureRequest.class)
public class UpdateRoomFeatureBackend
implements GwtRpcImplementation<RoomInterface.UpdateRoomFeatureRequest, RoomInterface.FeatureInterface> {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public RoomInterface.FeatureInterface execute(RoomInterface.UpdateRoomFeatureRequest request, SessionContext context) {
        if (request.hasSessionId()) {
            context = new EventAction.EventContext(context, request.getSessionId());
        }
        Transaction tx = null;
        RoomFeature f = null;
        try {
            org.hibernate.Session hibSession = RoomDeptDAO.getInstance().getSession();
            tx = hibSession.beginTransaction();
            if (request.hasFeature()) {
                if (request.hasFutureSessions()) {
                    for (Long id : request.getFutureSessions()) {
                        this.createOrUpdateFeature(request.getFeature(), request.getAddLocations(), request.getDropLocations(), id, hibSession, new EventAction.EventContext(context, context.getUser(), id), true);
                    }
                }
                f = this.createOrUpdateFeature(request.getFeature(), request.getAddLocations(), request.getDropLocations(), context.getUser().getCurrentAcademicSessionId(), hibSession, context, false);
            } else if (request.getDeleteFeatureId() != null) {
                if (request.hasFutureSessions()) {
                    for (Long id : request.getFutureSessions()) {
                        this.dropFeature(request.getDeleteFeatureId(), id, hibSession, new EventAction.EventContext(context, context.getUser(), id), true);
                    }
                }
                this.dropFeature(request.getDeleteFeatureId(), context.getUser().getCurrentAcademicSessionId(), hibSession, context, false);
            } else {
                throw new GwtRpcException("Bad request.");
            }
            RoomInterface.FeatureInterface feature = null;
            if (f != null) {
                feature = new RoomInterface.FeatureInterface(f.getUniqueId(), f.getAbbv(), f.getLabel());
                feature.setDescription(f.getDescription());
                if (f.getFeatureType() != null) {
                    feature.setType(new RoomInterface.FeatureTypeInterface(f.getFeatureType().getUniqueId(), f.getFeatureType().getReference(), f.getFeatureType().getLabel(), f.getFeatureType().isShowInEventManagement()));
                }
                if (f instanceof DepartmentRoomFeature) {
                    Department d = ((DepartmentRoomFeature)f).getDepartment();
                    feature.setDepartment(RoomDetailsBackend.wrap(d, null, null));
                    feature.setTitle((f.getDescription() == null || f.getDescription().isEmpty() ? f.getLabel() : f.getDescription()) + " (" + d.getName() + (String)(f.getFeatureType() == null ? "" : ", " + f.getFeatureType().getLabel()) + ")");
                } else {
                    feature.setTitle((f.getDescription() == null || f.getDescription().isEmpty() ? f.getLabel() : f.getDescription()) + (String)(f.getFeatureType() == null ? "" : " (" + f.getFeatureType().getLabel() + ")"));
                }
            }
            tx.commit();
            return feature;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (tx != null) {
                tx.rollback();
            }
            if (e instanceof GwtRpcException) {
                throw (GwtRpcException)e;
            }
            throw new GwtRpcException(e.getMessage());
        }
    }

    protected Department lookuDepartment(org.hibernate.Session hibSession, RoomInterface.DepartmentInterface original, boolean future, Long sessionId) {
        if (original == null) {
            return null;
        }
        if (future) {
            return Department.findByDeptCode(original.getDeptCode(), sessionId, hibSession);
        }
        return (Department)DepartmentDAO.getInstance().get(original.getId(), hibSession);
    }

    protected RoomFeature lookupFeature(org.hibernate.Session hibSession, RoomInterface.FeatureInterface original, boolean future, Long sessionId) {
        if (original == null) {
            return null;
        }
        if (future) {
            if (original.isDepartmental()) {
                return (RoomFeature)hibSession.createQuery("select f from DepartmentRoomFeature f, DepartmentRoomFeature o where o.uniqueId = :originalId and f.department.session.uniqueId = :sessionId and f.abbv = o.abbv and f.department.deptCode = o.department.deptCode", DepartmentRoomFeature.class).setParameter("sessionId", (Object)sessionId).setParameter("originalId", (Object)original.getId()).setCacheable(true).setMaxResults(1).uniqueResult();
            }
            return (RoomFeature)hibSession.createQuery("select f from GlobalRoomFeature f, GlobalRoomFeature o where o.uniqueId = :originalId and f.session.uniqueId = :sessionId and f.abbv = o.abbv", GlobalRoomFeature.class).setParameter("sessionId", (Object)sessionId).setParameter("originalId", (Object)original.getId()).setCacheable(true).setMaxResults(1).uniqueResult();
        }
        return (RoomFeature)RoomFeatureDAO.getInstance().get(original.getId(), hibSession);
    }

    protected RoomFeature lookupFeature(org.hibernate.Session hibSession, Long featureId, boolean future, Long sessionId) {
        if (featureId == null) {
            return null;
        }
        if (future) {
            RoomFeature feature = (RoomFeature)hibSession.createQuery("select f from DepartmentRoomFeature f, DepartmentRoomFeature o where o.uniqueId = :originalId and f.department.session.uniqueId = :sessionId and f.abbv = o.abbv and f.department.deptCode = o.department.deptCode", DepartmentRoomFeature.class).setParameter("sessionId", (Object)sessionId).setParameter("originalId", (Object)featureId).setCacheable(true).setMaxResults(1).uniqueResult();
            if (feature == null) {
                feature = (RoomFeature)hibSession.createQuery("select f from GlobalRoomFeature f, GlobalRoomFeature o where o.uniqueId = :originalId and f.session.uniqueId = :sessionId and f.abbv = o.abbv", GlobalRoomFeature.class).setParameter("sessionId", (Object)sessionId).setParameter("originalId", (Object)featureId).setCacheable(true).setMaxResults(1).uniqueResult();
            }
            return feature;
        }
        return (RoomFeature)RoomFeatureDAO.getInstance().get(featureId, hibSession);
    }

    protected Collection<Location> lookupLocations(org.hibernate.Session hibSession, List<Long> ids, boolean future, Long sessionId) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<Location>();
        }
        if (future) {
            return Location.lookupFutureLocations(hibSession, ids, sessionId);
        }
        return hibSession.createQuery("from Location where uniqueId in :ids", Location.class).setParameterList("ids", ids).list();
    }

    protected RoomFeature createOrUpdateFeature(RoomInterface.FeatureInterface feature, List<Long> add, List<Long> drop, Long sessionId, org.hibernate.Session hibSession, SessionContext context, boolean future) {
        RoomFeature rf;
        Department d;
        Department department = d = feature.isDepartmental() ? this.lookuDepartment(hibSession, feature.getDepartment(), future, sessionId) : null;
        if (feature.isDepartmental() && d == null) {
            return null;
        }
        RoomFeature roomFeature = rf = feature.getId() == null ? null : this.lookupFeature(hibSession, feature, future, sessionId);
        if (rf == null) {
            if (!future && feature.getId() != null) {
                throw new GwtRpcException(MESSAGES.errorRoomFeatureDoesNotExist(feature.getId()));
            }
            if (d == null) {
                context.checkPermission(Right.GlobalRoomFeatureAdd);
                rf = new GlobalRoomFeature();
                ((GlobalRoomFeature)rf).setSession((Session)SessionDAO.getInstance().get(sessionId));
            } else {
                context.checkPermission(d, Right.DepartmentRoomFeatureAdd);
                rf = new DepartmentRoomFeature();
                ((DepartmentRoomFeature)rf).setDepartment(d);
            }
            rf.setRooms(new HashSet<Location>());
        } else if (rf instanceof GlobalRoomFeature) {
            context.checkPermission(rf, Right.GlobalRoomFeatureEdit);
        } else {
            context.checkPermission(rf, Right.DepartmenalRoomFeatureEdit);
            ((DepartmentRoomFeature)rf).setDepartment(d);
        }
        for (RoomFeature roomFeature2 : RoomFeature.getAllGlobalRoomFeatures(sessionId)) {
            if (!roomFeature2.getLabel().equalsIgnoreCase(feature.getLabel()) && !roomFeature2.getAbbv().equalsIgnoreCase(feature.getAbbreviation()) || roomFeature2.getUniqueId().equals(rf.getUniqueId())) continue;
            throw new GwtRpcException(MESSAGES.errorRoomFeatureAlreadyExists(feature.getLabel(), ((Session)SessionDAO.getInstance().get(sessionId)).getLabel()));
        }
        if (rf instanceof DepartmentRoomFeature) {
            for (RoomFeature roomFeature3 : RoomFeature.getAllDepartmentRoomFeatures(d)) {
                if (!roomFeature3.getLabel().equalsIgnoreCase(feature.getLabel()) && !roomFeature3.getAbbv().equalsIgnoreCase(feature.getAbbreviation()) || roomFeature3.getUniqueId().equals(rf.getUniqueId())) continue;
                throw new GwtRpcException(MESSAGES.errorRoomFeatureAlreadyExists(feature.getLabel(), d.getSession().getLabel()));
            }
        }
        rf.setAbbv(feature.getAbbreviation());
        rf.setLabel(feature.getLabel());
        rf.setFeatureType(feature.getType() == null ? null : (RoomFeatureType)RoomFeatureTypeDAO.getInstance().get(feature.getType().getId(), hibSession));
        rf.setDescription(feature.getDescription());
        if (rf.getUniqueId() == null) {
            hibSession.persist((Object)rf);
        } else {
            hibSession.merge((Object)rf);
        }
        if (add != null && !add.isEmpty()) {
            for (Location location : this.lookupLocations(hibSession, add, future, sessionId)) {
                rf.getRooms().add(location);
                location.getFeatures().add(rf);
                hibSession.merge((Object)location);
            }
        }
        if (drop != null && !drop.isEmpty()) {
            for (Location location : this.lookupLocations(hibSession, drop, future, sessionId)) {
                rf.getRooms().remove(location);
                location.getFeatures().remove(rf);
                hibSession.merge((Object)location);
            }
        }
        hibSession.merge((Object)rf);
        ChangeLog.addChange(hibSession, context, rf, ChangeLog.Source.ROOM_FEATURE_EDIT, feature.getId() == null ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, null, rf instanceof DepartmentRoomFeature ? ((DepartmentRoomFeature)rf).getDepartment() : null);
        return rf;
    }

    protected boolean dropFeature(Long featureId, Long sessionId, org.hibernate.Session hibSession, SessionContext context, boolean future) {
        RoomFeature rf = this.lookupFeature(hibSession, featureId, future, sessionId);
        if (rf == null) {
            if (!future) {
                throw new GwtRpcException(MESSAGES.errorRoomFeatureDoesNotExist(featureId));
            }
            return false;
        }
        if (rf instanceof GlobalRoomFeature) {
            context.checkPermission(rf, Right.GlobalRoomFeatureDelete);
        } else {
            context.checkPermission(rf, Right.DepartmenalRoomFeatureDelete);
        }
        ChangeLog.addChange(hibSession, context, rf, ChangeLog.Source.ROOM_FEATURE_EDIT, ChangeLog.Operation.DELETE, null, rf instanceof DepartmentRoomFeature ? ((DepartmentRoomFeature)rf).getDepartment() : null);
        for (Location location : rf.getRooms()) {
            location.getFeatures().remove(rf);
            hibSession.merge((Object)location);
        }
        for (RoomFeaturePref p : hibSession.createQuery("from RoomFeaturePref p where p.roomFeature.uniqueId = :id", RoomFeaturePref.class).setParameter("id", (Object)rf.getUniqueId()).list()) {
            p.getOwner().getPreferences().remove(p);
            hibSession.remove((Object)p);
            hibSession.merge((Object)p.getOwner());
        }
        hibSession.remove((Object)rf);
        return true;
    }
}

