/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.pointintimedata;

import java.lang.reflect.InvocationTargetException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.PointInTimeDataReportsInterface;
import org.unitime.timetable.reports.pointintimedata.BasePointInTimeDataReports;
import org.unitime.timetable.security.SessionContext;

@GwtRpcImplements(value=PointInTimeDataReportsInterface.PITDQueriesRpcRequest.class)
public class PITDQueriesBackend
implements GwtRpcImplementation<PointInTimeDataReportsInterface.PITDQueriesRpcRequest, GwtRpcResponseList<PointInTimeDataReportsInterface.Report>> {
    @Autowired
    private SessionContext sessionContext;

    @Override
    @PreAuthorize(value="checkPermission('PointInTimeDataReports')")
    public GwtRpcResponseList<PointInTimeDataReportsInterface.Report> execute(PointInTimeDataReportsInterface.PITDQueriesRpcRequest request, SessionContext context) {
        GwtRpcResponseList<PointInTimeDataReportsInterface.Report> ret = new GwtRpcResponseList<PointInTimeDataReportsInterface.Report>();
        for (String key : BasePointInTimeDataReports.sPointInTimeDataReportRegister.keySet()) {
            Class rptCls = BasePointInTimeDataReports.sPointInTimeDataReportRegister.get(key);
            BasePointInTimeDataReports rpt = null;
            try {
                rpt = (BasePointInTimeDataReports)rptCls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            if (rpt == null) continue;
            PointInTimeDataReportsInterface.Report report = new PointInTimeDataReportsInterface.Report();
            report.setName(rpt.reportName());
            report.setDescription(rpt.reportDescription());
            for (BasePointInTimeDataReports.Parameter parameter : rpt.getParameters()) {
                PointInTimeDataReportsInterface.Parameter rptParam = new PointInTimeDataReportsInterface.Parameter();
                rptParam.setType(parameter.name());
                rptParam.setDefaultTextValue(parameter.defaultValue(this.sessionContext.getUser()));
                rptParam.setMultiSelect(parameter.allowMultiSelection());
                rptParam.setName(parameter.name());
                rptParam.setTextField(parameter.isTextField());
                report.addParameter(rptParam);
            }
            report.setFlags(255);
            report.setId(key);
            ret.add(report);
        }
        return ret;
    }
}

