/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor.survey;

import java.util.Date;
import java.util.Iterator;
import org.hibernate.Session;
import org.unitime.timetable.gwt.client.instructor.survey.InstructorSurveyInterface;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.InstructorSurvey;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=InstructorSurveyInterface.InstructorSurveyApplyRequest.class)
public class ApplyInstructorSurveyBackend
implements GwtRpcImplementation<InstructorSurveyInterface.InstructorSurveyApplyRequest, GwtRpcResponseNull> {
    @Override
    public GwtRpcResponseNull execute(InstructorSurveyInterface.InstructorSurveyApplyRequest request, SessionContext context) {
        DepartmentalInstructor di = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(request.getInstructorId());
        InstructorSurvey is = InstructorSurvey.getInstructorSurvey(di);
        Session hibSession = DepartmentalInstructorDAO.getInstance().getSession();
        context.checkPermission(di, Right.InstructorPreferences);
        Iterator<Preference> i = di.getPreferences().iterator();
        while (i.hasNext()) {
            Preference p = i.next();
            if (p instanceof TimePref) {
                i.remove();
                continue;
            }
            if (p instanceof RoomPref) {
                i.remove();
                continue;
            }
            if (p instanceof RoomFeaturePref) {
                i.remove();
                continue;
            }
            if (p instanceof RoomGroupPref) {
                i.remove();
                continue;
            }
            if (p instanceof BuildingPref) {
                i.remove();
                continue;
            }
            if (!(p instanceof DistributionPref) || !((DistributionPref)p).getDistributionType().effectiveSurvey()) continue;
            i.remove();
        }
        for (Preference p : is.getPreferences()) {
            if (p instanceof RoomPref && !di.getAvailableRooms().contains(((RoomPref)p).getRoom()) || p instanceof RoomFeaturePref && !di.getAvailableRoomFeatures().contains(((RoomFeaturePref)p).getRoomFeature()) || p instanceof RoomGroupPref && !di.getAvailableRoomGroups().contains(((RoomGroupPref)p).getRoomGroup()) || p instanceof BuildingPref && !di.getAvailableBuildings().contains(((BuildingPref)p).getBuilding()) || p instanceof DistributionPref && !((DistributionPref)p).getDistributionType().effectiveSurvey()) continue;
            Preference x = (Preference)p.clone();
            x.setOwner(di);
            di.getPreferences().add(x);
        }
        if (is.getEmail() != null && !is.getEmail().isEmpty()) {
            di.setEmail(is.getEmail());
        }
        hibSession.merge((Object)di);
        is.setAppliedDeptCode(di.getDepartment().getDeptCode());
        is.setApplied(new Date());
        hibSession.flush();
        return new GwtRpcResponseNull();
    }
}

