/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import java.util.Calendar;
import java.util.Date;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.command.server.GwtRpcLogging;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.util.DateUtils;

@GwtRpcImplements(value=InstructorInterface.PatternDatesRequest.class)
@GwtRpcLogging(value=GwtRpcLogging.Level.DISABLED)
public class PatternDatesBackend
implements GwtRpcImplementation<InstructorInterface.PatternDatesRequest, GwtRpcResponseList<EventInterface.SessionMonth>> {
    @Override
    public GwtRpcResponseList<EventInterface.SessionMonth> execute(InstructorInterface.PatternDatesRequest request, SessionContext context) {
        Session session = (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId());
        return PatternDatesBackend.listMonths(session);
    }

    public static GwtRpcResponseList<EventInterface.SessionMonth> listMonths(Session session) {
        GwtRpcResponseList<EventInterface.SessionMonth> response = new GwtRpcResponseList<EventInterface.SessionMonth>();
        Calendar calendar = Calendar.getInstance();
        int firstDayOfWeek = ApplicationProperty.TimeGridFirstDayOfWeek.intValue();
        int firstDay = 2;
        switch (firstDayOfWeek) {
            case 0: {
                firstDay = 2;
                break;
            }
            case 1: {
                firstDay = 3;
                break;
            }
            case 2: {
                firstDay = 4;
                break;
            }
            case 3: {
                firstDay = 5;
                break;
            }
            case 4: {
                firstDay = 6;
                break;
            }
            case 5: {
                firstDay = 7;
                break;
            }
            case 6: {
                firstDay = 1;
            }
        }
        for (int month = session.getPatternStartMonth(); month <= session.getPatternEndMonth(); ++month) {
            calendar.setTime(DateUtils.getDate(1, month, session.getSessionStartYear()));
            EventInterface.SessionMonth m = new EventInterface.SessionMonth(calendar.get(1), calendar.get(2));
            int nrDays = calendar.getActualMaximum(5);
            for (int i = 0; i < nrDays; ++i) {
                int dayInv;
                switch (session.getHoliday(1 + i, month)) {
                    case 2: {
                        m.setFlag(i, EventInterface.SessionMonth.Flag.BREAK);
                        break;
                    }
                    case 1: {
                        m.setFlag(i, EventInterface.SessionMonth.Flag.HOLIDAY);
                    }
                }
                if (PatternDatesBackend.compare(calendar.getTime(), session.getSessionBeginDateTime()) == 0) {
                    m.setFlag(i, EventInterface.SessionMonth.Flag.START);
                }
                if (PatternDatesBackend.compare(calendar.getTime(), session.getClassesEndDateTime()) == 0) {
                    m.setFlag(i, EventInterface.SessionMonth.Flag.END);
                }
                if (PatternDatesBackend.compare(calendar.getTime(), session.getSessionBeginDateTime()) >= 0 && PatternDatesBackend.compare(calendar.getTime(), session.getClassesEndDateTime()) <= 0) {
                    m.setFlag(i, EventInterface.SessionMonth.Flag.CLASSES);
                }
                if ((dayInv = (7 + calendar.get(7) - firstDay) % 7) >= 5) {
                    m.setFlag(i, EventInterface.SessionMonth.Flag.WEEKEND);
                }
                calendar.add(6, 1);
            }
            response.add(m);
        }
        return response;
    }

    private static int compare(Date d1, Date d2) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d1);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(d2);
        int cmp = PatternDatesBackend.compare(c1, c2, 1);
        if (cmp != 0) {
            return cmp;
        }
        return PatternDatesBackend.compare(c1, c2, 6);
    }

    private static int compare(Calendar c1, Calendar c2, int field) {
        return Integer.valueOf(c1.get(field)).compareTo(c2.get(field));
    }
}

