/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.InstructorSurvey;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.instructor.InstructorsTableBuilder;
import org.unitime.timetable.webutil.BackTracker;

@GwtRpcImplements(value=InstructorInterface.InstructorsRequest.class)
public class InstructorsBackend
implements GwtRpcImplementation<InstructorInterface.InstructorsRequest, InstructorInterface.InstructorsResponse> {
    protected static CourseMessages MESSAGES = Localization.create(CourseMessages.class);

    @Override
    public InstructorInterface.InstructorsResponse execute(InstructorInterface.InstructorsRequest request, SessionContext context) {
        String deptId = request.getFilter().getParameterValue("deptId");
        if (deptId == null || deptId.isEmpty()) {
            throw new GwtRpcException(MESSAGES.errorRequiredDepartment());
        }
        Department department = (Department)DepartmentDAO.getInstance().get(Long.valueOf(deptId));
        context.checkPermission(department, Right.Instructors);
        context.setAttribute(SessionAttribute.DepartmentId, (Object)deptId);
        context.getUser().setProperty("Instructoros.positions", request.getFilter().getParameterValue("positions"));
        InstructorInterface.InstructorsResponse response = new InstructorInterface.InstructorsResponse();
        response.setDepartmentId(Long.valueOf(deptId));
        InstructorsTableBuilder builder = new InstructorsTableBuilder(context, request.getBackType(), request.getBackId());
        response.setTable(builder.generateTableForDepartment(department, request.getFilter(), context));
        if (response.getTable() != null && response.getTable().hasLines() && context.hasPermission(department, Right.InstructorsExportPdf)) {
            response.addOperation("export");
        }
        if (context.hasPermission(department, Right.InstructorSurveyAdmin) && InstructorSurvey.hasInstructorSurveys(department.getUniqueId())) {
            response.addOperation("export-surveys");
        }
        if (context.hasPermission(department, Right.ManageInstructors)) {
            response.addOperation("manage-instructors");
        }
        if (context.hasPermission(department, Right.InstructorAdd)) {
            response.addOperation("add-instructor");
        }
        BackTracker.markForBack(context, "instructors?deptId=" + department.getUniqueId(), MESSAGES.backInstructors(department.getDeptCode() + " - " + department.getName()), true, true);
        return response;
    }
}

