/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.InstructorAttributeType;
import org.unitime.timetable.model.dao.InstructorAttributeTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=InstructorInterface.InstructorAttributePropertiesRequest.class)
public class InstructorAttributePropertiesBackend
implements GwtRpcImplementation<InstructorInterface.InstructorAttributePropertiesRequest, InstructorInterface.InstructorAttributePropertiesInterface> {
    @Override
    public InstructorInterface.InstructorAttributePropertiesInterface execute(InstructorInterface.InstructorAttributePropertiesRequest request, SessionContext context) {
        context.checkPermission(Right.InstructorAttributes);
        InstructorInterface.InstructorAttributePropertiesInterface response = new InstructorInterface.InstructorAttributePropertiesInterface();
        for (Department department : Department.getUserDepartments(context.getUser())) {
            InstructorInterface.DepartmentInterface d = new InstructorInterface.DepartmentInterface();
            d.setId(department.getUniqueId());
            d.setAbbreviation(department.getAbbreviation());
            d.setDeptCode(department.getDeptCode());
            d.setLabel(department.getName());
            d.setTitle(department.getLabel());
            d.setCanSeeAttributes(context.hasPermission(department, Right.InstructorAttributes));
            d.setCanAddAttribute(context.hasPermission(department, Right.InstructorAttributeAdd));
            response.addDepartment(d);
        }
        for (InstructorAttributeType type : InstructorAttributeTypeDAO.getInstance().getSession().createQuery("from InstructorAttributeType order by label", InstructorAttributeType.class).setCacheable(true).list()) {
            InstructorInterface.AttributeTypeInterface t = new InstructorInterface.AttributeTypeInterface();
            t.setId(type.getUniqueId());
            t.setAbbreviation(type.getReference());
            t.setLabel(type.getLabel());
            t.setConjunctive(type.isConjunctive());
            t.setRequired(type.isRequired());
            response.addAttributeType(t);
        }
        response.setCanAddGlobalAttribute(context.hasPermission(Right.InstructorGlobalAttributeEdit));
        if (response.getDepartments().size() == 1) {
            response.setLastDepartmentId(response.getDepartments().get(0).getId());
        } else {
            String deptId = (String)context.getAttribute(SessionAttribute.DepartmentId);
            if (deptId != null) {
                try {
                    response.setLastDepartmentId(Long.valueOf(deptId));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return response;
    }
}

