/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.exams;

import java.util.ArrayList;
import java.util.TreeSet;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.util.HtmlUtils;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.client.sectioning.ExaminationEnrollmentTable;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.exams.ExaminationEnrollmentsBackend;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;
import org.unitime.timetable.solver.service.SolverService;

@GwtRpcImplements(value=ExaminationEnrollmentTable.ExaminationScheduleRpcRequest.class)
public class ExaminationScheduleBackend
implements GwtRpcImplementation<ExaminationEnrollmentTable.ExaminationScheduleRpcRequest, ExaminationEnrollmentTable.ExaminationScheduleRpcResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;

    @Override
    public ExaminationEnrollmentTable.ExaminationScheduleRpcResponse execute(ExaminationEnrollmentTable.ExaminationScheduleRpcRequest request, SessionContext context) {
        Session hibSession = ExamDAO.getInstance().getSession();
        Exam exam = (Exam)ExamDAO.getInstance().get(request.getExamId());
        context.checkPermission(exam, Right.ExaminationDetail);
        ExamSolverProxy proxy = this.examinationSolverService.getSolver();
        if (proxy != null && !exam.getExamType().getUniqueId().equals(proxy.getExamTypeId())) {
            proxy = null;
        }
        ExaminationEnrollmentTable.ExaminationScheduleRpcResponse response = new ExaminationEnrollmentTable.ExaminationScheduleRpcResponse();
        response.setExamType(exam.getExamType().getLabel());
        ArrayList exams = new ArrayList();
        exams.addAll(hibSession.createQuery("select o, enrl.courseOffering from ExamOwner o, StudentClassEnrollment enrl inner join enrl.courseOffering co where o.ownerType = :type and o.ownerId = co.uniqueId and enrl.student.uniqueId = :studentId and o.exam.examType.uniqueId = :examTypeId", Object[].class).setParameter("type", (Object)1).setParameter("studentId", (Object)request.getStudentId()).setParameter("examTypeId", (Object)exam.getExamType().getUniqueId()).setCacheable(true).list());
        exams.addAll(hibSession.createQuery("select o, enrl.courseOffering from ExamOwner o, StudentClassEnrollment enrl inner join enrl.courseOffering.instructionalOffering io where o.ownerType = :type and o.ownerId = io.uniqueId and enrl.student.uniqueId = :studentId and o.exam.examType.uniqueId = :examTypeId", Object[].class).setParameter("type", (Object)0).setParameter("studentId", (Object)request.getStudentId()).setParameter("examTypeId", (Object)exam.getExamType().getUniqueId()).setCacheable(true).list());
        exams.addAll(hibSession.createQuery("select o, enrl.courseOffering from ExamOwner o, StudentClassEnrollment enrl inner join enrl.clazz.schedulingSubpart.instrOfferingConfig cfg where o.ownerType = :type and o.ownerId = cfg.uniqueId and enrl.student.uniqueId = :studentId and o.exam.examType.uniqueId = :examTypeId", Object[].class).setParameter("type", (Object)2).setParameter("studentId", (Object)request.getStudentId()).setParameter("examTypeId", (Object)exam.getExamType().getUniqueId()).setCacheable(true).list());
        exams.addAll(hibSession.createQuery("select o, enrl.courseOffering from ExamOwner o, StudentClassEnrollment enrl inner join enrl.clazz c where o.ownerType = :type and o.ownerId = c.uniqueId and enrl.student.uniqueId = :studentId and o.exam.examType.uniqueId = :examTypeId", Object[].class).setParameter("type", (Object)3).setParameter("studentId", (Object)request.getStudentId()).setParameter("examTypeId", (Object)exam.getExamType().getUniqueId()).setCacheable(true).list());
        for (Object[] o : exams) {
            ExamOwner owner = (ExamOwner)o[0];
            CourseOffering co = (CourseOffering)o[1];
            Exam x = owner.getExam();
            EventInterface.RelatedObjectInterface related = new EventInterface.RelatedObjectInterface();
            related.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Examination);
            related.setUniqueId(x.getUniqueId());
            related.setName(x.getName() == null ? x.generateName() : x.getName());
            related.addCourseId(co.getUniqueId());
            related.addCourseName(co.getCourseName());
            related.addCourseTitle(co.getTitle());
            related.setInstruction(x.getExamType().getLabel());
            related.setInstructionType(x.getExamType().getType());
            if (owner.getOwnerType() == 3) {
                Class_ clazz = (Class_)owner.getOwnerObject();
                related.setSectionNumber(clazz.getSectionNumberString(hibSession));
                related.setInstruction(clazz.getSchedulingSubpart().getItype().getAbbv());
                if (clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod() != null) {
                    related.setInstruction(related.getInstruction() + " (" + clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod().getLabel() + ")");
                }
                if (clazz.getClassSuffix() != null) {
                    related.addExternalId(clazz.getClassSuffix());
                }
            } else if (owner.getOwnerType() == 2) {
                InstrOfferingConfig config = (InstrOfferingConfig)owner.getOwnerObject();
                related.setSectionNumber(config.getName());
                related.setInstruction(MESSAGES.colConfig());
                if (config.getInstructionalMethod() != null) {
                    related.setInstruction(related.getInstruction() + " (" + config.getInstructionalMethod().getLabel() + ")");
                }
            } else if (owner.getOwnerType() == 1) {
                related.setInstruction(MESSAGES.colCourse());
            } else if (owner.getOwnerType() == 0) {
                related.setInstruction(MESSAGES.colOffering());
            }
            if (context != null && context.hasPermission(x, Right.ExaminationDetail)) {
                related.setDetailPage("examDetail.action?examId=" + x.getUniqueId());
            }
            for (DepartmentalInstructor i : x.getInstructors()) {
                EventInterface.ContactInterface instructor = new EventInterface.ContactInterface();
                instructor.setFirstName(i.getFirstName());
                instructor.setMiddleName(i.getMiddleName());
                instructor.setLastName(i.getLastName());
                instructor.setAcademicTitle(i.getAcademicTitle());
                instructor.setExternalId(i.getExternalUniqueId());
                instructor.setEmail(i.getEmail());
                related.addInstructor(instructor);
            }
            ExamAssignmentInfo assignment = null;
            ExamPeriod period = null;
            if (proxy != null) {
                assignment = proxy.getAssignmentInfo(x.getUniqueId());
                period = assignment == null ? null : assignment.getPeriod();
            } else {
                assignment = new ExamAssignmentInfo(x, false);
                period = x.getAssignedPeriod();
            }
            if (period != null) {
                related.setDate(period.getStartDateLabel());
                related.setDayOfYear(period.getDateOffset());
                related.setStartSlot(period.getStartSlot());
                related.setEndSlot(period.getEndSlot());
                int printOffset = x.getPrintOffset() == null ? 0 : x.getPrintOffset();
                related.setTime(period.getStartTimeLabel(printOffset) + " - " + period.getEndTimeLabel(x.getLength(), printOffset));
            }
            if (assignment != null && assignment.getRooms() != null) {
                for (ExamRoomInfo r : assignment.getRooms()) {
                    EventInterface.ResourceInterface location = new EventInterface.ResourceInterface();
                    location.setType(EventInterface.ResourceType.ROOM);
                    location.setId(r.getLocationId());
                    location.setName(r.getName());
                    location.setSize(r.getCapacity());
                    location.setRoomType(r.getLocation().getRoomTypeLabel());
                    location.setBreakTime(r.getLocation().getEffectiveBreakTime());
                    location.setMessage(r.getLocation().getEventMessage());
                    location.setIgnoreRoomCheck(r.getLocation().isIgnoreRoomCheck());
                    location.setDisplayName(r.getLocation().getDisplayName());
                    location.setPartitionParentId(r.getLocation().getPartitionParentId());
                    location.setEventEmail(r.getLocation().effectiveEventEmail());
                    related.addLocation(location);
                }
            }
            Object conflicts = "";
            if (period != null) {
                int t2;
                int t1;
                int nrTravelSlotsClassEvent = ApplicationProperty.ExaminationTravelTimeClass.intValue();
                int nrTravelSlotsCourseEvent = ApplicationProperty.ExaminationTravelTimeCourse.intValue();
                TreeSet events = new TreeSet();
                for (int t22 = 0; t22 < ExamOwner.sOwnerTypes.length; ++t22) {
                    events.addAll(hibSession.createQuery("select distinct m1.event from StudentClassEnrollment s1, ClassEvent e1 inner join e1.meetings m1, Exam e2 inner join e2.owners o2, StudentClassEnrollment s2 where e2.uniqueId = :examId and e1.clazz = s1.clazz and s1.student = s2.student and s1.student.uniqueId = :studentId" + ExaminationEnrollmentsBackend.where(t22, 2) + " and m1.meetingDate = :meetingDate and m1.startPeriod < :endSlot and :startSlot < m1.stopPeriod", Event.class).setParameter("examId", (Object)x.getUniqueId()).setParameter("studentId", (Object)request.getStudentId()).setParameter("meetingDate", (Object)period.getStartDate()).setParameter("startSlot", (Object)(period.getStartSlot() - nrTravelSlotsClassEvent)).setParameter("endSlot", (Object)(period.getEndSlot() + nrTravelSlotsClassEvent)).list());
                }
                for (t1 = 0; t1 < ExamOwner.sOwnerTypes.length; ++t1) {
                    for (t2 = 0; t2 < ExamOwner.sOwnerTypes.length; ++t2) {
                        events.addAll(hibSession.createQuery("select distinct m1.event from StudentClassEnrollment s1, CourseEvent e1 inner join e1.meetings m1 inner join e1.relatedCourses o1, Exam e2 inner join e2.owners o2, StudentClassEnrollment s2 where e2.uniqueId = :examId and s1.student = s2.student and s1.student.uniqueId = :studentId" + ExaminationEnrollmentsBackend.where(t1, 1) + ExaminationEnrollmentsBackend.where(t2, 2) + " and m1.meetingDate = :meetingDate and m1.startPeriod < :endSlot and :startSlot < m1.stopPeriod and e1.reqAttendance = true and m1.approvalStatus = 1", Event.class).setParameter("examId", (Object)x.getUniqueId()).setParameter("studentId", (Object)request.getStudentId()).setParameter("meetingDate", (Object)period.getStartDate()).setParameter("startSlot", (Object)(period.getStartSlot() - nrTravelSlotsCourseEvent)).setParameter("endSlot", (Object)(period.getEndSlot() + nrTravelSlotsCourseEvent)).list());
                    }
                }
                for (t1 = 0; t1 < ExamOwner.sOwnerTypes.length; ++t1) {
                    for (t2 = 0; t2 < ExamOwner.sOwnerTypes.length; ++t2) {
                        events.addAll(hibSession.createQuery("select distinct m1.event from StudentClassEnrollment s1, ExamEvent e1 inner join e1.meetings m1 inner join e1.exam.owners o1, Exam e2 inner join e2.owners o2, StudentClassEnrollment s2 where e2.uniqueId = :examId and s1.student = s2.student and s1.student.uniqueId = :studentId" + ExaminationEnrollmentsBackend.where(t1, 1) + ExaminationEnrollmentsBackend.where(t2, 2) + " and m1.meetingDate = :meetingDate and m1.startPeriod < :endSlot and :startSlot < m1.stopPeriod and e1.exam.examType.uniqueId != :examTypeId and m1.approvalStatus = 1", Event.class).setParameter("examId", (Object)x.getUniqueId()).setParameter("studentId", (Object)request.getStudentId()).setParameter("meetingDate", (Object)period.getStartDate()).setParameter("startSlot", (Object)(period.getStartSlot() - nrTravelSlotsCourseEvent)).setParameter("endSlot", (Object)(period.getEndSlot() + nrTravelSlotsCourseEvent)).setParameter("examTypeId", (Object)period.getExamType().getUniqueId()).list());
                    }
                }
                for (Event e : events) {
                    conflicts = (String)conflicts + (((String)conflicts).isEmpty() ? "" : "<br>") + "<span class='dc' title='" + HtmlUtils.htmlEscape((String)(e.getEventTypeAbbv() + " " + e.getEventName())) + "'>" + HtmlUtils.htmlEscape((String)e.getEventName()) + "</span>";
                }
            }
            if (assignment != null) {
                ExamAssignment other;
                for (ExamAssignmentInfo.DirectConflict conflict : assignment.getDirectConflicts()) {
                    other = conflict.getOtherExam();
                    if (other == null || !conflict.getStudents().contains(request.getStudentId())) continue;
                    for (ExamInfo.ExamSectionInfo section : other.getSections()) {
                        if (!section.getStudentIds().contains(request.getStudentId())) continue;
                        conflicts = (String)conflicts + (((String)conflicts).isEmpty() ? "" : "<br>") + "<span class='dc' title='" + HtmlUtils.htmlEscape((String)("Direct " + other.getExamName())) + "'>" + HtmlUtils.htmlEscape((String)(section.getSubject() + " " + section.getCourseNbr())) + "</span>";
                    }
                }
                for (ExamAssignmentInfo.BackToBackConflict conflict : assignment.getBackToBackConflicts()) {
                    other = conflict.getOtherExam();
                    if (other == null || !conflict.getStudents().contains(request.getStudentId())) continue;
                    for (ExamInfo.ExamSectionInfo section : other.getSections()) {
                        if (!section.getStudentIds().contains(request.getStudentId())) continue;
                        conflicts = (String)conflicts + (((String)conflicts).isEmpty() ? "" : "<br>") + "<span class='b2b' title='" + HtmlUtils.htmlEscape((String)("Back-To-Back " + other.getExamName())) + "'>" + HtmlUtils.htmlEscape((String)(section.getSubject() + " " + section.getCourseNbr())) + "</span>";
                    }
                }
                for (ExamAssignmentInfo.MoreThanTwoADayConflict conflict : assignment.getMoreThanTwoADaysConflicts()) {
                    if (!conflict.getStudents().contains(request.getStudentId())) continue;
                    Object name = "";
                    Object first = "";
                    Object next = "";
                    for (ExamAssignment other2 : conflict.getOtherExams()) {
                        name = (String)name + (((String)name).isEmpty() ? "" : ", ") + other2.getExamName();
                        for (ExamInfo.ExamSectionInfo section : other2.getSections()) {
                            if (!section.getStudentIds().contains(request.getStudentId())) continue;
                            String course = section.getSubject() + " " + section.getCourseNbr();
                            if (((String)first).isEmpty() || course.compareTo((String)first) < 0) {
                                first = course;
                            }
                            if (owner.getCourse().getCourseName().compareTo(course) >= 0 || !((String)next).isEmpty() && course.compareTo((String)next) >= 0) continue;
                            next = course;
                        }
                    }
                    conflicts = (String)conflicts + (((String)conflicts).isEmpty() ? "" : "<br>") + "<span class='m2d' title='" + HtmlUtils.htmlEscape((String)(">2 A Day " + (String)name)) + "'>" + HtmlUtils.htmlEscape((String)(((String)next).isEmpty() ? first : next)) + "</span>";
                }
            }
            if (!((String)conflicts).isEmpty()) {
                related.setConflicts((String)conflicts);
            }
            response.addExam(related);
        }
        return response;
    }
}

