/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.exams;

import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.exams.ExamsInterface;
import org.unitime.timetable.gwt.client.offerings.OfferingsInterface;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.webutil.BackTracker;

@GwtRpcImplements(value=ExamsInterface.ExamDistributionsFilterRequest.class)
public class ExamDistributionsFilterBackend
implements GwtRpcImplementation<ExamsInterface.ExamDistributionsFilterRequest, OfferingsInterface.DistributionsFilterResponse> {
    protected static CourseMessages MESSAGES = Localization.create(CourseMessages.class);
    protected static ExaminationMessages XMSG = Localization.create(ExaminationMessages.class);
    protected static GwtMessages GWT = Localization.create(GwtMessages.class);

    @Override
    public OfferingsInterface.DistributionsFilterResponse execute(ExamsInterface.ExamDistributionsFilterRequest request, SessionContext context) {
        context.checkPermission(Right.ExaminationDistributionPreferences);
        OfferingsInterface.DistributionsFilterResponse filter = new OfferingsInterface.DistributionsFilterResponse();
        FilterInterface.FilterParameterInterface preference = new FilterInterface.FilterParameterInterface();
        preference.setName("prefLevel");
        preference.setType("list");
        preference.setMultiSelect(true);
        preference.setCollapsible(true);
        preference.setLabel(MESSAGES.propertyDistributionPreference());
        for (PreferenceLevel preferenceLevel : PreferenceLevel.getPreferenceLevelList(false)) {
            preference.addOption(preferenceLevel.getPrefId().toString(), preferenceLevel.getPrefName());
        }
        preference.setDefaultValue(context.getUser().getProperty("ExamDistributions.prefLevel", ""));
        filter.addParameter(preference);
        FilterInterface.FilterParameterInterface distType = new FilterInterface.FilterParameterInterface();
        distType.setName("distType");
        distType.setType("list");
        distType.setMultiSelect(true);
        distType.setCollapsible(true);
        distType.setLabel(MESSAGES.propertyDistributionType());
        for (DistributionType distributionType : DistributionType.findAll(false, true, true)) {
            distType.addOption(distributionType.getUniqueId().toString(), distributionType.getLabel());
        }
        distType.setDefaultValue(context.getUser().getProperty("ExamDistributions.distType", ""));
        filter.addParameter(distType);
        FilterInterface.FilterParameterInterface filterParameterInterface = new FilterInterface.FilterParameterInterface();
        filterParameterInterface.setName("examType");
        filterParameterInterface.setType("list");
        filterParameterInterface.setMultiSelect(false);
        filterParameterInterface.setCollapsible(false);
        filterParameterInterface.setLabel(XMSG.propExamType());
        for (ExamType type : ExamType.findAllUsedApplicable(context.getUser(), DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable)) {
            filterParameterInterface.addOption(type.getUniqueId().toString(), type.getLabel());
        }
        Object object = context.getAttribute(SessionAttribute.ExamType);
        filterParameterInterface.setDefaultValue(object == null ? null : object.toString());
        if (!filterParameterInterface.hasDefaultValue() && filterParameterInterface.hasOptions()) {
            filterParameterInterface.setDefaultValue(filterParameterInterface.getOptions().get(0).getValue());
        }
        filter.addParameter(filterParameterInterface);
        FilterInterface.FilterParameterInterface subjectArea = new FilterInterface.FilterParameterInterface();
        subjectArea.setName("subjectArea");
        subjectArea.setType("list");
        subjectArea.setMultiSelect(true);
        subjectArea.setCollapsible(false);
        subjectArea.setLabel(MESSAGES.filterSubject());
        subjectArea.addOption("-1", GWT.itemAllSubjectAreas());
        if (ApplicationProperty.OfferingsFilterSubjectTitle.isTrue()) {
            for (SubjectArea subject : SubjectArea.getUserSubjectAreas(context.getUser())) {
                subjectArea.addOption(subject.getUniqueId().toString(), subject.getLabel());
            }
        } else {
            for (SubjectArea subject : SubjectArea.getUserSubjectAreas(context.getUser())) {
                subjectArea.addOption(subject.getUniqueId().toString(), subject.getSubjectAreaAbbreviation());
            }
        }
        subjectArea.setDefaultValue((String)context.getAttribute(SessionAttribute.OfferingsSubjectArea));
        subjectArea.setEnterToSubmit(true);
        filter.addParameter(subjectArea);
        FilterInterface.FilterParameterInterface courseNbr = new FilterInterface.FilterParameterInterface();
        courseNbr.setName("courseNbr");
        courseNbr.setLabel(MESSAGES.filterCourseNumber());
        courseNbr.setType("courseNumber");
        courseNbr.setDefaultValue((String)context.getAttribute(SessionAttribute.OfferingsCourseNumber));
        courseNbr.setCollapsible(false);
        courseNbr.setConfig("subjectId=${subjectArea};notOffered=false;");
        courseNbr.setEnterToSubmit(true);
        filter.addParameter(courseNbr);
        if (subjectArea.getDefaultValue() == null && courseNbr.getDefaultValue() == null) {
            subjectArea.setDefaultValue((String)context.getAttribute(SessionAttribute.ClassesSubjectAreas));
            courseNbr.setDefaultValue((String)context.getAttribute(SessionAttribute.ClassesCourseNumber));
        }
        filter.setSticky(CommonValues.Yes.eq(UserProperty.StickyTables.get(context.getUser())));
        filter.setMaxSubjectsToSearchAutomatically(ApplicationProperty.MaxSubjectsToSearchAutomatically.intValue());
        filter.setCanAdd(context.hasPermission(Right.ExaminationDistributionPreferenceAdd));
        filter.setSessionId(context.getUser().getCurrentAcademicSessionId());
        BackTracker.markForBack(context, null, null, false, true);
        return filter;
    }
}

