/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.offerings.OfferingsInterface;
import org.unitime.timetable.gwt.client.offerings.PrefGroupEditInterface;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.InstructorAttributePref;
import org.unitime.timetable.model.InstructorPref;
import org.unitime.timetable.model.LearningManagementSystemInfo;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.SectioningInfo;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.ClassCourseComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.comparators.InstructorComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.ClassEditBackend;
import org.unitime.timetable.server.courses.TableBuilder;
import org.unitime.timetable.solver.CachedClassAssignmentProxy;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamAssignmentProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.duration.DurationModel;
import org.unitime.timetable.webutil.Navigation;
import org.unitime.timetable.webutil.RequiredTimeTable;

public class InstructionalOfferingTableBuilder
extends TableBuilder {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static Formats.Format<Date> sDateFormat = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
    protected static DecimalFormat sRoomRatioFormat = new DecimalFormat("0.00");
    protected String disabledColor = "gray";
    private boolean showLabel;
    private boolean showDivSec;
    private boolean showDemand;
    private boolean showProjectedDemand;
    private boolean showMinPerWk;
    private boolean showLimit;
    private boolean showSnapshotLimit;
    private boolean showRoomRatio;
    private boolean showFundingDepartment;
    private boolean showManager;
    private boolean showDatePattern;
    private boolean showTimePattern;
    private boolean showPreferences;
    private boolean showInstructor;
    private boolean showTimetable;
    private boolean showCredit;
    private boolean showSubpartCredit;
    private boolean showSchedulePrintNote;
    private boolean showNote;
    private boolean showTitle;
    private boolean showConsent;
    private boolean showExam;
    private boolean showExamName = true;
    private boolean showExamTimetable;
    private boolean showInstructorAssignment;
    private boolean showLms;
    private boolean showWaitlistMode;
    private String filterWaitlist;
    private boolean iDisplayDistributionPrefs = true;
    private boolean iDisplayTimetable = true;
    private boolean iDisplayConflicts = false;
    private boolean iDisplayInstructorPrefs = true;
    private boolean iDisplayDatePatternDifferentWarning = false;
    private Comparator iClassComparator = new ClassComparator(3);
    private boolean displayConfigOpButtons = false;
    private Boolean iSessionHasEnrollments = null;
    public Boolean iShowOriginalDivSecs = null;

    public InstructionalOfferingTableBuilder(SessionContext context, String backType, String backId) {
        super(context, backType, backId);
    }

    protected boolean sessionHasEnrollments(Long sessionId) {
        if (this.iSessionHasEnrollments == null) {
            this.iSessionHasEnrollments = StudentClassEnrollment.sessionHasEnrollments(sessionId);
        }
        return this.iSessionHasEnrollments;
    }

    public void setDisplayConfigOpButtons(boolean displayConfigOpButtons) {
        this.displayConfigOpButtons = displayConfigOpButtons;
    }

    public boolean getDisplayConfigOpButtons() {
        return this.displayConfigOpButtons;
    }

    public void setDisplayDistributionPrefs(boolean displayDistributionPrefs) {
        this.iDisplayDistributionPrefs = displayDistributionPrefs;
    }

    public boolean getDisplayDistributionPrefs() {
        return this.iDisplayDistributionPrefs;
    }

    public void setDisplayInstructorPrefs(boolean displayInstructorPrefs) {
        this.iDisplayInstructorPrefs = displayInstructorPrefs;
    }

    public boolean getDisplayInstructorPrefs() {
        return this.iDisplayInstructorPrefs && this.isShowInstructorAssignment();
    }

    public void setDisplayTimetable(boolean displayTimetable) {
        this.iDisplayTimetable = displayTimetable;
    }

    public boolean getDisplayTimetable() {
        return this.iDisplayTimetable;
    }

    public void setDisplayConflicts(boolean displayConflicts) {
        this.iDisplayConflicts = displayConflicts;
    }

    public boolean getDisplayConflicts() {
        return this.iDisplayConflicts;
    }

    public void setDisplayDatePatternDifferentWarning(boolean displayDatePatternDifferentWarning) {
        this.iDisplayDatePatternDifferentWarning = displayDatePatternDifferentWarning;
    }

    public boolean getDisplayDatePatternDifferentWarning() {
        return this.iDisplayDatePatternDifferentWarning;
    }

    public int getPreferenceColumns() {
        if (this.isShowPreferences()) {
            return 2 + (this.getDisplayDistributionPrefs() ? 1 : 0) + (this.getDisplayInstructorPrefs() ? 2 : 0);
        }
        return this.getDisplayInstructorPrefs() ? 2 : 0;
    }

    public void setShowOriginalDivSecs(boolean showOriginalDivSecs) {
        this.iShowOriginalDivSecs = showOriginalDivSecs;
    }

    public boolean isShowOriginalDivSecs() {
        if (this.iShowOriginalDivSecs == null) {
            return ApplicationProperty.ClassSetupEditExternalIds.isTrue();
        }
        return this.iShowOriginalDivSecs;
    }

    public boolean isShowConsent() {
        return this.showConsent;
    }

    public void setShowConsent(boolean showConsent) {
        this.showConsent = showConsent;
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(boolean showTitle) {
        this.showTitle = showTitle;
    }

    public boolean isShowExam() {
        return this.showExam;
    }

    public void setShowExam(boolean showExam) {
        this.showExam = showExam;
    }

    public boolean isShowExamName() {
        return this.showExamName;
    }

    public void setShowExamName(boolean showExamName) {
        this.showExamName = showExamName;
    }

    public boolean isShowExamTimetable() {
        return this.showExamTimetable;
    }

    public void setShowExamTimetable(boolean showExamTimetable) {
        this.showExamTimetable = showExamTimetable;
    }

    public boolean isShowFundingDepartment() {
        if (ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue()) {
            return this.showFundingDepartment;
        }
        return false;
    }

    public void setShowFundingDepartment(boolean showFundingDepartment) {
        this.showFundingDepartment = showFundingDepartment;
    }

    public boolean isShowInstructorAssignment() {
        return this.showInstructorAssignment;
    }

    public void setShowInstructorAssignment(boolean showInstructorAssignment) {
        this.showInstructorAssignment = showInstructorAssignment;
    }

    public boolean isFilterWaitlist() {
        return "W".equals(this.filterWaitlist);
    }

    public boolean isFilterNonWaitlist() {
        return "N".equals(this.filterWaitlist);
    }

    public boolean isFilterCoursesAllowingReScheduling() {
        return "R".equals(this.filterWaitlist);
    }

    public boolean isFilterNonWaitedCoursesAllowingReScheduling() {
        return "Z".equals(this.filterWaitlist);
    }

    public boolean isFilterCoursesNotAllowingReScheduling() {
        return "X".equals(this.filterWaitlist);
    }

    public void setFilterWaitlist(String filterWaitlist) {
        this.filterWaitlist = filterWaitlist;
    }

    public boolean isShowLms() {
        return this.showLms;
    }

    public void setShowLms(boolean showLms) {
        this.showLms = showLms;
    }

    public boolean isShowWaitlistMode() {
        return this.showWaitlistMode;
    }

    public void setShowWaitlistMode(boolean showWaitlistMode) {
        this.showWaitlistMode = showWaitlistMode;
    }

    protected TableInterface.LineInterface initRow(boolean isHeaderRow) {
        TableInterface.LineInterface row = new TableInterface.LineInterface();
        if (isHeaderRow) {
            row.setBgColor("#f1f3f9");
        }
        return row;
    }

    protected TableInterface.CellInterface headerCell(String content) {
        return this.headerCell(content, 1, 1);
    }

    protected TableInterface.CellInterface headerCell(String content, int rowSpan, int colSpan) {
        TableInterface.CellInterface cell = new TableInterface.CellInterface();
        if (rowSpan > 1) {
            cell.setRowSpan(rowSpan);
        }
        if (colSpan > 1) {
            cell.setColSpan(colSpan);
        }
        cell.setHorizontalAlignment(TableInterface.CellInterface.Alignment.BOTTOM);
        cell.setClassName("WebTableHeader");
        cell.setText(content);
        return cell;
    }

    private TableInterface.CellInterface initCell(boolean isEditable, int cols) {
        return this.initCell(isEditable, cols, false);
    }

    private TableInterface.CellInterface initCell(boolean isEditable, int cols, boolean nowrap) {
        TableInterface.CellInterface cell = new TableInterface.CellInterface();
        if (cols > 1) {
            cell.setColSpan(cols);
        }
        if (nowrap) {
            cell.setNoWrap(true);
        }
        if (!isEditable) {
            cell.setColor(this.disabledColor);
        }
        return cell;
    }

    protected TableInterface.CellInterface initNormalCell(String text, boolean isEditable) {
        return this.initColSpanCell(text, isEditable, 1);
    }

    private TableInterface.CellInterface initColSpanCell(String text, boolean isEditable, int cols) {
        TableInterface.CellInterface cell = this.initCell(isEditable, cols);
        cell.setText(text);
        return cell;
    }

    protected void buildTableHeader(TableInterface table, Long sessionId, String durationColName) {
        TableInterface.LineInterface row = new TableInterface.LineInterface();
        TableInterface.LineInterface row2 = new TableInterface.LineInterface();
        TableInterface.CellInterface cell = null;
        if (this.isSimple()) {
            if (this.isShowLabel()) {
                row.addCell(this.headerCell(null).setWidth(175));
            }
            if (this.isShowDivSec()) {
                row.addCell(this.headerCell(MSG.columnExternalId()).setWidth(80));
            }
            if (this.isShowDemand()) {
                if (this.sessionHasEnrollments(sessionId)) {
                    row.addCell(this.headerCell(MSG.columnDemand()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT).setWidth(60));
                } else {
                    row.addCell(this.headerCell(MSG.columnLastDemand()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT).setWidth(60));
                }
            }
            if (this.isShowProjectedDemand()) {
                row.addCell(this.headerCell(MSG.columnProjectedDemand()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT).setWidth(65));
            }
            if (this.isShowLimit()) {
                row.addCell(this.headerCell(MSG.columnLimit()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT).setWidth(50));
            }
            if (this.isShowSnapshotLimit()) {
                row.addCell(this.headerCell(MSG.columnSnapshotLimit()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT).setWidth(50));
            }
            if (this.isShowRoomRatio()) {
                row.addCell(this.headerCell(MSG.columnRoomRatio()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT).setWidth(50));
            }
            if (this.isShowManager()) {
                cell = this.headerCell(MSG.columnManager(), 1, 1).setWidth(75);
                row.addCell(cell);
            }
            if (this.isShowFundingDepartment()) {
                row.addCell(this.headerCell(MSG.columnFundingDepartment()).setWidth(75));
            }
            if (this.isShowDatePattern()) {
                row.addCell(this.headerCell(MSG.columnDatePattern()).setWidth(100));
            }
            if (this.isShowMinPerWk()) {
                row.addCell(this.headerCell(durationColName).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT).setWidth(60));
            }
            if (this.isShowTimePattern()) {
                row.addCell(this.headerCell(MSG.columnTimePattern()).setWidth(80));
            }
            if (this.isShowPreferences()) {
                row.addCell(this.headerCell(MSG.columnTimePref()).setWidth(this.getGridAsText() ? 200 : 100));
                row.addCell(this.headerCell(MSG.columnAllRoomPref()).setWidth(150));
                if (this.getDisplayDistributionPrefs()) {
                    row.addCell(this.headerCell(MSG.columnDistributionPref()).setWidth(200));
                }
                if (this.getDisplayInstructorPrefs()) {
                    row.addCell(this.headerCell(MSG.columnInstructorAttributePref()).setWidth(150));
                    row.addCell(this.headerCell(MSG.columnInstructorPref()).setWidth(150));
                }
            } else if (this.getDisplayInstructorPrefs()) {
                row.addCell(this.headerCell(MSG.columnInstructorAttributePref()).setWidth(150));
                row.addCell(this.headerCell(MSG.columnInstructorPref()).setWidth(150));
            }
            if (this.isShowInstructorAssignment()) {
                row.addCell(this.headerCell(MSG.columnTeachingLoad()).setWidth(100));
            }
            if (this.isShowInstructor()) {
                row.addCell(this.headerCell(MSG.columnInstructor()).setWidth(200));
            }
            if (this.getDisplayTimetable() && this.isShowTimetable()) {
                row.addCell(this.headerCell(MSG.columnAssignedTime()).setWidth(130));
                row.addCell(this.headerCell(MSG.columnAssignedRoom()).setWidth(100));
                row.addCell(this.headerCell(MSG.columnAssignedRoomCapacity()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT).setWidth(70));
            }
            if (this.isShowTitle()) {
                row.addCell(this.headerCell(MSG.columnTitle()).setWidth(200));
            }
            if (this.isShowCredit()) {
                row.addCell(this.headerCell(MSG.columnOfferingCredit()).setWidth(100).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT));
            }
            if (this.isShowSubpartCredit()) {
                row.addCell(this.headerCell(MSG.columnSubpartCredit()).setWidth(100).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT));
            }
            if (this.isShowConsent()) {
                row.addCell(this.headerCell(MSG.columnConsent()).setWidth(100));
            }
            if (this.isShowSchedulePrintNote()) {
                row.addCell(this.headerCell(this.getSchedulePrintNoteLabel()).setWidth(150));
            }
            if (this.isShowNote()) {
                row.addCell(this.headerCell(MSG.columnNote()).setWidth(300));
            }
            if (this.isShowExam()) {
                if (this.isShowExamName()) {
                    row.addCell(this.headerCell(MSG.columnExam()).setWidth(120));
                }
                if (this.isShowExamTimetable()) {
                    row.addCell(this.headerCell(MSG.columnExamPeriod()).setWidth(120));
                    row.addCell(this.headerCell(MSG.columnExamRoom()).setWidth(80));
                }
            }
            if (this.isShowLms()) {
                row.addCell(this.headerCell(MSG.columnLms()).setWidth(100));
            }
            if (this.isShowWaitlistMode()) {
                row.addCell(this.headerCell(MSG.columnWaitlistMode()).setWidth(75));
            }
        } else {
            if (this.isShowLabel()) {
                cell = this.headerCell(null, 2, 1);
                row.addCell(cell);
            }
            if (this.isShowDivSec()) {
                cell = this.headerCell(MSG.columnExternalId(), 2, 1);
                row.addCell(cell);
            }
            if (this.isShowDemand()) {
                cell = this.sessionHasEnrollments(sessionId) ? this.headerCell(MSG.columnDemand(), 2, 1) : this.headerCell(MSG.columnLastDemand(), 2, 1);
                cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                row.addCell(cell);
            }
            if (this.isShowProjectedDemand()) {
                cell = this.headerCell(MSG.columnProjectedDemand(), 2, 1);
                cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                row.addCell(cell);
            }
            if (this.isShowLimit()) {
                cell = this.headerCell(MSG.columnLimit(), 2, 1);
                cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                row.addCell(cell);
            }
            if (this.isShowSnapshotLimit()) {
                cell = this.headerCell(MSG.columnSnapshotLimit(), 2, 1);
                cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                row.addCell(cell);
            }
            if (this.isShowRoomRatio()) {
                cell = this.headerCell(MSG.columnRoomRatio(), 2, 1);
                cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                row.addCell(cell);
            }
            if (this.isShowManager()) {
                cell = this.headerCell(MSG.columnManager(), 2, 1);
                row.addCell(cell);
            }
            if (this.isShowFundingDepartment()) {
                cell = this.headerCell(MSG.columnFundingDepartment(), 2, 1);
                row.addCell(cell);
            }
            if (this.isShowDatePattern()) {
                cell = this.headerCell(MSG.columnDatePattern(), 2, 1);
                row.addCell(cell);
            }
            if (this.isShowMinPerWk()) {
                cell = this.headerCell(durationColName, 2, 1);
                cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                row.addCell(cell);
            }
            if (this.isShowTimePattern()) {
                cell = this.headerCell(MSG.columnTimePattern(), 2, 1);
                row.addCell(cell);
            }
            if (this.isShowPreferences()) {
                cell = this.headerCell("----" + MSG.columnPreferences() + "----", 1, this.getPreferenceColumns());
                cell.setClassName("WebTableHeaderFirstRow");
                cell.setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
                row.addCell(cell);
                cell = this.headerCell(MSG.columnTimePref(), 1, 1);
                cell.setClassName("WebTableHeaderSecondRow");
                row2.addCell(cell);
                cell = this.headerCell(MSG.columnAllRoomPref(), 1, 1);
                cell.setClassName("WebTableHeaderSecondRow");
                row2.addCell(cell);
                if (this.getDisplayDistributionPrefs()) {
                    cell = this.headerCell(MSG.columnDistributionPref(), 1, 1);
                    cell.setClassName("WebTableHeaderSecondRow");
                    row2.addCell(cell);
                }
                if (this.getDisplayInstructorPrefs()) {
                    cell = this.headerCell(MSG.columnInstructorAttributePref(), 1, 1);
                    cell.setClassName("WebTableHeaderSecondRow");
                    row2.addCell(cell);
                    cell = this.headerCell(MSG.columnInstructorPref(), 1, 1);
                    cell.setClassName("WebTableHeaderSecondRow");
                    row2.addCell(cell);
                }
            } else if (this.getDisplayInstructorPrefs()) {
                cell = this.headerCell("----" + MSG.columnPreferences() + "----", 1, this.getPreferenceColumns());
                cell.setClassName("WebTableHeaderFirstRow");
                cell.setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
                row.addCell(cell);
                cell = this.headerCell(MSG.columnInstructorAttributePref(), 1, 1);
                cell.setClassName("WebTableHeaderSecondRow");
                row2.addCell(cell);
                cell = this.headerCell(MSG.columnInstructorPref(), 1, 1);
                cell.setClassName("WebTableHeaderSecondRow");
                row2.addCell(cell);
            }
            if (this.isShowInstructorAssignment()) {
                cell = this.headerCell(MSG.columnTeachingLoad(), 2, 1);
                row.addCell(cell);
            }
            if (this.isShowInstructor()) {
                cell = this.headerCell(MSG.columnInstructor(), 2, 1);
                row.addCell(cell);
            }
            if (this.getDisplayTimetable() && this.isShowTimetable()) {
                cell = this.headerCell("--------" + MSG.columnTimetable() + "--------", 1, 3);
                cell.setClassName("WebTableHeaderFirstRow");
                cell.setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
                row.addCell(cell);
                cell = this.headerCell(MSG.columnAssignedTime(), 1, 1);
                cell.setNoWrap(true);
                cell.setClassName("WebTableHeaderSecondRow");
                row2.addCell(cell);
                cell = this.headerCell(MSG.columnAssignedRoom(), 1, 1);
                cell.setNoWrap(true);
                cell.setClassName("WebTableHeaderSecondRow");
                row2.addCell(cell);
                cell = this.headerCell(MSG.columnAssignedRoomCapacity(), 1, 1);
                cell.setNoWrap(true);
                cell.setClassName("WebTableHeaderSecondRow");
                cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                row2.addCell(cell);
            }
            if (this.isShowTitle()) {
                cell = this.headerCell(MSG.columnTitle(), 2, 1);
                row.addCell(cell);
            }
            if (this.isShowCredit()) {
                cell = this.headerCell(MSG.columnOfferingCredit(), 2, 1).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                row.addCell(cell);
            }
            if (this.isShowSubpartCredit()) {
                cell = this.headerCell(MSG.columnSubpartCredit(), 2, 1).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                row.addCell(cell);
            }
            if (this.isShowConsent()) {
                cell = this.headerCell(MSG.columnConsent(), 2, 1);
                row.addCell(cell);
            }
            if (this.isShowSchedulePrintNote()) {
                cell = this.headerCell(this.getSchedulePrintNoteLabel(), 2, 1);
                row.addCell(cell);
            }
            if (this.isShowNote()) {
                cell = this.headerCell(MSG.columnNote(), 2, 1);
                row.addCell(cell);
            }
            if (this.isShowExam()) {
                cell = this.headerCell("-----------" + MSG.columnExam() + "--------", 1, (this.isShowExamName() ? 1 : 0) + (this.isShowExamTimetable() ? 2 : 0));
                cell.setClassName("WebTableHeaderFirstRow");
                cell.setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
                cell.setNoWrap(true);
                row.addCell(cell);
                if (this.isShowExamName()) {
                    cell = this.headerCell(MSG.columnExamName(), 1, 1);
                    cell.setNoWrap(true);
                    cell.setClassName("WebTableHeaderSecondRow");
                    row2.addCell(cell);
                }
                if (this.isShowExamTimetable()) {
                    cell = this.headerCell(MSG.columnExamPeriod(), 1, 1);
                    cell.setNoWrap(true);
                    cell.setClassName("WebTableHeaderSecondRow");
                    row2.addCell(cell);
                    cell = this.headerCell(MSG.columnExamRoom(), 1, 1);
                    cell.setNoWrap(true);
                    cell.setClassName("WebTableHeaderSecondRow");
                    row2.addCell(cell);
                }
            }
            if (this.isShowLms()) {
                cell = this.headerCell(MSG.columnLms(), 2, 1);
                row.addCell(cell);
            }
            if (this.isShowWaitlistMode()) {
                cell = this.headerCell(MSG.columnWaitlistMode(), 2, 1);
                row.addCell(cell);
            }
        }
        table.addHeader(row);
        if (row2.hasCells()) {
            table.addHeader(row2);
        } else {
            for (TableInterface.CellInterface c : row.getCells()) {
                c.setRowSpan(1);
            }
        }
    }

    protected String getSchedulePrintNoteLabel() {
        return MSG.columnSchedulePrintNote();
    }

    private TableInterface.CellInterface subjectAndCourseInfo(InstructionalOffering io, CourseOffering co, boolean isEditable) {
        InstructionalMethod im;
        TableInterface.CellInterface cell = this.initCell(isEditable && co.isIsControl() != false, 1, true);
        if ("InstructionalOffering".equals(this.getBackType()) && io.getUniqueId().toString().equals(this.getBackId())) {
            cell.addAnchor("back");
        }
        cell.addAnchor("A" + io.getUniqueId());
        cell.addAnchor("A" + co.getUniqueId());
        TableInterface.CellInterface c = cell.add(co.getCourseName()).setTitle(co.getCourseNameWithTitle()).addStyle("font-weight: bold;").setInline(false);
        InstructionalMethod instructionalMethod = im = co != null && co.getInstructionalOffering().getInstrOfferingConfigs().size() == 1 ? co.getInstructionalOffering().getInstrOfferingConfigs().iterator().next().getInstructionalMethod() : null;
        if (co != null && co.getCourseType() != null) {
            if (im != null) {
                c.add(" (");
                c.add(co.getCourseType().getReference()).setTitle(co.getCourseType().getLabel());
                c.add(", ");
                c.add(im.getReference()).setTitle(im.getLabel());
                c.add(")");
            } else {
                c.add(" (");
                c.add(co.getCourseType().getReference()).setTitle(co.getCourseType().getLabel());
                c.add(")");
            }
        } else if (im != null) {
            c.add(" (");
            c.add(im.getReference()).setTitle(im.getLabel());
            c.add(")");
        }
        for (CourseOffering tempCo : io.courseOfferingsMinusSortCourseOfferingForSubjectArea(co.getSubjectArea().getUniqueId())) {
            c = cell.add(tempCo.getCourseName()).setColor(this.disabledColor).setTitle(tempCo.getCourseNameWithTitle()).setIndent(1).setInline(false);
            if (tempCo == null || tempCo.getCourseType() == null) continue;
            c.add(" (");
            c.add(tempCo.getCourseType().getReference()).setTitle(tempCo.getCourseType().getLabel());
            c.add(")");
        }
        return cell;
    }

    protected TableInterface.CellInterface buildPrefGroupLabel(CourseOffering co, PreferenceGroup prefGroup, int indentSpaces, boolean isEditable, String prevLabel) {
        TableInterface.CellInterface cell = new TableInterface.CellInterface();
        if ("PreferenceGroup".equals(this.getBackType()) && prefGroup.getUniqueId().toString().equals(this.getBackId())) {
            cell.addAnchor("back");
        }
        if (indentSpaces > 0) {
            cell.setIndent(indentSpaces);
        }
        if (!isEditable) {
            cell.setColor(this.disabledColor);
        }
        cell.addAnchor("A" + prefGroup.getUniqueId());
        String label = prefGroup.htmlLabel();
        if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            if (!aClass.isEnabledForStudentScheduling().booleanValue()) {
                cell.setTitle(MSG.tooltipDisabledForStudentScheduling(aClass.getClassLabelWithTitle(co)));
                cell.addStyle("font-style: italic;");
            } else {
                cell.setTitle(aClass.getClassLabelWithTitle(co));
            }
        }
        if (prevLabel != null && label.equals(prevLabel)) {
            label = "";
        }
        cell.setText(label);
        cell.setNoWrap(true);
        return cell;
    }

    protected TableInterface.CellInterface buildDatePatternCell(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        ClassAssignmentProxy.AssignmentInfo a = null;
        AssignmentPreferenceInfo p = null;
        if (this.getDisplayTimetable() && this.isShowTimetable() && classAssignment != null && prefGroup instanceof Class_) {
            try {
                a = classAssignment.getAssignment((Class_)prefGroup);
                p = classAssignment.getAssignmentInfo((Class_)prefGroup);
            }
            catch (Exception e) {
                Debug.error(e);
            }
        }
        DatePattern dp = a != null ? a.getDatePattern() : prefGroup.effectiveDatePattern();
        TableInterface.CellInterface cell = null;
        if (dp == null) {
            cell = this.initNormalCell("", isEditable);
        } else if (dp.isPatternSet() && isEditable) {
            cell = this.initNormalCell(dp.getName(), isEditable);
            boolean hasReq = false;
            for (Preference preference : prefGroup.effectivePreferences(DatePatternPref.class)) {
                if (!hasReq && PreferenceLevel.sRequired.equals(preference.getPrefLevel().getPrefProlog())) {
                    hasReq = true;
                    if (cell.hasItems()) {
                        cell.getItems().clear();
                    }
                }
                if (hasReq && !PreferenceLevel.sRequired.equals(preference.getPrefLevel().getPrefProlog())) continue;
                cell.addItem(this.preferenceCell(preference).setInline(false));
            }
        } else {
            cell = this.initNormalCell(dp.getName(), isEditable);
            cell.setTitle(sDateFormat.format(dp.getStartDate()) + " - " + sDateFormat.format(dp.getEndDate()));
            if (p != null && isEditable) {
                cell.setColor(PreferenceLevel.int2color(p.getDatePatternPref()));
            }
        }
        cell.setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
        return cell;
    }

    private TableInterface.CellInterface buildTimePatternCell(PreferenceGroup prefGroup, boolean isEditable) {
        Set<TimePattern> patterns = prefGroup.effectiveTimePatterns();
        TableInterface.CellInterface cell = new TableInterface.CellInterface();
        cell.setNoWrap(true);
        cell.setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
        if (!isEditable) {
            cell.setColor(this.disabledColor);
        }
        if (patterns == null || patterns.isEmpty()) {
            if (prefGroup instanceof Class_) {
                Class_ clazz = (Class_)prefGroup;
                DurationModel dm = clazz.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
                Integer ah = dm.getArrangedHours(clazz.getSchedulingSubpart().getMinutesPerWk(), clazz.effectiveDatePattern());
                if (ah == null) {
                    cell.setText(MSG.arrHrs());
                    cell.setTitle(MSG.arrangeHours());
                } else {
                    cell.setText(MSG.arrHrsN(ah));
                    cell.setTitle(MSG.arrangeHoursN(ah));
                }
            }
        } else {
            for (TimePattern tp : patterns) {
                cell.add(tp.getName()).setInline(false).setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
            }
        }
        return cell;
    }

    protected TableInterface.CellInterface cellForTimePrefs(ClassAssignmentProxy.AssignmentInfo assignment, Set<TimePref> timePrefList, final boolean timeVertical, boolean gridAsText, String timeGridSize, boolean highlightClassPrefs) {
        TableInterface.CellInterface cell = new TableInterface.CellInterface();
        cell.setNoWrap(true);
        for (TimePref tp : timePrefList) {
            final RequiredTimeTable rtt = tp.getRequiredTimeTable(assignment == null ? null : assignment.getTimeLocation());
            Object owner = "";
            owner = tp.getOwner() != null && tp.getOwner() instanceof Class_ ? " (" + MSG.prefOwnerClass() + ")" : (tp.getOwner() != null && tp.getOwner() instanceof SchedulingSubpart ? " (" + MSG.prefOwnerSchedulingSubpart() + ")" : (tp.getOwner() != null && tp.getOwner() instanceof DepartmentalInstructor ? " (" + MSG.prefOwnerInstructor() + ")" : (tp.getOwner() != null && tp.getOwner() instanceof Exam ? " (" + MSG.prefOwnerExamination() + ")" : (tp.getOwner() != null && tp.getOwner() instanceof Department ? " (" + MSG.prefOwnerDepartment() + ")" : (tp.getOwner() != null && tp.getOwner() instanceof Session ? " (" + MSG.prefOwnerSession() + ")" : " (" + MSG.prefOwnerCombined() + ")")))));
            if (gridAsText || rtt.getModel().isExactTime()) {
                String hint = rtt.print(false, timeVertical, true, false, rtt.getModel().getName() + (String)owner).replace(");\n</script>", "").replace("<script language=\"javascript\">\ndocument.write(", "").replace("\n", " ");
                cell.addItem(rtt.getModel().toCell().setMouseOver("$wnd.showGwtHint($wnd.lastMouseOverElement, $wnd." + hint + ");").setMouseOut("$wnd.hideGwtHint();").addStyle(tp.getOwner() != null && tp.getOwner() instanceof Class_ && highlightClassPrefs ? "background: #ffa;" : "").setInline(false));
                continue;
            }
            rtt.getModel().setDefaultSelection(timeGridSize);
            PrefGroupEditInterface.TimePatternModel tpm = ClassEditBackend.createTimePatternModel(tp, this.getSessionContext());
            if (assignment != null && assignment.getTimeLocation() != null && tpm.getId().equals(assignment.getTimeLocation().getTimePatternId())) {
                tpm.setAssignment(assignment.getTimeLocation().getDayCode(), assignment.getTimeLocation().getStartSlot());
            }
            cell.add(null).setImage(new TableInterface.ImageInterface().setSource("pattern?v=" + (timeVertical ? 1 : 0) + "&s=" + rtt.getModel().getDefaultSelection() + "&tp=" + tp.getTimePattern().getUniqueId() + "&p=" + rtt.getModel().getPreferences() + (String)(assignment == null || assignment.getTimeLocation() == null ? "" : "&as=" + assignment.getTimeLocation().getStartSlot() + "&ad=" + assignment.getTimeLocation().getDayCode()) + (tp.getOwner() != null && tp.getOwner() instanceof Class_ && highlightClassPrefs ? "&hc=1" : "")).setAlt(rtt.getModel().toString()).setGenerator(new TableInterface.ImageGenerator(){

                @Override
                public Object generate() {
                    return rtt.createBufferedImage(timeVertical);
                }
            })).setToolTip(tpm).addStyle("display: inline-block;").setAria(rtt.getModel().toString().replace(", ", "\n"));
        }
        return cell;
    }

    private TableInterface.CellInterface buildTimePrefCell(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        ClassAssignmentProxy.AssignmentInfo a = null;
        if (this.getDisplayTimetable() && this.isShowTimetable() && classAssignment != null && prefGroup instanceof Class_) {
            try {
                a = classAssignment.getAssignment((Class_)prefGroup);
            }
            catch (Exception e) {
                Debug.error(e);
            }
        }
        TableInterface.CellInterface cell = this.cellForTimePrefs(a, prefGroup.effectivePreferences(TimePref.class), this.getTimeVertival(), this.getGridAsText(), this.getDefaultTimeGridSize(), this.isHighlightClassPrefs());
        return cell;
    }

    private TableInterface.CellInterface buildPreferenceCell(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, Class prefType, boolean isEditable) {
        if (!isEditable) {
            return this.initNormalCell("", false);
        }
        if (TimePref.class.equals((Object)prefType)) {
            return this.buildTimePrefCell(classAssignment, prefGroup, isEditable);
        }
        if (!prefGroup.isInstructorAssignmentNeeded() && (InstructorPref.class.equals((Object)prefType) || InstructorAttributePref.class.equals((Object)prefType))) {
            return this.initNormalCell("", false);
        }
        TableInterface.CellInterface cell = this.initNormalCell("", isEditable);
        cell.setInline(false);
        for (Object pref : prefGroup.effectivePreferences(prefType)) {
            cell.addItem(this.preferenceCell((Preference)pref));
        }
        if (!this.isSimple()) {
            cell.setNoWrap(true);
        }
        return cell;
    }

    private TableInterface.CellInterface buildPreferenceCell(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, Class[] prefTypes, boolean isEditable) {
        if (!isEditable) {
            return this.initNormalCell("", false);
        }
        TableInterface.CellInterface cell = this.initNormalCell("", isEditable);
        boolean noRoomPrefs = false;
        if (prefGroup instanceof Class_ && ((Class_)prefGroup).getNbrRooms() == 0) {
            noRoomPrefs = true;
        }
        if (prefGroup instanceof SchedulingSubpart && ((SchedulingSubpart)prefGroup).getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue()) {
            noRoomPrefs = true;
        }
        for (int i = 0; i < prefTypes.length; ++i) {
            Class prefType = prefTypes[i];
            if (noRoomPrefs && (prefType.equals(RoomGroupPref.class) || prefType.equals(RoomFeaturePref.class) || prefType.equals(BuildingPref.class))) continue;
            for (Object pref : prefGroup.effectivePreferences(prefType)) {
                cell.addItem(this.preferenceCell((Preference)pref));
            }
        }
        if (noRoomPrefs && !cell.hasItems()) {
            cell.setText(MSG.notApplicable()).addStyle("font-style: italic;");
        }
        cell.setNoWrap(true);
        return cell;
    }

    private TableInterface.CellInterface buildPrefGroupDemand(PreferenceGroup prefGroup, boolean isEditable) {
        Class_ c;
        if (prefGroup instanceof Class_ && this.sessionHasEnrollments((c = (Class_)prefGroup).getSessionId())) {
            TableInterface.CellInterface tc = null;
            tc = c.getEnrollment() != null ? this.initNormalCell(c.getEnrollment().toString(), isEditable) : this.initNormalCell("0", isEditable);
            tc.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
            return tc;
        }
        return this.initNormalCell("", isEditable);
    }

    private TableInterface.CellInterface buildPrefGroupProjectedDemand(PreferenceGroup prefGroup, boolean isEditable) {
        Class_ c;
        SectioningInfo i;
        if (prefGroup instanceof Class_ && (i = (c = (Class_)prefGroup).getSectioningInfo()) != null && i.getNbrExpectedStudents() != null) {
            TableInterface.CellInterface cell = this.initNormalCell(String.valueOf(Math.round(Math.max(0.0, (double)c.getEnrollment().intValue() + i.getNbrExpectedStudents()))), isEditable);
            cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
            return cell;
        }
        return this.initNormalCell("", isEditable);
    }

    private TableInterface.CellInterface buildSnapshotLimit(PreferenceGroup prefGroup, boolean isEditable) {
        Class_ c;
        if (prefGroup instanceof Class_ && (c = (Class_)prefGroup).getSnapshotLimit() != null) {
            TableInterface.CellInterface cell = null;
            if (c.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue()) {
                cell = this.initNormalCell("\u221e", isEditable);
                cell.addStyle("font-size: +1");
            } else {
                cell = this.initNormalCell(c.getSnapshotLimit().toString(), isEditable);
            }
            cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
            return cell;
        }
        return this.initNormalCell("", isEditable);
    }

    private TableInterface.CellInterface buildLimit(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        TableInterface.CellInterface cell = null;
        boolean nowrap = false;
        if (prefGroup instanceof SchedulingSubpart) {
            SchedulingSubpart ss = (SchedulingSubpart)prefGroup;
            boolean unlimited = ss.getInstrOfferingConfig().isUnlimitedEnrollment();
            if (!unlimited) {
                int maxExpCap;
                int limit = ss.getLimit();
                if (limit == (maxExpCap = ss.getMaxExpectedCapacity())) {
                    cell = this.initNormalCell(String.valueOf(limit), isEditable);
                } else {
                    cell = this.initNormalCell(limit + "-" + maxExpCap, isEditable);
                    nowrap = true;
                }
            } else {
                cell = this.initNormalCell("", isEditable);
            }
        } else if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            boolean unlimited = aClass.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment();
            if (!unlimited) {
                Object limitString = null;
                ClassAssignmentProxy.AssignmentInfo a = null;
                try {
                    if (classAssignment != null) {
                        a = classAssignment.getAssignment(aClass);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (a == null) {
                    if (aClass.getExpectedCapacity() != null) {
                        limitString = aClass.getExpectedCapacity().toString();
                        if (aClass.getMaxExpectedCapacity() != null && !aClass.getMaxExpectedCapacity().equals(aClass.getExpectedCapacity())) {
                            limitString = (String)limitString + "-" + aClass.getMaxExpectedCapacity().toString();
                            nowrap = true;
                        }
                    } else {
                        limitString = "0";
                        if (aClass.getMaxExpectedCapacity() != null && aClass.getMaxExpectedCapacity() != 0) {
                            limitString = (String)limitString + "-" + aClass.getMaxExpectedCapacity().toString();
                            nowrap = true;
                        }
                    }
                } else {
                    limitString = "" + aClass.getClassLimit(classAssignment);
                }
                cell = this.initNormalCell((String)limitString, isEditable);
                if (nowrap) {
                    cell.setNoWrap(true);
                }
            } else {
                cell = this.initNormalCell("\u221e", isEditable);
                cell.addStyle("font-size: +1");
            }
        } else {
            cell = this.initNormalCell("", isEditable);
        }
        cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
        return cell;
    }

    private TableInterface.CellInterface buildDivisionSection(CourseOffering co, PreferenceGroup prefGroup, boolean isEditable) {
        TableInterface.CellInterface cell = null;
        if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            String divSec = this.isShowOriginalDivSecs() ? aClass.getClassSuffix() : aClass.getClassSuffix(co);
            cell = this.initNormalCell(divSec == null ? "" : divSec, isEditable);
            cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
        } else {
            cell = this.initNormalCell("", isEditable);
        }
        cell.setNoWrap(true);
        return cell;
    }

    protected TableInterface.CellInterface buildInstructorAssignment(PreferenceGroup prefGroup, boolean isEditable) {
        SchedulingSubpart ss;
        TableInterface.CellInterface cell = this.initNormalCell("", isEditable);
        if (prefGroup instanceof Class_) {
            Class_ c = (Class_)prefGroup;
            if (c.isInstructorAssignmentNeeded()) {
                cell.add((String)(c.effectiveNbrInstructors() > 1 ? c.effectiveNbrInstructors() + " \u00d7 " : "") + Formats.getNumberFormat("0.##").format(Float.valueOf(c.effectiveTeachingLoad())) + " " + MSG.teachingLoadUnits()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT).setInline(false).setNoWrap(true);
            } else if (c.getSchedulingSubpart().isInstructorAssignmentNeeded()) {
                cell.add(MSG.cellNoInstructorAssignment()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT).setInline(false);
            }
        } else if (prefGroup instanceof SchedulingSubpart && (ss = (SchedulingSubpart)prefGroup).isInstructorAssignmentNeeded()) {
            cell.add((String)(ss.getNbrInstructors() > 1 ? ss.getNbrInstructors() + " \u00d7 " : "") + Formats.getNumberFormat("0.##").format(Float.valueOf(ss.getTeachingLoad())) + " " + MSG.teachingLoadUnits()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT).setInline(false).setNoWrap(true);
        }
        return cell;
    }

    protected TableInterface.CellInterface instructorCell(Class_ clazz, String instructorNameFormat) {
        TableInterface.CellInterface cell = new TableInterface.CellInterface();
        cell.setNoWrap(false);
        if (clazz.getClassInstructors() == null) {
            return cell;
        }
        InstructorComparator ic = new InstructorComparator();
        if (ApplicationProperty.InstructorsDropdownFollowNameFormatting.isTrue()) {
            ic.setNameFormat(instructorNameFormat);
        }
        TreeSet<ClassInstructor> sortedInstructors = new TreeSet<ClassInstructor>(ic);
        sortedInstructors.addAll(clazz.getClassInstructors());
        for (ClassInstructor ci : sortedInstructors) {
            Object title = ci.getInstructor().getNameLastFirst();
            title = (String)title + " (" + (String)(ci.getResponsibility() == null ? "" : ci.getResponsibility().getLabel() + " ") + ci.getPercentShare() + "%" + (String)(ci.isLead() != false ? ", " + MSG.toolTipInstructorLead() : "") + ")";
            if (!clazz.isDisplayInstructor().booleanValue()) {
                title = (String)title + MSG.toolTipInstructorDoNotDisplay();
            }
            TableInterface.CellInterface c = cell.add(ci.getInstructor().getName(instructorNameFormat) + (String)(ci.getResponsibility() != null && ci.getResponsibility().getAbbreviation() != null && !ci.getResponsibility().getAbbreviation().isEmpty() ? " (" + ci.getResponsibility().getAbbreviation() + ")" : "")).setTitle((String)title);
            if (ci.isLead().booleanValue()) {
                c.addStyle("font-weight: bold;");
            }
            if (!clazz.isDisplayInstructor().booleanValue()) {
                c.addStyle("font-style: italic;");
            }
            c.setInline(false);
        }
        return cell;
    }

    protected TableInterface.CellInterface buildInstructor(PreferenceGroup prefGroup, boolean isEditable) {
        if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            TableInterface.CellInterface cell = this.instructorCell(aClass, this.getInstructorNameFormat());
            if (!isEditable) {
                cell.setColor(this.disabledColor);
            }
            return cell.setTextAlignment(TableInterface.CellInterface.Alignment.LEFT);
        }
        return this.initNormalCell("", isEditable);
    }

    private TableInterface.CellInterface buildCredit(PreferenceGroup prefGroup, boolean isEditable) {
        TableInterface.CellInterface cell = this.initNormalCell("", isEditable);
        if (prefGroup instanceof SchedulingSubpart) {
            SchedulingSubpart ss = (SchedulingSubpart)prefGroup;
            if (ss.getCredit() != null) {
                cell.setText(ss.getCredit().creditAbbv());
                cell.setTitle(ss.getCredit().creditText());
            }
            cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
        }
        return cell;
    }

    private TableInterface.CellInterface buildSchedulePrintNote(PreferenceGroup prefGroup, boolean isEditable) {
        TableInterface.CellInterface cell = null;
        if (prefGroup instanceof Class_) {
            Class_ c = (Class_)prefGroup;
            if (c.getSchedulePrintNote() != null && !c.getSchedulePrintNote().trim().isEmpty()) {
                String note = c.getSchedulePrintNote().replaceAll("\\<.*?\\>", "");
                if (CommonValues.NoteAsFullText.eq(this.getUser().getProperty(UserProperty.SchedulePrintNoteDisplay))) {
                    cell = this.initNormalCell(c.getSchedulePrintNote(), isEditable);
                    cell.setStyle("white-space: pre-wrap;");
                    cell.setTextAlignment(TableInterface.CellInterface.Alignment.LEFT);
                } else if (CommonValues.NoteAsShortText.eq(this.getUser().getProperty(UserProperty.SchedulePrintNoteDisplay))) {
                    note = note.length() <= 20 ? note : note.substring(0, 20) + "...";
                    cell = this.initNormalCell(note, isEditable);
                    cell.setStyle("white-space: pre-wrap;");
                    cell.setTextAlignment(TableInterface.CellInterface.Alignment.LEFT);
                } else {
                    cell = this.initNormalCell("", isEditable);
                    cell.setImage(new TableInterface.ImageInterface().setSource("images/note.png").setTitle(note).setAlt(MSG.altHasSchedulePrintNote()));
                    cell.setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
                }
            } else {
                cell = this.initNormalCell("", isEditable);
            }
        } else {
            cell = this.initNormalCell("", isEditable);
        }
        return cell;
    }

    private TableInterface.CellInterface buildSchedulingDisclaimer(InstrOfferingConfig ioc, boolean isEditable) {
        TableInterface.CellInterface cell = null;
        if (ioc.getSchedulingDisclaimer() != null && !ioc.getSchedulingDisclaimer().isEmpty()) {
            String note = ioc.getSchedulingDisclaimer().replaceAll("\\<.*?\\>", "");
            if (CommonValues.NoteAsFullText.eq(this.getUser().getProperty(UserProperty.SchedulePrintNoteDisplay))) {
                cell = this.initNormalCell(ioc.getSchedulingDisclaimer(), isEditable);
                cell.setStyle("white-space: pre-wrap;");
                cell.setTextAlignment(TableInterface.CellInterface.Alignment.LEFT);
            } else if (CommonValues.NoteAsShortText.eq(this.getUser().getProperty(UserProperty.SchedulePrintNoteDisplay))) {
                note = note.length() <= 20 ? note : note.substring(0, 20) + "...";
                cell = this.initNormalCell(note, isEditable);
                cell.setStyle("white-space: pre-wrap;");
                cell.setTextAlignment(TableInterface.CellInterface.Alignment.LEFT);
            } else {
                cell = this.initNormalCell("", isEditable);
                cell.setImage(new TableInterface.ImageInterface().setSource("images/note.png").setTitle(note).setAlt(MSG.altHasSchedulePrintNote()));
                cell.setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
            }
        } else {
            cell = this.initNormalCell("", isEditable);
        }
        return cell;
    }

    private TableInterface.CellInterface buildExamName(TreeSet<Exam> exams, boolean isEditable) {
        TableInterface.CellInterface cell = new TableInterface.CellInterface();
        if (!isEditable) {
            cell.setColor(this.disabledColor);
        }
        for (Exam exam : exams) {
            TableInterface.CellInterface c = cell.add(exam.getLabel());
            c.setNoWrap(true);
            c.setInline(false);
            if (0 != exam.getExamType().getType()) continue;
            c.addStyle("font-weight: bold;");
        }
        cell.setTextAlignment(TableInterface.CellInterface.Alignment.LEFT);
        cell.setNoWrap(true);
        return cell;
    }

    protected TableInterface.CellInterface getPeriodCell(ExamAssignment ea) {
        TableInterface.CellInterface cell = new TableInterface.CellInterface();
        cell.setText(ea.getPeriodAbbreviation());
        if (ea.getPeriodPref() != null && !PreferenceLevel.sNeutral.equals(ea.getPeriodPref())) {
            cell.setColor(PreferenceLevel.prolog2color(ea.getPeriodPref()));
        }
        if (ApplicationProperty.LegacyPeriodPreferences.isTrue()) {
            cell.setMouseOver("$wnd.showGwtTimeHint($wnd.lastMouseOverElement, '" + ea.getExamId() + "," + ea.getPeriodId() + "');");
        } else {
            cell.setMouseOver("$wnd.showGwtExamPeriodPreferencesHint($wnd.lastMouseOverElement,'" + ea.getExamId() + "','" + ea.getPeriodId() + "');");
        }
        cell.setMouseOut("hideGwtTimeHint();");
        return cell;
    }

    private TableInterface.CellInterface buildExamPeriod(ExamAssignmentProxy examAssignment, TreeSet<Exam> exams, boolean isEditable) {
        TableInterface.CellInterface cell = new TableInterface.CellInterface();
        if (!isEditable) {
            cell.setColor(this.disabledColor);
        }
        for (Exam exam : exams) {
            if (examAssignment != null && examAssignment.getExamTypeId().equals(exam.getExamType().getUniqueId())) {
                ExamAssignment ea = examAssignment.getAssignment(exam.getUniqueId());
                if (ea == null && !this.isShowExamName()) continue;
                if (ea != null) {
                    TableInterface.CellInterface c = this.getPeriodCell(ea);
                    c.setInline(false);
                    c.setNoWrap(true);
                    if (0 == exam.getExamType().getType()) {
                        c.addStyle("font-weight: bold;");
                    }
                    cell.addItem(c);
                    continue;
                }
                cell.addBlankLine();
                continue;
            }
            if (exam.getAssignedPeriod() == null && !this.isShowExamName()) continue;
            if (exam.getAssignedPeriod() != null) {
                TableInterface.CellInterface c = cell.add(exam.getAssignedPeriod().getAbbreviation()).setTitle(exam.getAssignedPeriod().getName()).setInline(false).setNoWrap(true);
                if (0 != exam.getExamType().getType()) continue;
                c.addStyle("font-weight: bold;");
                continue;
            }
            cell.addBlankLine();
        }
        cell.setTextAlignment(TableInterface.CellInterface.Alignment.LEFT);
        cell.setNoWrap(true);
        return cell;
    }

    protected TableInterface.CellInterface getLocationCell(Location location) {
        TableInterface.CellInterface cell = new TableInterface.CellInterface();
        cell.setText(location.getLabel());
        cell.setMouseOver("$wnd.showGwtRoomHint($wnd.lastMouseOverElement, '" + location.getUniqueId() + "');");
        cell.setMouseOut("$wnd.hideGwtRoomHint()");
        return cell;
    }

    public TableInterface.CellInterface getLocationCell(ExamRoomInfo room) {
        TableInterface.CellInterface cell = new TableInterface.CellInterface();
        cell.setText(room.getName());
        cell.setColor(PreferenceLevel.prolog2color(PreferenceLevel.int2prolog(room.getPreference())));
        cell.setMouseOver("$wnd.showGwtRoomHint($wnd.lastMouseOverElement, '" + room.getLocationId() + "', '" + PreferenceLevel.int2string(room.getPreference()) + "');");
        cell.setMouseOut("$wnd.hideGwtRoomHint()");
        return cell;
    }

    private TableInterface.CellInterface buildExamRoom(ExamAssignmentProxy examAssignment, TreeSet<Exam> exams, boolean isEditable) {
        TableInterface.CellInterface cell = new TableInterface.CellInterface();
        if (!isEditable) {
            cell.setColor(this.disabledColor);
        }
        for (Exam exam : exams) {
            if (examAssignment != null && examAssignment.getExamTypeId().equals(exam.getExamType().getUniqueId())) {
                ExamAssignment ea = examAssignment.getAssignment(exam.getUniqueId());
                if (ea == null && !this.isShowExamName()) continue;
                TableInterface.CellInterface c = new TableInterface.CellInterface();
                c.setInline(false);
                c.setNoWrap(true);
                if (ea != null && ea.getRooms() != null) {
                    for (ExamRoomInfo room : ea.getRooms()) {
                        if (c.hasItems()) {
                            c.add(", ");
                        }
                        c.addItem(this.getLocationCell(room));
                    }
                }
                cell.addItem(c);
                if (0 != exam.getExamType().getType()) continue;
                c.addStyle("font-weight: bold;");
                continue;
            }
            if (exam.getAssignedPeriod() == null && !this.isShowExamName()) continue;
            TableInterface.CellInterface c = new TableInterface.CellInterface();
            c.setInline(false);
            c.setNoWrap(true);
            for (Location location : new TreeSet<Location>(exam.getAssignedRooms())) {
                if (c.hasItems()) {
                    c.add(", ");
                }
                c.addItem(this.getLocationCell(location));
            }
            cell.addItem(c);
            if (0 != exam.getExamType().getType()) continue;
            c.addStyle("font-weight: bold;");
        }
        cell.setTextAlignment(TableInterface.CellInterface.Alignment.LEFT);
        cell.setNoWrap(true);
        return cell;
    }

    protected TreeSet getExams(Class_ clazz) {
        return new TreeSet<Exam>(Exam.findAll(3, clazz.getUniqueId()));
    }

    private TableInterface.CellInterface buildSchedulePrintNote(InstructionalOffering io, boolean isEditable) {
        TableInterface.CellInterface cell = null;
        Object note = "";
        for (CourseOffering co : io.getCourseOfferings()) {
            if (co.getScheduleBookNote() == null || co.getScheduleBookNote().trim().isEmpty()) continue;
            if (!((String)note).isEmpty()) {
                note = (String)note + "\n";
            }
            if (CommonValues.NoteAsShortText.eq(this.getUser().getProperty(UserProperty.CourseOfferingNoteDisplay))) {
                String n = co.getScheduleBookNote().replaceAll("\\<.*?\\>", "");
                note = (String)note + (String)(n.length() <= 20 ? n : n.substring(0, 20) + "...");
                continue;
            }
            if (CommonValues.NoteAsIcon.eq(this.getUser().getProperty(UserProperty.CourseOfferingNoteDisplay))) {
                note = (String)note + co.getScheduleBookNote().replaceAll("\\<.*?\\>", "");
                continue;
            }
            note = (String)note + co.getScheduleBookNote();
        }
        if (((String)note).isEmpty()) {
            cell = this.initNormalCell("", isEditable);
        } else if (CommonValues.NoteAsIcon.eq(this.getUser().getProperty(UserProperty.CourseOfferingNoteDisplay))) {
            cell = this.initNormalCell("", isEditable);
            cell.setImage(new TableInterface.ImageInterface().setSource("images/note.png").setTitle((String)note).setAlt(MSG.altHasCourseOfferingNote()));
            cell.setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
        } else {
            cell = this.initNormalCell((String)note, isEditable);
            cell.setStyle("white-space: pre-wrap;");
            cell.setTextAlignment(TableInterface.CellInterface.Alignment.LEFT);
        }
        return cell;
    }

    protected TableInterface.CellInterface buildNote(PreferenceGroup prefGroup, boolean isEditable) {
        TableInterface.CellInterface cell = null;
        if (prefGroup instanceof Class_) {
            Class_ c = (Class_)prefGroup;
            if (c.getNotes() != null && !c.getNotes().trim().isEmpty()) {
                String note = c.getNotes().replaceAll("\\<.*?\\>", "");
                if (CommonValues.NoteAsShortText.eq(this.getUser().getProperty(UserProperty.ManagerNoteDisplay))) {
                    note = note.length() <= 20 ? note : note.substring(0, 20) + "...";
                    cell = this.initNormalCell(note, isEditable);
                    cell.setStyle("white-space: pre-wrap;");
                    cell.setTextAlignment(TableInterface.CellInterface.Alignment.LEFT);
                } else if (CommonValues.NoteAsFullText.eq(this.getUser().getProperty(UserProperty.ManagerNoteDisplay))) {
                    cell = this.initNormalCell(c.getNotes(), isEditable);
                    cell.setStyle("white-space: pre-wrap;");
                    cell.setTextAlignment(TableInterface.CellInterface.Alignment.LEFT);
                } else {
                    cell = this.initNormalCell("", isEditable);
                    cell.setImage(new TableInterface.ImageInterface().setSource("images/note.png").setTitle(note).setAlt(MSG.altHasNoteToMgr()));
                    cell.setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
                }
            } else {
                cell = this.initNormalCell("", isEditable);
            }
        } else {
            cell = this.initNormalCell("", isEditable);
        }
        return cell;
    }

    private TableInterface.CellInterface buildNote(InstructionalOffering offering, boolean isEditable) {
        TableInterface.CellInterface cell = null;
        if (offering.getNotes() != null && !offering.getNotes().trim().isEmpty()) {
            String note = offering.getNotes().replaceAll("\\<.*?\\>", "");
            if (CommonValues.NoteAsShortText.eq(this.getUser().getProperty(UserProperty.ManagerNoteDisplay))) {
                note = note.length() <= 20 ? note : note.substring(0, 20) + "...";
                cell = this.initNormalCell(note, isEditable);
                cell.setStyle("white-space: pre-wrap;");
                cell.setTextAlignment(TableInterface.CellInterface.Alignment.LEFT);
            } else if (CommonValues.NoteAsFullText.eq(this.getUser().getProperty(UserProperty.ManagerNoteDisplay))) {
                cell = this.initNormalCell(offering.getNotes(), isEditable);
                cell.setStyle("white-space: pre-wrap;");
                cell.setTextAlignment(TableInterface.CellInterface.Alignment.LEFT);
            } else {
                cell = this.initNormalCell("", isEditable);
                cell.setImage(new TableInterface.ImageInterface().setSource("images/note.png").setTitle(note).setAlt(MSG.altHasNoteToMgr()));
                cell.setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
            }
        } else {
            cell = this.initNormalCell("", isEditable);
        }
        return cell;
    }

    private TableInterface.CellInterface buildManager(PreferenceGroup prefGroup, boolean isEditable) {
        TableInterface.CellInterface cell = null;
        Department managingDept = null;
        if (prefGroup instanceof Class_) {
            managingDept = ((Class_)prefGroup).getManagingDept();
        } else if (prefGroup instanceof SchedulingSubpart) {
            managingDept = ((SchedulingSubpart)prefGroup).getManagingDept();
        }
        cell = this.initNormalCell(managingDept == null ? "" : managingDept.getShortLabel(), isEditable);
        if (managingDept != null) {
            cell.setTitle(managingDept.getManagingDeptLabel());
        }
        return cell;
    }

    protected TableInterface.CellInterface buildFundingDepartment(PreferenceGroup prefGroup, boolean isEditable) {
        TableInterface.CellInterface cell = null;
        Department fundingDepartment = null;
        if (prefGroup instanceof Class_) {
            fundingDepartment = ((Class_)prefGroup).getEffectiveFundingDept();
        }
        cell = this.initNormalCell(fundingDepartment == null ? "" : fundingDepartment.getShortLabel(), isEditable);
        if (fundingDepartment != null) {
            cell.setTitle(fundingDepartment.getManagingDeptLabel());
        }
        return cell;
    }

    protected TableInterface.CellInterface buildMinPerWeek(PreferenceGroup prefGroup, boolean isEditable) {
        TableInterface.CellInterface cell = null;
        if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            Object suffix = "";
            ClassDurationType dtype = aClass.getSchedulingSubpart().getInstrOfferingConfig().getEffectiveDurationType();
            if (dtype != null && !dtype.equals(aClass.getSchedulingSubpart().getSession().getDefaultClassDurationType())) {
                suffix = " " + dtype.getAbbreviation();
            }
            cell = this.initNormalCell(aClass.getSchedulingSubpart().getMinutesPerWk() + (String)suffix, isEditable);
            cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
        } else if (prefGroup instanceof SchedulingSubpart) {
            SchedulingSubpart aSchedulingSubpart = (SchedulingSubpart)prefGroup;
            Object suffix = "";
            ClassDurationType dtype = aSchedulingSubpart.getInstrOfferingConfig().getEffectiveDurationType();
            if (dtype != null && !dtype.equals(aSchedulingSubpart.getSession().getDefaultClassDurationType())) {
                suffix = " " + dtype.getAbbreviation();
            }
            cell = this.initNormalCell(aSchedulingSubpart.getMinutesPerWk() + (String)suffix, isEditable);
            cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
        } else {
            cell = this.initNormalCell("", isEditable);
        }
        return cell;
    }

    private TableInterface.CellInterface buildRoomLimit(PreferenceGroup prefGroup, boolean isEditable, boolean classLimitDisplayed) {
        TableInterface.CellInterface cell = null;
        if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            if (aClass.getNbrRooms() != null && aClass.getNbrRooms() != 1) {
                if (aClass.getNbrRooms() == 0) {
                    cell = this.initNormalCell(MSG.notApplicable(), isEditable);
                    cell.addStyle("color: gray; font-style: italic;");
                } else if (Boolean.TRUE.equals(aClass.isRoomsSplitAttendance())) {
                    cell = this.initNormalCell(MSG.cellNbrRoomsAndRoomRatioSlitAttendance(aClass.getNbrRooms(), aClass.getRoomRatio() == null ? "0" : sRoomRatioFormat.format(aClass.getRoomRatio())), isEditable);
                    cell.setTitle(MSG.titleNbrRoomsAndRoomRatioSlitAttendance(aClass.getNbrRooms(), aClass.getRoomRatio() == null ? "0" : sRoomRatioFormat.format(aClass.getRoomRatio())));
                    cell.setNoWrap(true);
                } else {
                    cell = this.initNormalCell(MSG.cellNbrRoomsAndRoomRatio(aClass.getNbrRooms(), aClass.getRoomRatio() == null ? "0" : sRoomRatioFormat.format(aClass.getRoomRatio())), isEditable);
                    cell.setTitle(MSG.titleNbrRoomsAndRoomRatio(aClass.getNbrRooms(), aClass.getRoomRatio() == null ? "0" : sRoomRatioFormat.format(aClass.getRoomRatio())));
                    cell.setNoWrap(true);
                }
            } else {
                cell = aClass.getRoomRatio() != null ? (classLimitDisplayed && aClass.getRoomRatio().equals(Float.valueOf(1.0f)) ? this.initNormalCell("", isEditable) : this.initNormalCell(sRoomRatioFormat.format(aClass.getRoomRatio().floatValue()), isEditable)) : (aClass.getExpectedCapacity() == null ? this.initNormalCell("", isEditable) : this.initNormalCell("0", isEditable));
            }
            cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
        } else {
            cell = this.initNormalCell("", isEditable);
        }
        return cell;
    }

    private TableInterface.CellInterface buildAssignedTime(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        TableInterface.CellInterface cell = null;
        if (classAssignment != null && prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            ClassAssignmentProxy.AssignmentInfo a = null;
            AssignmentPreferenceInfo info = null;
            try {
                a = classAssignment.getAssignment(aClass);
                info = classAssignment.getAssignmentInfo(aClass);
            }
            catch (Exception e) {
                Debug.error(e);
            }
            if (a != null) {
                StringBuffer sb = new StringBuffer();
                Integer firstDay = ApplicationProperty.TimePatternFirstDayOfWeek.intValue();
                for (int i = 0; i < CONSTANTS.shortDays().length; ++i) {
                    int idx;
                    int n = idx = firstDay == null ? i : (i + firstDay) % 7;
                    if ((Constants.DAY_CODES[idx] & a.getTimeLocation().getDayCode()) == 0) continue;
                    sb.append(CONSTANTS.shortDays()[idx]);
                }
                sb.append(" ");
                sb.append(a.getTimeLocation().getStartTimeHeader(CONSTANTS.useAmPm()));
                sb.append("-");
                sb.append(a.getTimeLocation().getEndTimeHeader(CONSTANTS.useAmPm()));
                cell = this.initNormalCell(sb.toString(), isEditable);
            } else {
                cell = this.initNormalCell("", isEditable);
            }
            cell.setTextAlignment(TableInterface.CellInterface.Alignment.LEFT);
            cell.setNoWrap(true);
            if (info != null) {
                cell.setColor(isEditable ? PreferenceLevel.int2color(info.getTimePreference()) : this.disabledColor);
            }
        } else {
            cell = this.initNormalCell("", isEditable);
        }
        return cell;
    }

    private TableInterface.CellInterface buildAssignedRoom(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        TableInterface.CellInterface cell = new TableInterface.CellInterface();
        if (!isEditable) {
            cell.setColor(this.disabledColor);
        }
        if (classAssignment != null && prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            ClassAssignmentProxy.AssignmentInfo a = null;
            AssignmentPreferenceInfo info = null;
            try {
                a = classAssignment.getAssignment(aClass);
                info = classAssignment.getAssignmentInfo(aClass);
            }
            catch (Exception e) {
                Debug.error(e);
            }
            if (a != null) {
                for (Location room : a.getRooms()) {
                    if (info != null) {
                        cell.add(room.getLabel()).setColor(isEditable ? PreferenceLevel.int2color(info.getRoomPreference(room.getUniqueId())) : this.disabledColor).setInline(false).setMouseOver("$wnd.showGwtRoomHint($wnd.lastMouseOverElement, '" + room.getUniqueId() + "', '" + (isEditable ? PreferenceLevel.int2string(info.getRoomPreference(room.getUniqueId())) : "") + "');").setMouseOut("$wnd.hideGwtRoomHint();");
                        continue;
                    }
                    cell.add(room.getLabel()).setInline(false);
                }
            }
        }
        cell.setTextAlignment(TableInterface.CellInterface.Alignment.LEFT);
        cell.setNoWrap(true);
        return cell;
    }

    private TableInterface.CellInterface buildAssignedRoomCapacity(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        TableInterface.CellInterface cell = new TableInterface.CellInterface();
        if (!isEditable) {
            cell.setColor(this.disabledColor);
        }
        if (classAssignment != null && prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            ClassAssignmentProxy.AssignmentInfo a = null;
            try {
                a = classAssignment.getAssignment(aClass);
            }
            catch (Exception e) {
                Debug.error(e);
            }
            if (a != null) {
                for (Location room : a.getRooms()) {
                    cell.add(room.getCapacity().toString()).setInline(false);
                }
            }
        }
        cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
        cell.setNoWrap(true);
        return cell;
    }

    protected TableInterface.CellInterface buildLmsInfo(PreferenceGroup prefGroup, boolean isEditable) {
        Class_ aClass;
        TableInterface.CellInterface cell = this.initNormalCell("", isEditable);
        if (prefGroup instanceof Class_ && LearningManagementSystemInfo.isLmsInfoDefinedForSession((aClass = (Class_)prefGroup).getSessionId())) {
            if (aClass.getLms() != null) {
                cell.setText(aClass.getLms().getLabel());
            }
            cell.setTextAlignment(TableInterface.CellInterface.Alignment.LEFT);
        }
        return cell;
    }

    protected void buildClassOrSubpartRow(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, TableInterface.LineInterface row, CourseOffering co, PreferenceGroup prefGroup, int indentSpaces, boolean isEditable, String prevLabel, boolean printSchedDisc) {
        boolean classLimitDisplayed = false;
        if (this.isShowLabel()) {
            row.addCell(this.buildPrefGroupLabel(co, prefGroup, indentSpaces, isEditable, prevLabel));
        }
        if (this.isShowDivSec()) {
            row.addCell(this.buildDivisionSection(co, prefGroup, isEditable));
        }
        if (this.isShowDemand()) {
            row.addCell(this.buildPrefGroupDemand(prefGroup, isEditable));
        }
        if (this.isShowProjectedDemand()) {
            row.addCell(this.buildPrefGroupProjectedDemand(prefGroup, isEditable));
        }
        if (this.isShowLimit()) {
            classLimitDisplayed = true;
            row.addCell(this.buildLimit(classAssignment, prefGroup, isEditable));
        }
        if (this.isShowSnapshotLimit()) {
            row.addCell(this.buildSnapshotLimit(prefGroup, isEditable));
        }
        if (this.isShowRoomRatio()) {
            row.addCell(this.buildRoomLimit(prefGroup, isEditable, classLimitDisplayed));
        }
        if (this.isShowManager()) {
            row.addCell(this.buildManager(prefGroup, isEditable));
        }
        if (this.isShowFundingDepartment()) {
            row.addCell(this.buildFundingDepartment(prefGroup, isEditable));
        }
        if (this.isShowDatePattern()) {
            row.addCell(this.buildDatePatternCell(classAssignment, prefGroup, isEditable));
        }
        if (this.isShowMinPerWk()) {
            row.addCell(this.buildMinPerWeek(prefGroup, isEditable));
        }
        if (this.isShowTimePattern()) {
            row.addCell(this.buildTimePatternCell(prefGroup, isEditable));
        }
        if (this.isShowPreferences()) {
            row.addCell(this.buildPreferenceCell(classAssignment, prefGroup, TimePref.class, isEditable));
            row.addCell(this.buildPreferenceCell(classAssignment, prefGroup, new Class[]{RoomPref.class, BuildingPref.class, RoomFeaturePref.class, RoomGroupPref.class}, isEditable));
            if (this.getDisplayDistributionPrefs()) {
                row.addCell(this.buildPreferenceCell(classAssignment, prefGroup, DistributionPref.class, isEditable));
            }
        }
        if (this.getDisplayInstructorPrefs()) {
            row.addCell(this.buildPreferenceCell(classAssignment, prefGroup, InstructorAttributePref.class, isEditable));
            row.addCell(this.buildPreferenceCell(classAssignment, prefGroup, InstructorPref.class, isEditable));
        }
        if (this.isShowInstructorAssignment()) {
            row.addCell(this.buildInstructorAssignment(prefGroup, isEditable));
        }
        if (this.isShowInstructor()) {
            row.addCell(this.buildInstructor(prefGroup, isEditable));
        }
        if (this.getDisplayTimetable() && this.isShowTimetable()) {
            row.addCell(this.buildAssignedTime(classAssignment, prefGroup, isEditable));
            row.addCell(this.buildAssignedRoom(classAssignment, prefGroup, isEditable));
            row.addCell(this.buildAssignedRoomCapacity(classAssignment, prefGroup, isEditable));
        }
        if (this.isShowTitle()) {
            row.addCell(this.initNormalCell("", isEditable));
        }
        if (this.isShowCredit()) {
            row.addCell(this.initNormalCell("", isEditable));
        }
        if (this.isShowSubpartCredit()) {
            row.addCell(this.buildCredit(prefGroup, isEditable));
        }
        if (this.isShowConsent()) {
            row.addCell(this.initNormalCell("", isEditable));
        }
        if (this.isShowSchedulePrintNote()) {
            if (printSchedDisc && prefGroup instanceof SchedulingSubpart) {
                SchedulingSubpart ss = (SchedulingSubpart)prefGroup;
                if (ss.getInstrOfferingConfig().getSchedulingDisclaimer() != null && !ss.getInstrOfferingConfig().getSchedulingDisclaimer().isEmpty()) {
                    row.addCell(this.buildSchedulingDisclaimer(ss.getInstrOfferingConfig(), isEditable));
                } else {
                    row.addCell(this.initNormalCell("", isEditable));
                }
            } else {
                row.addCell(this.buildSchedulePrintNote(prefGroup, isEditable));
            }
        }
        if (this.isShowNote()) {
            row.addCell(this.buildNote(prefGroup, isEditable));
        }
        if (this.isShowExam()) {
            if (prefGroup instanceof Class_) {
                TreeSet exams = this.getExams((Class_)prefGroup);
                Iterator i = exams.iterator();
                while (i.hasNext()) {
                    if (this.getSessionContext().hasPermission(i.next(), Right.ExaminationView)) continue;
                    i.remove();
                }
                if (this.isShowExamName()) {
                    row.addCell(this.buildExamName(exams, isEditable));
                }
                if (this.isShowExamTimetable()) {
                    row.addCell(this.buildExamPeriod(examAssignment, exams, isEditable));
                    row.addCell(this.buildExamRoom(examAssignment, exams, isEditable));
                }
            } else {
                if (this.isShowExamName()) {
                    row.addCell(this.initNormalCell("", isEditable));
                }
                if (this.isShowExamTimetable()) {
                    row.addCell(this.initNormalCell("", isEditable));
                    row.addCell(this.initNormalCell("", isEditable));
                }
            }
        }
        if (this.isShowLms()) {
            row.addCell(this.buildLmsInfo(prefGroup, isEditable));
        }
        if (this.isShowWaitlistMode()) {
            row.addCell(this.initNormalCell("", isEditable));
        }
    }

    private void buildSchedulingSubpartRow(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, TableInterface table, CourseOffering co, SchedulingSubpart ss, int indentSpaces, boolean printSchedDisc) {
        boolean isEditable = this.getSessionContext().hasPermission(ss, Right.SchedulingSubpartDetail);
        boolean isOffered = ss.getInstrOfferingConfig().getInstructionalOffering().isNotOffered() == false;
        TableInterface.LineInterface row = this.initRow(true);
        if (isEditable && isOffered) {
            row.setURL("subpart?id=" + ss.getUniqueId());
        }
        this.buildClassOrSubpartRow(classAssignment, examAssignment, row, co, ss, indentSpaces, isEditable, null, printSchedDisc);
        if (this.isSimple()) {
            row.setBgColor("#E1E1E1");
        }
        table.addLine(row);
    }

    private void buildSchedulingSubpartRows(Vector subpartIds, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, TableInterface table, CourseOffering co, SchedulingSubpart ss, int indentSpaces, boolean printSchedDisc) {
        if (subpartIds != null) {
            subpartIds.add(ss.getUniqueId());
        }
        this.buildSchedulingSubpartRow(classAssignment, examAssignment, table, co, ss, indentSpaces, printSchedDisc);
        Set<SchedulingSubpart> childSubparts = ss.getChildSubparts();
        if (childSubparts != null && !childSubparts.isEmpty()) {
            ArrayList<SchedulingSubpart> childSubpartList = new ArrayList<SchedulingSubpart>(childSubparts);
            Collections.sort(childSubpartList, new SchedulingSubpartComparator());
            Iterator<SchedulingSubpart> it = childSubpartList.iterator();
            SchedulingSubpart child = null;
            while (it.hasNext()) {
                child = it.next();
                this.buildSchedulingSubpartRows(subpartIds, classAssignment, examAssignment, table, co, child, indentSpaces + 1, false);
            }
        }
    }

    protected void buildClassRow(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, int ct, TableInterface table, CourseOffering co, Class_ aClass, int indentSpaces, String prevLabel) {
        boolean isHeaderRow = false;
        boolean isEditable = this.getSessionContext().hasPermission(aClass, Right.ClassDetail);
        TableInterface.LineInterface row = this.initRow(isHeaderRow);
        if (isEditable) {
            row.setURL("clazz?id=" + aClass.getUniqueId().toString());
        }
        if (aClass.isCancelled().booleanValue()) {
            row.setStyle("color: gray; font-style: italic;");
            row.setTitle(MSG.classNoteCancelled(aClass.getClassLabel(co)));
        }
        if (this.getDisplayConflicts() && classAssignment != null) {
            Set<ClassAssignmentProxy.AssignmentInfo> conflicts = null;
            try {
                conflicts = classAssignment.getConflicts(aClass.getUniqueId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (conflicts != null && !conflicts.isEmpty()) {
                row.setBgColor("#fff0f0");
                Object s = "";
                for (ClassAssignmentProxy.AssignmentInfo c : conflicts) {
                    if (!((String)s).isEmpty()) {
                        s = (String)s + ", ";
                    }
                    s = (String)s + (c.getClassName() + " " + c.getPlacement().getName(CONSTANTS.useAmPm())).trim();
                }
                row.setWarning(MSG.classIsConflicting(aClass.getClassLabel(co), (String)s));
            } else {
                Set<RoomAvailabilityInterface.TimeBlock> ec = null;
                try {
                    ec = classAssignment.getConflictingTimeBlocks(aClass.getUniqueId());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (ec != null && !ec.isEmpty()) {
                    Object s = "";
                    String lastName = null;
                    String lastType = null;
                    for (RoomAvailabilityInterface.TimeBlock t : ec) {
                        if (lastName != null && lastName.equals(t.getEventName()) && lastType.equals(t.getEventType())) continue;
                        lastName = t.getEventName();
                        lastType = t.getEventType();
                        if (!((String)s).isEmpty()) {
                            s = (String)s + ", ";
                        }
                        s = (String)s + lastName + " (" + lastType + ")";
                    }
                    row.setBgColor("#fff0f0");
                    row.setWarning(MSG.classIsConflicting(aClass.getClassLabel(co), (String)s));
                }
            }
        }
        if (this.getDisplayDatePatternDifferentWarning() && classAssignment != null) {
            ClassAssignmentProxy.AssignmentInfo a = null;
            boolean changedSinceCommit = false;
            DatePattern newDp = null;
            try {
                a = classAssignment.getAssignment(aClass);
                if (a != null && a.isCommitted() && a.getDatePattern() != null && !a.getDatePattern().equals(aClass.effectiveDatePattern())) {
                    if (aClass.effectiveDatePattern().isPatternSet() && a.getDatePattern().getParents() != null && a.getDatePattern().getParents().contains(aClass.effectiveDatePattern())) {
                        changedSinceCommit = false;
                    } else {
                        changedSinceCommit = true;
                        newDp = aClass.effectiveDatePattern();
                    }
                }
            }
            catch (Exception e) {
                Debug.error(e);
            }
            if (changedSinceCommit) {
                row.setBgColor("#fff0f0");
                Object msg = row.getTitle();
                msg = msg == null ? "" : (String)msg + " ";
                msg = (String)msg + MSG.datePatternCommittedIsDifferent(aClass.getClassLabel(co), a.getDatePattern().getName(), newDp.getName());
                row.setWarning((String)msg);
            }
        }
        this.buildClassOrSubpartRow(classAssignment, examAssignment, row, co, aClass, indentSpaces, isEditable && aClass.isCancelled() == false, prevLabel, false);
        table.addLine(row);
    }

    private void buildClassRows(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, int ct, TableInterface table, CourseOffering co, Class_ aClass, int indentSpaces, String prevLabel) {
        this.buildClassRow(classAssignment, examAssignment, ct, table, co, aClass, indentSpaces, prevLabel);
        Set<Class_> childClasses = aClass.getChildClasses();
        if (childClasses != null && !childClasses.isEmpty()) {
            ArrayList<Class_> childClassesList = new ArrayList<Class_>(childClasses);
            Collections.sort(childClassesList, this.iClassComparator);
            Iterator<Class_> it = childClassesList.iterator();
            Class_ child = null;
            String previousLabel = aClass.htmlLabel();
            while (it.hasNext()) {
                child = it.next();
                this.buildClassRows(classAssignment, examAssignment, ct, table, co, child, indentSpaces + 1, previousLabel);
            }
        }
    }

    protected void buildConfigRow(Vector subpartIds, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, TableInterface table, CourseOffering co, InstrOfferingConfig ioc, boolean printConfigLine, boolean printConfigReservation, boolean printSchedDisc) {
        boolean isHeaderRow = true;
        boolean isEditable = this.getSessionContext().hasPermission(ioc.getInstructionalOffering(), Right.InstructionalOfferingDetail);
        String configName = ioc.getName();
        boolean unlimited = ioc.isUnlimitedEnrollment();
        boolean hasConfig = false;
        if (printConfigLine) {
            TableInterface.LineInterface row = this.initRow(isHeaderRow);
            TableInterface.CellInterface cell = null;
            if (this.isShowLabel()) {
                if (configName == null || configName.trim().length() == 0) {
                    configName = ioc.getUniqueId().toString();
                }
                cell = ioc.getInstructionalMethod() != null ? this.initNormalCell(MSG.labelConfigurationWithInstructionalMethod(configName, ioc.getInstructionalMethod().getReference()), isEditable).setTitle(ioc.getInstructionalMethod().getLabel()) : this.initNormalCell(MSG.labelConfiguration(configName), isEditable);
                cell.setIndent(1);
                cell.setNoWrap(true);
                row.addCell(cell);
            }
            if (this.isShowDivSec()) {
                row.addCell(this.initNormalCell("", isEditable));
            }
            if (this.isShowDemand()) {
                row.addCell(this.initNormalCell("", isEditable));
            }
            if (this.isShowProjectedDemand()) {
                row.addCell(this.initNormalCell("", isEditable));
            }
            if (this.isShowLimit()) {
                cell = this.initNormalCell(unlimited ? "\u221e" : ioc.getLimit().toString(), isEditable);
                if (unlimited) {
                    cell.addStyle("font-size: +1");
                }
                cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                row.addCell(cell);
            }
            if (this.isShowSnapshotLimit()) {
                row.addCell(this.initNormalCell("", isEditable));
            }
            if (this.isShowRoomRatio()) {
                row.addCell(this.initNormalCell("", isEditable));
            }
            if (this.isShowManager()) {
                row.addCell(this.initNormalCell("", isEditable));
            }
            if (this.isShowFundingDepartment()) {
                row.addCell(this.initNormalCell("", isEditable));
            }
            if (this.isShowDatePattern()) {
                row.addCell(this.initNormalCell("", isEditable));
            }
            if (this.isShowMinPerWk()) {
                row.addCell(this.initNormalCell("", isEditable));
            }
            if (this.isShowTimePattern()) {
                row.addCell(this.initNormalCell("", isEditable));
            }
            if (this.isShowPreferences() || this.getDisplayInstructorPrefs()) {
                for (int j = 0; j < this.getPreferenceColumns(); ++j) {
                    row.addCell(this.initNormalCell("", isEditable));
                }
            }
            if (this.isShowInstructorAssignment()) {
                row.addCell(this.initNormalCell("", isEditable));
            }
            if (this.isShowInstructor()) {
                row.addCell(this.initNormalCell("", isEditable));
            }
            if (this.getDisplayTimetable() && this.isShowTimetable()) {
                row.addCell(this.initNormalCell("", isEditable));
                row.addCell(this.initNormalCell("", isEditable));
                row.addCell(this.initNormalCell("", isEditable));
            }
            if (this.isShowTitle()) {
                row.addCell(this.initNormalCell("", isEditable));
            }
            if (this.isShowCredit()) {
                row.addCell(this.initNormalCell("", isEditable));
            }
            if (this.isShowSubpartCredit()) {
                row.addCell(this.initNormalCell("", isEditable));
            }
            if (this.isShowConsent()) {
                row.addCell(this.initNormalCell("", isEditable));
            }
            if (this.isShowSchedulePrintNote()) {
                row.addCell(this.buildSchedulingDisclaimer(ioc, isEditable));
            }
            if (this.isShowNote()) {
                if (!this.isShowSchedulePrintNote()) {
                    row.addCell(this.buildSchedulingDisclaimer(ioc, isEditable));
                } else {
                    row.addCell(this.initNormalCell("", isEditable));
                }
            }
            if (this.isShowExam()) {
                TreeSet<Exam> exams = new TreeSet<Exam>(Exam.findAll(2, ioc.getUniqueId()));
                Iterator<Exam> i = exams.iterator();
                while (i.hasNext()) {
                    if (this.getSessionContext().hasPermission(i.next(), Right.ExaminationView)) continue;
                    i.remove();
                }
                if (this.isShowExamName()) {
                    row.addCell(this.buildExamName(exams, isEditable));
                }
                if (this.isShowExamTimetable()) {
                    row.addCell(this.buildExamPeriod(examAssignment, exams, isEditable));
                    row.addCell(this.buildExamRoom(examAssignment, exams, isEditable));
                }
            }
            if (this.isShowLms()) {
                row.addCell(this.initNormalCell("", isEditable));
            }
            if (this.isShowWaitlistMode()) {
                row.addCell(this.initNormalCell("", isEditable));
            }
            if (this.isSimple()) {
                row.setBgColor("#C8C8C8");
            }
            table.addLine(row);
            hasConfig = true;
        }
        ArrayList<SchedulingSubpart> subpartList = new ArrayList<SchedulingSubpart>(ioc.getSchedulingSubparts());
        Collections.sort(subpartList, new SchedulingSubpartComparator());
        Iterator<SchedulingSubpart> it = subpartList.iterator();
        SchedulingSubpart ss = null;
        while (it.hasNext()) {
            ss = it.next();
            if (ss.getParentSubpart() != null) continue;
            this.buildSchedulingSubpartRows(subpartIds, classAssignment, examAssignment, table, co, ss, hasConfig ? 2 : 1, printSchedDisc);
            printSchedDisc = false;
        }
        it = subpartList.iterator();
        int ct = 0;
        String prevLabel = null;
        while (it.hasNext()) {
            ss = it.next();
            if (ss.getParentSubpart() != null || ss.getClasses() == null) continue;
            Vector<Class_> classes = new Vector<Class_>(ss.getClasses());
            Collections.sort(classes, this.iClassComparator);
            Iterator<Class_> cIt = classes.iterator();
            Class_ c = null;
            while (cIt.hasNext()) {
                c = cIt.next();
                this.buildClassRows(classAssignment, examAssignment, ++ct, table, co, c, 1, prevLabel);
                prevLabel = c.htmlLabel();
            }
        }
    }

    private void buildConfigRows(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, TableInterface table, CourseOffering co, Set instrOfferingConfigs, boolean printConfigLine, boolean printConfigReservation) {
        Iterator it = instrOfferingConfigs.iterator();
        InstrOfferingConfig ioc = null;
        while (it.hasNext()) {
            ioc = (InstrOfferingConfig)it.next();
            this.buildConfigRow(null, classAssignment, examAssignment, table, co, ioc, printConfigLine && instrOfferingConfigs.size() > 1, printConfigReservation, !printConfigLine || instrOfferingConfigs.size() == 1);
        }
    }

    private void addInstrOffrRowsToTable(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, TableInterface table, InstructionalOffering io, Long subjectAreaId) {
        TableInterface.CellInterface c;
        Iterator<InstrOfferingConfig> x;
        boolean unlimited;
        CourseOffering co = io.findSortCourseOfferingForSubjectArea(subjectAreaId);
        boolean isEditable = this.getSessionContext().hasPermission(io, Right.InstructionalOfferingDetail);
        TableInterface.LineInterface row = this.initRow(true);
        if (isEditable) {
            row.setURL("instructionalOfferingDetail.action?op=view&io=" + io.getUniqueId());
        }
        boolean isManagedAs = co.isIsControl() == false;
        TableInterface.CellInterface cell = null;
        if (this.isShowLabel()) {
            row.addCell(this.subjectAndCourseInfo(io, co, isEditable));
        }
        if (this.isShowDivSec()) {
            row.addCell(this.initNormalCell("", isEditable));
        }
        if (this.isShowDemand()) {
            if (this.sessionHasEnrollments(io.getSessionId())) {
                cell = this.initNormalCell(io.getEnrollment() != null ? io.getEnrollment().toString() : "0", isEditable && co.isIsControl() != false);
            } else {
                cell = this.initNormalCell(io.getDemand() != null ? io.getDemand().toString() : "0", isEditable && co.isIsControl() != false);
                if (co.isIsControl().booleanValue() && !io.isNotOffered().booleanValue() && (io.getDemand() == null || io.getDemand() == 0)) {
                    cell.setColor("red");
                    cell.addStyle("='font-weight: bold;");
                }
            }
            cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
            row.addCell(cell);
        }
        if (this.isShowProjectedDemand()) {
            cell = this.initNormalCell(io.getProjectedDemand() != null ? io.getProjectedDemand().toString() : "0", isEditable && co.isIsControl() != false);
            cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
            row.addCell(cell);
        }
        if (this.isShowLimit()) {
            unlimited = false;
            x = io.getInstrOfferingConfigs().iterator();
            while (!unlimited && x.hasNext()) {
                if (!x.next().isUnlimitedEnrollment().booleanValue()) continue;
                unlimited = true;
            }
            if (unlimited) {
                cell = this.initNormalCell("\u221e", co.isIsControl());
                cell.addStyle("font-size: +1");
            } else {
                cell = this.initNormalCell(io.getLimit() != null ? io.getLimit().toString() : "", isEditable && co.isIsControl() != false);
            }
            cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
            row.addCell(cell);
        }
        if (this.isShowSnapshotLimit()) {
            unlimited = false;
            x = io.getInstrOfferingConfigs().iterator();
            while (!unlimited && x.hasNext()) {
                if (!x.next().isUnlimitedEnrollment().booleanValue()) continue;
                unlimited = true;
            }
            if (unlimited) {
                cell = this.initNormalCell("\u221e", co.isIsControl());
                cell.addStyle("font-size: +1");
            } else {
                cell = this.initNormalCell(io.getSnapshotLimit() != null ? io.getSnapshotLimit().toString() : "", isEditable && co.isIsControl() != false);
            }
            cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
            row.addCell(cell);
        }
        int emptyCells = 0;
        cell = null;
        if (this.isShowRoomRatio()) {
            ++emptyCells;
        }
        if (this.isShowManager()) {
            ++emptyCells;
        }
        if (this.isShowFundingDepartment()) {
            ++emptyCells;
        }
        if (this.isShowDatePattern()) {
            ++emptyCells;
        }
        if (this.isShowMinPerWk()) {
            ++emptyCells;
        }
        if (this.isShowTimePattern()) {
            ++emptyCells;
        }
        if (this.isShowPreferences() || this.getDisplayInstructorPrefs()) {
            emptyCells += this.getPreferenceColumns();
        }
        if (this.isShowInstructorAssignment()) {
            ++emptyCells;
        }
        if (this.isShowInstructor()) {
            ++emptyCells;
        }
        if (this.getDisplayTimetable() && this.isShowTimetable()) {
            emptyCells += 3;
        }
        if (emptyCells > 0) {
            cell = this.initNormalCell("", isEditable);
            if (isManagedAs) {
                if (!this.isShowTitle() && io.getControllingCourseOffering().getTitle() != null) {
                    if (co.getTitle() != null && co.getTitle().length() > 0) {
                        TableInterface.CellInterface c2 = cell.add(co.getTitle()).addStyle("font-weight: bold;");
                        c2.add(" (");
                        c2.add(MSG.crossListManagedAs(io.getControllingCourseOffering().getCourseName())).setTitle(io.getControllingCourseOffering().getCourseNameWithTitle());
                        c2.add(")");
                    } else {
                        cell.add(MSG.crossListManagedAs(io.getControllingCourseOffering().getCourseName())).setTitle(io.getControllingCourseOffering().getCourseNameWithTitle());
                    }
                    for (CourseOffering x2 : io.courseOfferingsMinusSortCourseOfferingForSubjectArea(co.getSubjectArea().getUniqueId())) {
                        cell.add(x2.getTitle()).setTitle(x2.getCourseNameWithTitle()).setColor(this.disabledColor).setIndent(1).setInline(false);
                    }
                    cell.setColor(this.disabledColor);
                } else {
                    cell.setIndent(1);
                    cell.setText(MSG.crossListManagedAs(io.getControllingCourseOffering().getCourseName()));
                    cell.setTitle(io.getControllingCourseOffering().getCourseNameWithTitle());
                }
            } else if (!this.isShowTitle() && io.getControllingCourseOffering().getTitle() != null) {
                cell.add(co.getTitle()).addStyle("font-weight: bold;");
                for (CourseOffering x2 : io.courseOfferingsMinusSortCourseOfferingForSubjectArea(co.getSubjectArea().getUniqueId())) {
                    cell.add(x2.getTitle()).setTitle(x2.getCourseNameWithTitle()).setColor(this.disabledColor).setIndent(1).setInline(false);
                }
            }
            cell.setColSpan(emptyCells);
            cell.setTextAlignment(TableInterface.CellInterface.Alignment.LEFT);
            cell.setInline(false);
            row.addCell(cell);
        }
        if (this.isShowTitle()) {
            cell = this.initNormalCell("", isEditable);
            if (co.getTitle() != null) {
                if (isManagedAs) {
                    cell.setText(co.getTitle());
                    cell.setColor(this.disabledColor);
                } else {
                    cell.setText(co.getTitle());
                }
            }
            for (CourseOffering x2 : io.courseOfferingsMinusSortCourseOfferingForSubjectArea(co.getSubjectArea().getUniqueId())) {
                cell.add(x2.getTitle() == null ? "" : x2.getTitle()).setColor(this.disabledColor).setInline(false).setNoWrap(true);
            }
            if (io.getCourseOfferings().size() > 1) {
                cell.setNoWrap(true);
            }
            row.addCell(cell);
        }
        if (this.isShowCredit()) {
            cell = this.initNormalCell("", isEditable);
            if (co.getCredit() != null) {
                cell.setText(co.getCredit().creditAbbv());
                cell.setTitle(co.getCredit().creditAbbv());
                cell.setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
            }
            if (co.isIsControl().booleanValue()) {
                cell.addStyle("font-weight: bold;");
            } else {
                cell.setColor(this.disabledColor);
            }
            for (CourseOffering x2 : io.courseOfferingsMinusSortCourseOfferingForSubjectArea(co.getSubjectArea().getUniqueId())) {
                if (x2.getCredit() != null) {
                    c = cell.add(x2.getCredit().creditAbbv()).setTitle(x2.getCredit().creditText()).setColor(this.disabledColor).setInline(false);
                    if (!x2.isIsControl().booleanValue()) continue;
                    c.addStyle("font-weight: bold;");
                    continue;
                }
                cell.add("").setInline(false);
            }
            if (io.getCourseOfferings().size() > 1) {
                cell.setNoWrap(true);
            }
            row.addCell(cell);
        }
        if (this.isShowSubpartCredit()) {
            row.addCell(this.initNormalCell("", isEditable));
        }
        if (this.isShowConsent()) {
            cell = this.initNormalCell("", isEditable);
            if (co.isIsControl().booleanValue()) {
                cell.addStyle("font-weight: bold;");
            } else {
                cell.setColor(this.disabledColor);
            }
            if (co.getConsentType() == null) {
                cell.setText(MSG.noConsentRequired());
            } else {
                cell.setText(co.getConsentType().getAbbv());
                cell.setTitle(co.getConsentType().getLabel());
            }
            for (CourseOffering x2 : io.courseOfferingsMinusSortCourseOfferingForSubjectArea(co.getSubjectArea().getUniqueId())) {
                if (x2.getConsentType() != null) {
                    c = cell.add(x2.getConsentType().getAbbv()).setTitle(x2.getConsentType().getLabel()).setColor(this.disabledColor).setInline(false);
                    if (!x2.isIsControl().booleanValue()) continue;
                    c.addStyle("font-weight: bold;");
                    continue;
                }
                cell.add("").setInline(false);
            }
            if (io.getCourseOfferings().size() > 1) {
                cell.setNoWrap(true);
            }
            row.addCell(cell);
        }
        if (this.isShowSchedulePrintNote()) {
            row.addCell(this.buildSchedulePrintNote(io, isEditable));
        }
        if (this.isShowNote()) {
            row.addCell(this.buildNote(io, isEditable));
        }
        if (this.isShowExam()) {
            TreeSet<Exam> exams = new TreeSet<Exam>(Exam.findAll(0, io.getUniqueId()));
            for (CourseOffering cox : io.getCourseOfferings()) {
                exams.addAll(Exam.findAll(1, cox.getUniqueId()));
            }
            if (io.getInstrOfferingConfigs().size() == 1) {
                for (InstrOfferingConfig ioc : io.getInstrOfferingConfigs()) {
                    exams.addAll(Exam.findAll(2, ioc.getUniqueId()));
                }
            }
            Iterator<Serializable> i = exams.iterator();
            while (i.hasNext()) {
                if (this.getSessionContext().hasPermission(i.next(), Right.ExaminationView)) continue;
                i.remove();
            }
            if (this.isShowExamName()) {
                row.addCell(this.buildExamName(exams, isEditable));
            }
            if (this.isShowExamTimetable()) {
                row.addCell(this.buildExamPeriod(examAssignment, exams, isEditable));
                row.addCell(this.buildExamRoom(examAssignment, exams, isEditable));
            }
        }
        if (this.isShowLms()) {
            row.addCell(this.initNormalCell("", isEditable));
        }
        if (this.isShowWaitlistMode()) {
            switch (io.getEffectiveWaitListMode()) {
                case Disabled: {
                    row.addCell(this.initNormalCell(MSG.waitListDisabledShort(), isEditable));
                    break;
                }
                case ReSchedule: {
                    row.addCell(this.initNormalCell(MSG.waitListRescheduleShort(), isEditable));
                    break;
                }
                case WaitList: {
                    row.addCell(this.initNormalCell(MSG.waitListEnabledShort(), isEditable));
                    break;
                }
                default: {
                    row.addCell(this.initNormalCell("", isEditable));
                }
            }
        }
        if (this.isSimple()) {
            row.setBgColor("#C8C8C8");
        }
        table.addLine(row);
        if (io.getInstrOfferingConfigs() != null & !io.getInstrOfferingConfigs().isEmpty()) {
            TreeSet<InstrOfferingConfig> configs = new TreeSet<InstrOfferingConfig>(new InstrOfferingConfigComparator(io.getControllingCourseOffering().getSubjectArea().getUniqueId()));
            configs.addAll(io.getInstrOfferingConfigs());
            this.buildConfigRows(classAssignment, examAssignment, table, io.getControllingCourseOffering(), configs, true, false);
        }
    }

    protected TableInterface initTable(Long sessionId, String durationColName) {
        TableInterface table = new TableInterface();
        this.buildTableHeader(table, sessionId, durationColName);
        return table;
    }

    protected TableInterface initTable(Long sessionId) {
        ClassDurationType dtype = ClassDurationType.findDefaultType(sessionId, null);
        return this.initTable(sessionId, dtype == null ? MSG.columnMinPerWk() : dtype.getLabel());
    }

    public void generateTableForInstructionalOfferings(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, TableInterface.FilterInterface filter, String[] subjectAreaIds, List<TableInterface> tables) {
        this.setVisibleColumns(filter);
        String courseNbr = filter.getParameterValue("courseNbr");
        String waitList = filter.getParameterValue("waitlist");
        boolean allCoursesAreGiven = !(courseNbr != null && !courseNbr.isEmpty() || !"A".equals(waitList) && waitList != null && !waitList.isEmpty());
        ArrayList<Long> navigationOfferingIds = new ArrayList<Long>();
        for (String subjectAreaId : subjectAreaIds) {
            if ("-1".equals(subjectAreaId)) continue;
            this.generateTableForInstructionalOfferings(classAssignment, examAssignment, InstructionalOffering.search(this.getCurrentAcademicSessionId(), Long.valueOf(subjectAreaId), filter.getParameterValue("courseNbr"), true, false, false, false, false, false, filter.getParameterValue("waitlist")), Long.valueOf(subjectAreaId), allCoursesAreGiven, tables, new ClassCourseComparator(filter.getParameterValue("sortBy", "NAME"), classAssignment, false), navigationOfferingIds);
        }
        Navigation.set(this.getSessionContext(), Navigation.sInstructionalOfferingLevel, navigationOfferingIds);
    }

    protected void generateTableForInstructionalOfferings(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, TreeSet<InstructionalOffering> insructionalOfferings, Long subjectAreaId, boolean allCoursesAreGiven, List<TableInterface> tables, Comparator classComparator, List<Long> navigationOfferingIds) {
        InstructionalOffering io;
        if (insructionalOfferings == null) {
            return;
        }
        if (classComparator != null) {
            this.setClassComparator(classComparator);
        }
        SubjectArea subjectArea = (SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(subjectAreaId));
        if (this.isShowTimetable()) {
            boolean hasTimetable = false;
            if (this.getSessionContext().hasPermission(Right.ClassAssignments) && classAssignment != null) {
                try {
                    if (classAssignment instanceof CachedClassAssignmentProxy) {
                        Vector<Class_> allClasses = new Vector<Class_>();
                        Iterator<InstructionalOffering> i = insructionalOfferings.iterator();
                        while (!hasTimetable && i.hasNext()) {
                            io = i.next();
                            Iterator<InstrOfferingConfig> j = io.getInstrOfferingConfigs().iterator();
                            while (!hasTimetable && j.hasNext()) {
                                InstrOfferingConfig ioc = j.next();
                                Iterator<SchedulingSubpart> k = ioc.getSchedulingSubparts().iterator();
                                while (!hasTimetable && k.hasNext()) {
                                    SchedulingSubpart ss = k.next();
                                    for (Class_ clazz : ss.getClasses()) {
                                        allClasses.add(clazz);
                                    }
                                }
                            }
                        }
                        ((CachedClassAssignmentProxy)classAssignment).setCache(allClasses);
                        hasTimetable = !classAssignment.getAssignmentTable(allClasses).isEmpty();
                    } else {
                        Iterator<InstructionalOffering> i = insructionalOfferings.iterator();
                        while (!hasTimetable && i.hasNext()) {
                            InstructionalOffering io2 = i.next();
                            Iterator<InstrOfferingConfig> j = io2.getInstrOfferingConfigs().iterator();
                            while (!hasTimetable && j.hasNext()) {
                                InstrOfferingConfig ioc = j.next();
                                Iterator<SchedulingSubpart> k = ioc.getSchedulingSubparts().iterator();
                                block8: while (!hasTimetable && k.hasNext()) {
                                    SchedulingSubpart ss = k.next();
                                    for (Class_ clazz : ss.getClasses()) {
                                        if (classAssignment.getAssignment(clazz) == null) continue;
                                        hasTimetable = true;
                                        continue block8;
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception i) {
                    // empty catch block
                }
            }
            this.setDisplayTimetable(hasTimetable);
        }
        if (this.isShowExam()) {
            this.setShowExamTimetable(examAssignment != null || Exam.hasTimetable(this.getCurrentAcademicSessionId()));
        }
        ArrayList<InstructionalOffering> notOfferedOfferings = new ArrayList<InstructionalOffering>();
        ArrayList<InstructionalOffering> offeredOfferings = new ArrayList<InstructionalOffering>();
        Iterator<InstructionalOffering> it = insructionalOfferings.iterator();
        io = null;
        boolean hasOfferedCourses = false;
        boolean hasNotOfferedCourses = false;
        while (it.hasNext()) {
            io = it.next();
            if (io.isNotOffered() == null || io.isNotOffered().booleanValue()) {
                hasNotOfferedCourses = true;
                notOfferedOfferings.add(io);
                continue;
            }
            hasOfferedCourses = true;
            offeredOfferings.add(io);
        }
        if (hasOfferedCourses || allCoursesAreGiven) {
            it = offeredOfferings.iterator();
            TableInterface offeredTable = this.initTable(this.getCurrentAcademicSessionId());
            while (it.hasNext()) {
                io = it.next();
                if (navigationOfferingIds != null) {
                    navigationOfferingIds.add(io.getUniqueId());
                }
                this.addInstrOffrRowsToTable(classAssignment, examAssignment, offeredTable, io, subjectAreaId);
            }
            offeredTable.setAnchor("AO" + subjectAreaId);
            if (this.isFilterWaitlist()) {
                offeredTable.setName(MSG.labelOfferedWaitListedCourses(subjectArea.getSubjectAreaAbbreviation()));
            } else if (this.isFilterNonWaitlist()) {
                offeredTable.setName(MSG.labelOfferedNotWaitListedCourses(subjectArea.getSubjectAreaAbbreviation()));
            } else if (this.isFilterCoursesAllowingReScheduling()) {
                offeredTable.setName(MSG.labelOfferedCoursesAllowingReScheduling(subjectArea.getSubjectAreaAbbreviation()));
            } else if (this.isFilterCoursesNotAllowingReScheduling()) {
                offeredTable.setName(MSG.labelOfferedCoursesNotAllowingReScheduling(subjectArea.getSubjectAreaAbbreviation()));
            } else if (this.isFilterNonWaitedCoursesAllowingReScheduling()) {
                offeredTable.setName(MSG.labelOfferedNotWaitListedCoursesAllowingReScheduling(subjectArea.getSubjectAreaAbbreviation()));
            } else {
                offeredTable.setName(MSG.labelOfferedCourses(subjectArea.getSubjectAreaAbbreviation()));
            }
            if (!hasOfferedCourses) {
                offeredTable.setErrorMessage(MSG.errorNoCoursesOffered(subjectArea.getSubjectAreaAbbreviation()));
                if (!this.isSimple()) {
                    offeredTable.getHeader().clear();
                }
            }
            if (allCoursesAreGiven) {
                offeredTable.addLink(new TableInterface.LinkInteface().setHref("#AN" + subjectAreaId).setText(MSG.labelNotOfferedCourses(subjectArea.getSubjectAreaAbbreviation())));
            }
            tables.add(offeredTable);
        }
        if (hasNotOfferedCourses || allCoursesAreGiven) {
            it = notOfferedOfferings.iterator();
            TableInterface notOfferedTable = this.initTable(this.getCurrentAcademicSessionId());
            while (it.hasNext()) {
                io = it.next();
                if (navigationOfferingIds != null) {
                    navigationOfferingIds.add(io.getUniqueId());
                }
                this.addInstrOffrRowsToTable(classAssignment, examAssignment, notOfferedTable, io, subjectAreaId);
            }
            notOfferedTable.setAnchor("AN" + subjectAreaId);
            notOfferedTable.setName(MSG.labelNotOfferedCourses(subjectArea.getSubjectAreaAbbreviation()));
            if (!hasNotOfferedCourses) {
                notOfferedTable.setErrorMessage(MSG.errorAllCoursesOffered(subjectArea.getSubjectAreaAbbreviation()));
                if (!this.isSimple()) {
                    notOfferedTable.getHeader().clear();
                }
            }
            if (allCoursesAreGiven) {
                notOfferedTable.addLink(new TableInterface.LinkInteface().setHref("#AO" + subjectAreaId).setText(MSG.labelOfferedCourses(subjectArea.getSubjectAreaAbbreviation())));
            }
            tables.add(notOfferedTable);
        }
        if (navigationOfferingIds != null) {
            Navigation.set(this.getSessionContext(), Navigation.sInstructionalOfferingLevel, navigationOfferingIds);
        }
    }

    public void generateConfigTablesForInstructionalOffering(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, InstructionalOffering io, OfferingsInterface.OfferingDetailResponse response) {
        if (CommonValues.Yes.eq(this.getUser().getProperty(UserProperty.ClassesKeepSort))) {
            this.setClassComparator(new ClassCourseComparator(this.getUser().getProperty("InstructionalOfferingList.sortBy", ClassCourseComparator.getName(ClassCourseComparator.SortBy.NAME)), classAssignment, false));
        }
        Vector subpartIds = new Vector();
        if (io.getInstrOfferingConfigs() != null) {
            TreeSet<InstrOfferingConfig> configs = new TreeSet<InstrOfferingConfig>(new InstrOfferingConfigComparator(io.getControllingCourseOffering().getSubjectArea().getUniqueId()));
            configs.addAll(io.getInstrOfferingConfigs());
            for (InstrOfferingConfig ioc : configs) {
                response.addConfig(this.generateTableForInstructionalOfferingConfig(subpartIds, classAssignment, examAssignment, ioc));
            }
        }
        Navigation.set(this.getSessionContext(), Navigation.sSchedulingSubpartLevel, subpartIds);
    }

    private OfferingsInterface.OfferingConfigInterface generateTableForInstructionalOfferingConfig(Vector subpartIds, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, InstrOfferingConfig ioc) {
        if (CommonValues.Yes.eq(this.getUser().getProperty(UserProperty.ClassesKeepSort))) {
            this.setClassComparator(new ClassCourseComparator(this.getUser().getProperty("InstructionalOfferingList.sortBy", ClassCourseComparator.getName(ClassCourseComparator.SortBy.NAME)), classAssignment, false));
        }
        OfferingsInterface.OfferingConfigInterface ret = new OfferingsInterface.OfferingConfigInterface();
        ret.setConfigId(ioc.getUniqueId());
        ret.setSchedulingDisclaimer(ioc.getSchedulingDisclaimer());
        if (ioc.getInstructionalMethod() != null) {
            ret.setName(MSG.labelConfigurationWithInstructionalMethod(ioc.getName(), ioc.getInstructionalMethod().getLabel()));
        } else {
            ret.setName(MSG.labelConfiguration(ioc.getName()));
        }
        if (!ioc.getInstructionalOffering().isNotOffered().booleanValue()) {
            if (this.getSessionContext().hasPermission(ioc, Right.InstrOfferingConfigEdit)) {
                ret.addOperation("config-edit");
            }
            if (this.getSessionContext().hasPermission(ioc, Right.MultipleClassSetup)) {
                ret.addOperation("class-setup");
            }
            if (this.getSessionContext().hasPermission(ioc, Right.AssignInstructors)) {
                ret.addOperation("assign-instructors");
            }
        }
        this.setDisplayDistributionPrefs(false);
        this.setShowLabel(true);
        this.setShowDemand(this.sessionHasEnrollments(this.getCurrentAcademicSessionId()));
        this.setShowProjectedDemand(false);
        this.setShowMinPerWk(true);
        this.setShowLimit(true);
        this.setShowSnapshotLimit(ioc.getInstructionalOffering().getSession().getCurrentSnapshotDate() != null);
        this.setShowRoomRatio(true);
        this.setShowFundingDepartment(false);
        if (ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue()) {
            block2: for (SchedulingSubpart ss : ioc.getSchedulingSubparts()) {
                for (Class_ c : ss.getClasses()) {
                    if (c.getFundingDept() == null) continue;
                    this.setShowFundingDepartment(true);
                    break block2;
                }
            }
        }
        this.setShowManager(true);
        this.setShowDatePattern(true);
        this.setShowTimePattern(true);
        this.setShowPreferences(true);
        this.setShowInstructor(true);
        this.setShowTimetable(true);
        this.setShowCredit(false);
        this.setShowNote(false);
        this.setShowConsent(false);
        this.setShowTitle(false);
        this.setShowExam(false);
        this.setShowLms(LearningManagementSystemInfo.isLmsInfoDefinedForSession(ioc.getSessionId()));
        this.setShowWaitlistMode(false);
        this.setDisplayConflicts(true);
        if (this.isShowTimetable()) {
            boolean hasTimetable = false;
            if (this.getSessionContext().hasPermission(Right.ClassAssignments) && classAssignment != null) {
                try {
                    if (classAssignment instanceof CachedClassAssignmentProxy) {
                        Vector<Class_> allClasses = new Vector<Class_>();
                        Iterator<SchedulingSubpart> k = ioc.getSchedulingSubparts().iterator();
                        while (!hasTimetable && k.hasNext()) {
                            SchedulingSubpart ss = k.next();
                            for (Class_ clazz : ss.getClasses()) {
                                allClasses.add(clazz);
                            }
                        }
                        ((CachedClassAssignmentProxy)classAssignment).setCache(allClasses);
                        hasTimetable = !classAssignment.getAssignmentTable(allClasses).isEmpty();
                    } else {
                        Iterator<SchedulingSubpart> k = ioc.getSchedulingSubparts().iterator();
                        block6: while (!hasTimetable && k.hasNext()) {
                            SchedulingSubpart ss = k.next();
                            for (Class_ clazz : ss.getClasses()) {
                                if (classAssignment.getAssignment(clazz) == null) continue;
                                hasTimetable = true;
                                continue block6;
                            }
                        }
                    }
                }
                catch (Exception k) {
                    // empty catch block
                }
            }
            this.setDisplayTimetable(hasTimetable);
        }
        this.setShowDivSec(false);
        this.setShowInstructorAssignment(false);
        this.setShowSchedulePrintNote(false);
        this.setShowSubpartCredit(false);
        CourseOffering co = ioc.getInstructionalOffering().getControllingCourseOffering();
        for (SchedulingSubpart ss : ioc.getSchedulingSubparts()) {
            if (ss.isInstructorAssignmentNeeded()) {
                this.setShowInstructorAssignment(true);
            }
            if (ss.getCredit() != null) {
                this.setShowSubpartCredit(true);
            }
            for (Class_ c : ss.getClasses()) {
                String divSec;
                String string = divSec = this.isShowOriginalDivSecs() ? c.getClassSuffix() : c.getClassSuffix(co);
                if (divSec != null && !divSec.isEmpty()) {
                    this.setShowDivSec(true);
                }
                if (c.getSchedulePrintNote() != null && !c.getSchedulePrintNote().trim().isEmpty()) {
                    this.setShowSchedulePrintNote(true);
                }
                if (!c.isInstructorAssignmentNeeded()) continue;
                this.setShowInstructorAssignment(true);
            }
        }
        this.setDisplayInstructorPrefs(false);
        ClassDurationType dtype = ioc.getEffectiveDurationType();
        this.buildTableHeader(ret, this.getCurrentAcademicSessionId(), dtype == null ? MSG.columnMinPerWk() : dtype.getLabel());
        this.buildConfigRow(subpartIds, classAssignment, examAssignment, ret, ioc.getInstructionalOffering().getControllingCourseOffering(), ioc, false, true, false);
        ret.setAnchor("ioc" + ioc.getUniqueId());
        return ret;
    }

    protected void setVisibleColumns(TableInterface.FilterInterface filter) {
        this.setShowLabel(true);
        this.setShowDivSec("1".equals(filter.getParameterValue("divSec", "0")));
        this.setShowDemand("1".equals(filter.getParameterValue("demand", "1")));
        this.setShowProjectedDemand("1".equals(filter.getParameterValue("projectedDemand", "1")));
        this.setShowMinPerWk("1".equals(filter.getParameterValue("minPerWk", "1")));
        this.setShowLimit("1".equals(filter.getParameterValue("limit", "1")));
        this.setShowSnapshotLimit("1".equals(filter.getParameterValue("snapshotLimit", "1")));
        this.setShowRoomRatio("1".equals(filter.getParameterValue("roomLimit", "1")));
        this.setShowFundingDepartment("1".equals(filter.getParameterValue("fundingDepartment", "1")));
        this.setShowManager("1".equals(filter.getParameterValue("manager", "1")));
        this.setShowDatePattern("1".equals(filter.getParameterValue("datePattern", "1")));
        this.setShowTimePattern("1".equals(filter.getParameterValue("timePattern", "1")));
        this.setShowPreferences("1".equals(filter.getParameterValue("preferences", "1")));
        this.setShowInstructor("1".equals(filter.getParameterValue("instructor", "1")));
        if (filter.hasParameter("timetable")) {
            this.setShowTimetable("1".equals(filter.getParameterValue("timetable", "1")));
        } else {
            this.setShowTimetable(false);
        }
        this.setShowCredit("1".equals(filter.getParameterValue("credit", "0")));
        this.setShowSubpartCredit("1".equals(filter.getParameterValue("subpartCredit", "0")));
        this.setShowSchedulePrintNote("1".equals(filter.getParameterValue("schedulePrintNote", "0")));
        this.setShowNote("1".equals(filter.getParameterValue("note", "0")));
        this.setShowConsent("1".equals(filter.getParameterValue("consent", "0")));
        this.setShowTitle("1".equals(filter.getParameterValue("title", "0")));
        if (filter.hasParameter("exams")) {
            this.setShowExam("1".equals(filter.getParameterValue("exams", "1")));
        } else {
            this.setShowExam(false);
        }
        if (filter.hasParameter("instructorAssignment")) {
            this.setShowInstructorAssignment("1".equals(filter.getParameterValue("instructorAssignment", "1")));
        } else {
            this.setShowInstructorAssignment(false);
        }
        if (filter.hasParameter("lms")) {
            this.setShowLms("1".equals(filter.getParameterValue("lms", "0")));
        } else {
            this.setShowLms(false);
        }
        if (filter.hasParameter("waitlist")) {
            this.setFilterWaitlist(filter.getParameterValue("waitlist"));
        } else {
            this.setFilterWaitlist(null);
        }
        if (filter.hasParameter("waitlistMode")) {
            this.setShowWaitlistMode("1".equals(filter.getParameterValue("waitlistMode", "0")));
        } else {
            this.setShowWaitlistMode(false);
        }
    }

    public boolean isShowCredit() {
        return this.showCredit;
    }

    public void setShowCredit(boolean showCredit) {
        this.showCredit = showCredit;
    }

    public boolean isShowDatePattern() {
        return this.showDatePattern;
    }

    public void setShowDatePattern(boolean showDatePattern) {
        this.showDatePattern = showDatePattern;
    }

    public boolean isShowDemand() {
        return this.showDemand;
    }

    public void setShowDemand(boolean showDemand) {
        this.showDemand = showDemand;
    }

    public boolean isShowDivSec() {
        return this.showDivSec;
    }

    public void setShowDivSec(boolean showDivSec) {
        this.showDivSec = showDivSec;
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public boolean isShowLimit() {
        return this.showLimit;
    }

    public void setShowLimit(boolean showLimit) {
        this.showLimit = showLimit;
    }

    public boolean isShowSnapshotLimit() {
        return this.showSnapshotLimit;
    }

    public void setShowSnapshotLimit(boolean showSnapshotLimit) {
        this.showSnapshotLimit = showSnapshotLimit;
    }

    public boolean isShowManager() {
        return this.showManager;
    }

    public void setShowManager(boolean showManager) {
        this.showManager = showManager;
    }

    public boolean isShowMinPerWk() {
        return this.showMinPerWk;
    }

    public void setShowMinPerWk(boolean showMinPerWk) {
        this.showMinPerWk = showMinPerWk;
    }

    public boolean isShowNote() {
        return this.showNote;
    }

    public void setShowNote(boolean showNote) {
        this.showNote = showNote;
    }

    public boolean isShowPreferences() {
        return this.showPreferences;
    }

    public void setShowPreferences(boolean showPreferences) {
        this.showPreferences = showPreferences;
    }

    public boolean isShowProjectedDemand() {
        return this.showProjectedDemand;
    }

    public void setShowProjectedDemand(boolean showProjectedDemand) {
        this.showProjectedDemand = showProjectedDemand;
    }

    public boolean isShowRoomRatio() {
        return this.showRoomRatio;
    }

    public void setShowRoomRatio(boolean showRoomRatio) {
        this.showRoomRatio = showRoomRatio;
    }

    public boolean isShowSchedulePrintNote() {
        return this.showSchedulePrintNote;
    }

    public void setShowSchedulePrintNote(boolean showSchedulePrintNote) {
        this.showSchedulePrintNote = showSchedulePrintNote;
    }

    public boolean isShowTimePattern() {
        return this.showTimePattern;
    }

    public void setShowTimePattern(boolean showTimePattern) {
        this.showTimePattern = showTimePattern;
    }

    public boolean isShowTimetable() {
        return this.showTimetable;
    }

    public void setShowTimetable(boolean showTimetable) {
        this.showTimetable = showTimetable;
    }

    public boolean isShowInstructor() {
        return this.showInstructor;
    }

    public void setShowInstructor(boolean showInstructor) {
        this.showInstructor = showInstructor;
    }

    public Comparator getClassComparator() {
        return this.iClassComparator;
    }

    public void setClassComparator(Comparator comparator) {
        this.iClassComparator = comparator;
    }

    public boolean isShowSubpartCredit() {
        return this.showSubpartCredit;
    }

    public void setShowSubpartCredit(boolean showSubpartCredit) {
        this.showSubpartCredit = showSubpartCredit;
    }
}

