/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.client.offerings.OfferingsInterface;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.DistributionsTableBuilder;
import org.unitime.timetable.webutil.BackTracker;

@GwtRpcImplements(value=OfferingsInterface.DistributionsRequest.class)
public class DistributionsBackend
implements GwtRpcImplementation<OfferingsInterface.DistributionsRequest, OfferingsInterface.DistributionsResponse> {
    protected static CourseMessages MESSAGES = Localization.create(CourseMessages.class);

    @Override
    public OfferingsInterface.DistributionsResponse execute(OfferingsInterface.DistributionsRequest request, SessionContext context) {
        context.checkPermission(Right.DistributionPreferences);
        String subjectArea = request.getFilter().getParameterValue("subjectArea");
        if (subjectArea == null || subjectArea.isEmpty()) {
            throw new GwtRpcException(MESSAGES.errorSubjectRequired());
        }
        DistributionsTableBuilder builder = new DistributionsTableBuilder(context, request.getBackType(), request.getBackId());
        for (FilterInterface.FilterParameterInterface p : request.getFilter().getParameters()) {
            if ("subjectArea".equals(p.getName())) {
                context.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)(p.getValue() != null ? p.getValue() : p.getDefaultValue()));
                continue;
            }
            if ("subjectArea".equals(p.getName())) {
                context.setAttribute(SessionAttribute.OfferingsCourseNumber, (Object)(p.getValue() != null ? p.getValue() : p.getDefaultValue()));
                continue;
            }
            if (p.getValue() == null) continue;
            context.getUser().setProperty("Distributions." + p.getName(), p.getValue());
        }
        OfferingsInterface.DistributionsResponse response = new OfferingsInterface.DistributionsResponse();
        for (String subjectAreaId : subjectArea.split(",")) {
            SubjectArea sa;
            if (subjectAreaId.isEmpty() || (sa = (SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(subjectAreaId))) == null) continue;
            TableInterface table = builder.getDistPrefsTableForFilter(request.getFilter(), sa.getUniqueId());
            table.setId(sa.getUniqueId().toString());
            table.setName(sa.getLabel());
            response.addTable(table);
        }
        BackTracker.markForBack(context, "distributions", MESSAGES.backDistributionPreferences(), true, true);
        return response;
    }
}

