/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import java.util.Iterator;
import org.hibernate.ObjectNotFoundException;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.client.offerings.OfferingsInterface;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=OfferingsInterface.CrossListGetRequest.class)
public class CrossListGetBackend
implements GwtRpcImplementation<OfferingsInterface.CrossListGetRequest, OfferingsInterface.CrossListGetResponse> {
    @Override
    public OfferingsInterface.CrossListGetResponse execute(OfferingsInterface.CrossListGetRequest request, SessionContext context) {
        InstructionalOffering io = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(request.getOfferingId());
        context.checkPermission(io, Right.InstructionalOfferingCrossLists);
        OfferingsInterface.CrossListGetResponse response = new OfferingsInterface.CrossListGetResponse();
        response.setOfferingId(io.getUniqueId());
        response.setOfferingName(io.getCourseNameWithTitle());
        response.setLimit(io.getLimit());
        response.setUnlimited(io.hasUnlimitedEnrollment());
        response.setSingleCourseLimitAllowed(ApplicationProperty.ModifyCrossListSingleCourseLimit.isTrue());
        for (CourseOffering course : io.getCourseOfferings()) {
            OfferingsInterface.CrossListedCourse c = new OfferingsInterface.CrossListedCourse();
            c.setControl(course.isIsControl());
            c.setCourseId(course.getUniqueId());
            c.setCourseName(course.getCourseNameWithTitle());
            c.setReserved(course.getReservation());
            c.setProjected(course.getProjectedDemand());
            c.setLastTerm(course.getDemand());
            c.setCanEdit(context.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent) || context.getUser().getCurrentAuthority().hasQualifier(course.getDepartment()));
            c.setCanDelete(context.hasPermission(course, Right.CourseOfferingDeleteFromCrossList));
            response.addCourse(c);
            response.addAvailableCourse(c);
        }
        for (SubjectArea subject : SubjectArea.getUserSubjectAreas(context.getUser())) {
            Iterator<CourseOffering> i = null;
            try {
                i = subject.getCourseOfferings().iterator();
            }
            catch (ObjectNotFoundException e) {
                CourseOfferingDAO.getInstance().getSession().refresh((Object)subject);
                i = subject.getCourseOfferings().iterator();
            }
            while (i.hasNext()) {
                CourseOffering course = i.next();
                if (course == null || !course.getInstructionalOffering().isNotOffered().booleanValue()) continue;
                OfferingsInterface.CrossListedCourse c = new OfferingsInterface.CrossListedCourse();
                c.setControl(course.isIsControl());
                c.setCourseId(course.getUniqueId());
                c.setCourseName(course.getCourseNameWithTitle());
                c.setReserved(course.getReservation());
                c.setProjected(course.getProjectedDemand());
                c.setLastTerm(course.getDemand());
                response.addAvailableCourse(c);
            }
        }
        return response;
    }
}

