/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.classinstructors;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.access.AccessDeniedException;
import org.unitime.commons.Debug;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.AssignClassInstructorsInterface;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.server.classinstructors.AssignClassInstructorsTable;

public class AssignClassInstructorsBackend {
    private static Log sLog = LogFactory.getLog(AssignClassInstructorsBackend.class);

    public static AssignClassInstructorsTable getTable(ApplicationContext context) {
        return (AssignClassInstructorsTable)context.getBean("gwtAssignClassInstrs", AssignClassInstructorsTable.class);
    }

    @GwtRpcImplements(value=AssignClassInstructorsInterface.RemoveAllClassInstructorsDataRpcRequest.class)
    public static class RemoveAllClassInstructorsDataBackend
    implements GwtRpcImplementation<AssignClassInstructorsInterface.RemoveAllClassInstructorsDataRpcRequest, AssignClassInstructorsInterface> {
        @Autowired
        ApplicationContext applicationContext;

        @Override
        public AssignClassInstructorsInterface execute(AssignClassInstructorsInterface.RemoveAllClassInstructorsDataRpcRequest request, SessionContext context) {
            Session hibSession = new _RootDAO().getSession();
            Transaction tx = null;
            try {
                tx = hibSession.beginTransaction();
                AssignClassInstructorsInterface data = request.getData();
                AssignClassInstructorsTable at = AssignClassInstructorsBackend.getTable(this.applicationContext);
                at.removeAllInstructors(request.getData(), context, hibSession);
                hibSession.flush();
                tx.commit();
                tx = null;
                Iterator<AssignClassInstructorsInterface.Record> i = data.getRecords().iterator();
                while (i.hasNext()) {
                    if (i.next().getUniqueId() != null) continue;
                    i.remove();
                }
                AssignClassInstructorsInterface assignClassInstructorsInterface = data;
                return assignClassInstructorsInterface;
            }
            catch (PageAccessException e) {
                throw e;
            }
            catch (GwtRpcException e) {
                throw e;
            }
            catch (Exception e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new GwtRpcException(e.getMessage(), e);
            }
            finally {
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    @GwtRpcImplements(value=AssignClassInstructorsInterface.SaveDataGoToNextRpcRequest.class)
    public static class SaveDataGoToNextRpcRequest
    implements GwtRpcImplementation<AssignClassInstructorsInterface.SaveDataGoToNextRpcRequest, AssignClassInstructorsInterface> {
        @Autowired
        ApplicationContext applicationContext;

        @Override
        public AssignClassInstructorsInterface execute(AssignClassInstructorsInterface.SaveDataGoToNextRpcRequest request, SessionContext context) {
            Debug.info("In AssignClassInstructorsInterface execute(AssignClassInstructorsInterface.SaveDataGoToPreviousRpcRequest request, ");
            Session hibSession = new _RootDAO().getSession();
            Transaction tx = null;
            try {
                tx = hibSession.beginTransaction();
                AssignClassInstructorsInterface data = request.getData();
                AssignClassInstructorsTable at = AssignClassInstructorsBackend.getTable(this.applicationContext);
                at.save(request.getData(), context, hibSession);
                if (data.isSaveSuccessful()) {
                    hibSession.flush();
                    tx.commit();
                    tx = null;
                    data = at.load(data.getNextConfigId().toString(), context, hibSession);
                }
                AssignClassInstructorsInterface assignClassInstructorsInterface = data;
                return assignClassInstructorsInterface;
            }
            catch (PageAccessException e) {
                throw e;
            }
            catch (GwtRpcException e) {
                throw e;
            }
            catch (Exception e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new GwtRpcException(e.getMessage(), e);
            }
            finally {
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    @GwtRpcImplements(value=AssignClassInstructorsInterface.SaveDataGoToPreviousRpcRequest.class)
    public static class SaveDataGoToPreviousRpcRequest
    implements GwtRpcImplementation<AssignClassInstructorsInterface.SaveDataGoToPreviousRpcRequest, AssignClassInstructorsInterface> {
        @Autowired
        ApplicationContext applicationContext;

        @Override
        public AssignClassInstructorsInterface execute(AssignClassInstructorsInterface.SaveDataGoToPreviousRpcRequest request, SessionContext context) {
            Debug.info("In AssignClassInstructorsInterface execute(AssignClassInstructorsInterface.SaveDataGoToPreviousRpcRequest request, ");
            Session hibSession = new _RootDAO().getSession();
            Transaction tx = null;
            try {
                tx = hibSession.beginTransaction();
                AssignClassInstructorsInterface data = request.getData();
                AssignClassInstructorsTable at = AssignClassInstructorsBackend.getTable(this.applicationContext);
                at.save(request.getData(), context, hibSession);
                if (data.isSaveSuccessful()) {
                    hibSession.flush();
                    tx.commit();
                    tx = null;
                    tx = hibSession.beginTransaction();
                    data = at.load(data.getPreviousConfigId().toString(), context, hibSession);
                    hibSession.flush();
                    tx.commit();
                    tx = null;
                }
                AssignClassInstructorsInterface assignClassInstructorsInterface = data;
                return assignClassInstructorsInterface;
            }
            catch (PageAccessException e) {
                throw e;
            }
            catch (GwtRpcException e) {
                throw e;
            }
            catch (Exception e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new GwtRpcException(e.getMessage(), e);
            }
            finally {
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    @GwtRpcImplements(value=AssignClassInstructorsInterface.SaveDataRpcRequest.class)
    public static class SaveDataBackend
    implements GwtRpcImplementation<AssignClassInstructorsInterface.SaveDataRpcRequest, AssignClassInstructorsInterface> {
        @Autowired
        ApplicationContext applicationContext;

        @Override
        public AssignClassInstructorsInterface execute(AssignClassInstructorsInterface.SaveDataRpcRequest request, SessionContext context) {
            Debug.info("In AssignClassInstructorsInterface execute(AssignClassInstructorsInterface.SaveDataRpcRequest request, ");
            Session hibSession = new _RootDAO().getSession();
            Transaction tx = null;
            try {
                tx = hibSession.beginTransaction();
                AssignClassInstructorsInterface data = request.getData();
                AssignClassInstructorsTable at = AssignClassInstructorsBackend.getTable(this.applicationContext);
                at.save(request.getData(), context, hibSession);
                if (data.isSaveSuccessful()) {
                    hibSession.flush();
                    tx.commit();
                    tx = null;
                    Iterator<AssignClassInstructorsInterface.Record> i = data.getRecords().iterator();
                    while (i.hasNext()) {
                        if (i.next().getUniqueId() != null) continue;
                        i.remove();
                    }
                }
                AssignClassInstructorsInterface assignClassInstructorsInterface = data;
                return assignClassInstructorsInterface;
            }
            catch (PageAccessException e) {
                throw e;
            }
            catch (GwtRpcException e) {
                throw e;
            }
            catch (Exception e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new GwtRpcException(e.getMessage(), e);
            }
            finally {
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    @GwtRpcImplements(value=AssignClassInstructorsInterface.LoadDataRpcRequest.class)
    public static class LoadDataBackend
    implements GwtRpcImplementation<AssignClassInstructorsInterface.LoadDataRpcRequest, AssignClassInstructorsInterface> {
        @Autowired
        ApplicationContext applicationContext;

        @Override
        public AssignClassInstructorsInterface execute(AssignClassInstructorsInterface.LoadDataRpcRequest request, SessionContext context) {
            Session hibSession = new _RootDAO().getSession();
            Transaction tx = null;
            try {
                tx = hibSession.beginTransaction();
                AssignClassInstructorsInterface data = null;
                AssignClassInstructorsTable at = AssignClassInstructorsBackend.getTable(this.applicationContext);
                data = at.load(request.getConfigIdStr(), context, hibSession);
                hibSession.flush();
                tx.commit();
                tx = null;
                AssignClassInstructorsInterface assignClassInstructorsInterface = data;
                return assignClassInstructorsInterface;
            }
            catch (PageAccessException e) {
                throw e;
            }
            catch (GwtRpcException e) {
                throw e;
            }
            catch (AccessDeniedException e) {
                throw new PageAccessException(e.getMessage(), e);
            }
            catch (Exception e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new GwtRpcException(e.getMessage(), e);
            }
            finally {
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    @GwtRpcImplements(value=AssignClassInstructorsInterface.GetPageNameRpcRequest.class)
    public static class PageNameBackend
    implements GwtRpcImplementation<AssignClassInstructorsInterface.GetPageNameRpcRequest, AssignClassInstructorsInterface.PageName> {
        @Autowired
        ApplicationContext applicationContext;

        @Override
        public AssignClassInstructorsInterface.PageName execute(AssignClassInstructorsInterface.GetPageNameRpcRequest request, SessionContext context) {
            Debug.info("In PageName execute(AssignClassInstructorsInterface.GetPageNameRpcRequest request");
            return AssignClassInstructorsBackend.getTable(this.applicationContext).name();
        }
    }
}

