/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.StandardSchedulingDisclaimer;
import org.unitime.timetable.model.dao.StandardSchedulingDisclaimerDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=stdSchdDisclaimers]")
public class StandardSchedulingDisclaimers
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageStandardSchedulingDisclaimer(), MESSAGES.pageStandardSchedulingDisclaimers());
    }

    @Override
    @PreAuthorize(value="checkPermission('SchedulingDisclaimers')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldReference(), SimpleEditInterface.FieldType.text, 160, 20, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldLabel(), SimpleEditInterface.FieldType.text, 300, 60, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldDisclaimer(), SimpleEditInterface.FieldType.textarea, 50, 3, 2000, SimpleEditInterface.Flag.NOT_EMPTY));
        data.setSortBy(1);
        for (StandardSchedulingDisclaimer disc : StandardSchedulingDisclaimerDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.addRecord(disc.getUniqueId());
            r.setField(0, disc.getReference());
            r.setField(1, disc.getLabel());
            r.setField(2, disc.getDisclaimer());
        }
        data.setEditable(context.hasPermission(Right.SchedulingDisclaimerEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('SchedulingDisclaimerEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (StandardSchedulingDisclaimer disc : StandardSchedulingDisclaimerDAO.getInstance().findAll(hibSession)) {
            SimpleEditInterface.Record r = data.getRecord(disc.getUniqueId());
            if (r == null) {
                this.delete(disc, context, hibSession);
                continue;
            }
            this.update(disc, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('SchedulingDisclaimerEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        StandardSchedulingDisclaimer disc = new StandardSchedulingDisclaimer();
        disc.setReference(record.getField(0));
        disc.setLabel(record.getField(1));
        disc.setDisclaimer(record.getField(2));
        hibSession.persist((Object)disc);
        record.setUniqueId(disc.getUniqueId());
        ChangeLog.addChange(hibSession, context, disc, disc.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(StandardSchedulingDisclaimer disc, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (disc == null) {
            return;
        }
        if (ToolBox.equals((Object)disc.getReference(), (Object)record.getField(0)) && ToolBox.equals((Object)disc.getLabel(), (Object)record.getField(1)) && ToolBox.equals((Object)disc.getDisclaimer(), (Object)record.getField(2))) {
            return;
        }
        disc.setReference(record.getField(0));
        disc.setLabel(record.getField(1));
        disc.setDisclaimer(record.getField(2));
        hibSession.merge((Object)disc);
        ChangeLog.addChange(hibSession, context, disc, disc.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @Override
    @PreAuthorize(value="checkPermission('SchedulingDisclaimerEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((StandardSchedulingDisclaimer)StandardSchedulingDisclaimerDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(StandardSchedulingDisclaimer disc, SessionContext context, Session hibSession) {
        if (disc == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, disc, disc.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.remove((Object)disc);
    }

    @Override
    @PreAuthorize(value="checkPermission('SchedulingDisclaimerEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((StandardSchedulingDisclaimer)StandardSchedulingDisclaimerDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

