/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.SponsoringOrganization;
import org.unitime.timetable.model.dao.SponsoringOrganizationDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=sponsoringOrganizations]")
public class SponsoringOrganizations
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageSponsoringOrganization(), MESSAGES.pageSponsoringOrganizations());
    }

    @Override
    @PreAuthorize(value="checkPermission('SponsoringOrganizations')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 350, 100, SimpleEditInterface.Flag.UNIQUE, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldEmailAddress(), SimpleEditInterface.FieldType.text, 350, 200, new SimpleEditInterface.Flag[0]));
        data.setSortBy(1);
        for (SponsoringOrganization sponsor : SponsoringOrganization.findAll()) {
            SimpleEditInterface.Record r = data.addRecord(sponsor.getUniqueId());
            boolean canEdit = context.hasPermission(sponsor, Right.SponsoringOrganizationEdit);
            r.setField(0, sponsor.getName(), canEdit);
            r.setField(1, sponsor.getEmail(), canEdit);
            r.setDeletable(context.hasPermission(sponsor, Right.SponsoringOrganizationDelete));
        }
        data.setAddable(context.hasPermission(Right.SponsoringOrganizationAdd));
        return data;
    }

    @Override
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (SponsoringOrganization sponsor : SponsoringOrganization.findAll()) {
            SimpleEditInterface.Record r = data.getRecord(sponsor.getUniqueId());
            if (r == null) {
                this.delete(sponsor, context, hibSession);
                continue;
            }
            this.update(sponsor, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        context.checkPermission(Right.SponsoringOrganizationAdd);
        SponsoringOrganization sponsor = new SponsoringOrganization();
        sponsor.setName(record.getField(0));
        sponsor.setEmail(record.getField(1));
        hibSession.persist((Object)sponsor);
        record.setUniqueId(sponsor.getUniqueId());
        ChangeLog.addChange(hibSession, context, sponsor, sponsor.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(SponsoringOrganization sponsor, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (sponsor == null) {
            return;
        }
        context.checkPermission(sponsor, Right.SponsoringOrganizationEdit);
        if (ToolBox.equals((Object)sponsor.getName(), (Object)record.getField(0)) && ToolBox.equals((Object)sponsor.getEmail(), (Object)record.getField(1))) {
            return;
        }
        sponsor.setName(record.getField(0));
        sponsor.setEmail(record.getField(1));
        hibSession.merge((Object)sponsor);
        ChangeLog.addChange(hibSession, context, sponsor, sponsor.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @Override
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((SponsoringOrganization)SponsoringOrganizationDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(SponsoringOrganization sponsor, SessionContext context, Session hibSession) {
        if (sponsor == null) {
            return;
        }
        context.checkPermission(sponsor, Right.SponsoringOrganizationDelete);
        for (Event event : hibSession.createQuery("from Event where sponsoringOrganization.uniqueId = :orgId", Event.class).setParameter("orgId", (Object)sponsor.getUniqueId()).list()) {
            event.setSponsoringOrganization(null);
            hibSession.merge((Object)event);
        }
        ChangeLog.addChange(hibSession, context, sponsor, sponsor.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.remove((Object)sponsor);
    }

    @Override
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((SponsoringOrganization)SponsoringOrganizationDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

