/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.RoomFeatureType;
import org.unitime.timetable.model.dao.RoomFeatureTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=featureType]")
public class RoomFeatureTypes
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageRoomFeatureType(), MESSAGES.pageRoomFeatureTypes());
    }

    @Override
    @PreAuthorize(value="checkPermission('RoomFeatureTypes')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldAbbreviation(), SimpleEditInterface.FieldType.text, 160, 20, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 60, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldEventManagement(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldInstructorSurvey(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]));
        data.setSortBy(2, 1);
        for (RoomFeatureType ftype : RoomFeatureTypeDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.addRecord(ftype.getUniqueId());
            r.setField(0, ftype.getReference());
            r.setField(1, ftype.getLabel());
            r.setField(2, ftype.isShowInEventManagement() != false ? "true" : "false");
            r.setField(3, ftype.isShowInInstructorSurvey() != false ? "true" : "false");
            int used = ((Number)hibSession.createQuery("select count(f) from RoomFeature f where f.featureType.uniqueId = :uniqueId", Number.class).setParameter("uniqueId", (Object)ftype.getUniqueId()).uniqueResult()).intValue();
            r.setDeletable(used == 0);
        }
        data.setEditable(context.hasPermission(Right.RoomFeatureTypeEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('RoomFeatureTypeEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (RoomFeatureType type : RoomFeatureTypeDAO.getInstance().findAll(hibSession)) {
            SimpleEditInterface.Record r = data.getRecord(type.getUniqueId());
            if (r == null) {
                this.delete(type, context, hibSession);
                continue;
            }
            this.update(type, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('RoomFeatureTypeEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        RoomFeatureType type = new RoomFeatureType();
        type.setReference(record.getField(0));
        type.setLabel(record.getField(1));
        type.setShowInEventManagement("true".equals(record.getField(2)));
        type.setShowInInstructorSurvey("true".equals(record.getField(3)));
        hibSession.persist((Object)type);
        record.setUniqueId(type.getUniqueId());
        ChangeLog.addChange(hibSession, context, type, type.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(RoomFeatureType type, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (type == null) {
            return;
        }
        if (ToolBox.equals((Object)type.getReference(), (Object)record.getField(0)) && ToolBox.equals((Object)type.getLabel(), (Object)record.getField(1)) && ToolBox.equals((Object)type.getShowInEventManagement(), (Object)"true".equals(record.getField(2))) && ToolBox.equals((Object)type.getShowInInstructorSurvey(), (Object)"true".equals(record.getField(3)))) {
            return;
        }
        type.setReference(record.getField(0));
        type.setLabel(record.getField(1));
        type.setShowInEventManagement("true".equals(record.getField(2)));
        type.setShowInInstructorSurvey("true".equals(record.getField(3)));
        hibSession.merge((Object)type);
        ChangeLog.addChange(hibSession, context, type, type.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @Override
    @PreAuthorize(value="checkPermission('RoomFeatureTypeEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((RoomFeatureType)RoomFeatureTypeDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(RoomFeatureType type, SessionContext context, Session hibSession) {
        if (type == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, type, type.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.remove((Object)type);
    }

    @Override
    @PreAuthorize(value="checkPermission('RoomFeatureTypeEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((RoomFeatureType)RoomFeatureTypeDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

