/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.dao.ClassDurationTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=durationType]")
public class DurationTypes
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageDurationType(), MESSAGES.pageDurationTypes());
    }

    @Override
    @PreAuthorize(value="checkPermission('DurationTypes')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldReference(), SimpleEditInterface.FieldType.text, 160, 20, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldAbbreviation(), SimpleEditInterface.FieldType.text, 160, 20, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 60, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldImplementation(), SimpleEditInterface.FieldType.text, 600, 255, SimpleEditInterface.Flag.NOT_EMPTY, SimpleEditInterface.Flag.HIDDEN), new SimpleEditInterface.Field(MESSAGES.fieldParameters(), SimpleEditInterface.FieldType.text, 300, 200, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldVisible(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]));
        data.setSortBy(2);
        data.setAddable(false);
        for (ClassDurationType type : ClassDurationTypeDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.addRecord(type.getUniqueId(), false);
            r.setField(0, type.getReference(), false);
            r.setField(1, type.getAbbreviation());
            r.setField(2, type.getLabel());
            r.setField(3, type.getImplementation(), false);
            r.setField(4, type.getParameter());
            r.setField(5, type.isVisible() != false ? "true" : "false");
        }
        data.setEditable(context.hasPermission(Right.DurationTypeEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('DurationTypeEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (ClassDurationType type : ClassDurationTypeDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.getRecord(type.getUniqueId());
            if (r == null) {
                this.delete(type, context, hibSession);
                continue;
            }
            this.update(type, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('DurationTypeEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        ClassDurationType type = new ClassDurationType();
        type.setReference(record.getField(0));
        type.setAbbreviation(record.getField(1));
        type.setLabel(record.getField(2));
        type.setImplementation(record.getField(3));
        type.setParameter(record.getField(4));
        type.setVisible("true".equalsIgnoreCase(record.getField(5)));
        hibSession.persist((Object)type);
        record.setUniqueId(type.getUniqueId());
        ChangeLog.addChange(hibSession, context, type, type.getReference() + " " + type.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(ClassDurationType type, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (type == null) {
            return;
        }
        if (ToolBox.equals((Object)type.getReference(), (Object)record.getField(0)) && ToolBox.equals((Object)type.getAbbreviation(), (Object)record.getField(1)) && ToolBox.equals((Object)type.getLabel(), (Object)record.getField(2)) && ToolBox.equals((Object)type.getImplementation(), (Object)record.getField(3)) && ToolBox.equals((Object)type.getParameter(), (Object)record.getField(4)) && ToolBox.equals((Object)type.isVisible(), (Object)"true".equalsIgnoreCase(record.getField(5)))) {
            return;
        }
        type.setReference(record.getField(0));
        type.setAbbreviation(record.getField(1));
        type.setLabel(record.getField(2));
        type.setImplementation(record.getField(3));
        type.setParameter(record.getField(4));
        type.setVisible("true".equalsIgnoreCase(record.getField(5)));
        hibSession.merge((Object)type);
        ChangeLog.addChange(hibSession, context, type, type.getReference() + " " + type.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @Override
    @PreAuthorize(value="checkPermission('DurationTypeEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((ClassDurationType)ClassDurationTypeDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(ClassDurationType type, SessionContext context, Session hibSession) {
        if (type == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, type, type.getReference() + " " + type.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.remove((Object)type);
    }

    @Override
    @PreAuthorize(value="checkPermission('DurationTypeEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((ClassDurationType)ClassDurationTypeDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

