/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.permissions;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.permissions.PermissionForRight;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.solver.service.SolverService;

public class CourseTimetablingPermissions {

    @PermissionForRight(value=Right.ManageSolvers)
    public static class ManageSolvers
    implements Permission<Session> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, Session source) {
            return this.permissionSession.check(user, source);
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.SolverSolutionExportXml)
    public static class SolverSolutionExportXml
    extends SolverSolutionSave {
    }

    @PermissionForRight(value=Right.SolverSolutionExportCsv)
    public static class SolverSolutionExportCsv
    extends SolverSolutionSave {
    }

    @PermissionForRight(value=Right.SolverSolutionSave)
    public static class SolverSolutionSave
    implements Permission<SolverGroup> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, SolverGroup source) {
            for (Department department : source.getDepartments()) {
                if (this.permissionDepartment.check(user, department, DepartmentStatusType.Status.Timetable)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Class<SolverGroup> type() {
            return SolverGroup.class;
        }
    }

    @PermissionForRight(value=Right.TimetablesSolutionExportCsv)
    public static class TimetablesSolutionExportCsv
    extends TimetablesSolutionLoad {
    }

    @PermissionForRight(value=Right.TimetablesSolutionChangeNote)
    public static class TimetablesSolutionChangeNote
    extends TimetablesSolutionLoad {
    }

    @PermissionForRight(value=Right.TimetablesSolutionLoadEmpty)
    public static class TimetablesSolutionLoadEmpty
    implements Permission<SolverGroup> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, SolverGroup source) {
            for (Department department : source.getDepartments()) {
                if (this.permissionDepartment.check(user, department, DepartmentStatusType.Status.Timetable, DepartmentStatusType.Status.Audit)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Class<SolverGroup> type() {
            return SolverGroup.class;
        }
    }

    @PermissionForRight(value=Right.TimetablesSolutionDelete)
    public static class TimetablesSolutionDelete
    extends TimetablesSolutionLoad {
    }

    @PermissionForRight(value=Right.TimetablesSolutionLoad)
    public static class TimetablesSolutionLoad
    implements Permission<Solution> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Solution source) {
            for (Department department : source.getOwner().getDepartments()) {
                if (this.permissionDepartment.check(user, department, DepartmentStatusType.Status.Timetable)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Class<Solution> type() {
            return Solution.class;
        }
    }

    @PermissionForRight(value=Right.TimetablesSolutionCommit)
    public static class TimetablesSolutionCommit
    implements Permission<SolverGroup> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;
        @Autowired
        SolverServerService solverServerService;

        private boolean hasInstance(Long sessionId) {
            if (sessionId == null) {
                return false;
            }
            return this.solverServerService.getOnlineStudentSchedulingContainer().hasSolver(sessionId.toString());
        }

        @Override
        public boolean check(UserContext user, SolverGroup source) {
            if (source.isAllowStudentScheduling() && this.hasInstance(user.getCurrentAcademicSessionId())) {
                return false;
            }
            for (Department department : source.getDepartments()) {
                if (this.permissionDepartment.check(user, department, DepartmentStatusType.Status.Commit)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Class<SolverGroup> type() {
            return SolverGroup.class;
        }
    }

    @PermissionForRight(value=Right.ClassAssignment)
    public static class ClassAssignment
    implements Permission<Class_> {
        @Autowired
        SessionContext sessionContext;
        @Autowired
        SolverService<SolverProxy> courseTimetablingSolverService;
        @Autowired
        Permission.PermissionDepartment permissionDepartment;
        @Autowired
        Permission<InstructionalOffering> permissionOfferingLockNeededLimitedEdit;

        @Override
        public boolean check(UserContext user, Class_ source) {
            if (source.isCancelled().booleanValue()) {
                return false;
            }
            if (source.getManagingDept() == null || source.getManagingDept().getSolverGroup() == null || source.getManagingDept().getSolverGroup().getCommittedSolution() == null) {
                return false;
            }
            if (source.effectiveDatePattern() == null || source.effectiveTimePatterns().isEmpty()) {
                return false;
            }
            if (this.courseTimetablingSolverService.getSolver() != null) {
                return false;
            }
            String solutionIdsStr = (String)this.sessionContext.getAttribute(SessionAttribute.SelectedSolution);
            if (solutionIdsStr != null && !solutionIdsStr.isEmpty()) {
                return false;
            }
            if (this.permissionOfferingLockNeededLimitedEdit.check(user, source.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering())) {
                return false;
            }
            return this.permissionDepartment.check(user, source.getManagingDept(), DepartmentStatusType.Status.Timetable);
        }

        @Override
        public Class<Class_> type() {
            return Class_.class;
        }
    }

    @PermissionForRight(value=Right.ClassAssignmentsExportPdf)
    public static class ClassAssignmentsExportPdf
    extends ClassAssignments {
    }

    @PermissionForRight(value=Right.ClassAssignmentsExportCsv)
    public static class ClassAssignmentsExportCsv
    extends ClassAssignments {
    }

    @PermissionForRight(value=Right.ClassAssignments)
    public static class ClassAssignments
    implements Permission<Session> {
        @Autowired
        Permission.PermissionSession permissionSession;
        @Autowired
        Permission.PermissionDepartment permissionDepartment;
        @Autowired
        SolverService<SolverProxy> courseTimetablingSolverService;

        @Override
        public boolean check(UserContext user, Session source) {
            if (!this.permissionSession.check(user, source)) {
                return false;
            }
            if (this.courseTimetablingSolverService.getSolver() != null) {
                return true;
            }
            if (!user.getCurrentAuthority().hasRight(Right.HasRole) && !this.permissionSession.check(user, source, DepartmentStatusType.Status.ReportClasses)) {
                return false;
            }
            for (Department department : source.getDepartments()) {
                if (department.getSolverGroup() == null) continue;
                if (department.getSolverGroup().getCommittedSolution() != null) {
                    return true;
                }
                if (!this.permissionDepartment.check(user, department, DepartmentStatusType.Status.Timetable) || department.getSolverGroup().getSolutions().isEmpty()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.TimetableGrid)
    public static class TimetableGrid
    extends Timetables {
    }

    @PermissionForRight(value=Right.SolutionReports)
    public static class SolutionReports
    extends CourseTimetabling {
    }

    @PermissionForRight(value=Right.NotAssignedClasses)
    public static class NotAssignedClasses
    extends CourseTimetabling {
    }

    @PermissionForRight(value=Right.SolverLog)
    public static class SolverLog
    extends CourseTimetablingOrAudit {
    }

    @PermissionForRight(value=Right.ConflictStatistics)
    public static class ConflictStatistics
    extends CourseTimetablingOrAudit {
    }

    @PermissionForRight(value=Right.SolutionChanges)
    public static class SolutionChanges
    extends CourseTimetabling {
    }

    @PermissionForRight(value=Right.Suggestions)
    public static class Suggestions
    extends CourseTimetabling {
    }

    @PermissionForRight(value=Right.AssignmentHistory)
    public static class AssignmentHistory
    extends CourseTimetabling {
    }

    @PermissionForRight(value=Right.AssignedClasses)
    public static class AssignedClasses
    extends CourseTimetabling {
    }

    @PermissionForRight(value=Right.Solver)
    public static class Solver
    extends CourseTimetablingOrAudit {
    }

    @PermissionForRight(value=Right.Timetables)
    public static class Timetables
    implements Permission<SolverGroup> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, SolverGroup source) {
            if (source.getCommittedSolution() != null) {
                return true;
            }
            for (Department department : source.getDepartments()) {
                if (this.permissionDepartment.check(user, department, DepartmentStatusType.Status.Timetable)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Class<SolverGroup> type() {
            return SolverGroup.class;
        }
    }

    public static class CourseTimetablingOrAudit
    extends CourseTimetabling {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, SolverGroup source) {
            for (Department department : source.getDepartments()) {
                if (this.permissionDepartment.check(user, department, DepartmentStatusType.Status.Audit, DepartmentStatusType.Status.Timetable)) continue;
                return false;
            }
            return true;
        }
    }

    @PermissionForRight(value=Right.CourseTimetablingAudit)
    public static class CourseTimetablingAudit
    extends CourseTimetabling {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, SolverGroup source) {
            if (super.check(user, source)) {
                return false;
            }
            for (Department department : source.getDepartments()) {
                if (this.permissionDepartment.check(user, department, DepartmentStatusType.Status.Audit, DepartmentStatusType.Status.Timetable)) continue;
                return false;
            }
            return true;
        }
    }

    @PermissionForRight(value=Right.CourseTimetabling)
    public static class CourseTimetabling
    implements Permission<SolverGroup> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, SolverGroup source) {
            for (Department department : source.getDepartments()) {
                if (this.permissionDepartment.check(user, department, DepartmentStatusType.Status.Timetable)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Class<SolverGroup> type() {
            return SolverGroup.class;
        }
    }
}

