/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.permissions;

import java.util.Collection;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.permissions.PermissionForRight;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.service.SolverServerService;

public class CoursePermissions {

    @PermissionForRight(value=Right.CourseCatalog)
    public static class CourseCatalog
    implements Permission<Session> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, Session source) {
            return this.permissionSession.check(user, source) && Customization.CourseDetailsProvider.getProvider() != null;
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.ClassCancel)
    public static class ClassCancel
    implements Permission<Class_> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;
        @Autowired
        Permission<InstructionalOffering> permissionOfferingLockNeeded;

        @Override
        public boolean check(UserContext user, Class_ source) {
            if (!(source.isCancelled().booleanValue() || source.getManagingDept() != null && source.getManagingDept().getSolverGroup() != null && source.getManagingDept().getSolverGroup().getCommittedSolution() != null)) {
                return false;
            }
            return !this.permissionOfferingLockNeeded.check(user, source.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering()) && this.permissionDepartment.check(user, source.getControllingDept(), DepartmentStatusType.Status.OwnerEdit, source.getManagingDept(), DepartmentStatusType.Status.ManagerEdit);
        }

        @Override
        public Class<Class_> type() {
            return Class_.class;
        }
    }

    @PermissionForRight(value=Right.ClassDeleteNoEnrollmentCheck)
    public static class ClassDeleteNoEnrollmentCheck
    implements Permission<Class_> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;
        @Autowired
        Permission<InstructionalOffering> permissionOfferingLockNeeded;

        @Override
        public boolean check(UserContext user, Class_ source) {
            return !this.permissionOfferingLockNeeded.check(user, source.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering()) && this.permissionDepartment.check(user, source.getControllingDept(), DepartmentStatusType.Status.OwnerEdit, source.getManagingDept(), DepartmentStatusType.Status.ManagerEdit);
        }

        @Override
        public Class<Class_> type() {
            return Class_.class;
        }
    }

    @PermissionForRight(value=Right.ClassDelete)
    public static class ClassDelete
    extends ClassDeleteNoEnrollmentCheck {
        @Override
        public boolean check(UserContext user, Class_ source) {
            if (!user.getCurrentAuthority().hasRight(Right.ClassDeleteNoEnrollmentCheck) && source.getManagingDept() != null && source.getManagingDept().getSolverGroup() != null && source.getManagingDept().getSolverGroup().getCommittedSolution() != null && source.getEnrollment() > 0) {
                return false;
            }
            return super.check(user, source);
        }
    }

    @PermissionForRight(value=Right.DistributionPreferenceDetail)
    public static class DistributionPreferenceDetail
    implements Permission<DistributionPref> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;
        @Autowired
        Permission<Class_> permissionClassDetail;
        @Autowired
        Permission<SchedulingSubpart> permissionSchedulingSubpartDetail;

        @Override
        public boolean check(UserContext user, DistributionPref source) {
            Department owner = null;
            owner = source.getOwner() instanceof DepartmentalInstructor ? ((DepartmentalInstructor)source.getOwner()).getDepartment() : (Department)source.getOwner();
            if (owner == null) {
                return false;
            }
            if (this.permissionDepartment.check(user, owner)) {
                return this.permissionDepartment.check(user, owner, owner.isExternalManager() != false ? DepartmentStatusType.Status.ManagerView : DepartmentStatusType.Status.OwnerView);
            }
            for (DistributionObject distrObj : source.getDistributionObjects()) {
                if (distrObj.getPrefGroup() instanceof Class_) {
                    if (!this.permissionClassDetail.check(user, (Class_)distrObj.getPrefGroup())) continue;
                    return true;
                }
                if (distrObj.getPrefGroup() instanceof SchedulingSubpart) {
                    if (!this.permissionSchedulingSubpartDetail.check(user, (SchedulingSubpart)distrObj.getPrefGroup())) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        @Override
        public Class<DistributionPref> type() {
            return DistributionPref.class;
        }
    }

    @PermissionForRight(value=Right.DistributionPreferenceDelete)
    public static class DistributionPreferenceDelete
    implements Permission<DistributionPref> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;
        @Autowired
        Permission<Class_> permissionClassEdit;
        @Autowired
        Permission<SchedulingSubpart> permissionSchedulingSubpartEdit;

        @Override
        public boolean check(UserContext user, DistributionPref source) {
            Department owner = null;
            owner = source.getOwner() instanceof DepartmentalInstructor ? ((DepartmentalInstructor)source.getOwner()).getDepartment() : (Department)source.getOwner();
            if (owner == null) {
                return true;
            }
            if (this.permissionDepartment.check(user, owner)) {
                return this.permissionDepartment.check(user, owner, owner.isExternalManager() != false ? DepartmentStatusType.Status.ManagerEdit : DepartmentStatusType.Status.OwnerEdit);
            }
            for (DistributionObject distrObj : source.getDistributionObjects()) {
                if (distrObj.getPrefGroup() instanceof Class_) {
                    if (this.permissionClassEdit.check(user, (Class_)distrObj.getPrefGroup())) continue;
                    return false;
                }
                if (distrObj.getPrefGroup() instanceof SchedulingSubpart) {
                    if (this.permissionSchedulingSubpartEdit.check(user, (SchedulingSubpart)distrObj.getPrefGroup())) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public Class<DistributionPref> type() {
            return DistributionPref.class;
        }
    }

    @PermissionForRight(value=Right.DistributionPreferenceEdit)
    public static class DistributionPreferenceEdit
    implements Permission<DistributionPref> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;
        @Autowired
        Permission<Class_> permissionClassEdit;
        @Autowired
        Permission<SchedulingSubpart> permissionSchedulingSubpartEdit;

        @Override
        public boolean check(UserContext user, DistributionPref source) {
            Department owner = null;
            owner = source.getOwner() instanceof DepartmentalInstructor ? ((DepartmentalInstructor)source.getOwner()).getDepartment() : (Department)source.getOwner();
            if (owner == null) {
                return false;
            }
            if (!user.getCurrentAuthority().hasRight(Right.DepartmentIndependent) && !source.getDistributionType().isApplicable(owner)) {
                return false;
            }
            if (this.permissionDepartment.check(user, owner)) {
                return this.permissionDepartment.check(user, owner, owner.isExternalManager() != false ? DepartmentStatusType.Status.ManagerEdit : DepartmentStatusType.Status.OwnerEdit);
            }
            if (!owner.isAllowReqDistribution().booleanValue()) {
                if (source.getPrefLevel().getPrefProlog().equals(PreferenceLevel.sRequired)) {
                    if (source.getDistributionType().getAllowedPref().indexOf(48) >= 0) {
                        source.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyPreferred));
                    } else {
                        return false;
                    }
                }
                if (source.getPrefLevel().getPrefProlog().equals(PreferenceLevel.sProhibited)) {
                    if (source.getDistributionType().getAllowedPref().indexOf(52) >= 0) {
                        source.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyDiscouraged));
                    } else {
                        return false;
                    }
                }
            }
            for (DistributionObject distrObj : source.getDistributionObjects()) {
                if (distrObj.getPrefGroup() instanceof Class_) {
                    if (this.permissionClassEdit.check(user, (Class_)distrObj.getPrefGroup())) continue;
                    return false;
                }
                if (distrObj.getPrefGroup() instanceof SchedulingSubpart) {
                    if (this.permissionSchedulingSubpartEdit.check(user, (SchedulingSubpart)distrObj.getPrefGroup())) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public Class<DistributionPref> type() {
            return DistributionPref.class;
        }
    }

    @PermissionForRight(value=Right.DistributionPreferenceAdd)
    public static class DistributionPreferenceAdd
    implements Permission<Department> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            return this.permissionDepartment.check(user, source, source.isExternalManager() != false ? DepartmentStatusType.Status.ManagerEdit : DepartmentStatusType.Status.OwnerEdit);
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    @PermissionForRight(value=Right.DistributionPreferences)
    public static class DistributionPreferences
    implements Permission<Department> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            return this.permissionDepartment.check(user, source, source.isExternalManager() != false ? DepartmentStatusType.Status.ManagerView : DepartmentStatusType.Status.OwnerView);
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    @PermissionForRight(value=Right.SchedulingSubpartEditClearPreferences)
    public static class SchedulingSubpartEditClearPreferences
    extends SchedulingSubpartEdit {
    }

    @PermissionForRight(value=Right.SchedulingSubpartDetailClearClassPreferences)
    public static class SchedulingSubpartDetailClearClassPreferences
    extends SchedulingSubpartEdit {
    }

    @PermissionForRight(value=Right.DistributionPreferenceSubpart)
    public static class DistributionPreferenceSubpart
    extends SchedulingSubpartEdit {
    }

    @PermissionForRight(value=Right.ClassEditClearPreferences)
    public static class ClassEditClearPreferences
    extends ClassEdit {
    }

    @PermissionForRight(value=Right.DistributionPreferenceClass)
    public static class DistributionPreferenceClass
    extends ClassEdit {
    }

    @PermissionForRight(value=Right.ClassesExportPDF)
    public static class ClassesExportPDF
    extends InstructionalOfferings {
    }

    @PermissionForRight(value=Right.Classes)
    public static class Classes
    extends InstructionalOfferings {
    }

    @PermissionForRight(value=Right.InstructionalOfferingsWorksheetPDF)
    public static class InstructionalOfferingsWorksheetPDF
    extends InstructionalOfferings {
    }

    @PermissionForRight(value=Right.InstructionalOfferingsExportPDF)
    public static class InstructionalOfferingsExportPDF
    extends InstructionalOfferings {
    }

    @PermissionForRight(value=Right.InstructionalOfferings)
    public static class InstructionalOfferings
    implements Permission<Department> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            return this.permissionDepartment.check(user, source, DepartmentStatusType.Status.OwnerView, DepartmentStatusType.Status.ManagerView);
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    @PermissionForRight(value=Right.CanUseHardDistributionPrefs)
    public static class CanUseHardDistributionPrefs
    implements Permission<PreferenceGroup> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, PreferenceGroup source) {
            if (user.getCurrentAuthority().hasRight(Right.DepartmentIndependent) || source.getDepartment() == null) {
                return true;
            }
            Department department = source.getDepartment();
            if (source instanceof Class_) {
                department = ((Class_)source).getManagingDept();
            }
            if (source instanceof SchedulingSubpart) {
                department = ((SchedulingSubpart)source).getManagingDept();
            }
            return department == null || user.getCurrentAuthority().hasQualifier(department) || source.getDepartment().getAllowReqDistribution() != false;
        }

        @Override
        public Class<PreferenceGroup> type() {
            return PreferenceGroup.class;
        }
    }

    @PermissionForRight(value=Right.CanUseHardRoomPrefs)
    public static class CanUseHardRoomPrefs
    implements Permission<PreferenceGroup> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, PreferenceGroup source) {
            if (user.getCurrentAuthority().hasRight(Right.DepartmentIndependent) || source.getDepartment() == null) {
                return true;
            }
            Department department = source.getDepartment();
            if (source instanceof Class_) {
                department = ((Class_)source).getManagingDept();
            }
            if (source instanceof SchedulingSubpart) {
                department = ((SchedulingSubpart)source).getManagingDept();
            }
            return department == null || user.getCurrentAuthority().hasQualifier(department) || source.getDepartment().getAllowReqRoom() != false;
        }

        @Override
        public Class<PreferenceGroup> type() {
            return PreferenceGroup.class;
        }
    }

    @PermissionForRight(value=Right.CanUseHardTimePrefs)
    public static class CanUseHardTimePrefs
    implements Permission<PreferenceGroup> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, PreferenceGroup source) {
            if (user.getCurrentAuthority().hasRight(Right.DepartmentIndependent) || source.getDepartment() == null) {
                return true;
            }
            Department department = source.getDepartment();
            if (source instanceof Class_) {
                department = ((Class_)source).getManagingDept();
            }
            if (source instanceof SchedulingSubpart) {
                department = ((SchedulingSubpart)source).getManagingDept();
            }
            return department == null || user.getCurrentAuthority().hasQualifier(department) || source.getDepartment().getAllowReqTime() != false;
        }

        @Override
        public Class<PreferenceGroup> type() {
            return PreferenceGroup.class;
        }
    }

    @PermissionForRight(value=Right.CanUseHardPeriodPrefs)
    public static class CanUseHardPeriodPrefs
    implements Permission<ExamType> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, ExamType source) {
            return user.getCurrentAuthority().hasRight(Right.DepartmentIndependent);
        }

        @Override
        public Class<ExamType> type() {
            return ExamType.class;
        }
    }

    @PermissionForRight(value=Right.EditCourseOfferingAssociatedCourse)
    public static class EditCourseOfferingAssociatedCourse
    extends AddCourseOffering {
    }

    @PermissionForRight(value=Right.EditCourseOfferingCoordinators)
    public static class EditCourseOfferingCoordinators
    implements Permission<CourseOffering> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, CourseOffering source) {
            if (source.isIsControl().booleanValue() && this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerLimitedEdit)) {
                return true;
            }
            if (ApplicationProperty.PermissionCourseOfferingAllowsExternalEdit.isTrue()) {
                HashSet<Department> externals = new HashSet<Department>();
                for (InstrOfferingConfig config : source.getInstructionalOffering().getInstrOfferingConfigs()) {
                    for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                        for (Class_ clazz : subpart.getClasses()) {
                            if (clazz.getManagingDept() == null || !clazz.getManagingDept().isExternalManager().booleanValue() || !externals.add(clazz.getManagingDept()) || !this.permissionDepartment.check(user, clazz.getManagingDept(), DepartmentStatusType.Status.ManagerLimitedEdit)) continue;
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        @Override
        public Class<CourseOffering> type() {
            return CourseOffering.class;
        }
    }

    @PermissionForRight(value=Right.EditCourseOfferingNote)
    public static class EditCourseOfferingNote
    implements Permission<CourseOffering> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, CourseOffering source) {
            if (this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerLimitedEdit)) {
                return true;
            }
            if (ApplicationProperty.PermissionCourseOfferingAllowsExternalEdit.isTrue()) {
                HashSet<Department> externals = new HashSet<Department>();
                for (InstrOfferingConfig config : source.getInstructionalOffering().getInstrOfferingConfigs()) {
                    for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                        for (Class_ clazz : subpart.getClasses()) {
                            if (clazz.getManagingDept() == null || !clazz.getManagingDept().isExternalManager().booleanValue() || !externals.add(clazz.getManagingDept()) || !this.permissionDepartment.check(user, clazz.getManagingDept(), DepartmentStatusType.Status.ManagerLimitedEdit)) continue;
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        @Override
        public Class<CourseOffering> type() {
            return CourseOffering.class;
        }
    }

    @PermissionForRight(value=Right.EditCourseOffering)
    public static class EditCourseOffering
    implements Permission<CourseOffering> {
        @Autowired
        Permission<InstructionalOffering> permissionOfferingLockNeeded;
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, CourseOffering source) {
            if (this.permissionOfferingLockNeeded.check(user, source.getInstructionalOffering())) {
                return false;
            }
            if (this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerEdit)) {
                return true;
            }
            if (ApplicationProperty.PermissionCourseOfferingAllowsExternalEdit.isTrue() && source.isIsControl().booleanValue()) {
                HashSet<Department> externals = new HashSet<Department>();
                for (InstrOfferingConfig config : source.getInstructionalOffering().getInstrOfferingConfigs()) {
                    for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                        for (Class_ clazz : subpart.getClasses()) {
                            if (clazz.getManagingDept() != null && clazz.getManagingDept().isExternalManager().booleanValue()) {
                                if (!externals.add(clazz.getManagingDept()) || this.permissionDepartment.check(user, clazz.getManagingDept(), DepartmentStatusType.Status.ManagerEdit)) continue;
                                return false;
                            }
                            return false;
                        }
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public Class<CourseOffering> type() {
            return CourseOffering.class;
        }
    }

    @PermissionForRight(value=Right.OfferingDelete)
    public static class OfferingDelete
    implements Permission<InstructionalOffering> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, InstructionalOffering source) {
            if (!source.isNotOffered().booleanValue()) {
                return false;
            }
            return this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerEdit);
        }

        @Override
        public Class<InstructionalOffering> type() {
            return InstructionalOffering.class;
        }
    }

    @PermissionForRight(value=Right.OfferingMakeNotOffered)
    public static class OfferingMakeNotOffered
    extends OfferingMakeNotOfferedNoEnrollmentCheck {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;
        @Autowired
        Permission<InstructionalOffering> permissionOfferingLockNeeded;

        @Override
        public boolean check(UserContext user, InstructionalOffering source) {
            if (!user.getCurrentAuthority().hasRight(Right.OfferingMakeNotOfferedNoEnrollmentCheck) && source.getDepartment() != null && source.getDepartment().getSolverGroup() != null && source.getDepartment().getSolverGroup().getCommittedSolution() != null && source.getEnrollment() > 0) {
                return false;
            }
            return super.check(user, source);
        }
    }

    @PermissionForRight(value=Right.OfferingMakeNotOfferedNoEnrollmentCheck)
    public static class OfferingMakeNotOfferedNoEnrollmentCheck
    implements Permission<InstructionalOffering> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;
        @Autowired
        Permission<InstructionalOffering> permissionOfferingLockNeeded;

        @Override
        public boolean check(UserContext user, InstructionalOffering source) {
            if (this.permissionOfferingLockNeeded.check(user, source)) {
                return false;
            }
            if (source.isNotOffered().booleanValue()) {
                return false;
            }
            HashSet<Department> externals = new HashSet<Department>();
            for (InstrOfferingConfig config : source.getInstrOfferingConfigs()) {
                for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                    for (Class_ clazz : subpart.getClasses()) {
                        if (clazz.getManagingDept() == null || !clazz.getManagingDept().isExternalManager().booleanValue() || !externals.add(clazz.getManagingDept()) || this.permissionDepartment.check(user, clazz.getManagingDept(), DepartmentStatusType.Status.ManagerEdit) || clazz.getManagingDept().effectiveStatusType(clazz.getControllingDept()).can(DepartmentStatusType.Status.OwnerEdit)) continue;
                        return false;
                    }
                }
            }
            return this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerEdit);
        }

        @Override
        public Class<InstructionalOffering> type() {
            return InstructionalOffering.class;
        }
    }

    @PermissionForRight(value=Right.OfferingMakeOffered)
    public static class OfferingMakeOffered
    implements Permission<InstructionalOffering> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, InstructionalOffering source) {
            if (!source.isNotOffered().booleanValue()) {
                return false;
            }
            return this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerEdit);
        }

        @Override
        public Class<InstructionalOffering> type() {
            return InstructionalOffering.class;
        }
    }

    @PermissionForRight(value=Right.MultipleClassSetupClass)
    public static class MultipleClassSetupClassEdit
    implements Permission<Class_> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;
        @Autowired
        Permission<InstructionalOffering> permissionOfferingLockNeeded;

        @Override
        public boolean check(UserContext user, Class_ source) {
            return !this.permissionOfferingLockNeeded.check(user, source.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering()) && this.permissionDepartment.check(user, source.getControllingDept(), DepartmentStatusType.Status.OwnerEdit, source.getManagingDept(), DepartmentStatusType.Status.ManagerEdit);
        }

        @Override
        public Class<Class_> type() {
            return Class_.class;
        }
    }

    @PermissionForRight(value=Right.MultipleClassSetupDepartment)
    public static class MultipleClassSetupDepartment
    extends InstrOfferingConfigEditDepartment {
    }

    @PermissionForRight(value=Right.CourseOfferingDeleteFromCrossList)
    public static class CourseOfferingDeleteFromCrossList
    extends CourseOfferingDeleteFromCrossListNoEnrollmentCheck {
        @Override
        public boolean check(UserContext user, CourseOffering source) {
            if (!user.getCurrentAuthority().hasRight(Right.CourseOfferingDeleteFromCrossListNoEnrollmentCheck) && source.getDepartment() != null && source.getDepartment().getSolverGroup() != null && source.getDepartment().getSolverGroup().getCommittedSolution() != null && source.getEnrollment() > 0) {
                return false;
            }
            return super.check(user, source);
        }
    }

    @PermissionForRight(value=Right.CourseOfferingDeleteFromCrossListNoEnrollmentCheck)
    public static class CourseOfferingDeleteFromCrossListNoEnrollmentCheck
    implements Permission<CourseOffering> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, CourseOffering source) {
            return this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerEdit);
        }

        @Override
        public Class<CourseOffering> type() {
            return CourseOffering.class;
        }
    }

    @PermissionForRight(value=Right.InstructionalOfferingCrossLists)
    public static class InstructionalOfferingCrossLists
    implements Permission<InstructionalOffering> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;
        @Autowired
        Permission<InstructionalOffering> permissionOfferingLockNeeded;

        @Override
        public boolean check(UserContext user, InstructionalOffering source) {
            if (this.permissionOfferingLockNeeded.check(user, source)) {
                return false;
            }
            return this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerEdit);
        }

        @Override
        public Class<InstructionalOffering> type() {
            return InstructionalOffering.class;
        }
    }

    @PermissionForRight(value=Right.InstrOfferingConfigEditSubpart)
    public static class InstrOfferingConfigEditSubpart
    extends SchedulingSubpartEdit {
    }

    @PermissionForRight(value=Right.InstrOfferingConfigEditDepartment)
    public static class InstrOfferingConfigEditDepartment
    implements Permission<Department> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            if (source.isExternalManager().booleanValue() && this.permissionDepartment.check(user, source, DepartmentStatusType.Status.ManagerEdit)) {
                return true;
            }
            if (!source.isExternalManager().booleanValue() && this.permissionDepartment.check(user, source, DepartmentStatusType.Status.OwnerEdit)) {
                return true;
            }
            return source.isExternalManager() != false && source.effectiveStatusType().can(DepartmentStatusType.Status.OwnerEdit);
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    @PermissionForRight(value=Right.InstrOfferingConfigDelete)
    public static class InstrOfferingConfigDelete
    implements Permission<InstrOfferingConfig> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;
        @Autowired
        Permission<InstructionalOffering> permissionOfferingLockNeeded;

        @Override
        public boolean check(UserContext user, InstrOfferingConfig source) {
            if (source.getInstructionalOffering().isNotOffered().booleanValue()) {
                return false;
            }
            if (source.getInstructionalOffering().getInstrOfferingConfigs().size() <= 1) {
                return false;
            }
            if (this.permissionOfferingLockNeeded.check(user, source.getInstructionalOffering())) {
                return false;
            }
            if (source.getInstructionalOffering().isNotOffered().booleanValue()) {
                return false;
            }
            HashSet<Department> externals = new HashSet<Department>();
            for (SchedulingSubpart subpart : source.getSchedulingSubparts()) {
                for (Class_ clazz : subpart.getClasses()) {
                    if (clazz.getManagingDept() == null || !clazz.getManagingDept().isExternalManager().booleanValue() || !externals.add(clazz.getManagingDept()) || this.permissionDepartment.check(user, clazz.getManagingDept(), DepartmentStatusType.Status.ManagerEdit) || clazz.getManagingDept().effectiveStatusType(clazz.getControllingDept()).can(DepartmentStatusType.Status.OwnerEdit)) continue;
                    return false;
                }
            }
            return this.permissionDepartment.check(user, source.getInstructionalOffering().getDepartment(), DepartmentStatusType.Status.OwnerEdit);
        }

        @Override
        public Class<InstrOfferingConfig> type() {
            return InstrOfferingConfig.class;
        }
    }

    @PermissionForRight(value=Right.InstrOfferingConfigAdd)
    public static class InstrOfferingConfigAdd
    implements Permission<InstructionalOffering> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;
        @Autowired
        Permission<InstructionalOffering> permissionOfferingLockNeeded;

        @Override
        public boolean check(UserContext user, InstructionalOffering source) {
            if (this.permissionOfferingLockNeeded.check(user, source)) {
                return false;
            }
            if (source.isNotOffered().booleanValue()) {
                return false;
            }
            return this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerEdit);
        }

        @Override
        public Class<InstructionalOffering> type() {
            return InstructionalOffering.class;
        }
    }

    @PermissionForRight(value=Right.InstrOfferingConfigEditDisclaimer)
    public static class InstrOfferingConfigEditDisclaimer
    extends InstrOfferingConfigAdd {
    }

    @PermissionForRight(value=Right.InstrOfferingConfigEdit)
    public static class InstrOfferingConfigEdit
    implements Permission<InstrOfferingConfig> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;
        @Autowired
        Permission<InstructionalOffering> permissionOfferingLockNeeded;

        @Override
        public boolean check(UserContext user, InstrOfferingConfig source) {
            if (this.permissionOfferingLockNeeded.check(user, source.getInstructionalOffering())) {
                return false;
            }
            if (source.getInstructionalOffering().isNotOffered().booleanValue()) {
                return false;
            }
            return this.permissionDepartment.check(user, source.getInstructionalOffering().getDepartment(), DepartmentStatusType.Status.OwnerEdit);
        }

        @Override
        public Class<InstrOfferingConfig> type() {
            return InstrOfferingConfig.class;
        }
    }

    @PermissionForRight(value=Right.MultipleClassSetup)
    public static class MultipleClassSetup
    implements Permission<InstrOfferingConfig> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;
        @Autowired
        Permission<InstructionalOffering> permissionOfferingLockNeeded;

        @Override
        public boolean check(UserContext user, InstrOfferingConfig source) {
            if (source.getInstructionalOffering().isNotOffered().booleanValue()) {
                return false;
            }
            if (this.permissionOfferingLockNeeded.check(user, source.getInstructionalOffering())) {
                return false;
            }
            if (this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerEdit)) {
                return true;
            }
            HashSet<Department> externals = new HashSet<Department>();
            for (SchedulingSubpart subpart : source.getSchedulingSubparts()) {
                for (Class_ clazz : subpart.getClasses()) {
                    if (clazz.getManagingDept() == null || !clazz.getManagingDept().isExternalManager().booleanValue() || !externals.add(clazz.getManagingDept()) || !this.permissionDepartment.check(user, clazz.getManagingDept(), DepartmentStatusType.Status.ManagerEdit)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Class<InstrOfferingConfig> type() {
            return InstrOfferingConfig.class;
        }
    }

    @PermissionForRight(value=Right.SchedulingSubpartEdit)
    public static class SchedulingSubpartEdit
    implements Permission<SchedulingSubpart> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;
        @Autowired
        Permission<InstructionalOffering> permissionOfferingLockNeeded;

        @Override
        public boolean check(UserContext user, SchedulingSubpart source) {
            return !this.permissionOfferingLockNeeded.check(user, source.getInstrOfferingConfig().getInstructionalOffering()) && this.permissionDepartment.check(user, source.getControllingDept(), DepartmentStatusType.Status.OwnerEdit, source.getManagingDept(), DepartmentStatusType.Status.ManagerEdit);
        }

        @Override
        public Class<SchedulingSubpart> type() {
            return SchedulingSubpart.class;
        }
    }

    @PermissionForRight(value=Right.ClassEdit)
    public static class ClassEdit
    implements Permission<Class_> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;
        @Autowired
        Permission<InstructionalOffering> permissionOfferingLockNeeded;

        @Override
        public boolean check(UserContext user, Class_ source) {
            if (source.isCancelled().booleanValue()) {
                return false;
            }
            return !this.permissionOfferingLockNeeded.check(user, source.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering()) && this.permissionDepartment.check(user, source.getControllingDept(), DepartmentStatusType.Status.OwnerEdit, source.getManagingDept(), DepartmentStatusType.Status.ManagerEdit);
        }

        @Override
        public Class<Class_> type() {
            return Class_.class;
        }
    }

    @PermissionForRight(value=Right.ClassDetail)
    public static class ClassDetail
    implements Permission<Class_> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Class_ source) {
            return this.permissionDepartment.check(user, source.getControllingDept(), DepartmentStatusType.Status.OwnerView, source.getManagingDept(), DepartmentStatusType.Status.ManagerView);
        }

        @Override
        public Class<Class_> type() {
            return Class_.class;
        }
    }

    @PermissionForRight(value=Right.SchedulingSubpartDetail)
    public static class SchedulingSubpartDetail
    implements Permission<SchedulingSubpart> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, SchedulingSubpart source) {
            return this.permissionDepartment.check(user, source.getControllingDept(), DepartmentStatusType.Status.OwnerView, source.getManagingDept(), DepartmentStatusType.Status.ManagerView);
        }

        @Override
        public Class<SchedulingSubpart> type() {
            return SchedulingSubpart.class;
        }
    }

    @PermissionForRight(value=Right.InstructionalOfferingDetail)
    public static class InstructionalOfferingDetail
    implements Permission<InstructionalOffering> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, InstructionalOffering source) {
            for (CourseOffering course : source.getCourseOfferings()) {
                if (!this.permissionDepartment.check(user, course.getDepartment(), DepartmentStatusType.Status.OwnerView)) continue;
                return true;
            }
            HashSet<Department> externals = new HashSet<Department>();
            for (InstrOfferingConfig config : source.getInstrOfferingConfigs()) {
                for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                    for (Class_ clazz : subpart.getClasses()) {
                        if (clazz.getManagingDept() == null || !clazz.getManagingDept().isExternalManager().booleanValue() || !externals.add(clazz.getManagingDept()) || !this.permissionDepartment.check(user, clazz.getManagingDept(), DepartmentStatusType.Status.ManagerView)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public Class<InstructionalOffering> type() {
            return InstructionalOffering.class;
        }
    }

    @PermissionForRight(value=Right.AddCourseOffering)
    public static class AddCourseOffering
    implements Permission<SubjectArea> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, SubjectArea source) {
            return this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerEdit);
        }

        @Override
        public Class<SubjectArea> type() {
            return SubjectArea.class;
        }
    }

    @PermissionForRight(value=Right.OfferingCanUnlock)
    public static class OfferingCanUnlock
    implements Permission<InstructionalOffering> {
        @Autowired
        Permission<InstructionalOffering> permissionOfferingEdit;
        @Autowired
        SolverServerService solverServerService;

        protected OnlineSectioningServer getInstance(Long sessionId) {
            if (sessionId == null) {
                return null;
            }
            return this.solverServerService.getOnlineStudentSchedulingContainer().getSolver(sessionId.toString());
        }

        @Override
        public boolean check(UserContext user, InstructionalOffering source) {
            if (!this.permissionOfferingEdit.check(user, source)) {
                return false;
            }
            OnlineSectioningServer server = this.getInstance(user.getCurrentAcademicSessionId());
            return user.getCurrentAuthority().hasRight(Right.OfferingCanUnlock) && server != null && server.isOfferingLocked(source.getUniqueId());
        }

        @Override
        public Class<InstructionalOffering> type() {
            return InstructionalOffering.class;
        }
    }

    @PermissionForRight(value=Right.OfferingCanLock)
    public static class OfferingCanLock
    implements Permission<InstructionalOffering> {
        @Autowired
        Permission<InstructionalOffering> permissionOfferingEdit;
        @Autowired
        Permission<InstructionalOffering> permissionOfferingLockNeeded;

        @Override
        public boolean check(UserContext user, InstructionalOffering source) {
            if (!this.permissionOfferingLockNeeded.check(user, source)) {
                return false;
            }
            return this.permissionOfferingEdit.check(user, source);
        }

        @Override
        public Class<InstructionalOffering> type() {
            return InstructionalOffering.class;
        }
    }

    @Service(value="permissionOfferingEdit")
    public static class OfferingEdit
    implements Permission<InstructionalOffering> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, InstructionalOffering source) {
            for (CourseOffering course : source.getCourseOfferings()) {
                if (!this.permissionDepartment.check(user, course.getDepartment(), DepartmentStatusType.Status.OwnerLimitedEdit)) continue;
                return true;
            }
            HashSet<Department> externals = new HashSet<Department>();
            for (InstrOfferingConfig config : source.getInstrOfferingConfigs()) {
                for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                    for (Class_ clazz : subpart.getClasses()) {
                        if (clazz.getManagingDept() == null || !clazz.getManagingDept().isExternalManager().booleanValue() || !externals.add(clazz.getManagingDept()) || !this.permissionDepartment.check(user, clazz.getManagingDept(), DepartmentStatusType.Status.ManagerLimitedEdit)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public Class<InstructionalOffering> type() {
            return InstructionalOffering.class;
        }
    }

    @Service(value="permissionOfferingLockNeededOnlyWhenWaitListing")
    public static class OfferingLockNeededOnlyWhenWaitListing
    extends OfferingLockNeededLimitedEdit {
        @Override
        public boolean check(UserContext user, InstructionalOffering source) {
            if (!CustomStudentEnrollmentHolder.isAllowWaitListing()) {
                return false;
            }
            if (!super.check(user, source)) {
                return false;
            }
            if (!source.effectiveWaitList()) {
                return false;
            }
            if (ApplicationProperty.ReservationLockCheckWaitList.isTrue()) {
                Collection<XCourseRequest> requests;
                OnlineSectioningServer server = this.getInstance(user.getCurrentAcademicSessionId());
                Collection<XCourseRequest> collection = requests = server != null ? server.getRequests(source.getUniqueId()) : null;
                if (requests != null) {
                    for (XCourseRequest request : requests) {
                        if (request.getEnrollment() != null || !request.isWaitlist()) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
    }

    @Service(value="permissionOfferingLockNeededLimitedEdit")
    public static class OfferingLockNeededLimitedEdit
    implements Permission<InstructionalOffering> {
        @Autowired
        Permission.PermissionSession permissionSession;
        @Autowired
        SolverServerService solverServerService;

        protected OnlineSectioningServer getInstance(Long sessionId) {
            if (sessionId == null) {
                return null;
            }
            return this.solverServerService.getOnlineStudentSchedulingContainer().getSolver(sessionId.toString());
        }

        @Override
        public boolean check(UserContext user, InstructionalOffering source) {
            if (source.isNotOffered().booleanValue() || !source.isAllowStudentScheduling()) {
                return false;
            }
            if (!this.permissionSession.check(user, source.getSession(), DepartmentStatusType.Status.StudentsOnline)) {
                return false;
            }
            OnlineSectioningServer server = this.getInstance(user.getCurrentAcademicSessionId());
            return server != null && server.getAcademicSession().isSectioningEnabled() && !server.isOfferingLocked(source.getUniqueId());
        }

        @Override
        public Class<InstructionalOffering> type() {
            return InstructionalOffering.class;
        }
    }

    @Service(value="permissionOfferingLockNeeded")
    public static class OfferingLockNeeded
    implements Permission<InstructionalOffering> {
        @Autowired
        Permission.PermissionSession permissionSession;
        @Autowired
        SolverServerService solverServerService;

        protected OnlineSectioningServer getInstance(Long sessionId) {
            if (sessionId == null) {
                return null;
            }
            return this.solverServerService.getOnlineStudentSchedulingContainer().getSolver(sessionId.toString());
        }

        @Override
        public boolean check(UserContext user, InstructionalOffering source) {
            if (source.isNotOffered().booleanValue() || !source.isAllowStudentScheduling()) {
                return false;
            }
            if (!this.permissionSession.check(user, source.getSession(), DepartmentStatusType.Status.StudentsAssistant, DepartmentStatusType.Status.StudentsOnline)) {
                return false;
            }
            OnlineSectioningServer server = this.getInstance(user.getCurrentAcademicSessionId());
            return server != null && !server.isOfferingLocked(source.getUniqueId());
        }

        @Override
        public Class<InstructionalOffering> type() {
            return InstructionalOffering.class;
        }
    }
}

