/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.context;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.ManagerRole;
import org.unitime.timetable.model.ManagerSettings;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Settings;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.UserData;
import org.unitime.timetable.model.base.BaseAdvisor;
import org.unitime.timetable.model.base.BaseManagerSettings;
import org.unitime.timetable.model.base.BaseRoles;
import org.unitime.timetable.model.base.BaseSession;
import org.unitime.timetable.model.base.BaseSettings;
import org.unitime.timetable.model.base.UserDataId;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.model.dao.UserDataDAO;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.authority.RoleAuthority;
import org.unitime.timetable.security.context.AbstractUserContext;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.HasRights;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.LoginManager;
import org.unitime.timetable.util.NameFormat;

public class UniTimeUserContext
extends AbstractUserContext {
    private static final long serialVersionUID = 1L;
    private String iId;
    private String iPassword;
    private String iName;
    private String iLogin;
    private String iEmail;

    public UniTimeUserContext(String userId, String login, String name, String password) {
        this(userId, login, name, password, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UniTimeUserContext(String userId, String login, String name, String password, Long sessionId) {
        this.iLogin = login;
        this.iPassword = password;
        this.iId = userId;
        this.iName = name;
        try (org.hibernate.Session hibSession = TimetableManagerDAO.getInstance().createNewSession();){
            List<? extends UserAuthority> authorities;
            Session session;
            Roles noRole;
            List<? extends UserAuthority> authorities2;
            List<? extends UserAuthority> authorities3;
            Session session2;
            Roles studentRole;
            RoleAuthority authority;
            TimetableManager manager;
            String lastSessionId;
            String nameFormat = ApplicationProperty.AuthorizationUserNameFormat.value();
            if (nameFormat == null || nameFormat.isEmpty()) {
                nameFormat = NameFormat.LAST_FIRST_MIDDLE.reference();
            }
            for (UserData data : hibSession.createQuery("from UserData where externalUniqueId = :id", UserData.class).setParameter("id", (Object)userId).list()) {
                this.getProperties().put(data.getName(), data.getValue());
            }
            for (Serializable setting : hibSession.createQuery("from Settings", Settings.class).list()) {
                if (((BaseSettings)setting).getDefaultValue() == null) continue;
                this.getProperties().put(((BaseSettings)setting).getKey(), ((BaseSettings)setting).getDefaultValue());
            }
            for (Serializable setting : hibSession.createQuery("from ManagerSettings where manager.externalUniqueId = :id", ManagerSettings.class).setParameter("id", (Object)userId).list()) {
                if (((BaseManagerSettings)setting).getValue() == null) continue;
                this.getProperties().put(((BaseManagerSettings)setting).getKey().getKey(), ((BaseManagerSettings)setting).getValue());
            }
            if (sessionId == null && ApplicationProperty.KeepLastUsedAcademicSession.isTrue() && (lastSessionId = this.getProperty(UserProperty.LastAcademicSession)) != null) {
                sessionId = Long.valueOf(lastSessionId);
            }
            if ((manager = (TimetableManager)hibSession.createQuery("from TimetableManager where externalUniqueId = :id", TimetableManager.class).setParameter("id", (Object)userId).setMaxResults(1).uniqueResult()) != null) {
                List<? extends UserAuthority> authorities4;
                Session session3;
                this.iName = manager.getName(nameFormat);
                this.iEmail = manager.getEmailAddress();
                BaseRoles primary = null;
                Object primarySessions = null;
                for (ManagerRole role : manager.getManagerRoles()) {
                    if (!role.getRole().isEnabled().booleanValue()) continue;
                    TreeSet<Object> sessions = new TreeSet<Object>();
                    if (role.getRole().hasRight(Right.SessionIndependent) || sessions.isEmpty() && role.getRole().hasRight(Right.SessionIndependentIfNoSessionGiven)) {
                        sessions.addAll(SessionDAO.getInstance().findAll(hibSession));
                    } else {
                        for (Department department : manager.getDepartments()) {
                            sessions.add(department.getSession());
                        }
                    }
                    if (role.isPrimary().booleanValue() && primary == null) {
                        primary = role.getRole();
                        primarySessions = sessions;
                    }
                    for (Session session4 : sessions) {
                        if ((session4.getStatusType() == null || session4.getStatusType().isTestSession()) && !role.getRole().hasRight(Right.AllowTestSessions)) continue;
                        authority = new RoleAuthority(manager.getUniqueId(), role.getRole());
                        authority.addQualifier(session4);
                        authority.addQualifier(manager);
                        for (Department department : manager.getDepartments()) {
                            if (!department.getSession().equals(session4)) continue;
                            authority.addQualifier(department);
                        }
                        block10: for (SolverGroup group : manager.getSolverGroups()) {
                            for (Department department : group.getDepartments()) {
                                if (!department.getSession().equals(session4)) continue;
                                authority.addQualifier(group);
                                continue block10;
                            }
                        }
                        this.addAuthority(authority);
                    }
                }
                if (sessionId == null && primary != null && (session3 = UniTimeUserContext.defaultSession(primarySessions, (HasRights)((Object)primary), this.getProperty(UserProperty.PrimaryCampus.key()))) != null) {
                    sessionId = session3.getUniqueId();
                }
                if (sessionId != null && primary != null && !(authorities4 = this.getAuthorities(primary.getReference(), new SimpleQualifier("Session", sessionId))).isEmpty()) {
                    this.setCurrentAuthority(authorities4.get(0));
                }
            }
            TreeSet<Session> sessions = new TreeSet<Session>();
            for (Object advisor : hibSession.createQuery("from Advisor where externalUniqueId = :id order by session.sessionBeginDateTime desc", Advisor.class).setParameter("id", (Object)userId).list()) {
                if (((BaseAdvisor)advisor).getRole() == null || !((BaseAdvisor)advisor).getRole().isEnabled().booleanValue() || ApplicationProperty.AuthorizationAdvisorMustHaveStudents.isTrue() && ((BaseAdvisor)advisor).getStudents().isEmpty() || (((BaseAdvisor)advisor).getSession().getStatusType() == null || ((BaseAdvisor)advisor).getSession().getStatusType().isTestSession()) && !((BaseAdvisor)advisor).getRole().hasRight(Right.AllowTestSessions)) continue;
                if (this.iName == null && ((Advisor)advisor).hasName()) {
                    this.iName = ((Advisor)advisor).getName(nameFormat);
                }
                if (this.iEmail == null) {
                    this.iEmail = ((BaseAdvisor)advisor).getEmail();
                }
                RoleAuthority authority2 = new RoleAuthority(((BaseAdvisor)advisor).getUniqueId(), ((BaseAdvisor)advisor).getRole());
                authority2.addQualifier(((BaseAdvisor)advisor).getSession());
                this.addAuthority(authority2);
                sessions.add(((BaseAdvisor)advisor).getSession());
            }
            Roles instructorRole = Roles.getRole("Instructor", hibSession);
            if (instructorRole != null && instructorRole.isEnabled().booleanValue()) {
                for (DepartmentalInstructor instructor : hibSession.createQuery("from DepartmentalInstructor where externalUniqueId = :id order by department.session.sessionBeginDateTime desc, department.deptCode", DepartmentalInstructor.class).setParameter("id", (Object)userId).list()) {
                    Object instrRoleAuthority;
                    if (this.iName == null) {
                        this.iName = instructor.getName(nameFormat);
                    }
                    if (this.iEmail == null) {
                        this.iEmail = instructor.getEmail();
                    }
                    if (instructor.getDepartment().getSession().getStatusType() != null && !instructor.getDepartment().getSession().getStatusType().isTestSession() || Roles.getRole("Instructor", hibSession).hasRight(Right.AllowTestSessions)) {
                        UserAuthority authority3;
                        List<? extends UserAuthority> authorities5 = this.getAuthorities("Instructor", instructor.getDepartment().getSession());
                        UserAuthority userAuthority = authority3 = authorities5.isEmpty() ? null : authorities5.get(0);
                        if (authority3 == null) {
                            authority3 = new RoleAuthority(instructor.getUniqueId(), instructorRole);
                            authority3.addQualifier(instructor.getDepartment().getSession());
                            this.addAuthority(authority3);
                            sessions.add(instructor.getDepartment().getSession());
                        }
                        authority3.addQualifier(instructor.getDepartment());
                    }
                    if (instructor.getRole() == null || (instructor.getDepartment().getSession().getStatusType() == null || instructor.getDepartment().getSession().getStatusType().isTestSession()) && !instructor.getRole().hasRight(Right.AllowTestSessions)) continue;
                    List<? extends UserAuthority> instrRoleAuthorities = this.getAuthorities(instructor.getRole().getReference(), instructor.getDepartment().getSession());
                    Object object = instrRoleAuthority = instrRoleAuthorities.isEmpty() ? null : instrRoleAuthorities.get(0);
                    if (instrRoleAuthority == null) {
                        instrRoleAuthority = new RoleAuthority(instructor.getUniqueId(), instructor.getRole());
                        instrRoleAuthority.addQualifier(instructor.getDepartment().getSession());
                        this.addAuthority((UserAuthority)instrRoleAuthority);
                        sessions.add(instructor.getDepartment().getSession());
                    }
                    instrRoleAuthority.addQualifier(instructor.getDepartment());
                    instrRoleAuthority.addQualifier(new SimpleQualifier("Role", (Serializable)((Object)"Instructor")));
                }
            }
            if ((studentRole = Roles.getRole("Student", hibSession)) != null && studentRole.isEnabled().booleanValue()) {
                boolean preferStudentName = ApplicationProperty.AuthorizationUseStudentName.isTrue();
                Date now = new Date();
                for (Student student : hibSession.createQuery("from Student where externalUniqueId = :id order by session.sessionBeginDateTime desc", Student.class).setParameter("id", (Object)userId).list()) {
                    if (this.iName == null) {
                        this.iName = student.getName(nameFormat);
                    }
                    if (this.iEmail == null) {
                        this.iEmail = student.getEmail();
                    }
                    if ((student.getSession().getStatusType() == null || student.getSession().getStatusType().isTestSession()) && !studentRole.hasRight(Right.AllowTestSessions)) continue;
                    authority = new RoleAuthority(student.getUniqueId(), studentRole);
                    authority.addQualifier(student.getSession());
                    authority.addQualifier(student);
                    this.addAuthority(authority);
                    sessions.add(student.getSession());
                    if (!preferStudentName || !now.before(student.getSession().getSessionEndDateTime())) continue;
                    this.iName = student.getName(nameFormat);
                    preferStudentName = false;
                }
            }
            if (sessionId == null && (session2 = UniTimeUserContext.defaultSession(sessions, null, this.getProperty(UserProperty.PrimaryCampus.key()))) != null) {
                sessionId = session2.getUniqueId();
            }
            if (this.getCurrentAuthority() == null && sessionId != null && !(authorities3 = this.getAuthorities("Instructor", new SimpleQualifier("Session", sessionId))).isEmpty()) {
                this.setCurrentAuthority(authorities3.get(0));
            }
            if (this.getCurrentAuthority() == null && sessionId != null && !(authorities2 = this.getAuthorities("Student", new SimpleQualifier("Session", sessionId))).isEmpty()) {
                this.setCurrentAuthority(authorities2.get(0));
            }
            if ((noRole = Roles.getRole("No Role", hibSession)) != null && noRole.isEnabled().booleanValue()) {
                for (Session session5 : new TreeSet(SessionDAO.getInstance().findAll(hibSession))) {
                    List<? extends UserAuthority> list;
                    if (session5.getStatusType() == null || !session5.getStatusType().isAllowNoRole() || session5.getStatusType().isTestSession() || !(list = this.getAuthorities(null, new SimpleQualifier("Session", session5.getUniqueId()))).isEmpty()) continue;
                    authority = new RoleAuthority(-1L, noRole);
                    authority.addQualifier(session5);
                    this.addAuthority(authority);
                    sessions.add(session5);
                }
            }
            if (this.getCurrentAuthority() == null && (session = UniTimeUserContext.defaultSession(sessions, null, this.getProperty(UserProperty.PrimaryCampus.key()))) != null && !(authorities = this.getAuthorities(null, new SimpleQualifier("Session", session.getUniqueId()))).isEmpty()) {
                this.setCurrentAuthority(authorities.get(0));
            }
        }
        if (this.iName == null) {
            this.iName = this.iLogin;
        }
    }

    public UniTimeUserContext(TimetableManager manager, Session session) {
        this.iLogin = null;
        this.iPassword = null;
        this.iId = manager.getExternalUniqueId();
        this.iName = manager.getName();
        this.iEmail = manager.getEmailAddress();
        for (ManagerRole role : manager.getManagerRoles()) {
            if (!role.getRole().isEnabled().booleanValue()) continue;
            boolean hasSession = false;
            for (Department department : manager.getDepartments()) {
                if (!session.equals(department.getSession())) continue;
                hasSession = true;
                break;
            }
            if (!role.getRole().hasRight(Right.SessionIndependent) && (role.getRole().hasRight(Right.SessionIndependentIfNoSessionGiven) ? !hasSession && !manager.getDepartments().isEmpty() : !hasSession)) continue;
            RoleAuthority authority = new RoleAuthority(manager.getUniqueId(), role.getRole());
            authority.addQualifier(session);
            authority.addQualifier(manager);
            for (Department department : manager.getDepartments()) {
                if (!department.getSession().equals(session)) continue;
                authority.addQualifier(department);
            }
            block3: for (SolverGroup group : manager.getSolverGroups()) {
                for (Department department : group.getDepartments()) {
                    if (!department.getSession().equals(session)) continue;
                    authority.addQualifier(group);
                    continue block3;
                }
            }
            this.addAuthority(authority);
            if (this.getCurrentAuthority() != null && !role.isPrimary().booleanValue()) continue;
            this.setCurrentAuthority(authority);
        }
    }

    public static Session defaultSession(TreeSet<Session> sessions, HasRights role, String primaryCampus) {
        if (sessions == null || sessions.isEmpty()) {
            return null;
        }
        String initiative = null;
        Session lastActive = null;
        BaseSession currentActive = null;
        Session firstFutureSession = null;
        boolean multipleInitiatives = false;
        Calendar cal = Calendar.getInstance(Localization.getJavaLocale());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Integer shift = ApplicationProperty.SessionDefaultShiftDays.intValue();
        if (shift != null && shift != 0) {
            cal.add(6, shift);
        }
        Date today = cal.getTime();
        for (Session session : sessions) {
            if (session.getStatusType() == null || !session.getStatusType().isActive() || session.getStatusType().isTestSession()) continue;
            if (initiative == null) {
                initiative = session.getAcademicInitiative();
            } else if (!initiative.equals(session.getAcademicInitiative())) {
                if (initiative.equals(primaryCampus)) continue;
                if (session.getAcademicInitiative().equals(primaryCampus)) {
                    initiative = session.getAcademicInitiative();
                    currentActive = null;
                    firstFutureSession = null;
                    lastActive = null;
                } else {
                    multipleInitiatives = true;
                    currentActive = null;
                    firstFutureSession = null;
                    lastActive = null;
                    continue;
                }
            }
            Date begin = session.getEventBeginDate();
            cal.setTime(session.getEventEndDate());
            cal.add(6, 1);
            Date end = cal.getTime();
            if (currentActive == null && !begin.after(today) && today.before(end)) {
                currentActive = session;
            }
            if (currentActive != null && firstFutureSession == null && !currentActive.equals(session)) {
                firstFutureSession = session;
            }
            if (currentActive == null && firstFutureSession == null && today.before(begin)) {
                firstFutureSession = session;
            }
            lastActive = session;
        }
        if (multipleInitiatives && lastActive == null) {
            return null;
        }
        if (role != null && role.hasRight(Right.SessionDefaultFirstFuture)) {
            if (firstFutureSession != null) {
                return firstFutureSession;
            }
            if (currentActive != null) {
                return currentActive;
            }
        }
        if (role != null && role.hasRight(Right.SessionDefaultFirstExamination)) {
            if (currentActive != null && !currentActive.getStatusType().canNoRoleReportExamFinal()) {
                return currentActive;
            }
            if (firstFutureSession != null) {
                return firstFutureSession;
            }
        }
        if (currentActive != null) {
            return currentActive;
        }
        if (firstFutureSession != null) {
            return firstFutureSession;
        }
        if (lastActive != null) {
            return lastActive;
        }
        Session lastNoTest = null;
        for (Session session : sessions) {
            if (session.getStatusType() == null || session.getStatusType().isTestSession()) continue;
            Date begin = session.getEventBeginDate();
            if (!begin.after(today)) {
                return session;
            }
            lastNoTest = session;
        }
        return lastNoTest;
    }

    public static Session defaultSession(TreeSet<Session> sessions, HasRights role) {
        return UniTimeUserContext.defaultSession(sessions, role, null);
    }

    @Override
    public void setCurrentAuthority(UserAuthority authority) {
        super.setCurrentAuthority(authority);
        if (authority.getAcademicSession() != null) {
            this.setProperty(UserProperty.LastAcademicSession, authority.getAcademicSession().getQualifierId().toString());
        }
    }

    @Override
    public String getExternalUserId() {
        return this.iId;
    }

    @Override
    public String getName() {
        return this.iName;
    }

    @Override
    public String getEmail() {
        return this.iEmail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String key, String value) {
        if (value != null && value.isEmpty()) {
            value = null;
        }
        super.setProperty(key, value);
        if (this.getExternalUserId() == null || this.getExternalUserId().isEmpty()) {
            return;
        }
        try (org.hibernate.Session hibSession = UserDataDAO.getInstance().createNewSession();){
            Settings settings = (Settings)hibSession.createQuery("from Settings where key = :key", Settings.class).setParameter("key", (Object)key).setCacheable(true).setMaxResults(1).uniqueResult();
            if (settings != null && this.getCurrentAuthority() != null && !this.getCurrentAuthority().getQualifiers("TimetableManager").isEmpty()) {
                ManagerSettings managerData = (ManagerSettings)hibSession.createQuery("from ManagerSettings where key.key = :key and manager.externalUniqueId = :id", ManagerSettings.class).setParameter("key", (Object)key).setParameter("id", (Object)this.getExternalUserId()).setCacheable(true).setMaxResults(1).uniqueResult();
                if (value == null && managerData == null) {
                    return;
                }
                if (value != null && managerData != null && value.equals(managerData.getValue())) {
                    return;
                }
                if (value == null) {
                    hibSession.remove((Object)managerData);
                } else if (managerData == null) {
                    managerData = new ManagerSettings();
                    managerData.setKey(settings);
                    managerData.setManager((TimetableManager)TimetableManagerDAO.getInstance().get((Long)this.getCurrentAuthority().getQualifiers("TimetableManager").get(0).getQualifierId(), hibSession));
                    managerData.setValue(value);
                    hibSession.persist((Object)managerData);
                } else {
                    managerData.setValue(value);
                    hibSession.merge((Object)managerData);
                }
            } else {
                UserData userData = (UserData)UserDataDAO.getInstance().get(new UserDataId(this.getExternalUserId(), key), hibSession);
                if (userData == null && value == null) {
                    return;
                }
                if (userData != null && value != null && value.equals(userData.getValue())) {
                    return;
                }
                if (value == null) {
                    hibSession.remove((Object)userData);
                } else if (userData == null) {
                    userData = new UserData(this.getExternalUserId(), key);
                    userData.setValue(value);
                    hibSession.persist((Object)userData);
                } else {
                    userData.setValue(value);
                    hibSession.merge((Object)userData);
                }
            }
            hibSession.flush();
        }
    }

    @Override
    public String getPassword() {
        return this.iPassword;
    }

    public String getUsername() {
        return this.iLogin;
    }

    @Override
    public boolean isAccountNonLocked() {
        return !LoginManager.isUserLockedOut(this.getUsername(), new Date());
    }
}

