/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.context;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.authority.OtherAuthority;
import org.unitime.timetable.security.evaluation.PermissionCheck;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.spring.SpringApplicationContextHolder;

public class HttpSessionContext
implements SessionContext {
    @Autowired
    private HttpSession iSession;
    @Autowired
    PermissionCheck unitimePermissionCheck;

    public HttpSessionContext() {
    }

    public HttpSessionContext(HttpSession session) {
        this.iSession = session;
        this.unitimePermissionCheck = (PermissionCheck)SpringApplicationContextHolder.getBean("unitimePermissionCheck");
    }

    @Override
    public Object getAttribute(String name) {
        return this.iSession.getAttribute(name);
    }

    @Override
    public void removeAttribute(String name) {
        this.iSession.removeAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.iSession.setAttribute(name, value);
    }

    @Override
    public void removeAttribute(SessionAttribute attribute) {
        this.removeAttribute(attribute.key());
    }

    @Override
    public void setAttribute(SessionAttribute attribute, Object value) {
        this.setAttribute(attribute.key(), value);
    }

    @Override
    public Object getAttribute(SessionAttribute attribute) {
        Object value = this.getAttribute(attribute.key());
        return value != null ? value : attribute.defaultValue();
    }

    @Override
    public boolean isHttpSessionNew() {
        return this.iSession.isNew();
    }

    @Override
    public UserContext getUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated() && authentication.getPrincipal() instanceof UserContext) {
            return (UserContext)authentication.getPrincipal();
        }
        return null;
    }

    @Override
    public boolean isAuthenticated() {
        return this.getUser() != null;
    }

    @Override
    public String getHttpSessionId() {
        try {
            return this.iSession.getId();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    @Override
    public void checkPermission(Right right) {
        this.unitimePermissionCheck.checkPermission(this.getUser(), null, null, right);
    }

    @Override
    public void checkPermission(Serializable targetId, String targetType, Right right) {
        this.unitimePermissionCheck.checkPermission(this.getUser(), targetId, targetType, right);
    }

    @Override
    public void checkPermission(Object targetObject, Right right) {
        this.unitimePermissionCheck.checkPermission(this.getUser(), targetObject, right);
    }

    @Override
    public boolean hasPermission(Right right) {
        return this.unitimePermissionCheck.hasPermission(this.getUser(), null, null, right);
    }

    @Override
    public boolean hasPermission(Serializable targetId, String targetType, Right right) {
        return this.unitimePermissionCheck.hasPermission(this.getUser(), targetId, targetType, right);
    }

    @Override
    public boolean hasPermission(Object targetObject, Right right) {
        return this.unitimePermissionCheck.hasPermission(this.getUser(), targetObject, right);
    }

    @Override
    public void checkPermissionAnyAuthority(Right right, Qualifiable ... filter) {
        this.unitimePermissionCheck.checkPermissionAnyAuthority(this.getUser(), null, null, right, filter);
    }

    @Override
    public void checkPermissionAnyAuthority(Serializable targetId, String targetType, Right right, Qualifiable ... filter) {
        this.unitimePermissionCheck.checkPermissionAnyAuthority(this.getUser(), targetId, targetType, right, filter);
    }

    @Override
    public void checkPermissionAnyAuthority(Object targetObject, Right right, Qualifiable ... filter) {
        this.unitimePermissionCheck.checkPermissionAnyAuthority(this.getUser(), targetObject, right, filter);
    }

    @Override
    public boolean hasPermissionAnyAuthority(Right right, Qualifiable ... filter) {
        return this.unitimePermissionCheck.hasPermissionAnyAuthority(this.getUser(), null, null, right, filter);
    }

    @Override
    public boolean hasPermissionAnyAuthority(Serializable targetId, String targetType, Right right, Qualifiable ... filter) {
        return this.unitimePermissionCheck.hasPermissionAnyAuthority(this.getUser(), targetId, targetType, right, filter);
    }

    @Override
    public boolean hasPermissionAnyAuthority(Object targetObject, Right right, Qualifiable ... filter) {
        return this.unitimePermissionCheck.hasPermissionAnyAuthority(this.getUser(), targetObject, right, filter);
    }

    @Override
    public void checkPermissionAnySession(Right right, Qualifiable ... filter) {
        this.unitimePermissionCheck.checkPermissionAnySession(this.getUser(), null, null, right, filter);
    }

    @Override
    public void checkPermissionAnySession(Serializable targetId, String targetType, Right right, Qualifiable ... filter) {
        this.unitimePermissionCheck.checkPermissionAnySession(this.getUser(), targetId, targetType, right, filter);
    }

    @Override
    public void checkPermissionAnySession(Object targetObject, Right right, Qualifiable ... filter) {
        this.unitimePermissionCheck.checkPermissionAnySession(this.getUser(), targetObject, right, filter);
    }

    @Override
    public boolean hasPermissionAnySession(Right right, Qualifiable ... filter) {
        return this.unitimePermissionCheck.hasPermissionAnySession(this.getUser(), null, null, right, filter);
    }

    @Override
    public boolean hasPermissionAnySession(Serializable targetId, String targetType, Right right, Qualifiable ... filter) {
        return this.unitimePermissionCheck.hasPermissionAnySession(this.getUser(), targetId, targetType, right, filter);
    }

    @Override
    public boolean hasPermissionAnySession(Object targetObject, Right right, Qualifiable ... filter) {
        return this.unitimePermissionCheck.hasPermissionAnySession(this.getUser(), targetObject, right, filter);
    }

    public static SessionContext getSessionContext(ServletContext context) {
        return (SessionContext)WebApplicationContextUtils.getWebApplicationContext((ServletContext)context).getBean("sessionContext");
    }

    @Override
    public void checkPermissionOtherAuthority(Right right, OtherAuthority other) {
        this.unitimePermissionCheck.checkPermission(this.getUser(), null, null, right, other);
    }

    @Override
    public void checkPermissionOtherAuthority(Serializable targetId, String targetType, Right right, OtherAuthority other) {
        this.unitimePermissionCheck.checkPermission(this.getUser(), targetId, targetType, right, other);
    }

    @Override
    public void checkPermissionOtherAuthority(Object targetObject, Right right, OtherAuthority other) {
        this.unitimePermissionCheck.checkPermission(this.getUser(), targetObject, right, other);
    }

    @Override
    public boolean hasPermissionOtherAuthority(Right right, OtherAuthority other) {
        return this.unitimePermissionCheck.hasPermission(this.getUser(), null, null, right, other);
    }

    @Override
    public boolean hasPermissionOtherAuthority(Serializable targetId, String targetType, Right right, OtherAuthority other) {
        return this.unitimePermissionCheck.hasPermission(this.getUser(), targetId, targetType, right, other);
    }

    @Override
    public boolean hasPermissionOtherAuthority(Object targetObject, Right right, OtherAuthority other) {
        return this.unitimePermissionCheck.hasPermission(this.getUser(), targetObject, right, other);
    }
}

