/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.studentsct;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentComparator;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.constraint.ConfigLimit;
import org.cpsolver.studentsct.constraint.CourseLimit;
import org.cpsolver.studentsct.constraint.HardDistanceConflicts;
import org.cpsolver.studentsct.constraint.SectionLimit;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.StudentGroup;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.report.AbstractStudentSectioningReport;
import org.cpsolver.studentsct.reservation.Reservation;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;

public class UnasignedCourseRequests
extends AbstractStudentSectioningReport {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);

    public UnasignedCourseRequests(StudentSectioningModel model) {
        super(model);
    }

    protected String curriculum(Student student) {
        Object curriculum = "";
        for (AreaClassificationMajor acm : student.getAreaClassificationMajors()) {
            curriculum = (String)curriculum + (((String)curriculum).isEmpty() ? "" : ", ") + acm.toString();
        }
        return curriculum;
    }

    protected String group(Student student) {
        Object group = "";
        for (StudentGroup aac : student.getGroups()) {
            group = (String)group + (((String)group).isEmpty() ? "" : ", ") + aac.getReference();
        }
        return group;
    }

    protected String advisor(Student student) {
        Object advisors = "";
        for (Instructor instructor : student.getAdvisors()) {
            advisors = (String)advisors + (((String)advisors).isEmpty() ? "" : ", ") + instructor.getName();
        }
        return advisors;
    }

    private static int min(int l1, int l2) {
        return l1 < 0 ? l2 : (l2 < 0 ? l1 : Math.min(l1, l2));
    }

    private static int add(int l1, int l2) {
        return l1 < 0 ? -1 : (l2 < 0 ? -1 : l1 + l2);
    }

    public static int getOfferingLimit(Offering offering, boolean skipCancelled, boolean skipDisabled) {
        int offeringLimit = 0;
        for (Config config : offering.getConfigs()) {
            Integer configLimit = null;
            for (Subpart subpart : config.getSubparts()) {
                int subpartLimit = 0;
                for (Section section : subpart.getSections()) {
                    if (skipCancelled && section.isCancelled() || skipDisabled && !section.isEnabled()) continue;
                    subpartLimit = UnasignedCourseRequests.add(subpartLimit, section.getLimit());
                }
                if (configLimit == null) {
                    configLimit = subpartLimit;
                    continue;
                }
                configLimit = UnasignedCourseRequests.min(configLimit, subpartLimit);
            }
            if (configLimit == null) continue;
            offeringLimit = UnasignedCourseRequests.add(offeringLimit, UnasignedCourseRequests.min(configLimit, config.getLimit()));
        }
        return offeringLimit;
    }

    public static double getOfferingEnrollment(Offering offering, Assignment<Request, Enrollment> assignment, boolean skipCancelled, boolean skipDisabled) {
        double enrollment = 0.0;
        for (Config config : offering.getConfigs()) {
            block1: for (Enrollment e : ((Config.ConfigContext)config.getContext(assignment)).getEnrollments()) {
                if (skipCancelled) {
                    for (Section s : e.getSections()) {
                        if (!s.isCancelled()) continue;
                        continue block1;
                    }
                }
                if (skipDisabled) {
                    for (Section s : e.getSections()) {
                        if (s.isEnabled()) continue;
                        continue block1;
                    }
                }
                enrollment += e.getRequest().getWeight();
            }
        }
        return enrollment;
    }

    public static void computeNoAvailableReasons(CourseRequest courseRequest, Assignment<Request, Enrollment> assignment, Set<String> reasons, Set<String> conflicts, Course course, Config config, HashSet<Section> sections, int idx) {
        block50: {
            block48: {
                boolean bl;
                Enrollment e;
                block49: {
                    if (idx == 0) {
                        if (courseRequest.isNotAllowed(course, config)) {
                            reasons.add(MSG.unavailableConfigNotAllowedDueToRestrictions(config.getInstructionalMethodName() != null ? config.getInstructionalMethodName() : config.getName()));
                            return;
                        }
                        boolean canOverLimit = false;
                        for (Reservation r : courseRequest.getReservations(course)) {
                            if (!r.canBatchAssignOverLimit() || r.neverIncluded() || !r.getConfigs().isEmpty() && !r.getConfigs().contains(config) || r.getReservedAvailableSpace(assignment, (Request)courseRequest) < courseRequest.getWeight() || r.getReservedAvailableSpace(assignment, config, (Request)courseRequest) < courseRequest.getWeight()) continue;
                            canOverLimit = true;
                            break;
                        }
                        if (!canOverLimit) {
                            if (config.getLimit() >= 0 && ConfigLimit.getEnrollmentWeight(assignment, (Config)config, (Request)courseRequest) > (double)config.getLimit()) {
                                conflicts.add(MSG.unavailableConfigIsFull(config.getName()));
                                return;
                            }
                            if (config.getOffering().hasReservations()) {
                                boolean hasReservation = false;
                                boolean hasConfigReservation = false;
                                boolean reservationMustBeUsed = false;
                                for (Object r : courseRequest.getReservations(course)) {
                                    if (r.mustBeUsed()) {
                                        reservationMustBeUsed = true;
                                    }
                                    if (r.getReservedAvailableSpace(assignment, (Request)courseRequest) < courseRequest.getWeight() || r.getReservedAvailableSpace(assignment, config, (Request)courseRequest) < courseRequest.getWeight() || r.neverIncluded()) continue;
                                    if (r.getConfigs().isEmpty()) {
                                        hasReservation = true;
                                        continue;
                                    }
                                    if (r.getConfigs().contains(config)) {
                                        hasReservation = true;
                                        hasConfigReservation = true;
                                        continue;
                                    }
                                    if (r.areRestrictionsInclusive()) continue;
                                    hasReservation = true;
                                }
                                if (!hasReservation && reservationMustBeUsed) {
                                    reasons.add(MSG.unavailableMustUseReservationIsFull());
                                    return;
                                }
                                if (!hasReservation && config.getOffering().getUnreservedSpace(assignment, (Request)courseRequest) < courseRequest.getWeight()) {
                                    reasons.add(MSG.unavailableCourseIsReserved(course.getName()));
                                    return;
                                }
                                if (!hasConfigReservation && config.getUnreservedSpace(assignment, (Request)courseRequest) < courseRequest.getWeight()) {
                                    reasons.add(MSG.unavailableConfigIsReserved(config.getName()));
                                    return;
                                }
                            }
                        }
                    }
                    if (config.getSubparts().size() != idx) break block48;
                    e = new Enrollment((Request)courseRequest, 0, course, config, new HashSet<Section>(sections), null);
                    if (!courseRequest.isNotAllowed(e)) break block49;
                    reasons.add(MSG.unavailableNotAllowed());
                    break block50;
                }
                if (!config.getOffering().hasReservations()) break block50;
                boolean mustHaveReservation = config.getOffering().getTotalUnreservedSpace() < courseRequest.getWeight();
                boolean mustHaveConfigReservation = config.getTotalUnreservedSpace() < courseRequest.getWeight();
                boolean mustHaveSectionReservation = false;
                boolean containDisabledSection = false;
                for (Section section : sections) {
                    if (section.getTotalUnreservedSpace() < courseRequest.getWeight()) {
                        mustHaveSectionReservation = true;
                    }
                    if (courseRequest.getStudent().isAllowDisabled() || section.isEnabled(courseRequest.getStudent())) continue;
                    containDisabledSection = true;
                }
                boolean canOverLimit = false;
                for (Object r : courseRequest.getReservations(course)) {
                    if (!r.canBatchAssignOverLimit() || !r.isIncluded(e) || r.getReservedAvailableSpace(assignment, config, (Request)courseRequest) < courseRequest.getWeight() || containDisabledSection && !r.isAllowDisabled()) continue;
                    canOverLimit = true;
                }
                if (canOverLimit) break block50;
                boolean bl2 = false;
                block4: for (Reservation r : courseRequest.getSortedReservations(assignment, course)) {
                    if (r.mustBeUsed()) {
                        bl = true;
                    }
                    if (!r.isIncluded(e) || r.getReservedAvailableSpace(assignment, config, (Request)courseRequest) < courseRequest.getWeight() || mustHaveConfigReservation && r.getConfigs().isEmpty()) continue;
                    if (mustHaveSectionReservation) {
                        for (Section s : sections) {
                            if (r.getSections(s.getSubpart()) != null || !(s.getTotalUnreservedSpace() < courseRequest.getWeight())) continue;
                            continue block4;
                        }
                    }
                    if (containDisabledSection && !r.isAllowDisabled()) continue;
                    return;
                }
                if (!(mustHaveReservation || mustHaveConfigReservation || mustHaveSectionReservation || config.getOffering().getUnreservedSpace(assignment, (Request)courseRequest) < courseRequest.getWeight() || bl || containDisabledSection)) {
                    return;
                }
                reasons.add(MSG.unavailableDueToReservation());
                break block50;
            }
            Subpart subpart = (Subpart)config.getSubparts().get(idx);
            List sectionsThisSubpart = subpart.getSections();
            ArrayList<Section> matchingSectionsThisSubpart = new ArrayList<Section>(subpart.getSections().size());
            for (Section section : sectionsThisSubpart) {
                if (section.getParent() != null && !sections.contains(section.getParent())) continue;
                boolean canOverLimit = false;
                for (Reservation r : courseRequest.getReservations(course)) {
                    if (!r.canBatchAssignOverLimit() || r.getSections(subpart) != null && !r.getSections(subpart).contains(section) || r.getReservedAvailableSpace(assignment, config, (Request)courseRequest) < courseRequest.getWeight()) continue;
                    canOverLimit = true;
                    break;
                }
                if (!canOverLimit) {
                    if (section.getLimit() >= 0 && SectionLimit.getEnrollmentWeight(assignment, (Section)section, (Request)courseRequest) > (double)section.getLimit()) continue;
                    if (section.isCancelled()) {
                        reasons.add(MSG.unavailableSectionCancelled(section.getName(course.getId())));
                        continue;
                    }
                    if (section.isOverlapping(sections)) {
                        for (Section a : sections) {
                            if (a.isAllowOverlap() || a.getTime() == null || section.isToIgnoreStudentConflictsWith(a.getId()) || !section.getTime().hasIntersection(a.getTime())) continue;
                            reasons.add(MSG.unavailableSectionConflict(section.getName(course.getId()), a.getName(course.getId())));
                        }
                        continue;
                    }
                    if (config.getOffering().hasReservations()) {
                        boolean bl;
                        boolean bl3 = false;
                        boolean hasSectionReservation = false;
                        boolean reservationMustBeUsed = false;
                        for (Reservation r : courseRequest.getReservations(course)) {
                            if (r.mustBeUsed()) {
                                reservationMustBeUsed = true;
                            }
                            if (r.getReservedAvailableSpace(assignment, config, (Request)courseRequest) < courseRequest.getWeight()) continue;
                            if (r.getSections(subpart) == null) {
                                bl = true;
                                continue;
                            }
                            if (!r.getSections(subpart).contains(section)) continue;
                            bl = true;
                            hasSectionReservation = true;
                        }
                        if (!hasSectionReservation && section.getUnreservedSpace(assignment, (Request)courseRequest) < courseRequest.getWeight()) {
                            reasons.add(MSG.unavailableSectionReserved(section.getName(course.getId())));
                            continue;
                        }
                        if (!bl && reservationMustBeUsed) {
                            reasons.add(MSG.unavailableDueToMustTakeReservation(section.getName(course.getId())));
                            continue;
                        }
                    }
                } else {
                    if (section.isCancelled()) {
                        reasons.add(MSG.unavailableSectionCancelled(section.getName(course.getId())));
                        continue;
                    }
                    if (section.isOverlapping(sections)) {
                        for (Section a : sections) {
                            if (a.isAllowOverlap() || a.getTime() == null || section.isToIgnoreStudentConflictsWith(a.getId()) || !section.getTime().hasIntersection(a.getTime())) continue;
                            reasons.add(MSG.unavailableSectionConflict(section.getName(course.getId()), a.getName(course.getId())));
                        }
                        continue;
                    }
                }
                if (courseRequest.getInitialAssignment() != null && courseRequest.getModel() != null && ((StudentSectioningModel)courseRequest.getModel()).getKeepInitialAssignments() && !((Enrollment)courseRequest.getInitialAssignment()).getAssignments().contains(section)) {
                    reasons.add(MSG.unavailableNotInitial());
                    continue;
                }
                if (courseRequest.isFixed() && !courseRequest.getFixedValue().getAssignments().contains(section)) {
                    reasons.add(MSG.unavailableNotFixed());
                    continue;
                }
                if (!courseRequest.isRequired(section)) {
                    reasons.add(MSG.unavailableStudentPrefs(section.getName(course.getId())));
                    continue;
                }
                if (courseRequest.isNotAllowed(course, section)) {
                    reasons.add(MSG.unavailableStudentRestrictions(section.getName(course.getId())));
                    continue;
                }
                if (!courseRequest.getStudent().isAvailable(section)) {
                    boolean bl;
                    boolean bl4 = false;
                    for (Reservation r : courseRequest.getReservations(course)) {
                        if (!r.isAllowOverlap() || r.getSections(subpart) != null && !r.getSections(subpart).contains(section) || r.getReservedAvailableSpace(assignment, config, (Request)courseRequest) < courseRequest.getWeight()) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        reasons.add(MSG.unavailableStudentUnavailabilities(section.getName(course.getId())));
                        continue;
                    }
                }
                if (!courseRequest.getStudent().isAllowDisabled() && !section.isEnabled(courseRequest.getStudent())) {
                    boolean bl;
                    boolean bl5 = false;
                    for (Reservation r : courseRequest.getReservations(course)) {
                        if (!r.isAllowDisabled() || r.getSections(subpart) != null && !r.getSections(subpart).contains(section) || !r.getConfigs().isEmpty() && !r.getConfigs().contains(config)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        reasons.add(MSG.unavailableSectionDisabled(section.getName(course.getId())));
                        continue;
                    }
                }
                matchingSectionsThisSubpart.add(section);
            }
            for (Section section : matchingSectionsThisSubpart) {
                sections.add(section);
                UnasignedCourseRequests.computeNoAvailableReasons(courseRequest, assignment, reasons, conflicts, course, config, sections, idx + 1);
                sections.remove(section);
            }
        }
    }

    public static String getNoAvailableMessage(CourseRequest courseRequest, Assignment<Request, Enrollment> assignment) {
        return UnasignedCourseRequests.getNoAvailableMessage(courseRequest, assignment, true);
    }

    public static String getNoAvailableMessage(CourseRequest courseRequest, Assignment<Request, Enrollment> assignment, boolean detailed) {
        Object ret;
        Course course = (Course)courseRequest.getCourses().get(0);
        Offering offering = course.getOffering();
        int limit = UnasignedCourseRequests.getOfferingLimit(offering, false, false);
        double enrollment = UnasignedCourseRequests.getOfferingEnrollment(offering, assignment, false, false);
        if (detailed && limit >= 0 && (double)limit < courseRequest.getWeight() + enrollment) {
            return MSG.unavailableCourseIsFull(course.getName());
        }
        if (detailed && course.getLimit() >= 0 && CourseLimit.getEnrollmentWeight(assignment, (Course)course, (Request)courseRequest) > (double)course.getLimit()) {
            return MSG.unavailableCourseIsFull(course.getName());
        }
        boolean reservationMustBeUsed = false;
        boolean hasReservation = false;
        for (Object r : courseRequest.getSortedReservations(assignment, course)) {
            if (r.mustBeUsed()) {
                reservationMustBeUsed = true;
            }
            if (r.getReservedAvailableSpace(assignment, (Request)courseRequest) < courseRequest.getWeight()) continue;
            hasReservation = true;
        }
        if (detailed && reservationMustBeUsed && !hasReservation) {
            return MSG.unavailableMustTakeReservationIsFull();
        }
        if (course.hasParent()) {
            Course parent = course.getParent();
            for (Request r : courseRequest.getStudent().getRequests()) {
                Enrollment e;
                if (!r.hasCourse(parent) || (e = (Enrollment)assignment.getValue((Variable)r)) != null && e.getCourse() != null && parent.equals((Object)e.getCourse())) continue;
                return MSG.notAssignedParentCourse(parent.getName());
            }
        }
        if (!detailed) {
            return null;
        }
        TreeSet<String> reasons = new TreeSet<String>();
        TreeSet<String> conflicts = new TreeSet<String>();
        for (Config config : offering.getConfigs()) {
            UnasignedCourseRequests.computeNoAvailableReasons(courseRequest, assignment, reasons, conflicts, course, config, new HashSet<Section>(), 0);
        }
        if (!reasons.isEmpty()) {
            ret = "";
            int count = 0;
            for (String reason : reasons) {
                if (count == 10) {
                    return (String)ret + "\n...";
                }
                ret = (String)ret + (((String)ret).isEmpty() ? "" : "\n") + reason;
                ++count;
            }
            return ret;
        }
        if (!conflicts.isEmpty()) {
            ret = "";
            int count = 0;
            for (String conflict : conflicts) {
                if (count == 10) {
                    return (String)ret + "\n...";
                }
                ret = (String)ret + (((String)ret).isEmpty() ? "" : "\n") + conflict;
                ++count;
            }
            return ret;
        }
        return null;
    }

    public CSVFile createTable(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        HashSet<String> types = new HashSet<String>();
        for (String type : properties.getProperty("type", "").split("\\,")) {
            if (type.isEmpty()) continue;
            types.add(type);
        }
        boolean skipFull = properties.getPropertyBoolean("skipFull", false);
        CSVFile csv = new CSVFile();
        if (types.size() != 1) {
            csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Student"), new CSVFile.CSVField((Object)MSG.reportStudentId()), new CSVFile.CSVField((Object)MSG.reportStudentName()), new CSVFile.CSVField((Object)MSG.reportStudentEmail()), new CSVFile.CSVField((Object)MSG.reportStudentPriority()), new CSVFile.CSVField((Object)MSG.reportStudentCurriculum()), new CSVFile.CSVField((Object)MSG.reportStudentGroup()), new CSVFile.CSVField((Object)MSG.reportStudentAdvisor()), new CSVFile.CSVField((Object)MSG.reportUnassignedCourse()), new CSVFile.CSVField((Object)MSG.reportCourseRequestPriority()), new CSVFile.CSVField((Object)MSG.reportAssignmentConflict()), new CSVFile.CSVField((Object)MSG.reportConflictingCourseRequestPriority())});
        } else {
            csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Student"), new CSVFile.CSVField((Object)MSG.reportStudentId()), new CSVFile.CSVField((Object)MSG.reportStudentName()), new CSVFile.CSVField((Object)MSG.reportStudentEmail()), new CSVFile.CSVField((Object)MSG.reportStudentPriority()), new CSVFile.CSVField((Object)MSG.reportStudentCurriculum()), new CSVFile.CSVField((Object)MSG.reportStudentGroup()), new CSVFile.CSVField((Object)MSG.reportStudentAdvisor()), new CSVFile.CSVField((Object)MSG.reportUnassignedCourse()), new CSVFile.CSVField((Object)MSG.reportAssignmentConflict()), new CSVFile.CSVField((Object)MSG.reportConflictingCourseRequestPriority())});
        }
        for (Student student : this.getModel().getStudents()) {
            for (Request request : student.getRequests()) {
                Enrollment enrollment;
                if (request instanceof FreeTimeRequest || (enrollment = (Enrollment)assignment.getValue((Variable)request)) != null || !student.canAssign(assignment, request) || !this.matches(request, enrollment)) continue;
                CourseRequest courseRequest = (CourseRequest)request;
                if (!types.isEmpty() && (courseRequest.getRequestPriority() == null || !types.contains(courseRequest.getRequestPriority().name()))) continue;
                ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                line.add(new CSVFile.CSVField(student.getId()));
                line.add(new CSVFile.CSVField((Object)student.getExternalId()));
                line.add(new CSVFile.CSVField((Object)student.getName()));
                org.unitime.timetable.model.Student dbStudent = (org.unitime.timetable.model.Student)StudentDAO.getInstance().get(student.getId());
                if (dbStudent != null) {
                    line.add(new CSVFile.CSVField((Object)dbStudent.getEmail()));
                } else {
                    line.add(new CSVFile.CSVField((Object)""));
                }
                line.add(new CSVFile.CSVField((Object)(student.getPriority() == null ? "" : student.getPriority().name())));
                line.add(new CSVFile.CSVField((Object)this.curriculum(student)));
                line.add(new CSVFile.CSVField((Object)this.group(student)));
                line.add(new CSVFile.CSVField((Object)this.advisor(student)));
                line.add(new CSVFile.CSVField((Object)((Course)courseRequest.getCourses().get(0)).getName()));
                if (types.size() != 1) {
                    line.add(new CSVFile.CSVField((Object)(courseRequest.getRequestPriority() == null ? "" : courseRequest.getRequestPriority().name())));
                }
                TreeSet<Enrollment> overlaps = new TreeSet<Enrollment>(new Comparator<Enrollment>(){

                    @Override
                    public int compare(Enrollment o1, Enrollment o2) {
                        return o1.getRequest().compareTo(o2.getRequest());
                    }
                });
                TreeSet<Object> other = new TreeSet<Object>();
                Hashtable<CourseRequest, TreeSet<Section>> overlapingSections = new Hashtable<CourseRequest, TreeSet<Section>>();
                List av = courseRequest.getAvaiableEnrollmentsSkipSameTime(assignment);
                Request.RequestPriority conflictPriority = null;
                if (av.isEmpty() || av.size() == 1 && ((Enrollment)av.get(0)).equals((Object)courseRequest.getInitialAssignment()) && this.getModel().inConflict(assignment, (Value)((Enrollment)av.get(0)))) {
                    if (skipFull) continue;
                    String message = UnasignedCourseRequests.getNoAvailableMessage(courseRequest, assignment);
                    if (message == null) {
                        message = MSG.classNotAvailable();
                    }
                    line.add(new CSVFile.CSVField((Object)message));
                } else {
                    for (Object enrl : av) {
                        for (Request q : enrl.getStudent().getRequests()) {
                            if (q.equals((Object)request)) continue;
                            Object x = (Enrollment)assignment.getValue((Variable)q);
                            if (x == null && q instanceof FreeTimeRequest && q.getPriority() < request.getPriority()) {
                                x = ((FreeTimeRequest)q).createEnrollment();
                            }
                            if (x == null || x.getAssignments() == null || x.getAssignments().isEmpty()) continue;
                            for (SctAssignment a : x.getAssignments()) {
                                if (!a.isOverlapping(enrl.getAssignments()) && !HardDistanceConflicts.inConflict((StudentQuality)this.getModel().getStudentQuality(), (SctAssignment)a, (Enrollment)enrl)) continue;
                                overlaps.add((Enrollment)x);
                                if (!(x.getRequest() instanceof CourseRequest)) continue;
                                CourseRequest cr = (CourseRequest)x.getRequest();
                                TreeSet<Section> ss = (TreeSet<Section>)overlapingSections.get(cr);
                                if (ss == null) {
                                    ss = new TreeSet<Section>((Comparator<Section>)new AssignmentComparator(assignment));
                                    overlapingSections.put(cr, ss);
                                }
                                ss.add((Section)a);
                            }
                        }
                        block6: for (Unavailability unavailability : student.getUnavailabilities()) {
                            for (SctAssignment section : enrl.getAssignments()) {
                                if (!HardDistanceConflicts.inConflict((StudentQuality)this.getModel().getStudentQuality(), (Section)((Section)section), (Unavailability)unavailability)) continue;
                                other.add(unavailability.getCourseName() + " " + unavailability.getSectionName());
                                continue block6;
                            }
                        }
                    }
                    block8: for (Unavailability unavailability : student.getUnavailabilities()) {
                        for (Object course : courseRequest.getCourses()) {
                            for (Config config : course.getOffering().getConfigs()) {
                                SctAssignment a;
                                a = config.getSubparts().iterator();
                                while (a.hasNext()) {
                                    Subpart subpart = (Subpart)a.next();
                                    for (Section section : subpart.getSections()) {
                                        if (section.getLimit() <= 0 || !unavailability.isOverlapping((SctAssignment)section)) continue;
                                        other.add(unavailability.getCourseName() + " " + unavailability.getSectionName());
                                        continue block8;
                                    }
                                }
                            }
                        }
                    }
                    if (overlaps.isEmpty() && other.isEmpty()) {
                        for (Object enrl : av) {
                            Object course;
                            HashSet conflicts = new HashSet();
                            for (Constraint constraint : ((Request)enrl.variable()).hardConstraints()) {
                                if (constraint.inConflict(assignment, (Value)enrl)) {
                                    other.add(constraint.getName());
                                    continue;
                                }
                                constraint.computeConflicts(assignment, (Value)enrl, conflicts);
                                if (conflicts.isEmpty()) continue;
                                other.add(constraint.getClass().getSimpleName().replaceAll("(?<=[^A-Z])([A-Z])", " $1"));
                                conflicts.clear();
                            }
                            course = this.getModel().globalConstraints().iterator();
                            while (course.hasNext()) {
                                Constraint constraint;
                                constraint = (GlobalConstraint)course.next();
                                if (constraint.inConflict(assignment, (Value)enrl)) {
                                    other.add(constraint.getName());
                                    continue;
                                }
                                constraint.computeConflicts(assignment, (Value)enrl, conflicts);
                                if (conflicts.isEmpty()) continue;
                                other.add(constraint.getClass().getSimpleName().replaceAll("(?<=[^A-Z])([A-Z])", " $1"));
                                conflicts.clear();
                            }
                        }
                    }
                    if (!overlaps.isEmpty() || !other.isEmpty()) {
                        Object enrl;
                        TreeSet<String> ts = new TreeSet<String>((SortedSet<String>)other);
                        enrl = overlaps.iterator();
                        while (enrl.hasNext()) {
                            Enrollment q = (Enrollment)enrl.next();
                            if (q.getRequest() instanceof FreeTimeRequest) {
                                ts.add(OnlineSectioningHelper.toString((FreeTimeRequest)q.getRequest()));
                            } else {
                                CourseRequest cr = (CourseRequest)q.getRequest();
                                Course o = q.getCourse();
                                Object ov = MSG.course(o.getSubjectArea(), o.getCourseNumber());
                                if (((TreeSet)overlapingSections.get(cr)).size() == 1) {
                                    Iterator i = ((TreeSet)overlapingSections.get(cr)).iterator();
                                    while (i.hasNext()) {
                                        Section s = (Section)i.next();
                                        ov = (String)ov + " " + s.getSubpart().getName();
                                        if (!i.hasNext()) continue;
                                        ov = (String)ov + ",";
                                    }
                                }
                                ts.add((String)ov);
                            }
                            if (q.getRequest().getRequestPriority() == null || conflictPriority != null && conflictPriority.ordinal() <= q.getRequest().getRequestPriority().ordinal()) continue;
                            conflictPriority = q.getRequest().getRequestPriority();
                        }
                        Object message = "";
                        Iterator i = ts.iterator();
                        while (i.hasNext()) {
                            String x = (String)i.next();
                            if (((String)message).isEmpty()) {
                                message = (String)message + MSG.conflictWithFirst(x);
                                continue;
                            }
                            if (!i.hasNext()) {
                                message = (String)message + MSG.conflictWithLast(x);
                                continue;
                            }
                            message = (String)message + MSG.conflictWithMiddle(x);
                        }
                        line.add(new CSVFile.CSVField(message));
                    } else {
                        if (skipFull) continue;
                        line.add(new CSVFile.CSVField((Object)MSG.courseNotAssigned()));
                    }
                }
                line.add(new CSVFile.CSVField((Object)(conflictPriority == null ? "" : conflictPriority.name())));
                csv.addLine(line);
            }
        }
        return csv;
    }
}

