/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.studentsct;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.StudentGroup;
import org.cpsolver.studentsct.report.AbstractStudentSectioningReport;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.util.Constants;

public class IndividualStudentTimeOverlaps
extends AbstractStudentSectioningReport {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static DecimalFormat sDF1 = new DecimalFormat("0.####");

    public IndividualStudentTimeOverlaps(StudentSectioningModel model) {
        super(model);
    }

    public boolean shareHoursIgnoreBreakTime(TimeLocation t1, TimeLocation t2) {
        int s1 = t1.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        int e1 = (t1.getStartSlot() + t1.getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - t1.getBreakTime();
        int s2 = t2.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        int e2 = (t2.getStartSlot() + t2.getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - t2.getBreakTime();
        return e1 > s2 && e2 > s1;
    }

    public boolean inConflict(SctAssignment a1, SctAssignment a2, boolean ignoreBreakTimeConflicts) {
        if (a1.getTime() == null || a2.getTime() == null) {
            return false;
        }
        if (ignoreBreakTimeConflicts) {
            TimeLocation t2;
            TimeLocation t1 = a1.getTime();
            return t1.shareDays(t2 = a2.getTime()) && this.shareHoursIgnoreBreakTime(t1, t2) && t1.shareWeeks(t2);
        }
        return a1.getTime().hasIntersection(a2.getTime());
    }

    public int nrSharedHoursIgnoreBreakTime(TimeLocation t1, TimeLocation t2) {
        int start;
        int s1 = t1.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        int e1 = (t1.getStartSlot() + t1.getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - t1.getBreakTime();
        int s2 = t2.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        int e2 = (t2.getStartSlot() + t2.getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - t2.getBreakTime();
        int end = Math.min(e1, e2);
        return end < (start = Math.max(s1, s2)) ? 0 : end - start;
    }

    public int share(SctAssignment a1, SctAssignment a2, boolean ignoreBreakTimeConflicts) {
        if (!this.inConflict(a1, a2, ignoreBreakTimeConflicts)) {
            return 0;
        }
        if (ignoreBreakTimeConflicts) {
            return a1.getTime().nrSharedDays(a2.getTime()) * this.nrSharedHoursIgnoreBreakTime(a1.getTime(), a2.getTime());
        }
        return 5 * a1.getTime().nrSharedDays(a2.getTime()) * a1.getTime().nrSharedHours(a2.getTime());
    }

    public int nrSharedDays(TimeLocation t1, TimeLocation t2, int dayOfWeekOffset) {
        if (t1 == null || t2 == null) {
            return 0;
        }
        int count = 0;
        int idx = -1;
        while ((idx = t1.getWeekCode().nextSetBit(1 + idx)) >= 0) {
            int dow = (idx + dayOfWeekOffset) % 7;
            if ((t1.getDayCode() & Constants.DAY_CODES[dow]) == 0 || !t2.getWeekCode().get(idx) || (t2.getDayCode() & Constants.DAY_CODES[dow]) == 0) continue;
            ++count;
        }
        return count;
    }

    protected String curriculum(Student student) {
        Object curriculum = "";
        for (AreaClassificationMajor acm : student.getAreaClassificationMajors()) {
            curriculum = (String)curriculum + (((String)curriculum).isEmpty() ? "" : ", ") + acm.toString();
        }
        return curriculum;
    }

    protected String group(Student student) {
        Object group = "";
        for (StudentGroup aac : student.getGroups()) {
            group = (String)group + (((String)group).isEmpty() ? "" : ", ") + aac.getReference();
        }
        return group;
    }

    protected String advisor(Student student) {
        Object advisors = "";
        for (Instructor instructor : student.getAdvisors()) {
            advisors = (String)advisors + (((String)advisors).isEmpty() ? "" : ", ") + instructor.getName();
        }
        return advisors;
    }

    public CSVFile createTable(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        boolean includeAllowedOverlaps = properties.getPropertyBoolean("includeAllowedOverlaps", true);
        boolean ignoreBreakTimeConflicts = properties.getPropertyBoolean("ignoreBreakTimeConflicts", false);
        int dayOfWeekOffset = properties.getPropertyInt("DatePattern.DayOfWeekOffset", 0);
        CSVFile csv = new CSVFile();
        if (includeAllowedOverlaps) {
            csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Student"), new CSVFile.CSVField((Object)MSG.reportStudentId()), new CSVFile.CSVField((Object)MSG.reportStudentName()), new CSVFile.CSVField((Object)MSG.reportStudentEmail()), new CSVFile.CSVField((Object)MSG.reportStudentPriority()), new CSVFile.CSVField((Object)MSG.reportStudentCurriculum()), new CSVFile.CSVField((Object)MSG.reportStudentGroup()), new CSVFile.CSVField((Object)MSG.reportStudentAdvisor()), new CSVFile.CSVField((Object)MSG.reportAllowedOverlap()), new CSVFile.CSVField((Object)MSG.reportCourse()), new CSVFile.CSVField((Object)MSG.reportClass()), new CSVFile.CSVField((Object)MSG.reportMeetingTime()), new CSVFile.CSVField((Object)MSG.reportDatePattern()), new CSVFile.CSVField((Object)MSG.reportSubpartOverlap()), new CSVFile.CSVField((Object)MSG.reportTimeOverride()), new CSVFile.CSVField((Object)MSG.reportConflictingCourse()), new CSVFile.CSVField((Object)MSG.reportConflictingClass()), new CSVFile.CSVField((Object)MSG.reportConflictingMeetingTime()), new CSVFile.CSVField((Object)MSG.reportConflictingDatePattern()), new CSVFile.CSVField((Object)MSG.reportSubpartOverlap()), new CSVFile.CSVField((Object)MSG.reportTimeOverride()), new CSVFile.CSVField((Object)MSG.reportIgnoreConflicts()), new CSVFile.CSVField((Object)MSG.reportOverlapMinutes()), new CSVFile.CSVField((Object)MSG.reportOverlappingMeetings())});
        } else {
            csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Student"), new CSVFile.CSVField((Object)MSG.reportStudentId()), new CSVFile.CSVField((Object)MSG.reportStudentName()), new CSVFile.CSVField((Object)MSG.reportStudentEmail()), new CSVFile.CSVField((Object)MSG.reportStudentPriority()), new CSVFile.CSVField((Object)MSG.reportStudentCurriculum()), new CSVFile.CSVField((Object)MSG.reportStudentGroup()), new CSVFile.CSVField((Object)MSG.reportStudentAdvisor()), new CSVFile.CSVField((Object)MSG.reportCourse()), new CSVFile.CSVField((Object)MSG.reportClass()), new CSVFile.CSVField((Object)MSG.reportMeetingTime()), new CSVFile.CSVField((Object)MSG.reportDatePattern()), new CSVFile.CSVField((Object)MSG.reportConflictingCourse()), new CSVFile.CSVField((Object)MSG.reportConflictingClass()), new CSVFile.CSVField((Object)MSG.reportConflictingMeetingTime()), new CSVFile.CSVField((Object)MSG.reportConflictingDatePattern()), new CSVFile.CSVField((Object)MSG.reportOverlapMinutes()), new CSVFile.CSVField((Object)MSG.reportOverlappingMeetings())});
        }
        TreeSet<Student> students = new TreeSet<Student>(new Comparator<Student>(){

            @Override
            public int compare(Student s1, Student s2) {
                return s1.getExternalId().compareTo(s2.getExternalId());
            }
        });
        students.addAll(this.getModel().getStudents());
        for (Student student : students) {
            for (int i = 0; i < student.getRequests().size() - 1; ++i) {
                Enrollment e1;
                Request r1 = (Request)student.getRequests().get(i);
                if (!this.matches(r1, e1 = (Enrollment)assignment.getValue((Variable)r1)) || e1 == null || r1 instanceof FreeTimeRequest) continue;
                for (int j = i + 1; j < student.getRequests().size(); ++j) {
                    Request r2 = (Request)student.getRequests().get(j);
                    Enrollment e2 = (Enrollment)assignment.getValue((Variable)r2);
                    if (e2 == null || r2 instanceof FreeTimeRequest) continue;
                    for (Section s1 : e1.getSections()) {
                        for (Section s2 : e2.getSections()) {
                            if (!this.inConflict((SctAssignment)s1, (SctAssignment)s2, ignoreBreakTimeConflicts) || !includeAllowedOverlaps && (e1.isAllowOverlap() || e2.isAllowOverlap() || !s1.isOverlapping((SctAssignment)s2))) continue;
                            ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                            line.add(new CSVFile.CSVField(student.getId()));
                            line.add(new CSVFile.CSVField((Object)student.getExternalId()));
                            line.add(new CSVFile.CSVField((Object)student.getName()));
                            org.unitime.timetable.model.Student s = (org.unitime.timetable.model.Student)StudentDAO.getInstance().get(student.getId());
                            if (s != null) {
                                line.add(new CSVFile.CSVField((Object)s.getEmail()));
                            } else {
                                line.add(new CSVFile.CSVField((Object)""));
                            }
                            line.add(new CSVFile.CSVField((Object)(student.getPriority() == null ? "" : student.getPriority().name())));
                            line.add(new CSVFile.CSVField((Object)this.curriculum(student)));
                            line.add(new CSVFile.CSVField((Object)this.group(student)));
                            line.add(new CSVFile.CSVField((Object)this.advisor(student)));
                            if (includeAllowedOverlaps) {
                                line.add(new CSVFile.CSVField(e1.isAllowOverlap() || e2.isAllowOverlap() || !s1.isOverlapping((SctAssignment)s2)));
                            }
                            line.add(new CSVFile.CSVField((Object)e1.getCourse().getName()));
                            line.add(new CSVFile.CSVField((Object)(s1.getSubpart().getName() + " " + s1.getName(e1.getCourse().getId()))));
                            line.add(new CSVFile.CSVField(s1.getTime() == null ? "" : s1.getTime().getDayHeader() + " " + s1.getTime().getStartTimeHeader(this.isUseAmPm()) + " - " + s1.getTime().getEndTimeHeader(this.isUseAmPm())));
                            line.add(new CSVFile.CSVField((Object)(s1.getTime() == null ? "" : s1.getTime().getDatePatternName())));
                            if (includeAllowedOverlaps) {
                                line.add(new CSVFile.CSVField(s1.getSubpart().isAllowOverlap()));
                                line.add(new CSVFile.CSVField(e1.getReservation() != null && e1.getReservation().isAllowOverlap()));
                            }
                            line.add(new CSVFile.CSVField((Object)e2.getCourse().getName()));
                            line.add(new CSVFile.CSVField((Object)(s2.getSubpart().getName() + " " + s2.getName(e2.getCourse().getId()))));
                            line.add(new CSVFile.CSVField(s2.getTime() == null ? "" : s2.getTime().getDayHeader() + " " + s2.getTime().getStartTimeHeader(this.isUseAmPm()) + " - " + s2.getTime().getEndTimeHeader(this.isUseAmPm())));
                            line.add(new CSVFile.CSVField((Object)(s2.getTime() == null ? "" : s2.getTime().getDatePatternName())));
                            if (includeAllowedOverlaps) {
                                line.add(new CSVFile.CSVField(s2.getSubpart().isAllowOverlap()));
                                line.add(new CSVFile.CSVField(e2.getReservation() != null && e2.getReservation().isAllowOverlap()));
                            }
                            if (includeAllowedOverlaps) {
                                line.add(new CSVFile.CSVField(s1.isToIgnoreStudentConflictsWith(s2.getId())));
                            }
                            line.add(new CSVFile.CSVField((Object)sDF1.format(this.share((SctAssignment)s1, (SctAssignment)s2, ignoreBreakTimeConflicts))));
                            line.add(new CSVFile.CSVField(this.nrSharedDays(s1.getTime(), s2.getTime(), dayOfWeekOffset)));
                            csv.addLine(line);
                        }
                    }
                }
            }
        }
        return csv;
    }
}

