/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.pointintimedata;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.TreeSet;
import org.hibernate.Session;
import org.unitime.timetable.model.PitClass;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.reports.pointintimedata.WSCHByDayOfWeekAndHourOfDay;

public class WSCHBySubjectAreaDayOfWeekHourOfDay
extends WSCHByDayOfWeekAndHourOfDay {
    TreeSet<SubjectArea> subjects = new TreeSet();

    @Override
    public String reportName() {
        return MSG.wseBySubjectAreaDayOfWeekAndHourOfDayReport();
    }

    @Override
    public String reportDescription() {
        return MSG.wseBySubjectAreaDayOfWeekAndHourOfDayReportNote();
    }

    @Override
    protected void intializeHeader() {
        ArrayList<String> hdr = new ArrayList<String>();
        hdr.add(MSG.columnSubjectArea());
        hdr.add(MSG.columnDayOfWeek());
        this.addTimeColumns(hdr);
        this.setHeader(hdr);
    }

    @Override
    public void createRoomUtilizationReportFor(PointInTimeData pointInTimeData, Session hibSession) {
        this.calculatePeriodsWithEnrollments(pointInTimeData, hibSession);
        int minute = this.startOnHalfHour ? 30 : 0;
        for (SubjectArea subjectArea : this.subjects) {
            for (int dayOfWeek = 1; dayOfWeek < 8; ++dayOfWeek) {
                ArrayList<String> row = new ArrayList<String>();
                row.add(subjectArea.getSubjectAreaAbbreviation());
                row.add(this.getDayOfWeekLabel(this.periodDayOfWeek(dayOfWeek)));
                for (int hourOfDay = 0; hourOfDay < 24; ++hourOfDay) {
                    String key = this.getPeriodTag(subjectArea.getUniqueId().toString(), dayOfWeek, hourOfDay, minute);
                    row.add((String)(this.periodEnrollmentMap.get(key) == null ? "0" : "" + ((WSCHByDayOfWeekAndHourOfDay.PeriodEnrollment)this.periodEnrollmentMap.get(key)).getWeeklyStudentEnrollment()));
                }
                this.addDataRow(row);
            }
        }
    }

    private void calculatePeriodsWithEnrollments(PointInTimeData pointInTimeData, Session hibSession) {
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct pc").append("\tfrom PitClass pc").append(" inner join pc.pitClassEvents as pce").append(" inner join pce.pitClassMeetings as pcm").append(" inner join pcm.pitClassMeetingUtilPeriods as pcmup").append("\tinner join pc.pitSchedulingSubpart.pitInstrOfferingConfig.pitInstructionalOffering.pitCourseOfferings as pco").append("\twhere pc.pitSchedulingSubpart.pitInstrOfferingConfig.pitInstructionalOffering.pointInTimeData.uniqueId = :sessId").append(" and pco.subjectArea.uniqueId = :saId").append("\tand pco.isControl = true").append(" and  pc.pitSchedulingSubpart.itype.organized = true");
        HashSet<Long> processedClasses = new HashSet<Long>();
        for (SubjectArea subjectArea : pointInTimeData.getSession().getSubjectAreas()) {
            for (PitClass pc : hibSession.createQuery(sb.toString(), PitClass.class).setParameter("sessId", (Object)pointInTimeData.getUniqueId()).setParameter("saId", (Object)subjectArea.getUniqueId()).setCacheable(true).list()) {
                if (processedClasses.contains(pc.getUniqueId())) continue;
                processedClasses.add(pc.getUniqueId());
                this.subjects.add(subjectArea);
                for (Date meetingPeriod : pc.getUniquePeriods()) {
                    String label = this.getPeriodTag(subjectArea.getUniqueId().toString(), meetingPeriod);
                    WSCHByDayOfWeekAndHourOfDay.PeriodEnrollment pe = (WSCHByDayOfWeekAndHourOfDay.PeriodEnrollment)this.periodEnrollmentMap.get(label);
                    if (pe == null) {
                        pe = new WSCHByDayOfWeekAndHourOfDay.PeriodEnrollment(label, this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
                        this.periodEnrollmentMap.put(label, pe);
                    }
                    pe.addEnrollment(pc.getEnrollment());
                }
            }
        }
    }
}

