/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.exam;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseExamPeriod;
import org.unitime.timetable.reports.AbstractReport;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;

public class ScheduleByRoomReport
extends PdfLegacyExamReport {
    protected static Log sLog = LogFactory.getLog(ScheduleByRoomReport.class);

    public ScheduleByRoomReport(int mode, File file, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, file, MSG.legacyReportScheduleByRoom(), session, examType, subjectAreas, exams);
    }

    @Override
    public void printReport() throws DocumentException {
        Hashtable roomAssignments;
        sLog.info((Object)MSG.statusComputingRoomTable());
        Hashtable<ExamRoomInfo, Hashtable> table = new Hashtable<ExamRoomInfo, Hashtable>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            if (exam.getPeriod() == null || !this.hasSubjectArea(exam)) continue;
            for (ExamRoomInfo room : exam.getRooms()) {
                ArrayList<ExamAssignmentInfo> exams;
                roomAssignments = (Hashtable)table.get(room);
                if (roomAssignments == null) {
                    roomAssignments = new Hashtable();
                    table.put(room, roomAssignments);
                }
                if ((exams = (ArrayList<ExamAssignmentInfo>)roomAssignments.get(exam.getPeriod())) == null) {
                    exams = new ArrayList<ExamAssignmentInfo>();
                    roomAssignments.put(exam.getPeriod(), exams);
                }
                exams.add(exam);
            }
        }
        TreeSet<ExamRoomInfo> rooms = new TreeSet<ExamRoomInfo>(new Comparator<ExamRoomInfo>(){

            @Override
            public int compare(ExamRoomInfo r1, ExamRoomInfo r2) {
                int cmp = r1.getName().compareTo(r2.getName());
                if (cmp != 0) {
                    return cmp;
                }
                return r1.getLocationId().compareTo(r2.getLocationId());
            }
        });
        rooms.addAll(table.keySet());
        Vector<ExamPeriod> periods = new Vector<ExamPeriod>(ExamPeriod.findAll(this.getSession().getUniqueId(), this.getExamType()));
        sLog.info((Object)MSG.statusPrintingReport());
        this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrBldg(), 5).withColSpan(0), this.rpad(MSG.lrRoom(), 5), this.lpad(MSG.lrCapacity(), 8), this.lpad(MSG.lrExCap(), 6), this.lpad(MSG.lrPeriod(), 6), this.rpad(MSG.lrDateAndTime(), 38), this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 10), this.lpad(MSG.lrEnrl(), 5)), new AbstractReport.Line(this.lpad("", '-', 5).withColSpan(0), this.lpad("", '-', 5), this.lpad("", '-', 8), this.lpad("", '-', 6), this.lpad("", '-', 6), this.lpad("", '-', 38), this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 10), this.lpad("", '-', 5)));
        this.printHeader();
        Iterator<ExamRoomInfo> i = rooms.iterator();
        while (i.hasNext()) {
            ExamRoomInfo room;
            room = i.next();
            this.iPeriodPrinted = false;
            this.setPageName(room.getName());
            this.setCont(room.getName());
            roomAssignments = (Hashtable)table.get(room);
            BaseExamPeriod lastPeriod = null;
            boolean somethingPrinted = false;
            for (ExamPeriod period : periods) {
                this.iStudentPrinted = false;
                List exams = (List)roomAssignments.get(period);
                if (exams == null) continue;
                for (ExamAssignmentInfo exam : exams) {
                    ExamInfo.ExamSectionInfo lastSection = null;
                    this.iITypePrinted = false;
                    this.iCoursePrinted = false;
                    this.iSubjectPrinted = false;
                    for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                        if (!this.hasSubjectArea(section)) continue;
                        if (lastSection != null && this.iSubjectPrinted) {
                            this.iITypePrinted = false;
                            this.iCoursePrinted = false;
                            this.iSubjectPrinted = false;
                            if (section.getSubject().equals(lastSection.getSubject())) {
                                this.iSubjectPrinted = true;
                                if (section.getCourseNbr().equals(lastSection.getCourseNbr())) {
                                    this.iCoursePrinted = true;
                                    if (section.getItype().equals(lastSection.getItype())) {
                                        this.iITypePrinted = true;
                                    }
                                }
                            }
                        }
                        if (lastPeriod != null && !lastPeriod.getDateOffset().equals(period.getDateOffset()) && !this.iNewPage) {
                            this.println(new AbstractReport.Line());
                        }
                        lastPeriod = period;
                        this.println(this.iPeriodPrinted && this.isSkipRepeating() ? this.rpad("", 11) : this.formatRoom(room), this.lpad(this.iPeriodPrinted && this.isSkipRepeating() ? "" : String.valueOf(room.getCapacity()), 8), this.lpad(this.iPeriodPrinted && this.isSkipRepeating() ? "" : String.valueOf(room.getExamCapacity()), 6), this.lpad(this.iStudentPrinted && this.isSkipRepeating() ? "" : String.valueOf(periods.indexOf(period) + 1), 6), this.rpad(this.iStudentPrinted && this.isSkipRepeating() ? "" : this.formatPeriod(section.getExamAssignment()), 38), this.rpad(this.iSubjectPrinted && this.isSkipRepeating() ? "" : section.getSubject(), 7), this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iITypePrinted && this.isSkipRepeating() ? "" : section.getItype(), 6) : NULL, this.formatSection10(section.getSection()), this.lpad(String.valueOf(section.getNrStudents()), 5));
                        this.iITypePrinted = !this.iNewPage;
                        this.iCoursePrinted = this.iITypePrinted;
                        this.iSubjectPrinted = this.iITypePrinted;
                        this.iStudentPrinted = this.iITypePrinted;
                        this.iPeriodPrinted = this.iITypePrinted;
                        lastSection = section;
                        somethingPrinted = true;
                    }
                }
            }
            this.setCont(null);
            if (!somethingPrinted || !i.hasNext()) continue;
            this.newPage();
        }
        this.lastPage();
    }
}

