/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.exam;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.reports.AbstractReport;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;

public class ScheduleByCourseReport
extends PdfLegacyExamReport {
    protected static Log sLog = LogFactory.getLog(ScheduleByCourseReport.class);

    public ScheduleByCourseReport(int mode, File file, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, file, MSG.legacyReportScheduleByCourse(), session, examType, subjectAreas, exams);
    }

    @Override
    public void printReport() throws DocumentException {
        sLog.debug((Object)MSG.statusSortingSections());
        Hashtable<String, TreeSet<ExamInfo.ExamSectionInfo>> subject2courseSections = new Hashtable<String, TreeSet<ExamInfo.ExamSectionInfo>>();
        for (ExamInfo examInfo : this.getExams()) {
            for (ExamInfo.ExamSectionInfo section : examInfo.getSectionsIncludeCrosslistedDummies()) {
                if (!this.hasSubjectArea(section)) continue;
                TreeSet<ExamInfo.ExamSectionInfo> sections = (TreeSet<ExamInfo.ExamSectionInfo>)subject2courseSections.get(section.getSubject());
                if (sections == null) {
                    sections = new TreeSet<ExamInfo.ExamSectionInfo>();
                    subject2courseSections.put(section.getSubject(), sections);
                }
                sections.add(section);
            }
        }
        sLog.debug((Object)MSG.statusPrintingReport());
        this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 10), this.rpad(MSG.lrMeetingTimes(), 35), this.lpad(MSG.lrEnrl(), 5).withSeparator("  "), this.rpad(MSG.lrDateAndTime(), 30), this.rpad(MSG.lrRoom(), 11), this.lpad(MSG.lrCap(), 5), this.lpad(MSG.lrExCap(), 5)), new AbstractReport.Line(this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 10), this.lpad("", '-', 35), this.lpad("", '-', 5).withSeparator("  "), this.lpad("", '-', 30), this.lpad("", '-', 11), this.lpad("", '-', 5), this.lpad("", '-', 5)));
        this.printHeader();
        Iterator i = new TreeSet(subject2courseSections.keySet()).iterator();
        while (i.hasNext()) {
            String string = (String)i.next();
            TreeSet sections = (TreeSet)subject2courseSections.get(string);
            this.setPageName(string);
            this.setCont(string);
            this.iSubjectPrinted = false;
            this.iCoursePrinted = false;
            String lastCourse = null;
            this.iITypePrinted = false;
            String lastItype = null;
            Iterator j = sections.iterator();
            while (j.hasNext()) {
                Iterator<ExamInfo.ExamSectionInfo> ch;
                ExamInfo.ExamSectionInfo section = (ExamInfo.ExamSectionInfo)j.next();
                if (this.iCoursePrinted && !section.getCourseNbr().equals(lastCourse)) {
                    this.iCoursePrinted = false;
                    this.iITypePrinted = false;
                }
                if (this.iITypePrinted && !section.getItype().equals(lastItype)) {
                    this.iITypePrinted = false;
                }
                Iterator<ExamInfo.ExamSectionInfo> iterator = ch = section.hasDifferentSubjectChildren() ? section.getDifferentSubjectChildren().iterator() : null;
                if (section.getExamAssignment().getRooms() == null || section.getExamAssignment().getRooms().isEmpty()) {
                    if (this.getLineNumber() + 1 + (section.hasDifferentSubjectChildren() ? section.getDifferentSubjectChildren().size() : 0) > this.getNrLinesPerPage() && this.getNrLinesPerPage() > 0) {
                        this.newPage();
                    }
                    this.println(this.rpad(this.iSubjectPrinted && this.isSkipRepeating() ? "" : string, 7), this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iITypePrinted && this.isSkipRepeating() ? "" : section.getItype(), 6) : NULL, this.formatSection10(section.getSection()), this.rpad(this.getMeetingTime(section), 35), this.lpad(String.valueOf(section.getNrStudents()), 5).withSeparator("  "), this.rpad(section.getExamAssignment() == null ? "" : section.getExamAssignment().getPeriodNameFixedLength(), 30), new AbstractReport.Cell(section.getExamAssignment() == null ? "" : this.iNoRoom).withColSpan(3));
                } else {
                    if (this.getLineNumber() + Math.max(section.getExamAssignment().getRooms().size(), section.hasDifferentSubjectChildren() ? section.getDifferentSubjectChildren().size() : 0) > this.getNrLinesPerPage() && this.getNrLinesPerPage() > 0) {
                        this.newPage();
                    }
                    boolean firstRoom = true;
                    for (ExamRoomInfo room : section.getExamAssignment().getRooms()) {
                        ExamInfo.ExamSectionInfo child;
                        ExamInfo.ExamSectionInfo examSectionInfo = child = firstRoom || ch == null || !ch.hasNext() ? null : ch.next();
                        if (child != null) {
                            this.println(this.rpad(MSG.lrWith() + child.getSubject(), 8).withSeparator(""), this.rpad(child.getCourseNbr(), 8), this.iItype ? this.rpad(child.getItype(), 6) : NULL, this.formatSection10(child.getSection()), this.rpad("", 35), this.lpad(String.valueOf(child.getNrStudents()), 5).withSeparator("  "), this.rpad("", 30), this.formatRoom(room), this.lpad("" + room.getCapacity(), 5), this.lpad("" + room.getExamCapacity(), 5));
                        } else {
                            this.println(this.rpad(!firstRoom || this.iSubjectPrinted && this.isSkipRepeating() ? "" : string, 7), this.rpad(!firstRoom || this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(!firstRoom || this.iITypePrinted && this.isSkipRepeating() ? "" : section.getItype(), 6) : NULL, this.formatSection10(!firstRoom ? "" : section.getSection()), !firstRoom ? this.rpad("", 35) : this.getMeetingTime(section), this.lpad(!firstRoom ? "" : String.valueOf(section.getNrStudents()), 5).withSeparator("  "), this.rpad(!firstRoom ? "" : (section.getExamAssignment() == null ? "" : section.getExamAssignment().getPeriodNameFixedLength()), 30), this.formatRoom(room), this.lpad("" + room.getCapacity(), 5), this.lpad("" + room.getExamCapacity(), 5));
                        }
                        firstRoom = false;
                    }
                }
                while (ch != null && ch.hasNext()) {
                    ExamInfo.ExamSectionInfo child = ch.next();
                    this.println(this.rpad(MSG.lrWith() + child.getSubject(), 8).withSeparator(""), this.rpad(child.getCourseNbr(), 8), this.iItype ? this.rpad(child.getItype(), 6) : NULL, this.formatSection10(child.getSection()), this.rpad("", 35), this.lpad(String.valueOf(child.getNrStudents()), 5));
                }
                if (this.iNewPage || section.hasDifferentSubjectChildren()) {
                    this.iCoursePrinted = false;
                    this.iITypePrinted = false;
                    this.iSubjectPrinted = false;
                    lastCourse = null;
                    lastItype = null;
                } else {
                    this.iCoursePrinted = true;
                    this.iITypePrinted = true;
                    this.iSubjectPrinted = true;
                    lastItype = section.getItype();
                    lastCourse = section.getCourseNbr();
                }
                if (!j.hasNext() || this.iNewPage) continue;
                this.println(new AbstractReport.Line());
            }
            this.setCont(null);
            if (!i.hasNext()) continue;
            this.newPage();
        }
        this.lastPage();
    }
}

