/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.enrollment;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.reports.AbstractReport;
import org.unitime.timetable.reports.enrollment.PdfEnrollmentAuditReport;

public class EnrollmentsViolatingCourseStructureAuditReport
extends PdfEnrollmentAuditReport {
    public EnrollmentsViolatingCourseStructureAuditReport(int mode, File file, Session session, TreeSet<SubjectArea> subjectAreas, String subTitle) throws DocumentException, IOException {
        super(mode, EnrollmentsViolatingCourseStructureAuditReport.getTitle(), file, session, subjectAreas, subTitle);
    }

    public EnrollmentsViolatingCourseStructureAuditReport(int mode, File file, Session session) throws DocumentException, IOException {
        super(mode, EnrollmentsViolatingCourseStructureAuditReport.getTitle(), file, session);
        this.setSession(session);
    }

    @Override
    public void printReport() throws DocumentException {
        this.setHeaderLine(this.buildHeaderString());
        List results = this.getAuditResults(this.getSubjectAreas());
        Vector<AbstractReport.Line> lines = new Vector<AbstractReport.Line>();
        Iterator it = results.iterator();
        while (it.hasNext()) {
            EnrollmentsViolatingCourseStructureAuditResult result = new EnrollmentsViolatingCourseStructureAuditResult((Object[])it.next());
            lines.add(this.buildLineString(result));
        }
        this.printHeader();
        for (AbstractReport.Line str : lines) {
            this.printLine(str);
        }
        if (!lines.isEmpty()) {
            this.lastPage();
        }
    }

    private AbstractReport.Line buildLineString(EnrollmentsViolatingCourseStructureAuditResult result) {
        return new AbstractReport.Line(this.buildBaseAuditLine(result), new AbstractReport.Line(this.rpad(result.classString(), ' ', classNameLength), this.rpad(result.expectedClassString(), ' ', classNameLength), this.rpad(result.actualClassString(), ' ', classNameLength)));
    }

    private AbstractReport.Line[] buildHeaderString() {
        AbstractReport.Line[] baseHdr = this.getBaseHeader();
        return new AbstractReport.Line[]{new AbstractReport.Line(baseHdr[0], new AbstractReport.Line(this.rpad("", ' ', classNameLength), this.rpad(MSG.lrExpected(), ' ', classNameLength), this.rpad("", ' ', classNameLength))), new AbstractReport.Line(baseHdr[1], new AbstractReport.Line(this.rpad(MSG.lrClass(), ' ', classNameLength), this.rpad(MSG.lrParentClass(), ' ', classNameLength), this.rpad(MSG.lrErrorResult(), ' ', classNameLength))), new AbstractReport.Line(baseHdr[2], new AbstractReport.Line(this.rpad("", '-', classNameLength), this.rpad("", '-', classNameLength), this.rpad("", '-', classNameLength)))};
    }

    @Override
    protected String createQueryString(TreeSet<SubjectArea> subjectAreas) {
        StringBuilder sb = new StringBuilder();
        sb.append("select s.externalUniqueId, s.lastName, s.firstName, s.middleName,").append(" sce.courseOffering.subjectArea.subjectAreaAbbreviation, sce.courseOffering.courseNbr,").append(" sce.courseOffering.title, sce.clazz.schedulingSubpart.itype.abbv, sce.clazz.sectionNumberCache,").append(" sce.clazz.schedulingSubpart.schedulingSubpartSuffixCache, c.schedulingSubpart.itype.abbv,").append(" c.sectionNumberCache, c.schedulingSubpart.schedulingSubpartSuffixCache,").append(" ( select count(sce1) from StudentClassEnrollment sce1 where sce1.clazz.uniqueId = c.uniqueId and sce.courseOffering = sce1.courseOffering and sce1.student.uniqueId = s.uniqueId ),").append(" ( select distinct sce2.clazz.schedulingSubpart.itype.abbv || ' ' || sce2.clazz.sectionNumberCache || ' ' ||  sce2.clazz.schedulingSubpart.schedulingSubpartSuffixCache").append(" from StudentClassEnrollment sce2 where sce2.clazz.schedulingSubpart.uniqueId = c.schedulingSubpart.uniqueId and sce2.student.uniqueId = s.uniqueId and sce2.courseOffering.uniqueId = sce.courseOffering.uniqueId )").append(" from Student s inner join s.classEnrollments as sce, Class_ c").append(" where s.session.uniqueId = :sessId").append(" and c.uniqueId = sce.clazz.parentClass.uniqueId");
        if (subjectAreas != null && !subjectAreas.isEmpty()) {
            sb.append(" and sce.courseOffering.subjectArea.uniqueId in (");
            boolean first = true;
            for (SubjectArea sa : subjectAreas) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(" ");
                sb.append(sa.getUniqueId().toString());
            }
            sb.append(" ) ");
        }
        sb.append(" and 1 != ( select count(sce1) from StudentClassEnrollment sce1 where sce1.clazz.uniqueId = c.uniqueId and sce.courseOffering = sce1.courseOffering and sce1.student.uniqueId = s.uniqueId )").append(" order by sce.courseOffering.subjectArea.subjectAreaAbbreviation, sce.courseOffering.courseNbr,").append(" sce.courseOffering.title, sce.clazz.schedulingSubpart.itype.abbv, sce.clazz.sectionNumberCache,").append(" sce.clazz.schedulingSubpart.schedulingSubpartSuffixCache");
        if (this.isShowId()) {
            sb.append(", s.externalUniqueId");
        } else if (this.isShowName()) {
            sb.append(", s.lastName, s.firstName, s.middleName");
        }
        return sb.toString();
    }

    public static String getTitle() {
        return MSG.reportEnrollmentsViolatingCourseStructureAudit();
    }

    private class EnrollmentsViolatingCourseStructureAuditResult
    extends PdfEnrollmentAuditReport.EnrollmentAuditResult {
        private String itype;
        private String classNbr;
        private String classNbrSuffix;
        private String parentItype;
        private String parentClassNbr;
        private String parentClassNbrSuffix;
        private boolean hasEnrollmentInParentSubpart;
        private String actualParentSupartItype;
        private String actualParentSubpartClassSectionNumber;
        private String actualParentSubpartClassSectionNumberSuffix;

        public EnrollmentsViolatingCourseStructureAuditResult(Object[] result) {
            super(EnrollmentsViolatingCourseStructureAuditReport.this, result);
            if (result[7] != null) {
                this.itype = result[7].toString();
            }
            if (result[8] != null) {
                this.classNbr = result[8].toString();
            }
            if (result[9] != null) {
                this.classNbrSuffix = result[9].toString();
            }
            if (result[10] != null) {
                this.parentItype = result[10].toString();
            }
            if (result[11] != null) {
                this.parentClassNbr = result[11].toString();
            }
            if (result[12] != null) {
                this.parentClassNbrSuffix = result[12].toString();
            }
            boolean bl = this.hasEnrollmentInParentSubpart = result[14] != null;
            if (this.hasEnrollmentInParentSubpart) {
                this.actualParentSupartItype = result[14].toString().substring(0, result[14].toString().indexOf(32));
                this.actualParentSubpartClassSectionNumber = result[14].toString().substring(result[14].toString().indexOf(32) + 1, result[14].toString().indexOf(32, result[14].toString().indexOf(32) + 1));
                this.actualParentSubpartClassSectionNumberSuffix = result[14].toString().substring(result[14].toString().indexOf(32, result[14].toString().indexOf(32) + 1) + 1).trim();
            } else {
                this.actualParentSupartItype = "No Class";
                this.actualParentSubpartClassSectionNumber = "";
                this.actualParentSubpartClassSectionNumberSuffix = "";
            }
        }

        public String classString() {
            return this.createClassString(this.itype, this.classNbr, this.classNbrSuffix);
        }

        public String expectedClassString() {
            return this.createClassString(this.parentItype, this.parentClassNbr, this.parentClassNbrSuffix);
        }

        public String actualClassString() {
            return this.createClassString(this.actualParentSupartItype, this.actualParentSubpartClassSectionNumber, this.actualParentSubpartClassSectionNumberSuffix);
        }
    }
}

