/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.HashMap;
import java.util.List;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.WaitList;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.updates.ReloadAllData;

public class ReloadAllStudents
extends ReloadAllData {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);

    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        OnlineSectioningServer.Lock lock = server.lockAll();
        try {
            helper.beginTransaction();
            try {
                server.clearAllStudents();
                HashMap<Long, List<XCourseRequest>> requestMap = new HashMap<Long, List<XCourseRequest>>();
                List students = helper.getHibSession().createQuery("select distinct s from Student s left join fetch s.courseDemands as cd left join fetch cd.courseRequests as cr left join fetch cr.classWaitLists as cwl left join fetch s.classEnrollments as e left join fetch s.areaClasfMajors as acm left join fetch s.waitlists as w left join fetch s.groups as g left join fetch s.notes as n where s.session.uniqueId=:sessionId", Student.class).setParameter("sessionId", (Object)server.getAcademicSession().getUniqueId()).list();
                for (Student student : students) {
                    XStudent s = ReloadAllStudents.loadStudent(student, requestMap, server, helper, WaitList.WaitListType.RELOAD);
                    if (s == null) continue;
                    server.update(s, true);
                }
                helper.commitTransaction();
                Boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                helper.rollbackTransaction();
                if (e instanceof SectioningException) {
                    throw (SectioningException)e;
                }
                throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
            }
        }
        finally {
            lock.release();
        }
    }

    @Override
    public String name() {
        return "reload-all-students";
    }
}

