/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.Collection;
import java.util.Date;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentNote;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentNote;

public class ChangeStudentStatus
implements OnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Collection<Long> iStudentIds = null;
    private String iStatus = null;
    private String iNote = null;

    public ChangeStudentStatus forStudents(Collection<Long> studentIds) {
        this.iStudentIds = studentIds;
        return this;
    }

    public ChangeStudentStatus withStatus(String status) {
        this.iStatus = status;
        return this;
    }

    public ChangeStudentStatus withNote(String note) {
        this.iNote = note;
        return this;
    }

    public String getStatus() {
        return this.iStatus;
    }

    public boolean hasStatus() {
        return this.iStatus != null && !this.iStatus.isEmpty();
    }

    public boolean changeStatus() {
        return !"-".equals(this.iStatus);
    }

    public String getNote() {
        return this.iNote;
    }

    public boolean hasNote() {
        return this.iNote != null;
    }

    public Collection<Long> getStudentIds() {
        return this.iStudentIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        StudentSectioningStatus status = this.changeStatus() && this.hasStatus() ? (StudentSectioningStatus)helper.getHibSession().createQuery("from StudentSectioningStatus where reference = :ref and (session is null or session.uniqueId = :sessionId)", StudentSectioningStatus.class).setParameter("ref", (Object)this.getStatus()).setParameter("sessionId", (Object)server.getAcademicSession().getUniqueId()).uniqueResult() : null;
        Date ts = new Date();
        for (Long studentId : this.getStudentIds()) {
            OnlineSectioningServer.Lock lock = server.lockStudent(studentId, null, this.name());
            try {
                XStudent student = server.getStudent(studentId);
                helper.beginTransaction();
                try {
                    Student dbStudent = (Student)StudentDAO.getInstance().get(studentId, helper.getHibSession());
                    if (student != null && dbStudent != null) {
                        OnlineSectioningLog.Action.Builder action = helper.addAction(this, server.getAcademicSession());
                        action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(student.getStudentId()).setExternalId(student.getExternalId()).setName(student.getName()));
                        if (status != null) {
                            action.addOther(OnlineSectioningLog.Entity.newBuilder().setUniqueId(status.getUniqueId()).setName(status.getLabel()).setExternalId(status.getReference()).setType(OnlineSectioningLog.Entity.EntityType.OTHER));
                        }
                        if (this.hasNote()) {
                            action.addMessage(OnlineSectioningLog.Message.newBuilder().setText(this.getNote()).setTimeStamp(ts.getTime()).setLevel(OnlineSectioningLog.Message.Level.INFO));
                            StudentNote note = new StudentNote();
                            note.setStudent(dbStudent);
                            note.setTextNote(this.getNote());
                            note.setTimeStamp(ts);
                            note.setUserId(helper.getUser().getExternalId());
                            dbStudent.addToNotes(note);
                            student.setLastNote(new XStudentNote(note));
                        }
                        if (this.changeStatus()) {
                            String newStatus;
                            String oldStatus;
                            String string = dbStudent.getSectioningStatus() != null ? dbStudent.getSectioningStatus().getReference() : (oldStatus = dbStudent.getSession().getDefaultSectioningStatus() != null ? MSG.studentStatusSessionDefault(dbStudent.getSession().getDefaultSectioningStatus().getReference()) : MSG.studentStatusSystemDefault());
                            if (dbStudent.getSectioningStatus() != null) {
                                action.addOptionBuilder().setKey("old-status").setValue(dbStudent.getSectioningStatus().getReference());
                            }
                            student.setStatus(status == null ? null : status.getReference());
                            dbStudent.setSectioningStatus(status);
                            String string2 = dbStudent.getSectioningStatus() != null ? dbStudent.getSectioningStatus().getReference() : (newStatus = dbStudent.getSession().getDefaultSectioningStatus() != null ? MSG.studentStatusSessionDefault(dbStudent.getSession().getDefaultSectioningStatus().getReference()) : MSG.studentStatusSystemDefault());
                            if (dbStudent.getSectioningStatus() != null) {
                                action.addOptionBuilder().setKey("new-status").setValue(dbStudent.getSectioningStatus().getReference());
                            }
                            if (oldStatus.equals(newStatus)) {
                                action.addMessage(OnlineSectioningLog.Message.newBuilder().setText(oldStatus).setTimeStamp(ts.getTime()).setLevel(OnlineSectioningLog.Message.Level.INFO));
                            } else {
                                action.addMessage(OnlineSectioningLog.Message.newBuilder().setText(oldStatus + " &rarr; " + newStatus).setTimeStamp(ts.getTime()).setLevel(OnlineSectioningLog.Message.Level.INFO));
                            }
                        }
                        helper.getHibSession().merge((Object)dbStudent);
                        server.update(student, false);
                    }
                    helper.commitTransaction();
                }
                catch (Exception e) {
                    helper.rollbackTransaction();
                    if (e instanceof SectioningException) {
                        throw (SectioningException)e;
                    }
                    throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
                }
            }
            finally {
                lock.release();
            }
        }
        return true;
    }

    @Override
    public String name() {
        return "status-change";
    }
}

