/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.studentsct.model.Student;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.PersonInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.OfferingConsentType;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.AcademicAreaDAO;
import org.unitime.timetable.model.dao.AcademicClassificationDAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.OfferingConsentTypeDAO;
import org.unitime.timetable.model.dao.OnlineSectioningLogDAO;
import org.unitime.timetable.model.dao.StudentAccomodationDAO;
import org.unitime.timetable.model.dao.StudentGroupDAO;
import org.unitime.timetable.model.dao.StudentSectioningStatusDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseLookupHolder;
import org.unitime.timetable.onlinesectioning.model.XAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XOverride;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.status.SectioningStatusFilterAction;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.server.lookup.PeopleLookupBackend;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

public class StatusPageSuggestionsAction
implements OnlineSectioningAction<List<String[]>> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);
    private String iQuery;
    private int iLimit;
    private String iUserId;
    private String iUserName;

    public StatusPageSuggestionsAction withParams(String userId, String userName, String query, int limit) {
        this.iUserId = userId;
        this.iUserName = userName;
        this.iQuery = query == null ? "" : query;
        this.iLimit = limit;
        return this;
    }

    @Override
    public List<String[]> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        try {
            String subject;
            helper.beginTransaction();
            AcademicSessionInfo session = server.getAcademicSession();
            Long sessionId = session.getUniqueId();
            ArrayList<String[]> ret = new ArrayList<String[]>();
            Matcher m = Pattern.compile("^(.*\\W?subject:[ ]?)(\\w*)$", 2).matcher(this.iQuery);
            if (m.matches()) {
                for (SubjectArea subjectArea : SubjectAreaDAO.getInstance().getSession().createQuery("select a from SubjectArea a where (lower(a.subjectAreaAbbreviation) like :q || '%'" + (m.group(2).length() <= 2 ? "" : " or lower(a.title) like '%' || :q || '%'") + ") and a.session.uniqueId = :sessionId order by a.subjectAreaAbbreviation", SubjectArea.class).setParameter("q", (Object)m.group(2).toLowerCase()).setParameter("sessionId", (Object)sessionId).setMaxResults(this.iLimit).list()) {
                    ret.add(new String[]{m.group(1) + (String)(subjectArea.getSubjectAreaAbbreviation().indexOf(32) >= 0 ? "\"" + subjectArea.getSubjectAreaAbbreviation() + "\"" : subjectArea.getSubjectAreaAbbreviation()), subjectArea.getSubjectAreaAbbreviation() + " - " + subjectArea.getTitle()});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?department:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                for (Department department : DepartmentDAO.getInstance().getSession().createQuery("select a from Department a where (lower(a.abbreviation) like :q || '%' or lower(a.deptCode) like :q || '%'" + (m.group(2).length() <= 2 ? "" : " or lower(name) like '%' || :q || '%'") + ") and a.session.uniqueId = :sessionId order by a.deptCode", Department.class).setParameter("q", (Object)m.group(2).toLowerCase()).setParameter("sessionId", (Object)sessionId).setMaxResults(this.iLimit).list()) {
                    ret.add(new String[]{m.group(1) + (String)(department.getDeptCode().indexOf(32) >= 0 ? "\"" + department.getDeptCode() + "\"" : department.getDeptCode()), department.getDeptCode() + " - " + department.getName()});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?area:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                for (AcademicArea academicArea : AcademicAreaDAO.getInstance().getSession().createQuery("select a from AcademicArea a where  (lower(a.academicAreaAbbreviation) like :q || '%'" + (m.group(2).length() <= 2 ? "" : " or lower(a.title) like '%' || :q || '%'") + ") and a.session.uniqueId = :sessionId order by a.academicAreaAbbreviation", AcademicArea.class).setParameter("q", (Object)m.group(2).toLowerCase()).setParameter("sessionId", (Object)sessionId).setMaxResults(this.iLimit).list()) {
                    ret.add(new String[]{m.group(1) + (String)(academicArea.getAcademicAreaAbbreviation().indexOf(32) >= 0 ? "\"" + academicArea.getAcademicAreaAbbreviation() + "\"" : academicArea.getAcademicAreaAbbreviation()), academicArea.getAcademicAreaAbbreviation() + " - " + academicArea.getTitle()});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?classification:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                for (AcademicClassification academicClassification : AcademicClassificationDAO.getInstance().getSession().createQuery("select a from AcademicClassification a where  (lower(a.code) like :q || '%'" + (m.group(2).length() <= 2 ? "" : " or lower(a.name) like '%' || :q || '%'") + ") and a.session.uniqueId = :sessionId order by a.code", AcademicClassification.class).setParameter("q", (Object)m.group(2).toLowerCase()).setParameter("sessionId", (Object)sessionId).setMaxResults(this.iLimit).list()) {
                    ret.add(new String[]{m.group(1) + (String)(academicClassification.getCode().indexOf(32) >= 0 ? "\"" + academicClassification.getCode() + "\"" : academicClassification.getCode()), academicClassification.getCode() + " - " + academicClassification.getName()});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?clasf:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                for (AcademicClassification academicClassification : AcademicClassificationDAO.getInstance().getSession().createQuery("select a from AcademicClassification a where  (lower(a.code) like :q || '%'" + (m.group(2).length() <= 2 ? "" : " or lower(a.name) like '%' || :q || '%'") + ") and a.session.uniqueId = :sessionId order by a.code", AcademicClassification.class).setParameter("q", (Object)m.group(2).toLowerCase()).setParameter("sessionId", (Object)sessionId).setMaxResults(this.iLimit).list()) {
                    ret.add(new String[]{m.group(1) + (String)(academicClassification.getCode().indexOf(32) >= 0 ? "\"" + academicClassification.getCode() + "\"" : academicClassification.getCode()), academicClassification.getCode() + " - " + academicClassification.getName()});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?major:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                String area = null;
                Matcher matcher = Pattern.compile("area:[ ]?\"([^\\\"]*)\"|area:[ ]?(\\w*)").matcher(this.iQuery);
                if (matcher.find()) {
                    area = matcher.group(1) == null ? matcher.group(2) : matcher.group(1);
                }
                for (PosMajor posMajor : AcademicClassificationDAO.getInstance().getSession().createQuery("select distinct a from PosMajor a " + (area == null ? "" : "inner join a.academicAreas x ") + "where  (lower(a.code) like :q || '%'" + (m.group(2).length() <= 2 ? "" : " or lower(a.name) like '%' || :q || '%'") + ")" + (String)(area == null ? "" : " and lower(x.academicAreaAbbreviation) = '" + area.toLowerCase() + "'") + " and a.session.uniqueId = :sessionId order by a.code", PosMajor.class).setParameter("q", (Object)m.group(2).toLowerCase()).setParameter("sessionId", (Object)sessionId).setMaxResults(this.iLimit).list()) {
                    ret.add(new String[]{m.group(1) + (String)(posMajor.getCode().indexOf(32) >= 0 ? "\"" + posMajor.getCode() + "\"" : posMajor.getCode()), posMajor.getCode() + " - " + posMajor.getName()});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?course:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                subject = null;
                Matcher matcher = Pattern.compile("subject:[ ]?\"([^\\\"]*)\"|subject:[ ]?(\\w*)").matcher(this.iQuery);
                if (matcher.find()) {
                    subject = matcher.group(1) == null ? matcher.group(2) : matcher.group(1);
                }
                for (CourseOffering courseOffering : CourseOfferingDAO.getInstance().getSession().createQuery("select c from CourseOffering c where  (lower(c.courseNbr) like :q || '%' or lower(c.subjectArea.subjectAreaAbbreviation) like :q || '%'" + (m.group(2).length() <= 2 ? "" : " or lower(c.title) like '%' || :q || '%'") + ")" + (String)(subject == null ? "" : " and lower(c.subjectArea.subjectAreaAbbreviation) = '" + subject.toLowerCase() + "'") + " and c.subjectArea.session.uniqueId = :sessionId order by c.subjectArea.subjectAreaAbbreviation, c.courseNbr", CourseOffering.class).setParameter("q", (Object)m.group(2).toLowerCase()).setParameter("sessionId", (Object)sessionId).setMaxResults(this.iLimit).list()) {
                    ret.add(new String[]{m.group(1) + "\"" + courseOffering.getCourseName() + "\"", courseOffering.getCourseNameWithTitle()});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?number:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                subject = null;
                Matcher matcher = Pattern.compile("subject:[ ]?\"([^\\\"]*)\"|subject:[ ]?(\\w*)").matcher(this.iQuery);
                if (matcher.find()) {
                    subject = matcher.group(1) == null ? matcher.group(2) : matcher.group(1);
                }
                for (CourseOffering courseOffering : CourseOfferingDAO.getInstance().getSession().createQuery("select c from CourseOffering c where  (lower(c.courseNbr) like :q || '%' or lower(c.subjectArea.subjectAreaAbbreviation) like :q || '%'" + (m.group(2).length() <= 2 ? "" : " or lower(c.title) like '%' || :q || '%'") + ")" + (String)(subject == null ? "" : " and lower(c.subjectArea.subjectAreaAbbreviation) = '" + subject.toLowerCase() + "'") + " and c.subjectArea.session.uniqueId = :sessionId order by c.subjectArea.subjectAreaAbbreviation, c.courseNbr", CourseOffering.class).setParameter("q", (Object)m.group(2).toLowerCase()).setParameter("sessionId", (Object)sessionId).setMaxResults(this.iLimit).list()) {
                    ret.add(new String[]{m.group(1) + (String)(courseOffering.getCourseNbr().indexOf(32) >= 0 ? "\"" + courseOffering.getCourseNbr() + "\"" : courseOffering.getCourseNbr()) + (String)(subject == null ? " subject: " + (String)(courseOffering.getSubjectArea().getSubjectAreaAbbreviation().indexOf(32) >= 0 ? "\"" + courseOffering.getSubjectArea().getSubjectAreaAbbreviation() + "\"" : courseOffering.getSubjectArea().getSubjectAreaAbbreviation()) : ""), courseOffering.getCourseNameWithTitle()});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?group:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                for (StudentGroup studentGroup : StudentGroupDAO.getInstance().getSession().createQuery("select a from StudentGroup a where  (lower(a.groupAbbreviation) like :q || '%'" + (m.group(2).length() <= 2 ? "" : " or lower(a.groupName) like '%' || :q || '%'") + ") and a.session.uniqueId = :sessionId order by a.groupAbbreviation", StudentGroup.class).setParameter("q", (Object)m.group(2).toLowerCase()).setParameter("sessionId", (Object)sessionId).setMaxResults(this.iLimit).list()) {
                    ret.add(new String[]{m.group(1) + (String)(studentGroup.getGroupAbbreviation().indexOf(32) >= 0 ? "\"" + studentGroup.getGroupAbbreviation() + "\"" : studentGroup.getGroupAbbreviation()), studentGroup.getGroupAbbreviation() + " - " + studentGroup.getGroupName()});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?accommodation:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                for (StudentAccomodation studentAccomodation : StudentAccomodationDAO.getInstance().getSession().createQuery("select a from StudentAccomodation a where  (lower(a.abbreviation) like :q || '%'" + (m.group(2).length() <= 2 ? "" : " or lower(a.name) like '%' || :q || '%'") + ") and a.session.uniqueId = :sessionId order by a.abbreviation", StudentAccomodation.class).setParameter("q", (Object)m.group(2).toLowerCase()).setParameter("sessionId", (Object)sessionId).setMaxResults(this.iLimit).list()) {
                    ret.add(new String[]{m.group(1) + (String)(studentAccomodation.getAbbreviation().indexOf(32) >= 0 ? "\"" + studentAccomodation.getAbbreviation() + "\"" : studentAccomodation.getAbbreviation()), studentAccomodation.getAbbreviation() + " - " + studentAccomodation.getName()});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?student:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches() && m.group(2).length() > 0) {
                for (PersonInterface personInterface : new PeopleLookupBackend().execute(new PersonInterface.LookupRequest(m.group(2), "mustHaveExternalId,source=students,session=" + sessionId + ",maxResults=" + this.iLimit), (SessionContext)null)) {
                    ret.add(new String[]{m.group(1) + (String)(personInterface.getId().indexOf(32) >= 0 ? "\"" + personInterface.getId() + "\"" : personInterface.getId()), personInterface.getName()});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?assigned:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                if ("true".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{m.group(1) + "true", "true - Assigned enrollments"});
                }
                if ("false".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{m.group(1) + "false", "false - Wait-listed course requests"});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?scheduled:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                if ("true".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{m.group(1) + "true", "true - Assigned enrollments"});
                }
                if ("false".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{m.group(1) + "false", "false - Wait-listed course requests"});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?waitlist:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                if ("true".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{m.group(1) + "true", "true - Wait-listed course requests"});
                }
                if ("false".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{m.group(1) + "false", "false - Assigned enrollments"});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?waitlisted:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                if ("true".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{m.group(1) + "true", "true - Wait-listed course requests"});
                }
                if ("false".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{m.group(1) + "false", "false - Assigned enrollments"});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?reservation:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                if ("true".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{m.group(1) + "true", "true - Enrollments with a reservation"});
                }
                if ("false".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{m.group(1) + "false", "false - Enrollments without a reservation"});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?reserved:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                if ("true".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{m.group(1) + "true", "true - Enrollments with a reservation"});
                }
                if ("false".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{m.group(1) + "false", "false - Enrollments without a reservation"});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?consent:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                if ("none".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{m.group(1) + "none", "none - Courses with no consent"});
                }
                if ("required".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{m.group(1) + "required", "required - Courses requiring a consent"});
                }
                for (OfferingConsentType offeringConsentType : OfferingConsentTypeDAO.getInstance().findAll()) {
                    if (!offeringConsentType.getAbbv().toLowerCase().startsWith(m.group(2).toLowerCase())) continue;
                    ret.add(new String[]{m.group(1) + ((String)(offeringConsentType.getAbbv().indexOf(32) >= 0 ? "\"" + offeringConsentType.getAbbv() + "\"" : offeringConsentType.getAbbv())).toLowerCase(), offeringConsentType.getAbbv().toLowerCase() + " - " + offeringConsentType.getLabel() + " required"});
                }
                if ("waiting".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{m.group(1) + "waiting", "waiting - Enrollments waiting for a consent"});
                }
                if ("todo".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{m.group(1) + "todo", "todo - Enrollments waiting for my consent"});
                }
                if ("approved".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{m.group(1) + "approved", "approved - Enrollments with an approved consent"});
                }
                if (m.group(2).length() > 0) {
                    for (TimetableManager timetableManager : TimetableManagerDAO.getInstance().getSession().createQuery("select distinct m from TimetableManager m inner join m.managerRoles r inner join m.departments d where  (lower(m.externalUniqueId) like :q || '%' or lower(m.emailAddress) like :q || '%' or lower(m.lastName) || ' ' || lower(m.firstName) like :q || '%') and r.role.reference in ('Administrator', 'Dept Sched Mgr') and d.session.uniqueId = :sessionId order by m.lastName, m.firstName, m.middleName", TimetableManager.class).setParameter("q", (Object)m.group(2).toLowerCase()).setParameter("sessionId", (Object)sessionId).setMaxResults(this.iLimit).list()) {
                        ret.add(new String[]{m.group(1) + (String)(timetableManager.getExternalUniqueId().indexOf(32) >= 0 ? "\"" + timetableManager.getExternalUniqueId() + "\"" : timetableManager.getExternalUniqueId()), timetableManager.getLastName().toLowerCase() + " - Enrollments approved by " + timetableManager.getName()});
                    }
                } else {
                    ret.add(new String[]{m.group(1) + this.iUserId, (this.iUserName.contains(",") ? this.iUserName.substring(0, this.iUserName.indexOf(44)).toLowerCase() : this.iUserName.toLowerCase()) + " - Enrollments approved by " + this.iUserName});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?user:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                if (m.group(2).length() > 0) {
                    for (TimetableManager timetableManager : TimetableManagerDAO.getInstance().getSession().createQuery("select distinct m from TimetableManager m inner join m.managerRoles r inner join m.departments d where  (lower(m.externalUniqueId) like :q || '%' or lower(m.emailAddress) like :q || '%' or lower(m.lastName) || ' ' || lower(m.firstName) like :q || '%') and r.role.reference in ('Administrator', 'Dept Sched Mgr') and d.session.uniqueId = :sessionId order by m.lastName, m.firstName, m.middleName", TimetableManager.class).setParameter("q", (Object)m.group(2).toLowerCase()).setParameter("sessionId", (Object)sessionId).setMaxResults(this.iLimit).list()) {
                        ret.add(new String[]{m.group(1) + (String)(timetableManager.getExternalUniqueId().indexOf(32) >= 0 ? "\"" + timetableManager.getExternalUniqueId() + "\"" : timetableManager.getExternalUniqueId()), timetableManager.getLastName().toLowerCase() + " - Enrollments approved by " + timetableManager.getName()});
                    }
                } else {
                    ret.add(new String[]{m.group(1) + this.iUserId, (this.iUserName.contains(",") ? this.iUserName.substring(0, this.iUserName.indexOf(44)).toLowerCase() : this.iUserName.toLowerCase()) + " - Enrollments approved by " + this.iUserName});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?operation:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                for (String string : OnlineSectioningLogDAO.getInstance().getSession().createQuery("select distinct operation from OnlineSectioningLog where operation like :q || '%' and session.uniqueId = :sessionId order by operation", String.class).setParameter("q", (Object)m.group(2).toLowerCase()).setParameter("sessionId", (Object)sessionId).setMaxResults(this.iLimit).list()) {
                    ret.add(new String[]{m.group(1) + string, Constants.toInitialCase(string.replace('-', ' '))});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?op:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                for (String string : OnlineSectioningLogDAO.getInstance().getSession().createQuery("select distinct operation from OnlineSectioningLog where operation like :q || '%' and session.uniqueId = :sessionId order by operation", String.class).setParameter("q", (Object)m.group(2).toLowerCase()).setParameter("sessionId", (Object)sessionId).setMaxResults(this.iLimit).list()) {
                    ret.add(new String[]{m.group(1) + string, Constants.toInitialCase(string.replace('-', ' '))});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?result:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                for (Iterator<Object> iterator : OnlineSectioningLog.Action.ResultType.values()) {
                    if (!((Enum)((Object)iterator)).name().toLowerCase().startsWith(m.group(2).toLowerCase())) continue;
                    ret.add(new String[]{m.group(1) + ((Enum)((Object)iterator)).name().toLowerCase(), Constants.toInitialCase(((Enum)((Object)iterator)).name().toLowerCase())});
                }
            }
            if (ret.isEmpty() && !this.iQuery.isEmpty()) {
                for (XCourseId xCourseId : server.findCourses(this.iQuery, this.iLimit, null)) {
                    ret.add(new String[]{xCourseId.getCourseName(), xCourseId.getCourseName() + (String)(xCourseId.getTitle() == null ? "" : " - " + xCourseId.getTitle())});
                }
            }
            if ((m = Pattern.compile("^(.*\\W?status:[ ]?)(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                if ("default".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{m.group(1) + "Default", "Default - Academic session default (" + (session.getDefaultSectioningStatus() == null ? "No Restrictions" : session.getDefaultSectioningStatus()) + ")"});
                }
                for (StudentSectioningStatus studentSectioningStatus : StudentSectioningStatusDAO.getInstance().getSession().createQuery("select a from StudentSectioningStatus a where (a.session is null or a.session.uniqueId = :sessionId) and  (lower(a.reference) like :q || '%'" + (m.group(2).length() <= 2 ? "" : " or lower(a.label) like '%' || :q || '%'") + ") order by a.reference", StudentSectioningStatus.class).setParameter("q", (Object)m.group(2).toLowerCase()).setParameter("sessionId", (Object)server.getAcademicSession().getUniqueId()).setMaxResults(this.iLimit).list()) {
                    ret.add(new String[]{m.group(1) + (String)(studentSectioningStatus.getReference().indexOf(32) >= 0 ? "\"" + studentSectioningStatus.getReference() + "\"" : studentSectioningStatus.getReference()), studentSectioningStatus.getReference() + " - " + studentSectioningStatus.getLabel()});
                }
            }
            if ((m = Pattern.compile("^(.*[^: ][ ]+)?(\\w*)$", 2).matcher(this.iQuery)).matches()) {
                if ("area".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{(m.group(1) == null ? "" : m.group(1)) + "area:", "area: Academic Area"});
                }
                if ("classification".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{(m.group(1) == null ? "" : m.group(1)) + "classification:", "classification: Academic Classification"});
                }
                if ("consent".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{(m.group(1) == null ? "" : m.group(1)) + "consent:", "consent: Courses with consent"});
                }
                if ("course".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{(m.group(1) == null ? "" : m.group(1)) + "course:", "course: Course Offering"});
                }
                if ("department".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{(m.group(1) == null ? "" : m.group(1)) + "department:", "department: Department"});
                }
                if ("group".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{(m.group(1) == null ? "" : m.group(1)) + "group:", "group: Student Group"});
                }
                if ("accommodation".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{(m.group(1) == null ? "" : m.group(1)) + "accommodation:", "accommodation: Student Accommodation"});
                }
                if ("major".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{(m.group(1) == null ? "" : m.group(1)) + "major:", "major: Major"});
                }
                if ("reservation".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{(m.group(1) == null ? "" : m.group(1)) + "reservation:", "reservation: Enrollments with a reservation"});
                }
                if ("status".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{(m.group(1) == null ? "" : m.group(1)) + "status:", "status: Student Scheduling Status"});
                }
                if ("student".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{(m.group(1) == null ? "" : m.group(1)) + "student:", "student: Student"});
                }
                if ("subject".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{(m.group(1) == null ? "" : m.group(1)) + "subject:", "subject: Subject Area"});
                }
                if ("waitlist".startsWith(m.group(2).toLowerCase())) {
                    ret.add(new String[]{(m.group(1) == null ? "" : m.group(1)) + "waitlist:", "waitlist: Wait-Listed Course Requests"});
                }
            }
            helper.commitTransaction();
            return ret;
        }
        catch (Exception e) {
            helper.rollbackTransaction();
            if (e instanceof SectioningException) {
                throw (SectioningException)e;
            }
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public String name() {
        return "status-suggestions";
    }

    public static class StudentMatcher
    implements Query.TermMatcher {
        private XStudent iStudent;
        private String iDefaultStatus;
        private OnlineSectioningServer iServer;
        private boolean iMyStudent;

        public StudentMatcher(XStudent student, String defaultStatus, OnlineSectioningServer server, boolean myStudent) {
            this.iStudent = student;
            this.iDefaultStatus = defaultStatus;
            this.iServer = server;
            this.iMyStudent = myStudent;
        }

        public XStudent student() {
            return this.iStudent;
        }

        public String status() {
            return this.iStudent == null || this.iStudent.getStatus() == null ? this.iDefaultStatus : this.iStudent.getStatus();
        }

        public OnlineSectioningServer server() {
            return this.iServer;
        }

        @Override
        public boolean match(String attr, String term) {
            block113: {
                block130: {
                    block129: {
                        block128: {
                            block127: {
                                block126: {
                                    block125: {
                                        block124: {
                                            block123: {
                                                block122: {
                                                    block121: {
                                                        block120: {
                                                            block119: {
                                                                block118: {
                                                                    block117: {
                                                                        block116: {
                                                                            block115: {
                                                                                block114: {
                                                                                    block112: {
                                                                                        if (attr == null && term.isEmpty()) {
                                                                                            return true;
                                                                                        }
                                                                                        if ("limit".equals(attr)) {
                                                                                            return true;
                                                                                        }
                                                                                        if (!"area".equals(attr)) break block112;
                                                                                        for (XAreaClassificationMajor acm : this.student().getMajors()) {
                                                                                            if (!this.like(acm.getArea(), term)) continue;
                                                                                            return true;
                                                                                        }
                                                                                        for (XAreaClassificationMajor acm : this.student().getMinors()) {
                                                                                            if (!this.like(acm.getArea(), term)) continue;
                                                                                            return true;
                                                                                        }
                                                                                        break block113;
                                                                                    }
                                                                                    if (!"clasf".equals(attr) && !"classification".equals(attr)) break block114;
                                                                                    for (XAreaClassificationMajor acm : this.student().getMajors()) {
                                                                                        if (!this.like(acm.getClassification(), term)) continue;
                                                                                        return true;
                                                                                    }
                                                                                    break block113;
                                                                                }
                                                                                if (!"major".equals(attr)) break block115;
                                                                                for (XAreaClassificationMajor acm : this.student().getMajors()) {
                                                                                    if (!this.like(acm.getMajor(), term)) continue;
                                                                                    return true;
                                                                                }
                                                                                break block113;
                                                                            }
                                                                            if (!"concentration".equals(attr)) break block116;
                                                                            for (XAreaClassificationMajor acm : this.student().getMajors()) {
                                                                                if (!this.like(acm.getConcentration(), term)) continue;
                                                                                return true;
                                                                            }
                                                                            break block113;
                                                                        }
                                                                        if (!"degree".equals(attr)) break block117;
                                                                        for (XAreaClassificationMajor acm : this.student().getMajors()) {
                                                                            if (!this.like(acm.getDegree(), term)) continue;
                                                                            return true;
                                                                        }
                                                                        break block113;
                                                                    }
                                                                    if (!"program".equals(attr)) break block118;
                                                                    for (XAreaClassificationMajor acm : this.student().getMajors()) {
                                                                        if (!this.like(acm.getProgram(), term)) continue;
                                                                        return true;
                                                                    }
                                                                    break block113;
                                                                }
                                                                if (!"campus".equals(attr)) break block119;
                                                                for (XAreaClassificationMajor acm : this.student().getMajors()) {
                                                                    if (!this.like(acm.getCampus(), term)) continue;
                                                                    return true;
                                                                }
                                                                break block113;
                                                            }
                                                            if (!"primary-area".equals(attr)) break block120;
                                                            XAreaClassificationMajor acm = this.student().getPrimaryMajor();
                                                            if (acm != null && this.like(acm.getArea(), term)) {
                                                                return true;
                                                            }
                                                            break block113;
                                                        }
                                                        if (!"primary-clasf".equals(attr) && !"primary-classification".equals(attr)) break block121;
                                                        XAreaClassificationMajor acm = this.student().getPrimaryMajor();
                                                        if (acm != null && this.like(acm.getClassification(), term)) {
                                                            return true;
                                                        }
                                                        break block113;
                                                    }
                                                    if (!"primary-major".equals(attr)) break block122;
                                                    XAreaClassificationMajor acm = this.student().getPrimaryMajor();
                                                    if (acm != null && this.like(acm.getMajor(), term)) {
                                                        return true;
                                                    }
                                                    break block113;
                                                }
                                                if (!"primary-concentration".equals(attr)) break block123;
                                                XAreaClassificationMajor acm = this.student().getPrimaryMajor();
                                                if (acm != null && this.like(acm.getConcentration(), term)) {
                                                    return true;
                                                }
                                                break block113;
                                            }
                                            if (!"primary-degree".equals(attr)) break block124;
                                            XAreaClassificationMajor acm = this.student().getPrimaryMajor();
                                            if (acm != null && this.like(acm.getDegree(), term)) {
                                                return true;
                                            }
                                            break block113;
                                        }
                                        if (!"primary-program".equals(attr)) break block125;
                                        XAreaClassificationMajor acm = this.student().getPrimaryMajor();
                                        if (acm != null && this.like(acm.getProgram(), term)) {
                                            return true;
                                        }
                                        break block113;
                                    }
                                    if (!"primary-campus".equals(attr)) break block126;
                                    XAreaClassificationMajor acm = this.student().getPrimaryMajor();
                                    if (acm != null && this.like(acm.getCampus(), term)) {
                                        return true;
                                    }
                                    break block113;
                                }
                                if (!"minor".equals(attr)) break block127;
                                for (XAreaClassificationMajor acm : this.student().getMinors()) {
                                    if (!this.like(acm.getMajor(), term)) continue;
                                    return true;
                                }
                                break block113;
                            }
                            if (!"group".equals(attr)) break block128;
                            for (XStudent.XGroup group : this.student().getGroups()) {
                                if (!this.like(group.getAbbreviation(), term)) continue;
                                return true;
                            }
                            break block113;
                        }
                        if (!"accommodation".equals(attr)) break block129;
                        for (XStudent.XGroup acc : this.student().getAccomodations()) {
                            if (!this.like(acc.getAbbreviation(), term)) continue;
                            return true;
                        }
                        break block113;
                    }
                    if ("student".equals(attr)) {
                        return this.has(this.student().getName(), term) || this.eq(this.student().getExternalId(), term) || this.eq(this.student().getName(), term);
                    }
                    if ("advisor".equals(attr)) {
                        for (XStudent.XAdvisor a : this.student().getAdvisors()) {
                            if (!this.eq(a.getExternalId(), term)) continue;
                            return true;
                        }
                        return false;
                    }
                    if ("registered".equals(attr)) {
                        return !this.eq("true", term) && !this.eq("1", term);
                    }
                    if ("status".equals(attr)) {
                        if ("default".equalsIgnoreCase(term) || "Not Set".equalsIgnoreCase(term)) {
                            return this.student().getStatus() == null;
                        }
                        return this.like(this.status(), term);
                    }
                    if ("credit".equals(attr)) {
                        String im;
                        float max;
                        float min;
                        block111: {
                            Object m;
                            block110: {
                                min = 0.0f;
                                max = Float.MAX_VALUE;
                                SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                                String number = term;
                                if (number.startsWith("<=")) {
                                    prefix = SectioningStatusFilterAction.Credit.le;
                                    number = number.substring(2);
                                } else if (number.startsWith(">=")) {
                                    prefix = SectioningStatusFilterAction.Credit.ge;
                                    number = number.substring(2);
                                } else if (number.startsWith("<")) {
                                    prefix = SectioningStatusFilterAction.Credit.lt;
                                    number = number.substring(1);
                                } else if (number.startsWith(">")) {
                                    prefix = SectioningStatusFilterAction.Credit.gt;
                                    number = number.substring(1);
                                } else if (number.startsWith("=")) {
                                    prefix = SectioningStatusFilterAction.Credit.eq;
                                    number = number.substring(1);
                                }
                                im = null;
                                try {
                                    float a = Float.parseFloat(number);
                                    switch (prefix) {
                                        case eq: {
                                            min = max = a;
                                            break;
                                        }
                                        case le: {
                                            max = a;
                                            break;
                                        }
                                        case ge: {
                                            min = a;
                                            break;
                                        }
                                        case lt: {
                                            max = a - 1.0f;
                                            break;
                                        }
                                        case gt: {
                                            min = a + 1.0f;
                                        }
                                    }
                                }
                                catch (NumberFormatException e) {
                                    m = Pattern.compile("([0-9]+\\.?[0-9]*)([^0-9\\.].*)").matcher(number);
                                    if (!((Matcher)m).matches()) break block110;
                                    float a = Float.parseFloat(((Matcher)m).group(1));
                                    im = ((Matcher)m).group(2).trim();
                                    switch (prefix) {
                                        case eq: {
                                            min = max = a;
                                            break;
                                        }
                                        case le: {
                                            max = a;
                                            break;
                                        }
                                        case ge: {
                                            min = a;
                                            break;
                                        }
                                        case lt: {
                                            max = a - 1.0f;
                                            break;
                                        }
                                        case gt: {
                                            min = a + 1.0f;
                                        }
                                    }
                                }
                            }
                            if (term.contains("..")) {
                                try {
                                    String a = term.substring(0, term.indexOf(46));
                                    String b = term.substring(term.indexOf("..") + 2);
                                    min = Float.parseFloat(a);
                                    max = Float.parseFloat(b);
                                }
                                catch (NumberFormatException e) {
                                    m = Pattern.compile("([0-9]+\\.?[0-9]*)\\.\\.([0-9]+\\.?[0-9]*)([^0-9].*)").matcher(term);
                                    if (!((Matcher)m).matches()) break block111;
                                    min = Float.parseFloat(((Matcher)m).group(1));
                                    max = Float.parseFloat(((Matcher)m).group(2));
                                    im = ((Matcher)m).group(3).trim();
                                }
                            }
                        }
                        float credit = 0.0f;
                        for (XRequest r : this.student().getRequests()) {
                            XOffering o;
                            XConfig g;
                            XCourseRequest cr;
                            if (!(r instanceof XCourseRequest) || (cr = (XCourseRequest)r).getEnrollment() == null || (g = (o = this.server() == null ? null : this.server().getOffering(cr.getEnrollment().getOfferingId())) == null ? null : o.getConfig(cr.getEnrollment().getConfigId())) == null || "!".equals(im) && g.getInstructionalMethod() != null && !g.getInstructionalMethod().getReference().equals(this.iServer.getAcademicSession().getDefaultInstructionalMethod()) || im != null && !"!".equals(im) && (g.getInstructionalMethod() == null || !im.equalsIgnoreCase(g.getInstructionalMethod().getReference()))) continue;
                            for (XSubpart xs : g.getSubparts()) {
                                credit += xs.getCreditValue(cr.getEnrollment().getCourseId());
                            }
                        }
                        return min <= credit && credit <= max;
                    }
                    if ("overlap".equals(attr)) {
                        int min = 0;
                        int max = Integer.MAX_VALUE;
                        SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                        String number = term;
                        if (number.startsWith("<=")) {
                            prefix = SectioningStatusFilterAction.Credit.le;
                            number = number.substring(2);
                        } else if (number.startsWith(">=")) {
                            prefix = SectioningStatusFilterAction.Credit.ge;
                            number = number.substring(2);
                        } else if (number.startsWith("<")) {
                            prefix = SectioningStatusFilterAction.Credit.lt;
                            number = number.substring(1);
                        } else if (number.startsWith(">")) {
                            prefix = SectioningStatusFilterAction.Credit.gt;
                            number = number.substring(1);
                        } else if (number.startsWith("=")) {
                            prefix = SectioningStatusFilterAction.Credit.eq;
                            number = number.substring(1);
                        }
                        try {
                            int a = Integer.parseInt(number);
                            switch (prefix) {
                                case eq: {
                                    min = max = a;
                                    break;
                                }
                                case le: {
                                    max = a;
                                    break;
                                }
                                case ge: {
                                    min = a;
                                    break;
                                }
                                case lt: {
                                    max = a - 1;
                                    break;
                                }
                                case gt: {
                                    min = a + 1;
                                }
                            }
                        }
                        catch (NumberFormatException a) {
                            // empty catch block
                        }
                        if (term.contains("..")) {
                            try {
                                String a = term.substring(0, term.indexOf(46));
                                String b = term.substring(term.indexOf("..") + 2);
                                min = Integer.parseInt(a);
                                max = Integer.parseInt(b);
                            }
                            catch (NumberFormatException a) {
                                // empty catch block
                            }
                        }
                        int share = 0;
                        for (XRequest r : this.student().getRequests()) {
                            XOffering o;
                            XCourseRequest cr;
                            if (!(r instanceof XCourseRequest) || (cr = (XCourseRequest)r).getEnrollment() == null || (o = this.server() == null ? null : this.server().getOffering(cr.getEnrollment().getOfferingId())) == null) continue;
                            for (XSection section : o.getSections(cr.getEnrollment())) {
                                if (section.getTime() == null) continue;
                                for (XRequest q : this.student().getRequests()) {
                                    XEnrollment otherEnrollment;
                                    if (!(q instanceof XCourseRequest) || (otherEnrollment = ((XCourseRequest)q).getEnrollment()) == null) continue;
                                    XOffering otherOffering = this.server().getOffering(otherEnrollment.getOfferingId());
                                    for (XSection otherSection : otherOffering.getSections(otherEnrollment)) {
                                        if (otherSection.equals(section) || otherSection.getTime() == null || !section.getTime().hasIntersection(otherSection.getTime()) || section.isToIgnoreStudentConflictsWith(o.getDistributions(), otherSection.getSectionId()) || section.getSectionId() >= otherSection.getSectionId()) continue;
                                        share += section.getTime().share(otherSection.getTime());
                                    }
                                }
                            }
                        }
                        return min <= share && share <= max;
                    }
                    if ("override".equals(attr)) {
                        if ("null".equalsIgnoreCase(term) || "None".equalsIgnoreCase(term)) {
                            for (XRequest request : this.student().getRequests()) {
                                if (!(request instanceof XCourseRequest)) continue;
                                XCourseRequest cr = (XCourseRequest)request;
                                for (XCourseId course : cr.getCourseIds()) {
                                    XOverride o = cr.getOverride(course);
                                    if (o != null) continue;
                                    return true;
                                }
                            }
                            return false;
                        }
                        CourseRequest.CourseRequestOverrideStatus status = null;
                        for (CourseRequest.CourseRequestOverrideStatus s : CourseRequest.CourseRequestOverrideStatus.values()) {
                            if (!s.name().equalsIgnoreCase(term)) continue;
                            status = s;
                            break;
                        }
                        if (status == null) {
                            return false;
                        }
                        if (this.student().getMaxCreditOverride() != null && this.student().getMaxCreditOverride().getStatus() != null && this.student().getMaxCreditOverride().getStatus().intValue() == status.ordinal()) {
                            return true;
                        }
                        for (XRequest request : this.student().getRequests()) {
                            if (!(request instanceof XCourseRequest)) continue;
                            XCourseRequest cr = (XCourseRequest)request;
                            for (XCourseId course : cr.getCourseIds()) {
                                XOverride o = cr.getOverride(course);
                                if (o == null || o.getStatus() == null || o.getStatus().intValue() != status.ordinal()) continue;
                                return true;
                            }
                        }
                        return false;
                    }
                    if ("mode".equals(attr)) {
                        if (this.eq("My Students", term)) {
                            return this.iMyStudent;
                        }
                        if (this.eq("My Advised", term)) {
                            return this.iMyStudent && this.student().hasAdvisorRequests();
                        }
                        if (this.eq("My Not Advised", term)) {
                            return this.iMyStudent && !this.student().hasAdvisorRequests();
                        }
                        if (this.eq("Advised", term)) {
                            return this.student().hasAdvisorRequests();
                        }
                        if (this.eq("Not Advised", term)) {
                            return !this.student().hasAdvisorRequests();
                        }
                        if (this.eq("PIN Released", term)) {
                            return this.student().isPinReleased();
                        }
                        if (this.eq("PIN Suppressed", term)) {
                            return !this.student().isPinReleased();
                        }
                        if (this.eq("My PIN Released", term)) {
                            return this.iMyStudent && this.student().isPinReleased();
                        }
                        if (this.eq("My PIN Suppressed", term)) {
                            return this.iMyStudent && !this.student().isPinReleased();
                        }
                        return true;
                    }
                    if ("btb".equals(attr)) {
                        if ("prefer".equalsIgnoreCase(term) || "preferred".equalsIgnoreCase(term)) {
                            return this.student().getBackToBackPreference() == Student.BackToBackPreference.BTB_PREFERRED;
                        }
                        if ("disc".equalsIgnoreCase(term) || "discouraged".equalsIgnoreCase(term)) {
                            return this.student().getBackToBackPreference() == Student.BackToBackPreference.BTB_DISCOURAGED;
                        }
                        return this.student().getBackToBackPreference() == Student.BackToBackPreference.NO_PREFERENCE;
                    }
                    if (!"online".equals(attr)) break block130;
                    if ("prefer".equalsIgnoreCase(term) || "preferred".equalsIgnoreCase(term)) {
                        return this.student().getModalityPreference() == Student.ModalityPreference.ONLINE_PREFERRED;
                    }
                    if ("require".equalsIgnoreCase(term) || "required".equalsIgnoreCase(term)) {
                        return this.student().getModalityPreference() == Student.ModalityPreference.ONLINE_REQUIRED;
                    }
                    if ("disc".equalsIgnoreCase(term) || "discouraged".equalsIgnoreCase(term)) {
                        return this.student().getModalityPreference() == Student.ModalityPreference.ONILNE_DISCOURAGED;
                    }
                    if ("no".equalsIgnoreCase(term) || "no-preference".equalsIgnoreCase(term)) {
                        return this.student().getModalityPreference() == Student.ModalityPreference.NO_PREFERENCE;
                    }
                    break block113;
                }
                if (attr == null) break block113;
                for (XStudent.XGroup group : this.student().getGroups()) {
                    if (!this.eq(group.getType(), attr.replace('_', ' ')) || !this.like(group.getAbbreviation(), term)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean eq(String name, String term) {
            if (name == null) {
                return false;
            }
            return name.equalsIgnoreCase(term);
        }

        private boolean like(String name, String term) {
            if (name == null) {
                return false;
            }
            if (term.indexOf(37) >= 0) {
                return name.matches("(?i)" + term.replaceAll("%", ".*"));
            }
            return name.equalsIgnoreCase(term);
        }

        private boolean has(String name, String term) {
            if (name == null) {
                return false;
            }
            if (this.eq(name, term)) {
                return true;
            }
            for (String t : name.split(" |,")) {
                if (!t.equalsIgnoreCase(term)) continue;
                return true;
            }
            return false;
        }
    }

    public static class CourseRequestMatcher
    extends CourseInfoMatcher {
        private static final long serialVersionUID = 1L;
        private XStudent iStudent;
        private XCourseRequest iRequest;
        private XOffering iOffering;
        private Date iFirstDate;
        private String iDefaultStatus;
        private boolean iMyStudent;
        private XEnrollment iEnrollment;
        private XEnrollment iTestEnrollment = null;
        private OnlineSectioningInterface.WaitListMode iWaitListMode;

        public CourseRequestMatcher(AcademicSessionInfo session, XCourse info, XStudent student, XOffering offering, XCourseRequest request, boolean isConsentToDoCourse, boolean isMyStudent, CourseLookup lookup, OnlineSectioningServer server, OnlineSectioningInterface.WaitListMode wlMode) {
            super(info, isConsentToDoCourse, lookup, server);
            this.iFirstDate = session.getDatePatternFirstDate();
            this.iStudent = student;
            this.iRequest = request;
            this.iEnrollment = request.getEnrollment();
            this.iDefaultStatus = session.getDefaultSectioningStatus();
            this.iOffering = offering;
            this.iMyStudent = isMyStudent;
            this.iWaitListMode = wlMode;
        }

        public XCourseRequest request() {
            return this.iRequest;
        }

        public XEnrollment enrollment() {
            if (this.iTestEnrollment != null) {
                return this.iTestEnrollment;
            }
            return this.iEnrollment;
        }

        public boolean isAssigned() {
            return this.iEnrollment != null;
        }

        public XStudent student() {
            return this.iStudent;
        }

        public String status() {
            return this.student().getStatus() == null ? this.iDefaultStatus : this.student().getStatus();
        }

        public XCourseId course() {
            if (this.enrollment() != null) {
                return this.enrollment();
            }
            for (XCourseId course : this.request().getCourseIds()) {
                if (!course.getCourseId().equals(this.info().getCourseId())) continue;
                return course;
            }
            return this.request().getCourseIds().get(0);
        }

        public XOffering offering() {
            return this.iOffering;
        }

        public CourseRequestMatcher setEnrollment(XEnrollment e) {
            this.iTestEnrollment = e;
            return this;
        }

        @Override
        public Boolean match(String attr, String term) {
            List<XCourseRequest.XPreference> prefs;
            Object o;
            Iterator<Externalizable> acm;
            if (attr == null || "name".equals(attr) || "title".equals(attr) || "subject".equals(attr) || "number".equals(attr) || "course".equals(attr) || "lookup".equals(attr) || "department".equals(attr) || "registered".equals(attr)) {
                return super.match(attr, term);
            }
            if ("limit".equals(attr)) {
                return true;
            }
            if ("area".equals(attr)) {
                for (XAreaClassificationMajor acm2 : this.student().getMajors()) {
                    if (!this.like(acm2.getArea(), term)) continue;
                    return true;
                }
                for (XAreaClassificationMajor acm2 : this.student().getMinors()) {
                    if (!this.like(acm2.getArea(), term)) continue;
                    return true;
                }
            }
            if ("clasf".equals(attr) || "classification".equals(attr)) {
                for (XAreaClassificationMajor acm2 : this.student().getMajors()) {
                    if (!this.like(acm2.getClassification(), term)) continue;
                    return true;
                }
            }
            if ("major".equals(attr)) {
                for (XAreaClassificationMajor acm2 : this.student().getMajors()) {
                    if (!this.like(acm2.getMajor(), term)) continue;
                    return true;
                }
            }
            if ("concentration".equals(attr)) {
                for (XAreaClassificationMajor acm2 : this.student().getMajors()) {
                    if (!this.like(acm2.getConcentration(), term)) continue;
                    return true;
                }
            }
            if ("degree".equals(attr)) {
                for (XAreaClassificationMajor acm2 : this.student().getMajors()) {
                    if (!this.like(acm2.getDegree(), term)) continue;
                    return true;
                }
            }
            if ("program".equals(attr)) {
                for (XAreaClassificationMajor acm2 : this.student().getMajors()) {
                    if (!this.like(acm2.getProgram(), term)) continue;
                    return true;
                }
            }
            if ("campus".equals(attr)) {
                for (XAreaClassificationMajor acm2 : this.student().getMajors()) {
                    if (!this.like(acm2.getCampus(), term)) continue;
                    return true;
                }
            }
            if ("primary-area".equals(attr) && (acm = this.student().getPrimaryMajor()) != null && this.like(((XAreaClassificationMajor)((Object)acm)).getArea(), term)) {
                return true;
            }
            if (("primary-clasf".equals(attr) || "primary-classification".equals(attr)) && (acm = this.student().getPrimaryMajor()) != null && this.like(((XAreaClassificationMajor)((Object)acm)).getClassification(), term)) {
                return true;
            }
            if ("primary-major".equals(attr) && (acm = this.student().getPrimaryMajor()) != null && this.like(((XAreaClassificationMajor)((Object)acm)).getMajor(), term)) {
                return true;
            }
            if ("primary-concentration".equals(attr) && (acm = this.student().getPrimaryMajor()) != null && this.like(((XAreaClassificationMajor)((Object)acm)).getConcentration(), term)) {
                return true;
            }
            if ("primary-degree".equals(attr) && (acm = this.student().getPrimaryMajor()) != null && this.like(((XAreaClassificationMajor)((Object)acm)).getDegree(), term)) {
                return true;
            }
            if ("primary-program".equals(attr) && (acm = this.student().getPrimaryMajor()) != null && this.like(((XAreaClassificationMajor)((Object)acm)).getProgram(), term)) {
                return true;
            }
            if ("primary-campus".equals(attr) && (acm = this.student().getPrimaryMajor()) != null && this.like(((XAreaClassificationMajor)((Object)acm)).getCampus(), term)) {
                return true;
            }
            if ("minor".equals(attr)) {
                for (XAreaClassificationMajor acm2 : this.student().getMinors()) {
                    if (!this.like(acm2.getMajor(), term)) continue;
                    return true;
                }
            }
            if ("group".equals(attr)) {
                for (XStudent.XGroup group : this.student().getGroups()) {
                    if (!this.like(group.getAbbreviation(), term)) continue;
                    return true;
                }
            } else {
                for (XStudent.XGroup group : this.student().getGroups()) {
                    if (attr == null || !this.eq(group.getType(), attr.replace('_', ' ')) || !this.like(group.getAbbreviation(), term)) continue;
                    return true;
                }
            }
            if ("accommodation".equals(attr)) {
                for (XStudent.XGroup acc : this.student().getAccomodations()) {
                    if (!this.like(acc.getAbbreviation(), term)) continue;
                    return true;
                }
            }
            if ("student".equals(attr)) {
                if (ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue() && term.startsWith("0")) {
                    return this.has(this.student().getName(), term) || this.eq(this.student().getExternalId(), term.replaceFirst("^0+(?!$)", "")) || this.eq(this.student().getName(), term);
                }
                return this.has(this.student().getName(), term) || this.eq(this.student().getExternalId(), term) || this.eq(this.student().getName(), term);
            }
            if ("advisor".equals(attr)) {
                if (ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue() && term.startsWith("0")) {
                    for (XStudent.XAdvisor a : this.student().getAdvisors()) {
                        if (!this.eq(a.getExternalId(), term.replaceFirst("^0+(?!$)", ""))) continue;
                        return true;
                    }
                } else {
                    for (XStudent.XAdvisor a : this.student().getAdvisors()) {
                        if (!this.eq(a.getExternalId(), term)) continue;
                        return true;
                    }
                }
                return false;
            }
            if ("assignment".equals(attr)) {
                if (this.eq("Assigned", term)) {
                    return this.isAssigned();
                }
                if (this.eq("Reserved", term)) {
                    return this.isAssigned() && this.enrollment().getReservation() != null;
                }
                if (this.eq("Not Assigned", term)) {
                    return !this.isAssigned() && !this.request().isAlternative();
                }
                if (this.eq("Wait-Listed", term)) {
                    if (this.isAssigned() && this.request().isWaitlist(this.iWaitListMode) && this.enrollment().equals(this.request().getWaitListSwapWithCourseOffering())) {
                        return true;
                    }
                    return !this.isAssigned() && this.request().isWaitlist(this.iWaitListMode);
                }
                if (this.eq("Critical", term)) {
                    return this.request().getCritical() == CourseDemand.Critical.CRITICAL.ordinal();
                }
                if (this.eq("Assigned Critical", term)) {
                    return this.request().getCritical() == CourseDemand.Critical.CRITICAL.ordinal() && this.isAssigned();
                }
                if (this.eq("Not Assigned Critical", term)) {
                    return this.request().getCritical() == CourseDemand.Critical.CRITICAL.ordinal() && !this.isAssigned();
                }
                if (this.eq("Vital", term)) {
                    return this.request().getCritical() == CourseDemand.Critical.VITAL.ordinal();
                }
                if (this.eq("Assigned Vital", term)) {
                    return this.request().getCritical() == CourseDemand.Critical.VITAL.ordinal() && this.isAssigned();
                }
                if (this.eq("Not Assigned Vital", term)) {
                    return this.request().getCritical() == CourseDemand.Critical.VITAL.ordinal() && !this.isAssigned();
                }
                if (this.eq("LC", term)) {
                    return this.request().getCritical() == CourseDemand.Critical.LC.ordinal();
                }
                if (this.eq("Assigned LC", term)) {
                    return this.request().getCritical() == CourseDemand.Critical.LC.ordinal() && this.isAssigned();
                }
                if (this.eq("Not Assigned LC", term)) {
                    return this.request().getCritical() == CourseDemand.Critical.LC.ordinal() && !this.isAssigned();
                }
                if (this.eq("Important", term)) {
                    return this.request().getCritical() == CourseDemand.Critical.IMPORTANT.ordinal();
                }
                if (this.eq("Assigned Important", term)) {
                    return this.request().getCritical() == CourseDemand.Critical.IMPORTANT.ordinal() && this.isAssigned();
                }
                if (this.eq("Not Assigned Important", term)) {
                    return this.request().getCritical() == CourseDemand.Critical.IMPORTANT.ordinal() && !this.isAssigned();
                }
                if (this.eq("Visiting F2F", term)) {
                    return this.request().getCritical() == CourseDemand.Critical.VISITING_F2F.ordinal();
                }
                if (this.eq("Assigned Visiting F2F", term)) {
                    return this.request().getCritical() == CourseDemand.Critical.VISITING_F2F.ordinal() && this.isAssigned();
                }
                if (this.eq("Not Assigned Visiting F2F", term)) {
                    return this.request().getCritical() == CourseDemand.Critical.VISITING_F2F.ordinal() && !this.isAssigned();
                }
                if (this.eq("No-Subs", term) || this.eq("No-Substitutes", term)) {
                    return this.request().isNoSub(this.iWaitListMode);
                }
                if (this.eq("Assigned No-Subs", term) || this.eq("Assigned  No-Substitutes", term)) {
                    return this.isAssigned() && this.request().isNoSub(this.iWaitListMode);
                }
                if (this.eq("Not Assigned No-Subs", term) || this.eq("Not Assigned No-Substitutes", term)) {
                    return !this.isAssigned() && this.request().isNoSub(this.iWaitListMode);
                }
            }
            if ("assigned".equals(attr) || "scheduled".equals(attr)) {
                if (this.eq("true", term) || this.eq("1", term)) {
                    return this.isAssigned();
                }
                return !this.isAssigned();
            }
            if ("waitlisted".equals(attr) || "waitlist".equals(attr)) {
                if (this.eq("true", term) || this.eq("1", term)) {
                    return !this.isAssigned() && this.request().isWaitlist();
                }
                return this.isAssigned();
            }
            if ("no-substitutes".equals(attr) || "no-subs".equals(attr)) {
                if (this.eq("true", term) || this.eq("1", term)) {
                    return !this.isAssigned() && this.request().isNoSub();
                }
                return this.isAssigned();
            }
            if ("reservation".equals(attr) || "reserved".equals(attr)) {
                if (this.eq("true", term) || this.eq("1", term)) {
                    return this.isAssigned() && this.enrollment().getReservation() != null;
                }
                return this.isAssigned() && this.enrollment().getReservation() == null;
            }
            if ("consent".equals(attr)) {
                if (this.eq("none", term) || this.eq("No Consent", term)) {
                    return this.info().getConsentLabel() == null;
                }
                if (this.eq("Required", term) || this.eq("Consent", term)) {
                    return this.info().getConsentLabel() != null && this.enrollment() != null;
                }
                if (this.eq("Approved", term)) {
                    return this.info().getConsentLabel() != null && this.enrollment() != null && this.enrollment().getApproval() != null;
                }
                if (this.eq("Waiting", term)) {
                    return this.info().getConsentLabel() != null && this.enrollment() != null && this.enrollment().getApproval() == null;
                }
                if (this.eq("todo", term) || this.eq("To Do", term)) {
                    return this.isConsentToDoCourse() && this.enrollment() != null && this.enrollment().getApproval() == null;
                }
                return this.info().getConsentLabel() != null && this.enrollment() != null && (this.enrollment().getApproval() != null && (this.has(this.enrollment().getApproval().getExternalId(), term) || this.eq(this.enrollment().getApproval().getName(), term)) || this.eq(this.info().getConsentAbbv(), term));
            }
            if ("mode".equals(attr)) {
                if (this.eq("My Students", term)) {
                    return this.iMyStudent;
                }
                if (this.eq("My Advised", term)) {
                    return this.iMyStudent && this.student().hasAdvisorRequests();
                }
                if (this.eq("My Not Advised", term)) {
                    return this.iMyStudent && !this.student().hasAdvisorRequests();
                }
                if (this.eq("Advised", term)) {
                    return this.student().hasAdvisorRequests();
                }
                if (this.eq("Not Advised", term)) {
                    return !this.student().hasAdvisorRequests();
                }
                if (this.eq("PIN Released", term)) {
                    return this.student().isPinReleased();
                }
                if (this.eq("PIN Suppressed", term)) {
                    return !this.student().isPinReleased();
                }
                if (this.eq("My PIN Released", term)) {
                    return this.iMyStudent && this.student().isPinReleased();
                }
                if (this.eq("My PIN Suppressed", term)) {
                    return this.iMyStudent && !this.student().isPinReleased();
                }
                return true;
            }
            if ("approver".equals(attr)) {
                return this.info().getConsentLabel() != null && this.enrollment() != null && this.enrollment().getApproval() != null && (this.has(this.enrollment().getApproval().getExternalId(), term) || this.eq(this.enrollment().getApproval().getName(), term));
            }
            if ("status".equals(attr)) {
                if ("default".equalsIgnoreCase(term) || "Not Set".equalsIgnoreCase(term)) {
                    return this.student().getStatus() == null;
                }
                return this.like(this.status(), term);
            }
            if ("credit".equals(attr)) {
                String im;
                float max;
                float min;
                block396: {
                    Object m;
                    block395: {
                        min = 0.0f;
                        max = Float.MAX_VALUE;
                        SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                        String number = term;
                        if (number.startsWith("<=")) {
                            prefix = SectioningStatusFilterAction.Credit.le;
                            number = number.substring(2);
                        } else if (number.startsWith(">=")) {
                            prefix = SectioningStatusFilterAction.Credit.ge;
                            number = number.substring(2);
                        } else if (number.startsWith("<")) {
                            prefix = SectioningStatusFilterAction.Credit.lt;
                            number = number.substring(1);
                        } else if (number.startsWith(">")) {
                            prefix = SectioningStatusFilterAction.Credit.gt;
                            number = number.substring(1);
                        } else if (number.startsWith("=")) {
                            prefix = SectioningStatusFilterAction.Credit.eq;
                            number = number.substring(1);
                        }
                        im = null;
                        try {
                            float a = Float.parseFloat(number);
                            switch (prefix) {
                                case eq: {
                                    min = max = a;
                                    break;
                                }
                                case le: {
                                    max = a;
                                    break;
                                }
                                case ge: {
                                    min = a;
                                    break;
                                }
                                case lt: {
                                    max = a - 1.0f;
                                    break;
                                }
                                case gt: {
                                    min = a + 1.0f;
                                }
                            }
                        }
                        catch (NumberFormatException e) {
                            m = Pattern.compile("([0-9]+\\.?[0-9]*)([^0-9\\.].*)").matcher(number);
                            if (!((Matcher)m).matches()) break block395;
                            float a = Float.parseFloat(((Matcher)m).group(1));
                            im = ((Matcher)m).group(2).trim();
                            switch (prefix) {
                                case eq: {
                                    min = max = a;
                                    break;
                                }
                                case le: {
                                    max = a;
                                    break;
                                }
                                case ge: {
                                    min = a;
                                    break;
                                }
                                case lt: {
                                    max = a - 1.0f;
                                    break;
                                }
                                case gt: {
                                    min = a + 1.0f;
                                }
                            }
                        }
                    }
                    if (term.contains("..")) {
                        try {
                            String a = term.substring(0, term.indexOf(46));
                            String b = term.substring(term.indexOf("..") + 2);
                            min = Float.parseFloat(a);
                            max = Float.parseFloat(b);
                        }
                        catch (NumberFormatException e) {
                            m = Pattern.compile("([0-9]+\\.?[0-9]*)\\.\\.([0-9]+\\.?[0-9]*)([^0-9].*)").matcher(term);
                            if (!((Matcher)m).matches()) break block396;
                            min = Float.parseFloat(((Matcher)m).group(1));
                            max = Float.parseFloat(((Matcher)m).group(2));
                            im = ((Matcher)m).group(3).trim();
                        }
                    }
                }
                float credit = 0.0f;
                for (XRequest r : this.student().getRequests()) {
                    XOffering o2;
                    XConfig g;
                    XCourseRequest cr;
                    if (!(r instanceof XCourseRequest) || (cr = (XCourseRequest)r).getEnrollment() == null || (g = (o2 = this.server().getOffering(cr.getEnrollment().getOfferingId())) == null ? null : o2.getConfig(cr.getEnrollment().getConfigId())) == null || "!".equals(im) && g.getInstructionalMethod() != null && !g.getInstructionalMethod().getReference().equals(this.server().getAcademicSession().getDefaultInstructionalMethod()) || im != null && !"!".equals(im) && (g.getInstructionalMethod() == null || !im.equalsIgnoreCase(g.getInstructionalMethod().getReference()))) continue;
                    for (XSubpart xs : g.getSubparts()) {
                        credit += xs.getCreditValue(cr.getEnrollment().getCourseId());
                    }
                }
                return min <= credit && credit <= max;
            }
            if ("rc".equals(attr) || "requested-credit".equals(attr)) {
                int min = 0;
                int max = Integer.MAX_VALUE;
                SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = SectioningStatusFilterAction.Credit.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = SectioningStatusFilterAction.Credit.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = SectioningStatusFilterAction.Credit.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = SectioningStatusFilterAction.Credit.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = SectioningStatusFilterAction.Credit.eq;
                    number = number.substring(1);
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            min = max = a;
                            break;
                        }
                        case le: {
                            max = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            max = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        max = Integer.parseInt(b);
                    }
                    catch (NumberFormatException a) {
                        // empty catch block
                    }
                }
                if (min == 0 && max == Integer.MAX_VALUE) {
                    return true;
                }
                float studentMinTot = 0.0f;
                float studentMaxTot = 0.0f;
                int nrCoursesTot = 0;
                ArrayList<Float> minsTot = new ArrayList<Float>();
                ArrayList<Float> maxsTot = new ArrayList<Float>();
                Set<Long> advisorWaitListedCourseIds = this.student().getAdvisorWaitListedCourseIds(this.server());
                for (XRequest r : this.student().getRequests()) {
                    if (!(r instanceof XCourseRequest)) continue;
                    XCourseRequest cr = (XCourseRequest)r;
                    Float minTot = null;
                    Float maxTot = null;
                    for (XCourseId courseId : cr.getCourseIds()) {
                        XCourse c = this.server().getCourse(courseId.getCourseId());
                        if (c == null || !c.hasCredit()) continue;
                        if (minTot == null || minTot.floatValue() > c.getMinCredit().floatValue()) {
                            minTot = c.getMinCredit();
                        }
                        if (maxTot != null && !(maxTot.floatValue() < c.getMaxCredit().floatValue())) continue;
                        maxTot = c.getMaxCredit();
                    }
                    if (cr.isWaitListOrNoSub(this.iWaitListMode, advisorWaitListedCourseIds)) {
                        if (minTot == null) continue;
                        studentMinTot += minTot.floatValue();
                        studentMaxTot += maxTot.floatValue();
                        continue;
                    }
                    if (minTot == null) continue;
                    minsTot.add(minTot);
                    maxsTot.add(maxTot);
                    if (r.isAlternative()) continue;
                    ++nrCoursesTot;
                }
                Collections.sort(minsTot);
                Collections.sort(maxsTot);
                for (int i = 0; i < nrCoursesTot; ++i) {
                    studentMinTot += ((Float)minsTot.get(i)).floatValue();
                    studentMaxTot += ((Float)maxsTot.get(maxsTot.size() - i - 1)).floatValue();
                }
                return (float)min <= studentMaxTot && studentMinTot <= (float)max;
            }
            if ("ft".equals(attr) || "free-time".equals(attr)) {
                int min = 0;
                int max = Integer.MAX_VALUE;
                SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = SectioningStatusFilterAction.Credit.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = SectioningStatusFilterAction.Credit.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = SectioningStatusFilterAction.Credit.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = SectioningStatusFilterAction.Credit.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = SectioningStatusFilterAction.Credit.eq;
                    number = number.substring(1);
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            min = max = a;
                            break;
                        }
                        case le: {
                            max = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            max = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        max = Integer.parseInt(b);
                    }
                    catch (NumberFormatException a) {
                        // empty catch block
                    }
                }
                if (min == 0 && max == Integer.MAX_VALUE) {
                    return true;
                }
                for (XRequest r : this.student().getRequests()) {
                    if (!(r instanceof XFreeTimeRequest) || min > r.getPriority() + 1 || r.getPriority() + 1 > max) continue;
                    return true;
                }
                return false;
            }
            if ("fc".equals(attr) || "first-choice-credit".equals(attr)) {
                int min = 0;
                int max = Integer.MAX_VALUE;
                SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = SectioningStatusFilterAction.Credit.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = SectioningStatusFilterAction.Credit.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = SectioningStatusFilterAction.Credit.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = SectioningStatusFilterAction.Credit.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = SectioningStatusFilterAction.Credit.eq;
                    number = number.substring(1);
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            min = max = a;
                            break;
                        }
                        case le: {
                            max = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            max = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        max = Integer.parseInt(b);
                    }
                    catch (NumberFormatException a) {
                        // empty catch block
                    }
                }
                if (min == 0 && max == Integer.MAX_VALUE) {
                    return true;
                }
                float credit = 0.0f;
                block132: for (XRequest r : this.student().getRequests()) {
                    if (!(r instanceof XCourseRequest) || r.isAlternative()) continue;
                    XCourseRequest cr = (XCourseRequest)r;
                    for (XCourseId courseId : cr.getCourseIds()) {
                        XCourse c = this.server().getCourse(courseId.getCourseId());
                        if (c == null || !c.hasCredit()) continue;
                        credit += c.getMinCredit().floatValue();
                        continue block132;
                    }
                }
                return (float)min <= credit && credit <= (float)max;
            }
            if ("rp".equals(attr)) {
                if ("subst".equalsIgnoreCase(term)) {
                    return this.request().isAlternative();
                }
                int min = 0;
                int max = Integer.MAX_VALUE;
                SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = SectioningStatusFilterAction.Credit.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = SectioningStatusFilterAction.Credit.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = SectioningStatusFilterAction.Credit.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = SectioningStatusFilterAction.Credit.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = SectioningStatusFilterAction.Credit.eq;
                    number = number.substring(1);
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            min = max = a;
                            break;
                        }
                        case le: {
                            max = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            max = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        max = Integer.parseInt(b);
                    }
                    catch (NumberFormatException a) {
                        // empty catch block
                    }
                }
                if (min == 0 && max == Integer.MAX_VALUE) {
                    return true;
                }
                return !this.request().isAlternative() && min <= this.request().getPriority() + 1 && this.request().getPriority() + 1 <= max;
            }
            if ("choice".equals(attr) || "ch".equals(attr)) {
                int min = 0;
                int max = Integer.MAX_VALUE;
                SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = SectioningStatusFilterAction.Credit.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = SectioningStatusFilterAction.Credit.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = SectioningStatusFilterAction.Credit.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = SectioningStatusFilterAction.Credit.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = SectioningStatusFilterAction.Credit.eq;
                    number = number.substring(1);
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            min = max = a;
                            break;
                        }
                        case le: {
                            max = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            max = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        max = Integer.parseInt(b);
                    }
                    catch (NumberFormatException a) {
                        // empty catch block
                    }
                }
                if (min == 0 && max == Integer.MAX_VALUE) {
                    return true;
                }
                if (this.enrollment() != null) {
                    int choice = 1;
                    for (XCourseId course : this.request().getCourseIds()) {
                        if (course.getCourseId().equals(this.enrollment().getCourseId())) {
                            return min <= choice && choice <= max;
                        }
                        ++choice;
                    }
                    return false;
                }
                if (!this.request().isAlternative()) {
                    int choice = this.request().getCourseIds().size();
                    return min <= choice && choice <= max;
                }
                return false;
            }
            if ("btb".equals(attr)) {
                if ("prefer".equalsIgnoreCase(term) || "preferred".equalsIgnoreCase(term)) {
                    return this.student().getBackToBackPreference() == Student.BackToBackPreference.BTB_PREFERRED;
                }
                if ("disc".equalsIgnoreCase(term) || "discouraged".equalsIgnoreCase(term)) {
                    return this.student().getBackToBackPreference() == Student.BackToBackPreference.BTB_DISCOURAGED;
                }
                return this.student().getBackToBackPreference() == Student.BackToBackPreference.NO_PREFERENCE;
            }
            if ("online".equals(attr)) {
                if ("prefer".equalsIgnoreCase(term) || "preferred".equalsIgnoreCase(term)) {
                    return this.student().getModalityPreference() == Student.ModalityPreference.ONLINE_PREFERRED;
                }
                if ("require".equalsIgnoreCase(term) || "required".equalsIgnoreCase(term)) {
                    return this.student().getModalityPreference() == Student.ModalityPreference.ONLINE_REQUIRED;
                }
                if ("disc".equalsIgnoreCase(term) || "discouraged".equalsIgnoreCase(term)) {
                    return this.student().getModalityPreference() == Student.ModalityPreference.ONILNE_DISCOURAGED;
                }
                if ("no".equalsIgnoreCase(term) || "no-preference".equalsIgnoreCase(term)) {
                    return this.student().getModalityPreference() == Student.ModalityPreference.NO_PREFERENCE;
                }
            }
            if ("online".equals(attr) || "face-to-face".equals(attr) || "f2f".equals(attr) || "no-time".equals(attr) || "has-time".equals(attr)) {
                int min = 0;
                int max = Integer.MAX_VALUE;
                SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = SectioningStatusFilterAction.Credit.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = SectioningStatusFilterAction.Credit.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = SectioningStatusFilterAction.Credit.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = SectioningStatusFilterAction.Credit.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = SectioningStatusFilterAction.Credit.eq;
                    number = number.substring(1);
                }
                boolean perc = false;
                if (number.endsWith("%")) {
                    perc = true;
                    number = number.substring(0, number.length() - 1).trim();
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            min = max = a;
                            break;
                        }
                        case le: {
                            max = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            max = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        max = Integer.parseInt(b);
                    }
                    catch (NumberFormatException a) {
                        // empty catch block
                    }
                }
                if (min == 0 && max == Integer.MAX_VALUE) {
                    return true;
                }
                int match = 0;
                int total = 0;
                for (XRequest r : this.student().getRequests()) {
                    XOffering o3;
                    XCourseRequest cr;
                    if (!(r instanceof XCourseRequest) || (cr = (XCourseRequest)r).getEnrollment() == null || (o3 = this.server().getOffering(cr.getEnrollment().getOfferingId())) == null) continue;
                    for (XSection section : o3.getSections(cr.getEnrollment())) {
                        if ("online".equals(attr) && section.isOnline()) {
                            ++match;
                        } else if (("face-to-face".equals(attr) || "f2f".equals(attr)) && !section.isOnline()) {
                            ++match;
                        } else if ("no-time".equals(attr) && (section.getTime() == null || section.getTime().getDays() == 0)) {
                            ++match;
                        } else if ("has-time".equals(attr) && section.getTime() != null && section.getTime().getDays() != 0) {
                            ++match;
                        }
                        ++total;
                    }
                }
                if (total == 0) {
                    return false;
                }
                if (perc) {
                    double percentage = 100.0 * (double)match / (double)total;
                    return (double)min <= percentage && percentage <= (double)max;
                }
                return min <= match && match <= max;
            }
            if ("overlap".equals(attr)) {
                int min = 0;
                int max = Integer.MAX_VALUE;
                SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = SectioningStatusFilterAction.Credit.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = SectioningStatusFilterAction.Credit.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = SectioningStatusFilterAction.Credit.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = SectioningStatusFilterAction.Credit.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = SectioningStatusFilterAction.Credit.eq;
                    number = number.substring(1);
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            min = max = a;
                            break;
                        }
                        case le: {
                            max = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            max = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        max = Integer.parseInt(b);
                    }
                    catch (NumberFormatException a) {
                        // empty catch block
                    }
                }
                int share = 0;
                for (XRequest r : this.student().getRequests()) {
                    XOffering o4;
                    XCourseRequest cr;
                    if (!(r instanceof XCourseRequest) || (cr = (XCourseRequest)r).getEnrollment() == null || (o4 = this.server().getOffering(cr.getEnrollment().getOfferingId())) == null) continue;
                    for (XSection section : o4.getSections(cr.getEnrollment())) {
                        if (section.getTime() == null) continue;
                        for (XRequest q : this.student().getRequests()) {
                            XEnrollment otherEnrollment;
                            if (!(q instanceof XCourseRequest) || (otherEnrollment = ((XCourseRequest)q).getEnrollment()) == null) continue;
                            XOffering otherOffering = this.server().getOffering(otherEnrollment.getOfferingId());
                            for (XSection otherSection : otherOffering.getSections(otherEnrollment)) {
                                if (otherSection.equals(section) || otherSection.getTime() == null || !section.getTime().hasIntersection(otherSection.getTime()) || section.isToIgnoreStudentConflictsWith(o4.getDistributions(), otherSection.getSectionId()) || section.getSectionId() >= otherSection.getSectionId()) continue;
                                share += section.getTime().share(otherSection.getTime());
                            }
                        }
                    }
                }
                return min <= share && share <= max;
            }
            if ("override".equals(attr)) {
                if ("null".equalsIgnoreCase(term) || "None".equalsIgnoreCase(term)) {
                    return this.request().getOverride(this.info()) == null;
                }
                CourseRequest.CourseRequestOverrideStatus status = null;
                for (CourseRequest.CourseRequestOverrideStatus s : CourseRequest.CourseRequestOverrideStatus.values()) {
                    if (!s.name().equalsIgnoreCase(term)) continue;
                    status = s;
                    break;
                }
                if (status == null) {
                    return false;
                }
                o = this.request().getOverride(this.info());
                return o != null && ((XOverride)o).getStatus() != null && ((XOverride)o).getStatus().intValue() == status.ordinal();
            }
            if ("prefer".equals(attr)) {
                prefs = this.request().getPreferences(this.info());
                if (prefs == null) {
                    return false;
                }
                if (this.eq("Any Preference", term)) {
                    return !prefs.isEmpty();
                }
                if (this.eq("Met Preference", term) || this.eq("Unmet Preference", term)) {
                    XConfig g;
                    if (this.enrollment() == null) {
                        if (this.eq("Unmet Preference", term)) {
                            return !prefs.isEmpty();
                        }
                        return false;
                    }
                    o = this.server().getOffering(this.enrollment().getOfferingId());
                    XConfig xConfig = g = o == null ? null : ((XOffering)o).getConfig(this.enrollment().getConfigId());
                    if (g == null) {
                        return false;
                    }
                    boolean hasIm = false;
                    boolean im = false;
                    HashSet<String> allSubparts = new HashSet<String>();
                    HashSet<String> selectedSubparts = new HashSet<String>();
                    for (XCourseRequest.XPreference p : prefs) {
                        switch (p.getType()) {
                            case INSTR_METHOD: {
                                hasIm = true;
                                if (g.getInstructionalMethod() == null || !g.getInstructionalMethod().getUniqueId().equals(p.getUniqueId())) break;
                                im = true;
                                break;
                            }
                            case SECTION: {
                                XSection ps = ((XOffering)o).getSection(p.getUniqueId());
                                if (ps == null) break;
                                allSubparts.add(ps.getSubpartName());
                                for (XSection section : ((XOffering)o).getSections(this.enrollment())) {
                                    if (!section.getSectionId().equals(p.getUniqueId())) continue;
                                    selectedSubparts.add(section.getSubpartName());
                                }
                                break;
                            }
                        }
                    }
                    if (this.eq("Met Preference", term)) {
                        return !prefs.isEmpty() && hasIm == im && selectedSubparts.size() == allSubparts.size();
                    }
                    return !prefs.isEmpty() && (hasIm != im || selectedSubparts.size() != allSubparts.size());
                }
                for (XCourseRequest.XPreference p : prefs) {
                    if (!this.eq(p.getLabel(), term)) continue;
                    return true;
                }
                return false;
            }
            if ("require".equals(attr)) {
                prefs = this.request().getPreferences(this.info());
                if (prefs == null) {
                    return false;
                }
                if (this.eq("Any Requirement", term)) {
                    for (XCourseRequest.XPreference p : prefs) {
                        if (!p.isRequired()) continue;
                        return true;
                    }
                    return false;
                }
                if (this.eq("Met Requirement", term)) {
                    XConfig g;
                    if (this.enrollment() == null) {
                        return false;
                    }
                    o = this.server().getOffering(this.enrollment().getOfferingId());
                    XConfig xConfig = g = o == null ? null : ((XOffering)o).getConfig(this.enrollment().getConfigId());
                    if (g == null) {
                        return false;
                    }
                    boolean hasIm = false;
                    boolean im = false;
                    HashSet<String> allSubparts = new HashSet<String>();
                    HashSet<String> selectedSubparts = new HashSet<String>();
                    boolean hasPref = false;
                    for (XCourseRequest.XPreference p : prefs) {
                        if (!p.isRequired()) continue;
                        hasPref = true;
                        switch (p.getType()) {
                            case INSTR_METHOD: {
                                hasIm = true;
                                if (g.getInstructionalMethod() == null || !g.getInstructionalMethod().getUniqueId().equals(p.getUniqueId())) break;
                                im = true;
                                break;
                            }
                            case SECTION: {
                                XSection ps = ((XOffering)o).getSection(p.getUniqueId());
                                if (ps == null) break;
                                allSubparts.add(ps.getSubpartName());
                                for (XSection section : ((XOffering)o).getSections(this.enrollment())) {
                                    if (!section.getSectionId().equals(p.getUniqueId())) continue;
                                    selectedSubparts.add(section.getSubpartName());
                                }
                                break;
                            }
                        }
                    }
                    return hasPref && hasIm == im && selectedSubparts.size() == allSubparts.size();
                }
                if (this.eq("Unmet Requirement", term)) {
                    if (this.enrollment() != null) {
                        return false;
                    }
                    for (XCourseRequest.XPreference p : prefs) {
                        if (!p.isRequired()) continue;
                        return true;
                    }
                    return false;
                }
                for (XCourseRequest.XPreference p : prefs) {
                    if (!p.isRequired() || !this.eq(p.getLabel(), term)) continue;
                    return true;
                }
                return false;
            }
            if ("im".equals(attr)) {
                if (this.enrollment() == null) {
                    for (XConfig config : this.offering().getConfigs()) {
                        if (config.getInstructionalMethod() == null && term.equals(this.server().getAcademicSession().getDefaultInstructionalMethod())) {
                            return true;
                        }
                        if (config.getInstructionalMethod() == null || !term.equals(config.getInstructionalMethod().getReference())) continue;
                        return true;
                    }
                    return false;
                }
                XConfig config = this.offering().getConfig(this.enrollment().getConfigId());
                if (config == null) {
                    return false;
                }
                if (config.getInstructionalMethod() == null) {
                    return term.equals(this.server().getAcademicSession().getDefaultInstructionalMethod());
                }
                return term.equals(config.getInstructionalMethod().getReference());
            }
            if (this.enrollment() != null) {
                for (XSection section : this.offering().getSections(this.enrollment())) {
                    int start;
                    int end;
                    if ((attr == null || attr.equals("crn") || attr.equals("id") || attr.equals("externalId") || attr.equals("exid") || attr.equals("name")) && section.getName(this.info().getCourseId()) != null && section.getName(this.info().getCourseId()).toLowerCase().startsWith(term.toLowerCase())) {
                        return true;
                    }
                    if (attr == null || attr.equals("day")) {
                        int day;
                        if (section.getTime() == null && term.equalsIgnoreCase("none")) {
                            return true;
                        }
                        if (section.getTime() != null && (day = this.parseDay(term)) > 0 && (section.getTime().getDays() & day) == day) {
                            return true;
                        }
                    }
                    if (attr == null || attr.equals("time")) {
                        int start2;
                        if (section.getTime() == null && term.equalsIgnoreCase("none")) {
                            return true;
                        }
                        if (section.getTime() != null && (start2 = this.parseStart(term)) >= 0 && section.getTime().getSlot() == start2) {
                            return true;
                        }
                    }
                    if (attr != null && attr.equals("before") && section.getTime() != null && (end = this.parseStart(term)) >= 0 && section.getTime().getSlot() + section.getTime().getLength() - section.getTime().getBreakTime() / 5 <= end) {
                        return true;
                    }
                    if (attr != null && attr.equals("after") && section.getTime() != null && (start = this.parseStart(term)) >= 0 && section.getTime().getSlot() >= start) {
                        return true;
                    }
                    if (attr == null || attr.equals("date")) {
                        if (section.getTime() == null && term.equalsIgnoreCase("none")) {
                            return true;
                        }
                        if (section.getTime() != null && !section.getTime().getWeeks().isEmpty()) {
                            Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_PATTERN);
                            Calendar cal = Calendar.getInstance(Locale.US);
                            cal.setLenient(true);
                            cal.setTime(this.iFirstDate);
                            for (int i = 0; i < section.getTime().getWeeks().size(); ++i) {
                                if (section.getTime().getWeeks().get(i)) {
                                    DayCode day = null;
                                    switch (cal.get(7)) {
                                        case 2: {
                                            day = DayCode.MON;
                                            break;
                                        }
                                        case 3: {
                                            day = DayCode.TUE;
                                            break;
                                        }
                                        case 4: {
                                            day = DayCode.WED;
                                            break;
                                        }
                                        case 5: {
                                            day = DayCode.THU;
                                            break;
                                        }
                                        case 6: {
                                            day = DayCode.FRI;
                                            break;
                                        }
                                        case 7: {
                                            day = DayCode.SAT;
                                            break;
                                        }
                                        case 1: {
                                            day = DayCode.SUN;
                                        }
                                    }
                                    if ((section.getTime().getDays() & day.getCode()) == day.getCode()) {
                                        int d = cal.get(5);
                                        int m = cal.get(2) + 1;
                                        if (df.format(cal.getTime()).equalsIgnoreCase(term) || this.eq(d + "." + m + ".", term) || this.eq(m + "/" + d, term)) {
                                            return true;
                                        }
                                    }
                                }
                                cal.add(6, 1);
                            }
                        }
                    }
                    if (attr == null || attr.equals("room")) {
                        if ((section.getRooms() == null || section.getRooms().isEmpty()) && term.equalsIgnoreCase("none")) {
                            return true;
                        }
                        if (section.getRooms() != null) {
                            for (XRoom r : section.getRooms()) {
                                if (!this.has(r.getName(), term)) continue;
                                return true;
                            }
                        }
                    }
                    if (attr != null && !attr.equals("instr") && !attr.equals("instructor")) continue;
                    if (attr != null && section.getInstructors().isEmpty() && term.equalsIgnoreCase("none")) {
                        return true;
                    }
                    for (XInstructor instuctor : section.getInstructors()) {
                        if (this.has(instuctor.getName(), term) || this.eq(instuctor.getExternalId(), term)) {
                            return true;
                        }
                        if (instuctor.getEmail() == null) continue;
                        String email = instuctor.getEmail();
                        if (email.indexOf(64) >= 0) {
                            email = email.substring(0, email.indexOf(64));
                        }
                        if (!this.eq(email, term)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean eq(String name, String term) {
            if (name == null) {
                return false;
            }
            return name.equalsIgnoreCase(term);
        }

        private boolean like(String name, String term) {
            if (name == null) {
                return false;
            }
            if (term.indexOf(37) >= 0) {
                return name.matches("(?i)" + term.replaceAll("%", ".*"));
            }
            return name.equalsIgnoreCase(term);
        }

        private boolean has(String name, String term) {
            if (name == null) {
                return false;
            }
            if (this.eq(name, term)) {
                return true;
            }
            for (String t : name.split(" |,")) {
                if (!t.equalsIgnoreCase(term)) continue;
                return true;
            }
            return false;
        }

        private int parseDay(String token) {
            int days = 0;
            boolean found = false;
            do {
                int i;
                found = false;
                for (i = 0; i < CONSTANTS.longDays().length; ++i) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.longDays()[i].toLowerCase())) continue;
                    days |= DayCode.values()[i].getCode();
                    token = token.substring(CONSTANTS.longDays()[i].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
                for (i = 0; i < CONSTANTS.days().length; ++i) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.days()[i].toLowerCase())) continue;
                    days |= DayCode.values()[i].getCode();
                    token = token.substring(CONSTANTS.days()[i].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
                for (i = 0; i < CONSTANTS.days().length; ++i) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.days()[i].substring(0, 2).toLowerCase())) continue;
                    days |= DayCode.values()[i].getCode();
                    token = token.substring(2);
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
                for (i = 0; i < CONSTANTS.shortDays().length; ++i) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.shortDays()[i].toLowerCase())) continue;
                    days |= DayCode.values()[i].getCode();
                    token = token.substring(CONSTANTS.shortDays()[i].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
                for (i = 0; i < CONSTANTS.freeTimeShortDays().length; ++i) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.freeTimeShortDays()[i].toLowerCase())) continue;
                    days |= DayCode.values()[i].getCode();
                    token = token.substring(CONSTANTS.freeTimeShortDays()[i].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
            } while (found);
            return token.isEmpty() ? days : 0;
        }

        private int parseStart(String token) {
            int startHour = 0;
            int startMin = 0;
            Object number = "";
            while (!token.isEmpty() && token.charAt(0) >= '0' && token.charAt(0) <= '9') {
                number = (String)number + token.substring(0, 1);
                token = token.substring(1);
            }
            if (((String)number).isEmpty()) {
                return -1;
            }
            if (((String)number).length() > 2) {
                startHour = Integer.parseInt((String)number) / 100;
                startMin = Integer.parseInt((String)number) % 100;
            } else {
                startHour = Integer.parseInt((String)number);
            }
            while (token.startsWith(" ")) {
                token = token.substring(1);
            }
            if (token.startsWith(":")) {
                token = token.substring(1);
                while (token.startsWith(" ")) {
                    token = token.substring(1);
                }
                number = "";
                while (!token.isEmpty() && token.charAt(0) >= '0' && token.charAt(0) <= '9') {
                    number = (String)number + token.substring(0, 1);
                    token = token.substring(1);
                }
                if (((String)number).isEmpty()) {
                    return -1;
                }
                startMin = Integer.parseInt((String)number);
            }
            while (token.startsWith(" ")) {
                token = token.substring(1);
            }
            boolean hasAmOrPm = false;
            if (token.toLowerCase().startsWith("am")) {
                token = token.substring(2);
                hasAmOrPm = true;
            }
            if (token.toLowerCase().startsWith("a")) {
                token = token.substring(1);
                hasAmOrPm = true;
            }
            if (token.toLowerCase().startsWith("pm")) {
                token = token.substring(2);
                hasAmOrPm = true;
                if (startHour < 12) {
                    startHour += 12;
                }
            }
            if (token.toLowerCase().startsWith("p")) {
                token = token.substring(1);
                hasAmOrPm = true;
                if (startHour < 12) {
                    startHour += 12;
                }
            }
            if (startHour < 7 && !hasAmOrPm) {
                startHour += 12;
            }
            if (startMin % 5 != 0) {
                startMin = 5 * ((startMin + 2) / 5);
            }
            if (startHour == 7 && startMin == 0 && !hasAmOrPm) {
                startHour += 12;
            }
            return (60 * startHour + startMin) / 5;
        }
    }

    public static class CourseInfoMatcher
    implements Query.AmbigousTermMatcher,
    Serializable {
        private static final long serialVersionUID = 1L;
        private XCourse iInfo;
        private boolean iConsentToDoCourse;
        private CourseLookup iLookup;
        private OnlineSectioningServer iServer;

        public CourseInfoMatcher(XCourse course, boolean isConsentToDoCourse, CourseLookup lookup, OnlineSectioningServer server) {
            this.iInfo = course;
            this.iConsentToDoCourse = isConsentToDoCourse;
            this.iLookup = lookup;
            this.iServer = server;
        }

        public XCourse info() {
            return this.iInfo;
        }

        public boolean isConsentToDoCourse() {
            return this.iConsentToDoCourse;
        }

        public OnlineSectioningServer server() {
            return this.iServer;
        }

        @Override
        public Boolean match(String attr, String term) {
            if (term.isEmpty()) {
                return true;
            }
            if ("limit".equals(attr)) {
                return true;
            }
            if ("lookup".equals(attr)) {
                Set<Long> courseIds = this.iLookup.getCourses(term);
                return courseIds != null && courseIds.contains(this.info().getCourseId());
            }
            if (attr == null || "name".equals(attr) || "course".equals(attr)) {
                return this.info().getSubjectArea().equalsIgnoreCase(term) || this.info().getCourseNumber().equalsIgnoreCase(term) || (this.info().getSubjectArea() + " " + this.info().getCourseNumber()).equalsIgnoreCase(term);
            }
            if (attr == null && term.length() > 2 || "title".equals(attr)) {
                return this.info().getTitle().toLowerCase().contains(term.toLowerCase());
            }
            if (attr == null || "subject".equals(attr)) {
                return this.info().getSubjectArea().equalsIgnoreCase(term);
            }
            if (attr == null || "number".equals(attr)) {
                return this.info().getCourseNumber().equalsIgnoreCase(term);
            }
            if ("department".equals(attr)) {
                return this.info().getDepartment().equalsIgnoreCase(term);
            }
            if ("consent".equals(attr)) {
                if ("none".equalsIgnoreCase(term) || "No Consent".equalsIgnoreCase(term)) {
                    return this.info().getConsentLabel() == null;
                }
                if ("todo".equalsIgnoreCase(term) || "To Do".equalsIgnoreCase(term)) {
                    return this.isConsentToDoCourse();
                }
                return this.info().getConsentLabel() != null;
            }
            if ("mode".equals(attr)) {
                return true;
            }
            if ("registered".equals(attr)) {
                if ("true".equalsIgnoreCase(term) || "1".equalsIgnoreCase(term)) {
                    return true;
                }
                return false;
            }
            if ("assignment".equals(attr)) {
                if ("Wait-Listed".equals(term)) {
                    XOffering offering = this.server().getOffering(this.info().getOfferingId());
                    return offering != null && offering.isWaitList();
                }
                return null;
            }
            if ("im".equals(attr)) {
                XOffering offering = this.server().getOffering(this.info().getOfferingId());
                if (offering != null) {
                    for (XConfig config : offering.getConfigs()) {
                        if (config.getInstructionalMethod() == null && term.equals(this.server().getAcademicSession().getDefaultInstructionalMethod())) {
                            return true;
                        }
                        if (config.getInstructionalMethod() == null || !term.equals(config.getInstructionalMethod().getReference())) continue;
                        return true;
                    }
                }
                return false;
            }
            return null;
        }
    }

    public static class CourseLookup
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private AcademicSessionInfo iSession;
        private Map<String, Set<Long>> iLookups = new HashMap<String, Set<Long>>();

        public CourseLookup(AcademicSessionInfo session) {
            this.iSession = session;
        }

        public Set<Long> getCourses(String term) {
            Set<Long> courses = this.iLookups.get(term);
            if (courses == null && CustomCourseLookupHolder.hasProvider()) {
                courses = CustomCourseLookupHolder.getProvider().getCourseIds(this.iSession, null, term, true);
                if (courses == null) {
                    courses = new HashSet<Long>();
                }
                this.iLookups.put(term, courses);
            }
            return courses;
        }
    }
}

