/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.specreg;

import java.util.Collection;
import java.util.Hashtable;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomSpecialRegistrationHolder;
import org.unitime.timetable.onlinesectioning.model.XStudent;

public class SpecialRegistrationEligibility
implements OnlineSectioningAction<SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private SpecialRegistrationInterface.SpecialRegistrationEligibilityRequest iRequest;

    public SpecialRegistrationEligibility withRequest(SpecialRegistrationInterface.SpecialRegistrationEligibilityRequest request) {
        this.iRequest = request;
        return this;
    }

    public SpecialRegistrationInterface.SpecialRegistrationEligibilityRequest getRequest() {
        return this.iRequest;
    }

    public Collection<ClassAssignmentInterface.ClassAssignment> getAssignment() {
        return this.iRequest.getClassAssignments();
    }

    public Long getStudentId() {
        return this.iRequest.getStudentId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (!server.getAcademicSession().isSectioningEnabled() || !CustomSpecialRegistrationHolder.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        OnlineSectioningServer.Lock lock = server.lockStudent(this.getStudentId(), null, this.name());
        try {
            SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse response;
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            if (this.getRequest().getStudentId() != null) {
                action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getStudentId()));
            }
            OnlineSectioningLog.Enrollment.Builder requested = OnlineSectioningLog.Enrollment.newBuilder();
            requested.setType(OnlineSectioningLog.Enrollment.EnrollmentType.REQUESTED);
            Hashtable<Long, OnlineSectioningLog.CourseRequestOption.Builder> options = new Hashtable<Long, OnlineSectioningLog.CourseRequestOption.Builder>();
            for (ClassAssignmentInterface.ClassAssignment assignment : this.getAssignment()) {
                if (assignment == null) continue;
                OnlineSectioningLog.Section s = OnlineSectioningHelper.toProto(assignment);
                requested.addSection(s);
                if (assignment.isFreeTime() || assignment.isDummy() || assignment.isTeachingAssignment()) continue;
                OnlineSectioningLog.CourseRequestOption.Builder option = (OnlineSectioningLog.CourseRequestOption.Builder)options.get(assignment.getCourseId());
                if (option == null) {
                    option = OnlineSectioningLog.CourseRequestOption.newBuilder().setType(OnlineSectioningLog.CourseRequestOption.OptionType.ORIGINAL_ENROLLMENT);
                    options.put(assignment.getCourseId(), option);
                }
                option.addSection(s);
            }
            action.addEnrollment(requested);
            XStudent student = server.getStudent(this.getStudentId());
            action.getStudentBuilder().setUniqueId(student.getStudentId()).setExternalId(student.getExternalId()).setName(student.getName());
            SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse specialRegistrationEligibilityResponse = response = CustomSpecialRegistrationHolder.getProvider().checkEligibility(server, helper, student, this.getRequest());
            return specialRegistrationEligibilityResponse;
        }
        finally {
            lock.release();
        }
    }

    @Override
    public String name() {
        return "specreg-eligibility";
    }
}

