/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.server;

import java.util.Comparator;
import java.util.TreeSet;

public class SubSet<T extends Comparable<T>>
extends TreeSet<T> {
    private static final long serialVersionUID = 1L;
    private int iLimit = -1;

    public SubSet(Integer limit, Comparator<T> comparator) {
        super(comparator);
        this.iLimit = limit == null ? -1 : limit;
    }

    @Override
    public boolean add(T e) {
        if (this.iLimit <= 0 || this.size() < this.iLimit) {
            return super.add(e);
        }
        Comparable last = (Comparable)this.last();
        if (this.comparator().compare(last, e) > 0) {
            this.remove(last);
            return super.add(e);
        }
        return false;
    }

    public boolean isLimitReached() {
        return this.iLimit > 0 && this.size() >= this.iLimit;
    }
}

