/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.reports;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.reports.OnlineSectioningReport;

public class ExportReport
implements OnlineSectioningReport.Report {
    protected static Log sLog = LogFactory.getLog(ExportReport.class);
    private CodedOutputStream iOut = null;
    private PrintWriter iPrint = null;

    public ExportReport(OutputStream out, PrintWriter print) {
        this.iOut = CodedOutputStream.newInstance((OutputStream)out);
        this.iPrint = print;
    }

    @Override
    public String getYear() {
        return System.getProperty("year", "2013");
    }

    @Override
    public String getTerm() {
        return System.getProperty("term", "Fall");
    }

    @Override
    public String getCampus() {
        return System.getProperty("campus", "PWL");
    }

    @Override
    public File getReportFolder() {
        return new File(System.getProperty("user.home", "."));
    }

    @Override
    public String[] getOperations() {
        return System.getProperty("operations", "section,suggestions,reload-student").split(",");
    }

    @Override
    public String[] getExcludeUsers() {
        return System.getProperty("exclude", "TEST").split(",");
    }

    @Override
    public String getLastTimeStamp() {
        return System.getProperty("before", null);
    }

    @Override
    public void process(OnlineSectioningReport report, String student, List<OnlineSectioningLog.Action> actions) {
        try {
            OnlineSectioningLog.ExportedLog log = OnlineSectioningLog.ExportedLog.newBuilder().setStudent(student).addAllAction(actions).build();
            if (this.iOut != null) {
                this.iOut.writeInt32NoTag(log.getSerializedSize());
                log.writeTo(this.iOut);
                this.iOut.flush();
            }
            if (this.iPrint != null) {
                this.iPrint.println("student: " + student);
                for (OnlineSectioningLog.Action action : actions) {
                    this.iPrint.println(TextFormat.shortDebugString((MessageOrBuilder)action));
                }
                this.iPrint.flush();
            }
            report.inc("Log size [MB]", (double)log.getSerializedSize() / 1048576.0);
            report.inc("Log count", actions.size());
            HashMap<String, Integer> op2cnt = new HashMap<String, Integer>();
            HashMap<String, Long> op2size = new HashMap<String, Long>();
            for (OnlineSectioningLog.Action action : actions) {
                Integer cnt = (Integer)op2cnt.get(action.getOperation());
                op2cnt.put(action.getOperation(), 1 + (cnt == null ? 0 : cnt));
                Long size = (Long)op2size.get(action.getOperation());
                op2size.put(action.getOperation(), (long)action.getSerializedSize() + (size == null ? 0L : size));
            }
            for (Map.Entry entry : op2cnt.entrySet()) {
                report.inc("Count " + (String)entry.getKey(), ((Integer)entry.getValue()).intValue());
            }
            for (Map.Entry entry : op2size.entrySet()) {
                report.inc("Avg. size " + (String)entry.getKey() + " [kB]", (double)((Long)entry.getValue()).longValue() / (1024.0 * (double)((Integer)op2cnt.get(entry.getKey())).intValue()));
            }
        }
        catch (IOException e) {
            sLog.error((Object)("Failed to export student " + student + ": " + e.getMessage()), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            FileOutputStream out = new FileOutputStream("sectioning.dat");
            PrintWriter pw = new PrintWriter("sectioning.log");
            new OnlineSectioningReport(new ExportReport(out, pw)).run();
            out.close();
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

