/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import jakarta.persistence.Transient;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.cpsolver.studentsct.reservation.Reservation;
import org.cpsolver.studentsct.reservation.UniversalOverride;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.model.UniversalOverrideReservation;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XReservationType;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;

public class XUniversalReservation
extends XReservation {
    private static final long serialVersionUID = 1L;
    private int iLimit;
    private Boolean iOverride;
    private String iFilter;
    transient Query iQuery = null;

    public XUniversalReservation() {
    }

    public XUniversalReservation(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XUniversalReservation(XOffering offering, UniversalOverrideReservation reservation) {
        super(XReservationType.Universal, offering, reservation);
        this.iLimit = reservation.getLimit() == null ? -1 : reservation.getLimit();
        this.iFilter = reservation.getFilter();
        this.iOverride = reservation.isAlwaysExpired();
        this.setMustBeUsed(reservation.isMustBeUsed());
        this.setAllowOverlap(reservation.isAllowOverlap());
        this.setCanAssignOverLimit(reservation.isCanAssignOverLimit());
    }

    public XUniversalReservation(UniversalOverride reservation) {
        super(XReservationType.Universal, (Reservation)reservation);
        this.iLimit = (int)Math.round(reservation.getReservationLimit());
        this.iFilter = reservation.getFilter();
        this.iOverride = reservation.isOverride();
    }

    @Override
    public int getReservationLimit() {
        return this.iLimit;
    }

    public String getFilter() {
        return this.iFilter;
    }

    @Override
    public boolean isOverride() {
        return this.iOverride;
    }

    @Override
    public boolean isExpired() {
        return this.isOverride() ? true : super.isExpired();
    }

    @Override
    public boolean isAlwaysExpired() {
        return this.iOverride;
    }

    @Transient
    public Query getStudentQuery() {
        if (this.iQuery == null) {
            this.iQuery = new Query(this.getFilter());
        }
        return this.iQuery;
    }

    @Override
    public boolean isApplicable(XStudent student, XCourseId course) {
        return this.getFilter() != null && !this.getFilter().isEmpty() && this.getStudentQuery().match(new StatusPageSuggestionsAction.StudentMatcher(student, null, null, false));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.iFilter = (String)in.readObject();
        this.iLimit = in.readInt();
        this.iOverride = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.iFilter);
        out.writeInt(this.iLimit);
        out.writeBoolean(this.iOverride);
    }
}

