/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Unavailability;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.TeachingClassRequest;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.model.XDistribution;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XTime;

public class XSection
implements Serializable,
Comparable<XSection>,
Externalizable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId = null;
    private String iName = null;
    private Map<Long, String> iNameByCourse = new HashMap<Long, String>();
    private Long iSubpartId = null;
    private Long iParentId = null;
    private int iLimit = 0;
    private String iNote = null;
    private XTime iTime = null;
    private List<XRoom> iRooms = new ArrayList<XRoom>();
    private List<XInstructor> iInstructors = new ArrayList<XInstructor>();
    private boolean iAllowOverlap = false;
    private String iInstructionalType = null;
    private String iSubpartName = null;
    private String iExternalId = null;
    private Map<Long, String> iExternalIdByCourse = new HashMap<Long, String>();
    private boolean iEnabledForScheduling = true;
    private boolean iCancelled = false;
    private boolean iOnline = false;
    private boolean iPast = false;
    private Map<Long, Float> iCreditByCourse = null;

    public XSection() {
    }

    public XSection(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XSection(Class_ clazz, OnlineSectioningHelper helper) {
        this.iUniqueId = clazz.getUniqueId();
        this.iAllowOverlap = clazz.getSchedulingSubpart().isStudentAllowOverlap();
        this.iName = clazz.getClassSuffix() == null ? clazz.getSectionNumber(helper.getHibSession()) + clazz.getSchedulingSubpart().getSchedulingSubpartSuffix(helper.getHibSession()) : clazz.getClassSuffix();
        this.iInstructionalType = clazz.getSchedulingSubpart().getItypeDesc();
        this.iSubpartName = clazz.getSchedulingSubpart().getItype().getAbbv().trim();
        Assignment assignment = clazz.getCommittedAssignment();
        this.iEnabledForScheduling = clazz.isEnabledForStudentScheduling();
        this.iCancelled = clazz.isCancelled();
        if (clazz.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue()) {
            this.iLimit = -1;
        } else {
            this.iLimit = clazz.getMaxExpectedCapacity();
            if (clazz.getExpectedCapacity() < clazz.getMaxExpectedCapacity() && assignment != null && !assignment.getRooms().isEmpty()) {
                int roomSize = Integer.MAX_VALUE;
                for (Location room : assignment.getRooms()) {
                    roomSize = Math.min(roomSize, room.getCapacity() == null ? 0 : room.getCapacity());
                }
                int roomLimit = (int)Math.floor((float)roomSize / (clazz.getRoomRatio() == null ? 1.0f : clazz.getRoomRatio().floatValue()));
                this.iLimit = Math.min(Math.max(clazz.getExpectedCapacity(), roomLimit), clazz.getMaxExpectedCapacity());
            }
            if (this.iLimit >= 9999) {
                this.iLimit = -1;
            }
        }
        this.iParentId = clazz.getParentClass() == null ? null : clazz.getParentClass().getUniqueId();
        this.iSubpartId = clazz.getSchedulingSubpart().getUniqueId();
        this.iNote = clazz.getSchedulePrintNote();
        this.iExternalId = clazz.getExternalUniqueId();
        if (this.iExternalId == null) {
            this.iExternalId = clazz.getSchedulingSubpart().getItypeDesc().trim() + " " + clazz.getClassLabel();
        }
        for (CourseOffering course : clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings()) {
            this.iNameByCourse.put(course.getUniqueId(), helper.getClassSuffix(clazz, course));
            String extId = helper.getExternalId(clazz, course);
            if (extId == null) {
                extId = helper.getClassLabel(clazz, course);
            }
            this.iExternalIdByCourse.put(course.getUniqueId(), extId);
            Float credit = helper.getClassCredit(clazz, course);
            if (credit == null) continue;
            if (this.iCreditByCourse == null) {
                this.iCreditByCourse = new HashMap<Long, Float>();
            }
            this.iCreditByCourse.put(course.getUniqueId(), credit);
        }
        this.iNameByCourse.put(-1L, clazz.getSectionNumberString(helper.getHibSession()));
        if (assignment != null) {
            this.iTime = new XTime(assignment, helper.getExactTimeConversion(), helper.getDatePatternFormat());
            for (Location room : assignment.getRooms()) {
                this.iRooms.add(new XRoom(room));
            }
        } else {
            for (RoomPref p : clazz.effectivePreferences(RoomPref.class)) {
                if (!PreferenceLevel.sRequired.equals(p.getPrefLevel().getPrefProlog())) continue;
                this.iRooms.add(new XRoom(p.getRoom()));
            }
            DatePattern dp = clazz.effectiveDatePattern();
            if (dp != null) {
                this.iTime = new XTime(dp, helper.getDatePatternFormat());
            }
        }
        for (ClassInstructor ci : clazz.getClassInstructors()) {
            this.iInstructors.add(new XInstructor(ci, helper));
        }
        for (TeachingClassRequest tcr : clazz.getTeachingRequests()) {
            if (tcr.isAssignInstructor().booleanValue() || !tcr.getTeachingRequest().isCommitted()) continue;
            for (DepartmentalInstructor di : tcr.getTeachingRequest().getAssignedInstructors()) {
                this.iInstructors.add(new XInstructor(di, tcr, helper));
            }
        }
        this.iOnline = true;
        if (assignment != null) {
            this.iOnline = true;
            for (Location loc : assignment.getRooms()) {
                if (loc.isIgnoreRoomCheck().booleanValue()) continue;
                this.iOnline = false;
                break;
            }
        }
        this.iPast = false;
    }

    public XSection(Section section) {
        this.iUniqueId = section.getId();
        this.iAllowOverlap = section.getSubpart().isAllowOverlap();
        this.iName = section.getName();
        this.iNameByCourse = section.getNameByCourse();
        this.iSubpartName = section.getSubpart().getName();
        this.iLimit = section.getLimit();
        this.iParentId = section.getParent() == null ? null : Long.valueOf(section.getParent().getId());
        this.iSubpartId = section.getSubpart().getId();
        this.iInstructionalType = section.getSubpart().getInstructionalType();
        this.iNote = section.getNote();
        this.iTime = section.getTime() == null ? null : new XTime(section.getTime());
        this.iCancelled = section.isCancelled();
        this.iOnline = section.isOnline();
        this.iEnabledForScheduling = section.isEnabled();
        this.iPast = section.isPast();
        if (section.getNameByCourse() != null) {
            for (Map.Entry e : section.getNameByCourse().entrySet()) {
                this.iNameByCourse.put((Long)e.getKey(), (String)e.getValue());
            }
        }
        if (section.getNrRooms() > 0) {
            for (RoomLocation room : section.getRooms()) {
                this.iRooms.add(new XRoom(room));
            }
        }
        HashSet<String> instructorExternalIds = new HashSet<String>();
        if (section.hasInstructors()) {
            for (Instructor instructor : section.getInstructors()) {
                this.iInstructors.add(new XInstructor(instructor.getId(), instructor.getExternalId(), instructor.getName(), instructor.getEmail(), true, false, true));
                if (instructor.getExternalId() == null) continue;
                instructorExternalIds.add(instructor.getExternalId());
            }
        }
        for (Unavailability u : section.getUnavailabilities()) {
            if (u.getId() != section.getId() || u.getStudent().getExternalId() == null || !instructorExternalIds.add(u.getStudent().getExternalId())) continue;
            this.iInstructors.add(new XInstructor(u.getStudent().getId(), u.getStudent().getExternalId(), u.getStudent().getName(), null, false, u.isAllowOverlap(), false));
        }
    }

    public XSection(XSection section) {
        this.iUniqueId = section.getSectionId();
        this.iName = section.getName();
        this.iNameByCourse = new HashMap<Long, String>(this.getNameByCourse());
        this.iSubpartId = section.getSubpartId();
        this.iParentId = section.getParentId();
        this.iLimit = section.getLimit();
        this.iNote = section.getNote();
        this.iTime = section.getTime() == null ? null : new XTime(section.getTime());
        for (XRoom room : section.getRooms()) {
            this.iRooms.add(new XRoom(room));
        }
        for (XInstructor instructor : section.getInstructors()) {
            this.iInstructors.add(new XInstructor(instructor));
        }
        this.iAllowOverlap = section.isAllowOverlap();
        this.iInstructionalType = section.getInstructionalType();
        this.iSubpartName = section.getSubpartName();
        this.iExternalId = section.iExternalId;
        this.iExternalIdByCourse = new HashMap<Long, String>(section.iExternalIdByCourse);
        this.iEnabledForScheduling = section.isEnabledForScheduling();
        this.iCancelled = section.isCancelled();
        this.iOnline = section.isOnline();
        this.iPast = section.isPast();
        this.iCreditByCourse = section.iCreditByCourse == null ? null : new HashMap<Long, Float>(section.iCreditByCourse);
    }

    @Deprecated
    public XSection(String externalId) {
        this.iExternalId = externalId;
    }

    public Long getSectionId() {
        return this.iUniqueId;
    }

    public int getLimit() {
        return this.iLimit;
    }

    public String getName() {
        return this.iName;
    }

    public Long getSubpartId() {
        return this.iSubpartId;
    }

    public Long getParentId() {
        return this.iParentId;
    }

    public XTime getTime() {
        return this.iTime;
    }

    public int getNrRooms() {
        return this.iRooms == null ? 0 : this.iRooms.size();
    }

    public List<XRoom> getRooms() {
        return this.iRooms;
    }

    public String toRoomString(String delim) {
        Object ret = "";
        for (XRoom room : this.iRooms) {
            if (!((String)ret).isEmpty()) {
                ret = (String)ret + delim;
            }
            ret = (String)ret + room.getName();
        }
        return ret;
    }

    public String toString() {
        return this.getSubpartName() + " " + this.getName() + " " + (this.getTime() == null ? "Arrange Hours" : this.getTime().toString()) + (String)(this.getNrRooms() == 0 ? "" : " " + this.toRoomString(", "));
    }

    public String toString(Long coruseId) {
        return this.getSubpartName() + " " + this.getName(coruseId) + " " + (this.getTime() == null ? "Arrange Hours" : this.getTime().toString()) + (String)(this.getNrRooms() == 0 ? "" : " " + this.toRoomString(", "));
    }

    public String getName(long courseId) {
        if (this.iNameByCourse == null) {
            return this.getName();
        }
        String name = this.iNameByCourse.get(courseId);
        return name == null ? this.getName() : name;
    }

    public String getExternalId(long courseId) {
        if (this.iExternalIdByCourse == null) {
            return this.iExternalId;
        }
        String externalId = this.iExternalIdByCourse.get(courseId);
        return externalId == null ? this.iExternalId : externalId;
    }

    public Float getCreditOverride(long courseId) {
        if (this.iCreditByCourse == null) {
            return null;
        }
        return this.iCreditByCourse.get(courseId);
    }

    public Map<Long, String> getNameByCourse() {
        return this.iNameByCourse;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XSection)) {
            return false;
        }
        return this.getSectionId().equals(((XSection)o).getSectionId());
    }

    public int hashCode() {
        return (int)(this.getSectionId() ^ this.getSectionId() >>> 32);
    }

    public String getNote() {
        return this.iNote;
    }

    public List<XInstructor> getAllInstructors() {
        return this.iInstructors;
    }

    public List<XInstructor> getInstructors() {
        ArrayList<XInstructor> instructors = new ArrayList<XInstructor>();
        for (XInstructor instructor : this.iInstructors) {
            if (!instructor.isAllowDisplay()) continue;
            instructors.add(instructor);
        }
        return instructors;
    }

    public XInstructor getInstructor(String externalId) {
        if (externalId == null) {
            return null;
        }
        for (XInstructor instructor : this.iInstructors) {
            if (!externalId.equals(instructor.getExternalId())) continue;
            return instructor;
        }
        return null;
    }

    @Deprecated
    public String getInstructorIds() {
        if (this.iInstructors == null || this.iInstructors.isEmpty()) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        for (XInstructor instructor : this.iInstructors) {
            if (ret.length() > 0) {
                ret.append(":");
            }
            ret.append(instructor.getIntructorId());
        }
        return ret.toString();
    }

    @Deprecated
    public String getInstructorNames() {
        if (this.iInstructors == null || this.iInstructors.isEmpty()) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        for (XInstructor instructor : this.iInstructors) {
            if (ret.length() > 0) {
                ret.append(":");
            }
            ret.append(instructor.getName() + "|" + (instructor.getEmail() == null ? "" : instructor.getEmail()));
        }
        return ret.toString();
    }

    public boolean isToIgnoreStudentConflictsWith(Collection<XDistribution> distributions, Long sectionId) {
        if (distributions == null) {
            return false;
        }
        for (XDistribution distribution : distributions) {
            if (distribution.getDistributionType() != XDistributionType.IngoreConflicts || !distribution.getSectionIds().contains(this.getSectionId()) || !distribution.getSectionIds().contains(sectionId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(XSection section) {
        return this.getSectionId().compareTo(section.getSectionId());
    }

    public int getDistanceInMinutes(DistanceMetric m, List<XRoom> other) {
        int dist = 0;
        for (XRoom r1 : this.getRooms()) {
            for (XRoom r2 : other) {
                dist = Math.max(dist, r1.getDistanceInMinutes(m, r2));
            }
        }
        return dist;
    }

    public int getDistanceInMinutes(XSection other, DistanceMetric m) {
        if (this.getNrRooms() == 0 || other.getNrRooms() == 0) {
            return 0;
        }
        XTime t1 = this.getTime();
        XTime t2 = other.getTime();
        if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
            return 0;
        }
        int a1 = t1.getSlot();
        int a2 = t2.getSlot();
        if (m.doComputeDistanceConflictsBetweenNonBTBClasses()) {
            int dist;
            if (a1 + t1.getLength() <= a2 && (dist = this.getDistanceInMinutes(m, other.getRooms())) > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength())) {
                return dist;
            }
        } else if (a1 + t1.getLength() == a2) {
            return this.getDistanceInMinutes(m, other.getRooms());
        }
        return 0;
    }

    public boolean isDistanceConflict(XStudent student, XSection other, DistanceMetric m) {
        if (this.getNrRooms() == 0 || other.getNrRooms() == 0) {
            return false;
        }
        XTime t1 = this.getTime();
        XTime t2 = other.getTime();
        if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
            return false;
        }
        int a1 = t1.getSlot();
        int a2 = t2.getSlot();
        if (student.hasAccomodation(m.getShortDistanceAccommodationReference())) {
            if (m.doComputeDistanceConflictsBetweenNonBTBClasses()) {
                if (a1 + t1.getLength() <= a2) {
                    int dist = this.getDistanceInMinutes(m, other.getRooms());
                    return dist > Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength());
                }
            } else if (a1 + t1.getLength() == a2) {
                return this.getDistanceInMinutes(m, other.getRooms()) > 0;
            }
        } else if (m.doComputeDistanceConflictsBetweenNonBTBClasses()) {
            if (a1 + t1.getLength() <= a2) {
                int dist = this.getDistanceInMinutes(m, other.getRooms());
                return dist > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength());
            }
        } else if (a1 + t1.getLength() == a2) {
            return this.getDistanceInMinutes(m, other.getRooms()) > t1.getBreakTime();
        }
        return false;
    }

    public boolean isLongDistanceConflict(XStudent student, XSection other, DistanceMetric m) {
        if (this.getNrRooms() == 0 || other.getNrRooms() == 0) {
            return false;
        }
        XTime t1 = this.getTime();
        XTime t2 = other.getTime();
        if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
            return false;
        }
        int a1 = t1.getSlot();
        int a2 = t2.getSlot();
        if (student.hasAccomodation(m.getShortDistanceAccommodationReference())) {
            if (m.doComputeDistanceConflictsBetweenNonBTBClasses()) {
                if (a1 + t1.getLength() <= a2) {
                    int dist = this.getDistanceInMinutes(m, other.getRooms());
                    return dist > Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength());
                }
            } else if (a1 + t1.getLength() == a2) {
                return this.getDistanceInMinutes(m, other.getRooms()) > 0;
            }
        } else if (m.doComputeDistanceConflictsBetweenNonBTBClasses()) {
            if (a1 + t1.getLength() <= a2) {
                int dist = this.getDistanceInMinutes(m, other.getRooms());
                return dist >= m.getDistanceLongLimitInMinutes() && dist > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength());
            }
        } else if (a1 + t1.getLength() == a2) {
            int dist = this.getDistanceInMinutes(m, other.getRooms());
            return dist >= m.getDistanceLongLimitInMinutes() && dist > t1.getBreakTime();
        }
        return false;
    }

    public boolean isHardDistanceConflict(XStudent student, XSection other, DistanceMetric m) {
        if (!m.isHardDistanceConflictsEnabled()) {
            return false;
        }
        if (this.getNrRooms() == 0 || other.getNrRooms() == 0) {
            return false;
        }
        XTime t1 = this.getTime();
        XTime t2 = other.getTime();
        if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
            return false;
        }
        int a1 = t1.getSlot();
        int a2 = t2.getSlot();
        if (m.doComputeDistanceConflictsBetweenNonBTBClasses()) {
            if (a1 + t1.getLength() <= a2) {
                int dist = this.getDistanceInMinutes(m, other.getRooms());
                return dist >= m.getDistanceHardLimitInMinutes() && dist > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength()) + m.getAllowedDistanceInMinutes();
            }
            if (a2 + t2.getLength() <= a1) {
                int dist = this.getDistanceInMinutes(m, other.getRooms());
                return dist >= m.getDistanceHardLimitInMinutes() && dist > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a1 - a2 - t2.getLength()) + m.getAllowedDistanceInMinutes();
            }
        } else {
            if (a1 + t1.getLength() == a2) {
                int dist = this.getDistanceInMinutes(m, other.getRooms());
                return dist >= m.getDistanceHardLimitInMinutes() && dist > t1.getBreakTime() + m.getAllowedDistanceInMinutes();
            }
            if (a1 == a2 + t2.getLength()) {
                int dist = this.getDistanceInMinutes(m, other.getRooms());
                return dist >= m.getDistanceHardLimitInMinutes() && dist > t2.getBreakTime() + m.getAllowedDistanceInMinutes();
            }
        }
        return false;
    }

    public boolean isUnavailabilityDistanceConflict(XStudent student, XSection other, DistanceMetric m) {
        if (this.getNrRooms() == 0 || other.getNrRooms() == 0) {
            return false;
        }
        XTime t1 = this.getTime();
        XTime t2 = other.getTime();
        if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
            return false;
        }
        int a1 = t1.getSlot();
        int a2 = t2.getSlot();
        if (a1 + t1.getLength() <= a2) {
            int dist = this.getDistanceInMinutes(m, other.getRooms());
            return dist > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength());
        }
        if (a2 + t2.getLength() <= a1) {
            int dist = this.getDistanceInMinutes(m, other.getRooms());
            return dist > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a1 - a2 - t2.getLength());
        }
        return false;
    }

    public boolean isUnavailabilityHardDistanceConflict(XStudent student, XSection other, DistanceMetric m) {
        if (!m.isHardDistanceConflictsEnabled()) {
            return false;
        }
        if (this.getNrRooms() == 0 || other.getNrRooms() == 0) {
            return false;
        }
        XTime t1 = this.getTime();
        XTime t2 = other.getTime();
        if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
            return false;
        }
        int a1 = t1.getSlot();
        int a2 = t2.getSlot();
        if (a1 + t1.getLength() <= a2) {
            int dist = this.getDistanceInMinutes(m, other.getRooms());
            return dist >= m.getDistanceHardLimitInMinutes() && dist > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength()) + m.getAllowedDistanceInMinutes();
        }
        if (a2 + t2.getLength() <= a1) {
            int dist = this.getDistanceInMinutes(m, other.getRooms());
            return dist >= m.getDistanceHardLimitInMinutes() && dist > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a1 - a2 - t2.getLength()) + m.getAllowedDistanceInMinutes();
        }
        return false;
    }

    public boolean isUnavailabilityLongDistanceConflict(XStudent student, XSection other, DistanceMetric m) {
        if (this.getNrRooms() == 0 || other.getNrRooms() == 0) {
            return false;
        }
        XTime t1 = this.getTime();
        XTime t2 = other.getTime();
        if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
            return false;
        }
        int a1 = t1.getSlot();
        int a2 = t2.getSlot();
        if (a1 + t1.getLength() <= a2) {
            int dist = this.getDistanceInMinutes(m, other.getRooms());
            return dist >= m.getDistanceLongLimitInMinutes() && dist > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength());
        }
        if (a2 + t2.getLength() <= a1) {
            int dist = this.getDistanceInMinutes(m, other.getRooms());
            return dist >= m.getDistanceLongLimitInMinutes() && dist > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a1 - a2 - t2.getLength());
        }
        return false;
    }

    public boolean isAllowOverlap() {
        return this.iAllowOverlap;
    }

    public String getSubpartName() {
        return this.iSubpartName;
    }

    public String getInstructionalType() {
        return this.iInstructionalType;
    }

    public boolean isEnabledForScheduling() {
        return this.iEnabledForScheduling;
    }

    public boolean isCancelled() {
        return this.iCancelled;
    }

    public boolean isOnline() {
        return this.iOnline;
    }

    public boolean isPast() {
        return this.iPast;
    }

    public boolean isEnabled(XStudent student, AcademicSessionInfo session) {
        if (!this.iEnabledForScheduling) {
            return false;
        }
        if (student != null && student.getModalityPreference() == Student.ModalityPreference.ONLINE_REQUIRED && !this.isOnline()) {
            return false;
        }
        if (student != null && this.getTime() != null) {
            if (student.getClassStartDate() != null) {
                int firstMeeting;
                if (this.getTime().getDays() != 0 && this.getTime().getFirstMeeting(session.getDayOfWeekOffset()) < student.getClassStartDate()) {
                    return false;
                }
                if (this.getTime().getDays() == 0 && (firstMeeting = this.getTime().getWeeks().nextSetBit(0)) >= 0 && firstMeeting < student.getClassStartDate()) {
                    return false;
                }
            }
            if (student.getClassEndDate() != null) {
                int lastMeeting;
                if (this.getTime().getDays() != 0 && this.getTime().getLastMeeting(session.getDayOfWeekOffset()) > student.getClassEndDate()) {
                    return false;
                }
                if (this.getTime().getDays() == 0 && (lastMeeting = this.getTime().getWeeks().length() - 1) >= 0 && lastMeeting > student.getClassEndDate()) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isOverlapping(Collection<XDistribution> distributions, XSection other) {
        if (this.isAllowOverlap() || other.isAllowOverlap()) {
            return false;
        }
        if (this.getTime() == null || other.getTime() == null) {
            return false;
        }
        if (this.isToIgnoreStudentConflictsWith(distributions, other.getSectionId())) {
            return false;
        }
        return this.getTime().hasIntersection(other.getTime());
    }

    public boolean isOverlapping(Collection<XDistribution> distributions, XSection other, boolean ignoreBreakTime) {
        if (this.isAllowOverlap() || other.isAllowOverlap()) {
            return false;
        }
        if (this.getTime() == null || other.getTime() == null) {
            return false;
        }
        if (this.isToIgnoreStudentConflictsWith(distributions, other.getSectionId())) {
            return false;
        }
        return this.getTime().hasIntersection(other.getTime(), ignoreBreakTime);
    }

    public boolean isOverlapping(Collection<XDistribution> distributions, Collection<XSection> assignments) {
        if (this.isAllowOverlap()) {
            return false;
        }
        if (this.getTime() == null || assignments == null) {
            return false;
        }
        for (XSection assignment : assignments) {
            if (assignment.isAllowOverlap() || assignment.getTime() == null || this.isToIgnoreStudentConflictsWith(distributions, assignment.getSectionId()) || !this.getTime().hasIntersection(assignment.getTime())) continue;
            return true;
        }
        return false;
    }

    public boolean isOverlapping(Collection<XDistribution> distributions, Collection<XSection> assignments, boolean ignoreBreakTime) {
        if (this.isAllowOverlap()) {
            return false;
        }
        if (this.getTime() == null || assignments == null) {
            return false;
        }
        for (XSection assignment : assignments) {
            if (assignment.isAllowOverlap() || assignment.getTime() == null || this.isToIgnoreStudentConflictsWith(distributions, assignment.getSectionId()) || !this.getTime().hasIntersection(assignment.getTime(), ignoreBreakTime)) continue;
            return true;
        }
        return false;
    }

    public Placement toPlacement() {
        if (this.getTime() == null) {
            return null;
        }
        ArrayList<RoomLocation> rooms = new ArrayList<RoomLocation>();
        for (XRoom r : this.getRooms()) {
            rooms.add(new RoomLocation(r.getUniqueId(), r.getName(), null, 0, 0, r.getX(), r.getY(), r.getIgnoreTooFar(), null));
        }
        return new Placement(new Lecture(this.getSectionId(), null, this.getSubpartId(), this.getName(), new ArrayList(), new ArrayList(), this.getNrRooms(), null, this.getLimit(), this.getLimit(), 1.0), this.getTime().toTimeLocation(), rooms);
    }

    public Placement toPlacement(int shiftDays) {
        if (this.getTime() == null) {
            return null;
        }
        ArrayList<RoomLocation> rooms = new ArrayList<RoomLocation>();
        for (XRoom r : this.getRooms()) {
            rooms.add(new RoomLocation(r.getUniqueId(), r.getName(), null, 0, 0, r.getX(), r.getY(), r.getIgnoreTooFar(), null));
        }
        return new Placement(new Lecture(this.getSectionId(), null, this.getSubpartId(), this.getName(), new ArrayList(), new ArrayList(), this.getNrRooms(), null, this.getLimit(), this.getLimit(), 1.0), this.getTime().toTimeLocation(shiftDays), rooms);
    }

    public List<Instructor> toInstructors() {
        if (this.getInstructors() == null || this.getInstructors().isEmpty()) {
            return null;
        }
        ArrayList<Instructor> instructors = new ArrayList<Instructor>();
        for (XInstructor instructor : this.getInstructors()) {
            instructors.add(new Instructor(instructor.getIntructorId().longValue(), instructor.getExternalId(), instructor.getName(), instructor.getEmail()));
        }
        return instructors;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iUniqueId = in.readLong();
        this.iName = (String)in.readObject();
        int nrNames = in.readInt();
        this.iNameByCourse.clear();
        for (int i = 0; i < nrNames; ++i) {
            this.iNameByCourse.put(in.readLong(), (String)in.readObject());
        }
        this.iSubpartId = in.readLong();
        this.iParentId = in.readLong();
        if (this.iParentId < 0L) {
            this.iParentId = null;
        }
        this.iLimit = in.readInt();
        this.iNote = (String)in.readObject();
        this.iTime = in.readBoolean() ? new XTime(in) : null;
        int nrRooms = in.readInt();
        this.iRooms.clear();
        for (int i = 0; i < nrRooms; ++i) {
            this.iRooms.add(new XRoom(in));
        }
        int nrInstructors = in.readInt();
        this.iInstructors.clear();
        for (int i = 0; i < nrInstructors; ++i) {
            this.iInstructors.add(new XInstructor(in));
        }
        this.iAllowOverlap = in.readBoolean();
        this.iInstructionalType = (String)in.readObject();
        this.iSubpartName = (String)in.readObject();
        this.iExternalId = (String)in.readObject();
        int nrExtIds = in.readInt();
        this.iExternalIdByCourse.clear();
        for (int i = 0; i < nrExtIds; ++i) {
            this.iExternalIdByCourse.put(in.readLong(), (String)in.readObject());
        }
        this.iEnabledForScheduling = in.readBoolean();
        this.iCancelled = in.readBoolean();
        this.iOnline = in.readBoolean();
        this.iPast = in.readBoolean();
        int nrCreditsByCourse = in.readInt();
        if (nrCreditsByCourse > 0) {
            this.iCreditByCourse = new HashMap<Long, Float>();
            for (int i = 0; i < nrExtIds; ++i) {
                this.iCreditByCourse.put(in.readLong(), Float.valueOf(in.readFloat()));
            }
        } else {
            this.iCreditByCourse = null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.iUniqueId);
        out.writeObject(this.iName);
        out.writeInt(this.iNameByCourse.size());
        for (Map.Entry<Long, String> entry : this.iNameByCourse.entrySet()) {
            out.writeLong(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.writeLong(this.iSubpartId);
        out.writeLong(this.iParentId == null ? -1L : this.iParentId);
        out.writeInt(this.iLimit);
        out.writeObject(this.iNote);
        out.writeBoolean(this.iTime != null);
        if (this.iTime != null) {
            this.iTime.writeExternal(out);
        }
        out.writeInt(this.iRooms.size());
        for (XRoom xRoom : this.iRooms) {
            xRoom.writeExternal(out);
        }
        out.writeInt(this.iInstructors.size());
        for (XInstructor xInstructor : this.iInstructors) {
            xInstructor.writeExternal(out);
        }
        out.writeBoolean(this.iAllowOverlap);
        out.writeObject(this.iInstructionalType);
        out.writeObject(this.iSubpartName);
        out.writeObject(this.iExternalId);
        out.writeInt(this.iExternalIdByCourse.size());
        for (Map.Entry entry : this.iExternalIdByCourse.entrySet()) {
            out.writeLong((Long)entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.writeBoolean(this.iEnabledForScheduling);
        out.writeBoolean(this.iCancelled);
        out.writeBoolean(this.iOnline);
        out.writeBoolean(this.iPast);
        if (this.iCreditByCourse != null) {
            out.writeInt(this.iCreditByCourse.size());
            for (Map.Entry entry : this.iCreditByCourse.entrySet()) {
                out.writeLong((Long)entry.getKey());
                out.writeFloat(((Float)entry.getValue()).floatValue());
            }
        } else {
            out.writeInt(0);
        }
    }
}

