/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.cpsolver.studentsct.model.Request;
import org.unitime.timetable.model.CourseDemand;

public abstract class XRequest
implements Serializable,
Comparable<XRequest>,
Externalizable {
    private static final long serialVersionUID = 1L;
    protected Long iRequestId = null;
    protected int iPriority = 0;
    protected boolean iAlternative = false;
    protected Long iStudentId;
    protected int iCritical = 0;

    public XRequest() {
    }

    public XRequest(CourseDemand demand) {
        this.iRequestId = demand.getUniqueId();
        this.iPriority = demand.getPriority();
        this.iAlternative = demand.isAlternative();
        this.iStudentId = demand.getStudent().getUniqueId();
        this.iCritical = demand.getEffectiveCritical().ordinal();
    }

    public XRequest(Request request) {
        this.iRequestId = request.getId();
        this.iPriority = request.getPriority();
        this.iAlternative = request.isAlternative();
        this.iStudentId = request.getStudent().getId();
        this.iCritical = CourseDemand.Critical.fromRequestPriority(request.getRequestPriority()).ordinal();
    }

    public XRequest(XRequest request) {
        this.iRequestId = request.getRequestId();
        this.iPriority = request.getPriority();
        this.iAlternative = request.isAlternative();
        this.iStudentId = request.getStudentId();
        this.iCritical = request.getCritical();
    }

    public Long getRequestId() {
        return this.iRequestId;
    }

    public int getPriority() {
        return this.iPriority;
    }

    public boolean isAlternative() {
        return this.iAlternative;
    }

    public void setAlternative(boolean alt) {
        this.iAlternative = alt;
    }

    public void setPriority(int priority) {
        this.iPriority = priority;
    }

    public void setCritical(int critical) {
        this.iCritical = critical;
    }

    public int getCritical() {
        return this.iCritical;
    }

    public boolean isCritical() {
        return this.iCritical > 0 && this.iCritical != 5;
    }

    public Request.RequestPriority getRequestPriority() {
        return CourseDemand.Critical.values()[this.iCritical].toRequestPriority();
    }

    public Long getStudentId() {
        return this.iStudentId;
    }

    public int hashCode() {
        return (int)(this.getRequestId() ^ this.getRequestId() >>> 32);
    }

    @Override
    public int compareTo(XRequest request) {
        return this.isAlternative() != request.isAlternative() ? (this.isAlternative() ? 1 : -1) : (this.getPriority() < request.getPriority() ? -1 : 1);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XRequest)) {
            return false;
        }
        return this.getRequestId().equals(((XRequest)o).getRequestId()) && this.getStudentId().equals(((XRequest)o).getStudentId());
    }

    public String toString() {
        return (this.isAlternative() ? "A" : "") + this.getPriority() + ".";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iRequestId = in.readLong();
        this.iPriority = in.readInt();
        this.iAlternative = in.readBoolean();
        this.iStudentId = in.readLong();
        this.iCritical = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.iRequestId);
        out.writeInt(this.iPriority);
        out.writeBoolean(this.iAlternative);
        out.writeLong(this.iStudentId);
        out.writeInt(this.iCritical);
    }
}

