/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.TeachingClassRequest;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.util.NameInterface;

public class XInstructor
implements Serializable,
Externalizable,
NameInterface {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalId;
    private String iName;
    private String iEmail;
    private boolean iAllowOverlap;
    private boolean iDisplay = true;
    private boolean iInstructing = false;
    private String iFName;
    private String iMName;
    private String iLName;
    private String iTitle;
    private Integer iPercentShare = null;
    private String iResponsibility = null;

    public XInstructor() {
    }

    public XInstructor(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XInstructor(ClassInstructor instructor, OnlineSectioningHelper helper) {
        this.iUniqueId = instructor.getInstructor().getUniqueId();
        this.iExternalId = instructor.getInstructor().getExternalUniqueId();
        this.iName = helper.getInstructorNameFormat().format(instructor.getInstructor());
        this.iEmail = instructor.getInstructor().getEmail();
        this.iDisplay = instructor.getClassInstructing().isDisplayInstructor() != false && (instructor.getResponsibility() == null || !instructor.getResponsibility().hasOption(TeachingResponsibility.Option.auxiliary));
        this.iAllowOverlap = instructor.isLead() == false;
        this.iInstructing = true;
        if (instructor.getTeachingRequest() != null) {
            for (TeachingClassRequest tcr : instructor.getTeachingRequest().getClassRequests()) {
                if (!tcr.getTeachingClass().equals(instructor.getClassInstructing())) continue;
                this.iAllowOverlap = tcr.isCanOverlap();
                break;
            }
        }
        this.iFName = instructor.getInstructor().getFirstName();
        this.iMName = instructor.getInstructor().getMiddleName();
        this.iLName = instructor.getInstructor().getLastName();
        this.iTitle = instructor.getInstructor().getAcademicTitle();
        this.iPercentShare = instructor.getPercentShare();
        this.iResponsibility = instructor.getResponsibility() == null ? null : instructor.getResponsibility().getLabel();
    }

    public XInstructor(DepartmentalInstructor instructor, TeachingClassRequest tcr, OnlineSectioningHelper helper) {
        this.iUniqueId = instructor.getUniqueId();
        this.iExternalId = instructor.getExternalUniqueId();
        this.iName = helper.getInstructorNameFormat().format(instructor);
        this.iEmail = instructor.getEmail();
        this.iDisplay = false;
        this.iAllowOverlap = tcr.isCanOverlap();
        this.iInstructing = false;
        this.iFName = instructor.getFirstName();
        this.iMName = instructor.getMiddleName();
        this.iLName = instructor.getLastName();
        this.iTitle = instructor.getAcademicTitle();
    }

    public XInstructor(Long uniqueId, String externalId, String name, String email, boolean display, boolean allowOverlap, boolean instructing) {
        this.iUniqueId = uniqueId;
        this.iExternalId = externalId;
        this.iName = name;
        this.iEmail = email;
        this.iDisplay = display;
        this.iAllowOverlap = allowOverlap;
        this.iInstructing = instructing;
    }

    public XInstructor(XInstructor instructor) {
        this.iUniqueId = instructor.getIntructorId();
        this.iExternalId = instructor.getExternalId();
        this.iName = instructor.getName();
        this.iEmail = instructor.getEmail();
        this.iAllowOverlap = instructor.isAllowOverlap();
        this.iDisplay = instructor.isAllowDisplay();
        this.iInstructing = instructor.isInstructing();
        this.iFName = instructor.getFirstName();
        this.iMName = instructor.getMiddleName();
        this.iLName = instructor.getLastName();
        this.iTitle = instructor.getAcademicTitle();
        this.iPercentShare = instructor.getPercentShare();
        this.iResponsibility = instructor.getResponsibility();
    }

    public Long getIntructorId() {
        return this.iUniqueId;
    }

    public String getExternalId() {
        return this.iExternalId;
    }

    public boolean hasExternalId() {
        return this.iExternalId != null && !this.iExternalId.isEmpty();
    }

    public String getName() {
        return this.iName;
    }

    public String getEmail() {
        return this.iEmail;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isAllowOverlap() {
        return this.iAllowOverlap;
    }

    public boolean isAllowDisplay() {
        return this.iDisplay;
    }

    public boolean isInstructing() {
        return this.iInstructing;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XInstructor)) {
            return false;
        }
        return this.getIntructorId().equals(((XInstructor)o).getIntructorId());
    }

    public int hashCode() {
        return Long.valueOf(this.getIntructorId()).hashCode();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iUniqueId = in.readLong();
        this.iExternalId = (String)in.readObject();
        this.iName = (String)in.readObject();
        this.iEmail = (String)in.readObject();
        this.iAllowOverlap = in.readBoolean();
        this.iDisplay = in.readBoolean();
        this.iInstructing = in.readBoolean();
        this.iFName = (String)in.readObject();
        this.iMName = (String)in.readObject();
        this.iLName = (String)in.readObject();
        this.iTitle = (String)in.readObject();
        this.iPercentShare = in.readBoolean() ? Integer.valueOf(in.readInt()) : null;
        this.iResponsibility = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.iUniqueId);
        out.writeObject(this.iExternalId);
        out.writeObject(this.iName);
        out.writeObject(this.iEmail);
        out.writeBoolean(this.iAllowOverlap);
        out.writeBoolean(this.iDisplay);
        out.writeBoolean(this.iInstructing);
        out.writeObject(this.iFName);
        out.writeObject(this.iMName);
        out.writeObject(this.iLName);
        out.writeObject(this.iTitle);
        if (this.iPercentShare == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.iPercentShare);
        }
        out.writeObject(this.iResponsibility);
    }

    @Override
    public String getFirstName() {
        return this.iFName;
    }

    @Override
    public String getMiddleName() {
        return this.iMName;
    }

    @Override
    public String getLastName() {
        return this.iLName;
    }

    @Override
    public String getAcademicTitle() {
        return this.iTitle;
    }

    @Override
    public String getExternalUniqueId() {
        return this.iExternalId;
    }

    public Integer getPercentShare() {
        return this.iPercentShare;
    }

    public String getResponsibility() {
        return this.iResponsibility;
    }
}

