/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cpsolver.studentsct.reservation.CurriculumOverride;
import org.cpsolver.studentsct.reservation.Reservation;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.CurriculumOverrideReservation;
import org.unitime.timetable.model.CurriculumReservation;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMajorConcentration;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.onlinesectioning.model.XAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XReservationType;
import org.unitime.timetable.onlinesectioning.model.XStudent;

public class XCurriculumReservation
extends XReservation {
    private static final long serialVersionUID = 1L;
    private int iLimit;
    private Set<String> iAcadAreas = new HashSet<String>();
    private Set<String> iClassifications = new HashSet<String>();
    private Set<String> iMajors = new HashSet<String>();
    private Set<String> iMinors = new HashSet<String>();
    private Map<String, Set<String>> iConcentrations = new HashMap<String, Set<String>>();
    private Boolean iExpired;
    private boolean iOverride = false;

    public XCurriculumReservation() {
    }

    public XCurriculumReservation(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XCurriculumReservation(XOffering offering, CurriculumReservation reservation) {
        super(XReservationType.Curriculum, offering, reservation);
        this.iLimit = reservation.getLimit() == null ? -1 : reservation.getLimit();
        for (AcademicArea area : reservation.getAreas()) {
            this.iAcadAreas.add(area.getAcademicAreaAbbreviation());
        }
        for (AcademicClassification clasf : reservation.getClassifications()) {
            this.iClassifications.add(clasf.getCode());
        }
        for (PosMajor major : reservation.getMajors()) {
            this.iMajors.add(major.getCode());
        }
        for (PosMinor minor : reservation.getMinors()) {
            this.iMinors.add(minor.getCode());
        }
        for (PosMajorConcentration conc : reservation.getConcentrations()) {
            Set<String> concentrations = this.iConcentrations.get(conc.getMajor().getCode());
            if (concentrations == null) {
                concentrations = new HashSet<String>();
                this.iConcentrations.put(conc.getMajor().getCode(), concentrations);
            }
            concentrations.add(conc.getCode());
        }
    }

    public XCurriculumReservation(XOffering offering, CurriculumOverrideReservation reservation) {
        super(XReservationType.CurriculumOverride, offering, reservation);
        this.iLimit = reservation.getLimit() == null ? -1 : reservation.getLimit();
        for (AcademicArea area : reservation.getAreas()) {
            this.iAcadAreas.add(area.getAcademicAreaAbbreviation());
        }
        for (AcademicClassification clasf : reservation.getClassifications()) {
            this.iClassifications.add(clasf.getCode());
        }
        for (PosMajor major : reservation.getMajors()) {
            this.iMajors.add(major.getCode());
        }
        for (PosMinor minor : reservation.getMinors()) {
            this.iMinors.add(minor.getCode());
        }
        for (PosMajorConcentration conc : reservation.getConcentrations()) {
            Set<String> concentrations = this.iConcentrations.get(conc.getMajor().getCode());
            if (concentrations == null) {
                concentrations = new HashSet<String>();
                this.iConcentrations.put(conc.getMajor().getCode(), concentrations);
            }
            concentrations.add(conc.getCode());
        }
        this.iOverride = reservation.isAlwaysExpired();
        this.setMustBeUsed(reservation.isMustBeUsed());
        this.setAllowOverlap(reservation.isAllowOverlap());
        this.setCanAssignOverLimit(reservation.isCanAssignOverLimit());
        if (reservation.isAlwaysExpired()) {
            this.iExpired = true;
        } else {
            this.iType = XReservationType.Curriculum;
        }
    }

    public XCurriculumReservation(org.cpsolver.studentsct.reservation.CurriculumReservation reservation) {
        super(XReservationType.Curriculum, (Reservation)reservation);
        this.iLimit = (int)Math.round(reservation.getReservationLimit());
        if (reservation.getAcademicAreas() != null) {
            this.iAcadAreas.addAll(reservation.getAcademicAreas());
        }
        if (reservation.getClassifications() != null) {
            this.iClassifications.addAll(reservation.getClassifications());
        }
        if (reservation.getMajors() != null) {
            this.iMajors.addAll(reservation.getMajors());
        }
        if (reservation.getMinors() != null) {
            this.iMinors.addAll(reservation.getMinors());
        }
        for (String major : reservation.getMajors()) {
            Set concentrations = reservation.getConcentrations(major);
            if (concentrations == null) continue;
            this.iConcentrations.put(major, new HashSet(concentrations));
        }
    }

    public XCurriculumReservation(CurriculumOverride reservation) {
        super(XReservationType.CurriculumOverride, (Reservation)reservation);
        this.iLimit = (int)Math.round(reservation.getReservationLimit());
        if (reservation.getAcademicAreas() != null) {
            this.iAcadAreas.addAll(reservation.getAcademicAreas());
        }
        if (reservation.getClassifications() != null) {
            this.iClassifications.addAll(reservation.getClassifications());
        }
        if (reservation.getMajors() != null) {
            this.iMajors.addAll(reservation.getMajors());
        }
        if (reservation.getMinors() != null) {
            this.iMinors.addAll(reservation.getMinors());
        }
        for (String major : reservation.getMajors()) {
            Set concentrations = reservation.getConcentrations(major);
            if (concentrations == null) continue;
            this.iConcentrations.put(major, new HashSet(concentrations));
        }
        this.iOverride = true;
    }

    @Override
    public int getReservationLimit() {
        return this.iLimit;
    }

    public Set<String> getAcademicAreas() {
        return this.iAcadAreas;
    }

    public Set<String> getMajors() {
        return this.iMajors;
    }

    public Set<String> getMinors() {
        return this.iMinors;
    }

    public Set<String> getClassifications() {
        return this.iClassifications;
    }

    public Set<String> getConcentrations(String major) {
        return this.iConcentrations.get(major);
    }

    @Override
    public boolean isOverride() {
        return this.iOverride;
    }

    @Override
    public boolean isExpired() {
        return this.getType() == XReservationType.CurriculumOverride && this.iExpired != null ? this.iExpired.booleanValue() : super.isExpired();
    }

    @Override
    public boolean isAlwaysExpired() {
        return this.getType() == XReservationType.CurriculumOverride && this.iExpired != null && this.iExpired != false;
    }

    @Override
    public boolean isApplicable(XStudent student, XCourseId course) {
        if (!this.getMajors().isEmpty() || this.getMinors().isEmpty()) {
            for (XAreaClassificationMajor acm : student.getMajors()) {
                if (!this.getAcademicAreas().contains(acm.getArea()) || !this.getClassifications().isEmpty() && !this.getClassifications().contains(acm.getClassification()) || !this.getMajors().isEmpty() && !this.getMajors().contains(acm.getMajor())) continue;
                Set<String> conc = this.iConcentrations.get(acm.getMajor());
                if (conc != null && !conc.isEmpty()) {
                    return acm.getConcentration() != null && conc.contains(acm.getConcentration());
                }
                return true;
            }
        }
        if (!this.getMinors().isEmpty()) {
            for (XAreaClassificationMajor acm : student.getMinors()) {
                if (!this.getAcademicAreas().contains(acm.getArea()) || !this.getClassifications().isEmpty() && !this.getClassifications().contains(acm.getClassification()) || !this.getMinors().contains(acm.getMajor())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int nrAcadAreas = in.readInt();
        this.iAcadAreas.clear();
        for (int i = 0; i < nrAcadAreas; ++i) {
            this.iAcadAreas.add((String)in.readObject());
        }
        int nrClassifications = in.readInt();
        this.iClassifications.clear();
        for (int i = 0; i < nrClassifications; ++i) {
            this.iClassifications.add((String)in.readObject());
        }
        int nrMajors = in.readInt();
        this.iMajors.clear();
        for (int i = 0; i < nrMajors; ++i) {
            this.iMajors.add((String)in.readObject());
        }
        int nrMinors = in.readInt();
        this.iMinors.clear();
        for (int i = 0; i < nrMinors; ++i) {
            this.iMinors.add((String)in.readObject());
        }
        this.iLimit = in.readInt();
        if (this.getType() == XReservationType.CurriculumOverride) {
            switch (in.readByte()) {
                case 0: {
                    this.iExpired = false;
                    break;
                }
                case 1: {
                    this.iExpired = true;
                    break;
                }
                default: {
                    this.iExpired = null;
                }
            }
            this.iOverride = in.readBoolean();
        } else {
            this.iExpired = null;
            this.iOverride = false;
        }
        this.iConcentrations = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.iAcadAreas.size());
        for (String area : this.iAcadAreas) {
            out.writeObject(area);
        }
        out.writeInt(this.iClassifications.size());
        for (String clasf : this.iClassifications) {
            out.writeObject(clasf);
        }
        out.writeInt(this.iMajors.size());
        for (String major : this.iMajors) {
            out.writeObject(major);
        }
        out.writeInt(this.iMinors.size());
        for (String minor : this.iMinors) {
            out.writeObject(minor);
        }
        out.writeInt(this.iLimit);
        if (this.getType() == XReservationType.CurriculumOverride) {
            out.writeByte(this.iExpired == null ? 2 : (this.iExpired != false ? 1 : 0));
            out.writeBoolean(this.iOverride);
        }
        out.writeObject(this.iConcentrations);
    }
}

