/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.model.AdvisorClassPref;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.AdvisorInstrMthPref;
import org.unitime.timetable.model.AdvisorSectioningPref;
import org.unitime.timetable.model.ClassWaitList;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.CourseRequestOption;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentClassPref;
import org.unitime.timetable.model.StudentEnrollmentMessage;
import org.unitime.timetable.model.StudentInstrMthPref;
import org.unitime.timetable.model.StudentSectioningPref;
import org.unitime.timetable.model.base.BaseStudentEnrollmentMessage;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XOverride;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.model.XWaitListedSection;

public class XCourseRequest
extends XRequest {
    private static final long serialVersionUID = 1L;
    private List<XCourseId> iCourseIds = new ArrayList<XCourseId>();
    private boolean iWaitlist = false;
    private boolean iNoSub = false;
    private Date iTimeStamp = null;
    private XEnrollment iEnrollment = null;
    private Map<XCourseId, List<XWaitListedSection>> iSectionWaitlist = null;
    private Map<XCourseId, byte[]> iOptions = null;
    private Map<XCourseId, List<XPreference>> iPreferences = null;
    private String iMessage = null;
    private Map<XCourseId, XOverride> iOverrides = null;
    private Date iWaitListedTimeStamp = null;
    private XCourseId iWaitListSwapWithCourseOffering = null;

    public XCourseRequest() {
    }

    public XCourseRequest(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XCourseRequest(CourseDemand demand, OnlineSectioningHelper helper) {
        super(demand);
        List<StudentClassEnrollment> enrl;
        TreeSet<org.unitime.timetable.model.CourseRequest> crs = new TreeSet<org.unitime.timetable.model.CourseRequest>(new Comparator<org.unitime.timetable.model.CourseRequest>(){

            @Override
            public int compare(org.unitime.timetable.model.CourseRequest r1, org.unitime.timetable.model.CourseRequest r2) {
                return r1.getOrder().compareTo(r2.getOrder());
            }
        });
        crs.addAll(demand.getCourseRequests());
        for (org.unitime.timetable.model.CourseRequest cr : crs) {
            XCourseId courseId = new XCourseId(cr.getCourseOffering());
            this.iCourseIds.add(courseId);
            if (cr.getClassWaitLists() != null) {
                for (ClassWaitList cwl : cr.getClassWaitLists()) {
                    List<XWaitListedSection> sections;
                    if (this.iSectionWaitlist == null) {
                        this.iSectionWaitlist = new HashMap<XCourseId, List<XWaitListedSection>>();
                    }
                    if ((sections = this.iSectionWaitlist.get(courseId)) == null) {
                        sections = new ArrayList<XWaitListedSection>();
                        this.iSectionWaitlist.put(courseId, sections);
                    }
                    sections.add(new XWaitListedSection(cwl, helper));
                }
            }
            for (CourseRequestOption option : cr.getCourseRequestOptions()) {
                if (OnlineSectioningLog.CourseRequestOption.OptionType.ORIGINAL_ENROLLMENT.getNumber() != option.getOptionType().intValue()) continue;
                if (this.iOptions == null) {
                    this.iOptions = new HashMap<XCourseId, byte[]>();
                }
                this.iOptions.put(courseId, option.getValue());
            }
            if (cr.getOverrideExternalId() != null) {
                if (this.iOverrides == null) {
                    this.iOverrides = new HashMap<XCourseId, XOverride>();
                }
                this.iOverrides.put(courseId, new XOverride(cr.getOverrideExternalId(), cr.getOverrideTimeStamp(), cr.getOverrideStatus()));
            }
            if (cr.getPreferences() == null || cr.getPreferences().isEmpty()) continue;
            ArrayList<XPreference> prefs = new ArrayList<XPreference>();
            for (StudentSectioningPref p : cr.getPreferences()) {
                prefs.add(new XPreference(cr, p));
            }
            if (this.iPreferences == null) {
                this.iPreferences = new HashMap<XCourseId, List<XPreference>>();
            }
            this.iPreferences.put(courseId, prefs);
        }
        if (helper.isAlternativeCourseEnabled() && crs.size() == 1 && !demand.isAlternative().booleanValue()) {
            CourseOffering co = crs.first().getCourseOffering();
            CourseOffering alternative = co.getAlternativeOffering();
            if (alternative != null) {
                for (CourseDemand d : demand.getStudent().getCourseDemands()) {
                    if (d.getFreeTime() != null) continue;
                    for (org.unitime.timetable.model.CourseRequest r : d.getCourseRequests()) {
                        if (alternative.equals(r.getCourseOffering())) {
                            alternative = null;
                            break;
                        }
                        if (d.isAlternative().booleanValue() || d.getPriority() >= demand.getPriority() || d.getCourseRequests().size() != 1 || !alternative.equals(r.getCourseOffering().getAlternativeOffering())) continue;
                        alternative = null;
                        break;
                    }
                    if (alternative != null) continue;
                    break;
                }
            }
            if (alternative != null) {
                this.iCourseIds.add(new XCourseId(alternative));
                enrl = alternative.getClassEnrollments(demand.getStudent());
                if (!enrl.isEmpty()) {
                    this.iEnrollment = new XEnrollment(demand.getStudent(), alternative, helper, enrl);
                }
            }
        }
        this.iWaitlist = demand.isWaitlist() != null && demand.isWaitlist() != false;
        this.iNoSub = demand.isNoSub() != null && demand.isNoSub() != false;
        this.iTimeStamp = demand.getTimestamp() == null ? new Date() : demand.getTimestamp();
        this.iWaitListedTimeStamp = demand.getWaitlistedTimeStamp();
        for (org.unitime.timetable.model.CourseRequest cr : crs) {
            enrl = cr.getClassEnrollments();
            if (enrl.isEmpty()) continue;
            this.iEnrollment = new XEnrollment(demand.getStudent(), cr.getCourseOffering(), helper, enrl);
            break;
        }
        if (demand.getEnrollmentMessages() != null) {
            BaseStudentEnrollmentMessage message = null;
            for (StudentEnrollmentMessage m : demand.getEnrollmentMessages()) {
                if (message != null && message.getOrder() >= m.getOrder() && (message.getOrder() != m.getOrder() || !message.getTimestamp().before(m.getTimestamp()))) continue;
                message = m;
            }
            if (message != null) {
                this.iMessage = message.getMessage();
            }
        }
        if (demand.getWaitListSwapWithCourseOffering() != null) {
            this.iWaitListSwapWithCourseOffering = new XCourseId(demand.getWaitListSwapWithCourseOffering());
        }
    }

    public XCourseRequest(Student student, CourseOffering course, int priority, OnlineSectioningHelper helper, Collection<StudentClassEnrollment> classes) {
        this.iStudentId = student.getUniqueId();
        this.iRequestId = -course.getUniqueId().longValue();
        this.iAlternative = false;
        this.iPriority = priority;
        this.iCourseIds.add(new XCourseId(course));
        this.iWaitlist = false;
        this.iNoSub = false;
        if (classes != null && !classes.isEmpty()) {
            this.iEnrollment = new XEnrollment(student, course, helper, classes);
        }
        this.iTimeStamp = this.iEnrollment != null ? this.iEnrollment.getTimeStamp() : new Date();
    }

    public XCourseRequest(org.unitime.timetable.model.CourseRequest cr, OnlineSectioningHelper helper, Collection<StudentClassEnrollment> classes) {
        this(cr.getCourseDemand().getStudent(), cr.getCourseOffering(), cr.getOrder(), helper, classes);
        if (cr.getPreferences() != null && !cr.getPreferences().isEmpty()) {
            ArrayList<XPreference> prefs = new ArrayList<XPreference>();
            for (StudentSectioningPref p : cr.getPreferences()) {
                prefs.add(new XPreference(cr, p));
            }
            this.iPreferences = new HashMap<XCourseId, List<XPreference>>();
            this.iPreferences.put(new XCourseId(cr.getCourseOffering()), prefs);
        }
    }

    public XCourseRequest(Student student, XCourseId course, int priority, XEnrollment enrollment) {
        this.iStudentId = student.getUniqueId();
        this.iRequestId = -course.getCourseId().longValue();
        this.iAlternative = false;
        this.iPriority = priority;
        this.iCourseIds.add(course);
        this.iWaitlist = false;
        this.iNoSub = false;
        this.iEnrollment = enrollment;
        this.iTimeStamp = this.iEnrollment != null ? this.iEnrollment.getTimeStamp() : new Date();
    }

    public XCourseRequest(XStudent student, XCourseId course, CourseRequestInterface.RequestedCourse rc) {
        this.iStudentId = student.getStudentId();
        this.iRequestId = -course.getCourseId().longValue();
        this.iAlternative = false;
        this.iPriority = student.getRequests().size();
        this.iCourseIds.add(course);
        this.iWaitlist = false;
        this.iNoSub = false;
        this.iTimeStamp = new Date();
        if (rc != null) {
            ArrayList<XPreference> prefs = new ArrayList<XPreference>();
            if (rc.hasSelectedClasses()) {
                for (CourseRequestInterface.Preference p : rc.getSelectedClasses()) {
                    prefs.add(new XPreference(p, XPreferenceType.SECTION));
                }
            }
            if (rc.hasSelectedIntructionalMethods()) {
                for (CourseRequestInterface.Preference p : rc.getSelectedIntructionalMethods()) {
                    prefs.add(new XPreference(p, XPreferenceType.INSTR_METHOD));
                }
            }
            if (!prefs.isEmpty()) {
                this.iPreferences = new HashMap<XCourseId, List<XPreference>>();
                this.iPreferences.put(course, prefs);
            }
        }
    }

    public XCourseRequest(XCourseRequest request, XEnrollment enrollment) {
        super(request);
        this.iCourseIds.addAll(request.getCourseIds());
        this.iWaitlist = request.isWaitlist();
        this.iNoSub = request.isNoSub();
        this.iTimeStamp = request.getTimeStamp();
        this.iWaitListedTimeStamp = request.getWaitListedTimeStamp();
        this.iEnrollment = enrollment;
        if (request.iSectionWaitlist != null) {
            this.iSectionWaitlist = new HashMap<XCourseId, List<XWaitListedSection>>(request.iSectionWaitlist);
        }
        if (request.iOptions != null) {
            this.iOptions = new HashMap<XCourseId, byte[]>(request.iOptions);
        }
        if (request.iPreferences != null) {
            this.iPreferences = new HashMap<XCourseId, List<XPreference>>(request.iPreferences);
        }
        if (request.iOverrides != null) {
            this.iOverrides = new HashMap<XCourseId, XOverride>(request.iOverrides);
        }
        this.iMessage = request.getEnrollmentMessage();
    }

    public XCourseRequest(CourseRequest request, Enrollment enrollment) {
        super((Request)request);
        for (Course course : request.getCourses()) {
            this.iCourseIds.add(new XCourseId(course));
        }
        this.iWaitlist = request.isWaitlist();
        this.iNoSub = request.isWaitlist();
        this.iTimeStamp = request.getTimeStamp() == null ? null : new Date(request.getTimeStamp());
        this.iWaitListedTimeStamp = request.isWaitlist() ? new Date() : null;
        XEnrollment xEnrollment = this.iEnrollment = enrollment == null ? null : new XEnrollment(enrollment);
        if (!request.getSelectedChoices().isEmpty() || !request.getRequiredChoices().isEmpty()) {
            for (Course course : request.getCourses()) {
                Object section;
                ArrayList<XPreference> prefs = new ArrayList<XPreference>();
                HashSet<Long> im = new HashSet<Long>();
                for (Choice choice : request.getSelectedChoices()) {
                    if (!course.getOffering().equals((Object)choice.getOffering())) continue;
                    if (choice.getSectionId() != null) {
                        section = choice.getOffering().getSection(choice.getSectionId().longValue());
                        if (section == null) continue;
                        prefs.add(new XPreference((Section)section, course, false));
                        continue;
                    }
                    if (choice.getConfigId() == null) continue;
                    for (Config config : choice.getOffering().getConfigs()) {
                        if (!choice.getConfigId().equals(config.getId()) || config.getInstructionalMethodId() == null || !im.add(config.getInstructionalMethodId())) continue;
                        prefs.add(new XPreference(XPreferenceType.INSTR_METHOD, config.getInstructionalMethodId(), config.getInstructionalMethodName(), false));
                    }
                }
                for (Choice choice : request.getRequiredChoices()) {
                    if (!course.getOffering().equals((Object)choice.getOffering())) continue;
                    if (choice.getSectionId() != null) {
                        section = choice.getOffering().getSection(choice.getSectionId().longValue());
                        if (section == null) continue;
                        prefs.add(new XPreference((Section)section, course, true));
                        continue;
                    }
                    if (choice.getConfigId() == null) continue;
                    for (Config config : choice.getOffering().getConfigs()) {
                        if (!choice.getConfigId().equals(config.getId()) || config.getInstructionalMethodId() == null || !im.add(config.getInstructionalMethodId())) continue;
                        prefs.add(new XPreference(XPreferenceType.INSTR_METHOD, config.getInstructionalMethodId(), config.getInstructionalMethodName(), true));
                    }
                }
                if (prefs.isEmpty()) continue;
                if (this.iPreferences == null) {
                    this.iPreferences = new HashMap<XCourseId, List<XPreference>>();
                }
                this.iPreferences.put(new XCourseId(course), prefs);
            }
        }
    }

    public List<XCourseId> getCourseIds() {
        return this.iCourseIds;
    }

    public int getIndex(XOffering offering) {
        for (int i = 0; i < this.iCourseIds.size(); ++i) {
            if (!this.iCourseIds.get(i).getOfferingId().equals(offering.getOfferingId())) continue;
            return i;
        }
        return -1;
    }

    public XCourseId getWaitListSwapWithCourseOffering() {
        return this.iWaitListSwapWithCourseOffering;
    }

    public void setWaitListSwapWithCourseOffering(XCourseId courseId) {
        this.iWaitListSwapWithCourseOffering = courseId;
    }

    public boolean isDuplicateOffering(XCourseId id) {
        for (XCourseId other : this.iCourseIds) {
            if (other.equals(id)) {
                return false;
            }
            if (!id.getOfferingId().equals(other.getOfferingId())) continue;
            return true;
        }
        return false;
    }

    public boolean hasCourse(Long courseId) {
        for (XCourseId id : this.iCourseIds) {
            if (!id.getCourseId().equals(courseId)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCourseName(String course) {
        for (XCourseId id : this.iCourseIds) {
            if (!id.getCourseName().equals(course)) continue;
            return true;
        }
        return false;
    }

    public XCourseId getCourseName(String course) {
        for (XCourseId id : this.iCourseIds) {
            if (!id.getCourseName().equals(course)) continue;
            return id;
        }
        return null;
    }

    public boolean isPrimary(Long courseId) {
        return !this.iCourseIds.isEmpty() && this.iCourseIds.get(0).getCourseId().equals(courseId);
    }

    public boolean isPrimary(XCourseId courseId) {
        return !this.iCourseIds.isEmpty() && this.iCourseIds.get(0).equals(courseId);
    }

    public Integer getEnrolledCourseIndex() {
        if (this.iEnrollment == null) {
            return null;
        }
        for (int i = 0; i < this.iCourseIds.size(); ++i) {
            if (!this.iCourseIds.get(i).getCourseId().equals(this.iEnrollment.getCourseId())) continue;
            return i;
        }
        return -1;
    }

    public XCourseId getCourseIdByOfferingId(Long offeringId) {
        for (XCourseId id : this.iCourseIds) {
            if (!id.getOfferingId().equals(offeringId)) continue;
            return id;
        }
        return null;
    }

    public boolean isWaitlist() {
        return this.iWaitlist;
    }

    public boolean isWaitlist(Set<Long> advisorWaitListedCourseIds) {
        if (this.iWaitlist) {
            return true;
        }
        if (advisorWaitListedCourseIds != null) {
            for (XCourseId id : this.iCourseIds) {
                if (!advisorWaitListedCourseIds.contains(id.getCourseId())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNoSub() {
        return this.iNoSub;
    }

    public boolean isWaitlist(OnlineSectioningInterface.WaitListMode wlMode) {
        return wlMode == OnlineSectioningInterface.WaitListMode.WaitList && this.iWaitlist;
    }

    public boolean isNoSub(OnlineSectioningInterface.WaitListMode wlMode) {
        return wlMode == OnlineSectioningInterface.WaitListMode.NoSubs && this.iNoSub;
    }

    public boolean isWaitListOrNoSub(OnlineSectioningInterface.WaitListMode mode) {
        if (mode == null) {
            return false;
        }
        switch (mode) {
            case NoSubs: {
                return this.iNoSub;
            }
            case WaitList: {
                return this.iWaitlist;
            }
        }
        return false;
    }

    public boolean isWaitListOrNoSub(OnlineSectioningInterface.WaitListMode mode, Set<Long> advisorWaitListedCourseIds) {
        if (this.isWaitListOrNoSub(mode)) {
            return true;
        }
        if (advisorWaitListedCourseIds != null) {
            for (XCourseId id : this.iCourseIds) {
                if (!advisorWaitListedCourseIds.contains(id.getCourseId())) continue;
                return true;
            }
        }
        return false;
    }

    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    public Date getWaitListedTimeStamp() {
        return this.iWaitListedTimeStamp;
    }

    public void setWaitListedTimeStamp(Date ts) {
        this.iWaitListedTimeStamp = ts;
    }

    public XEnrollment getEnrollment() {
        return this.iEnrollment;
    }

    public void setEnrollment(XEnrollment enrollment) {
        this.iEnrollment = enrollment;
    }

    public void setWaitlist(boolean waitlist) {
        this.iWaitlist = waitlist;
    }

    public void setNoSub(boolean noSub) {
        this.iNoSub = noSub;
    }

    public boolean hasSectionWaitlist(XCourseId courseId) {
        List<XWaitListedSection> sections = this.getSectionWaitlist(courseId);
        return sections != null && !sections.isEmpty();
    }

    public List<XWaitListedSection> getSectionWaitlist(XCourseId courseId) {
        return this.iSectionWaitlist == null ? null : this.iSectionWaitlist.get(courseId);
    }

    public XOverride getOverride(XCourseId courseId) {
        return this.iOverrides == null ? null : this.iOverrides.get(courseId);
    }

    public void setOverride(XCourseId courseId, XOverride override) {
        if (this.iOverrides == null) {
            this.iOverrides = new HashMap<XCourseId, XOverride>();
        }
        if (override == null) {
            this.iOverrides.remove(courseId);
        } else {
            this.iOverrides.put(courseId, override);
        }
    }

    public boolean hasOverrides() {
        return this.iOverrides != null && !this.iOverrides.isEmpty();
    }

    public Map<XCourseId, XOverride> getOverrides() {
        return this.iOverrides;
    }

    public Integer getOverrideStatus(XCourseId courseId) {
        XOverride override = this.iOverrides == null ? null : this.iOverrides.get(courseId);
        return override == null ? null : override.getStatus();
    }

    public Date getOverrideTimeStamp(XCourseId courseId) {
        XOverride override = this.iOverrides == null ? null : this.iOverrides.get(courseId);
        return override == null ? null : override.getTimeStamp();
    }

    public String getOverrideExternalId(XCourseId courseId) {
        XOverride override = this.iOverrides == null ? null : this.iOverrides.get(courseId);
        return override == null ? null : override.getExternalId();
    }

    public boolean isOverridePending(XCourseId courseId) {
        XOverride override;
        XOverride xOverride = override = this.iOverrides == null ? null : this.iOverrides.get(courseId);
        return override == null || override.getStatus() == null ? false : override.getStatus().intValue() == CourseRequest.CourseRequestOverrideStatus.PENDING.ordinal();
    }

    public OnlineSectioningLog.CourseRequestOption getOptions(Long offeringId) {
        if (this.iOptions == null) {
            return null;
        }
        XCourseId courseId = this.getCourseIdByOfferingId(offeringId);
        if (courseId == null) {
            return null;
        }
        byte[] option = this.iOptions.get(courseId);
        if (option != null) {
            try {
                return OnlineSectioningLog.CourseRequestOption.parseFrom(option);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                // empty catch block
            }
        }
        return null;
    }

    public List<XPreference> getPreferences(XCourseId courseId) {
        if (this.iPreferences == null) {
            return null;
        }
        return this.iPreferences.get(courseId);
    }

    public void fillChoicesIn(CourseRequest request) {
        Course course;
        if (this.iSectionWaitlist != null) {
            for (Map.Entry<XCourseId, List<Externalizable>> entry : this.iSectionWaitlist.entrySet()) {
                course = request.getCourse(entry.getKey().getCourseId().longValue());
                if (course == null) continue;
                for (XSection xSection : entry.getValue()) {
                    Object instructors = null;
                    if (!xSection.getInstructors().isEmpty()) {
                        instructors = new ArrayList();
                        for (XInstructor i : xSection.getInstructors()) {
                            instructors.add(new Instructor(i.getIntructorId().longValue(), i.getExternalId(), i.getName(), i.getEmail()));
                        }
                    }
                    request.getSelectedChoices().add(new Choice(course.getOffering(), xSection.getInstructionalType(), xSection.getTime() == null || xSection.getTime().getDays() == 0 ? null : xSection.getTime().toTimeLocation(), (List)instructors));
                }
            }
        }
        if (this.iPreferences != null) {
            for (Map.Entry<XCourseId, List<Externalizable>> entry : this.iPreferences.entrySet()) {
                course = request.getCourse(entry.getKey().getCourseId().longValue());
                if (course == null) continue;
                block8: for (XPreference xPreference : entry.getValue()) {
                    switch (xPreference.getType()) {
                        case INSTR_METHOD: {
                            for (Config config : course.getOffering().getConfigs()) {
                                if (config.getInstructionalMethodId() == null || !config.getInstructionalMethodId().equals(xPreference.getUniqueId())) continue;
                                (xPreference.isRequired() ? request.getRequiredChoices() : request.getSelectedChoices()).add(new Choice(config));
                            }
                            continue block8;
                        }
                        case SECTION: {
                            Section section = course.getOffering().getSection(xPreference.getUniqueId().longValue());
                            if (section == null) break;
                            if (xPreference.isRequired()) {
                                for (Section x = section; x != null; x = x.getParent()) {
                                    request.getRequiredChoices().add(new Choice(x));
                                }
                                request.getRequiredChoices().add(new Choice(section.getSubpart().getConfig()));
                                break;
                            }
                            request.getSelectedChoices().add(new Choice(section));
                        }
                    }
                }
            }
        }
    }

    public void fillPreferencesIn(CourseRequestInterface.RequestedCourse rc, XCourseId courseId) {
        List<XPreference> prefs = this.getPreferences(courseId);
        if (prefs != null) {
            for (XPreference p : prefs) {
                switch (p.getType()) {
                    case INSTR_METHOD: {
                        rc.setSelectedIntructionalMethod(p.getUniqueId(), p.getLabel(), p.isRequired(), true);
                        break;
                    }
                    case SECTION: {
                        rc.setSelectedClass(p.getUniqueId(), p.getLabel(), p.isRequired(), true);
                    }
                }
            }
        }
    }

    public boolean isRequired(XEnrollment enrollment, XOffering offering) {
        List<XPreference> prefs = this.getPreferences(enrollment);
        if (prefs == null || prefs.isEmpty()) {
            return true;
        }
        XConfig config = offering.getConfig(enrollment.getConfigId());
        for (XSection section : offering.getSections(enrollment)) {
            boolean hasConfig = false;
            boolean hasMatchingConfig = false;
            boolean hasSubpart = false;
            boolean hasMatchingSection = false;
            boolean hasSectionReq = false;
            block1: for (XPreference choice : prefs) {
                if (!choice.isRequired()) continue;
                if (choice.getType() == XPreferenceType.INSTR_METHOD) {
                    hasConfig = true;
                    if (config.getInstructionalMethod() != null && choice.getUniqueId().equals(config.getInstructionalMethod().getUniqueId())) {
                        hasMatchingConfig = true;
                    }
                }
                if (choice.getType() != XPreferenceType.SECTION) continue;
                XSection reqSection = offering.getSection(choice.getUniqueId());
                hasSectionReq = true;
                if (reqSection.getSubpartId().equals(section.getSubpartId())) {
                    hasSubpart = true;
                    if (!reqSection.equals(section)) continue;
                    hasMatchingSection = true;
                    continue;
                }
                if (hasMatchingConfig) continue;
                for (XSubpart subpart : config.getSubparts()) {
                    if (!reqSection.getSubpartId().equals(subpart.getSubpartId())) continue;
                    hasMatchingConfig = true;
                    continue block1;
                }
            }
            if (hasConfig && !hasMatchingConfig) {
                return false;
            }
            if (hasSubpart && !hasMatchingSection) {
                return false;
            }
            if (hasMatchingConfig || hasMatchingSection || !hasSectionReq) continue;
            return false;
        }
        return true;
    }

    public boolean isRequired(XOffering offering, XConfig config, XSection section, XCourseId course) {
        List<XPreference> prefs = this.getPreferences(course);
        if (prefs == null || prefs.isEmpty()) {
            return true;
        }
        boolean hasConfig = false;
        boolean hasMatchingConfig = false;
        boolean hasSubpart = false;
        boolean hasMatchingSection = false;
        boolean hasSectionReq = false;
        block0: for (XPreference choice : prefs) {
            if (!choice.isRequired()) continue;
            if (choice.getType() == XPreferenceType.INSTR_METHOD) {
                hasConfig = true;
                if (config.getInstructionalMethod() != null && choice.getUniqueId().equals(config.getInstructionalMethod().getUniqueId())) {
                    hasMatchingConfig = true;
                }
            }
            if (choice.getType() != XPreferenceType.SECTION) continue;
            XSection reqSection = offering.getSection(choice.getUniqueId());
            hasSectionReq = true;
            if (reqSection.getSubpartId().equals(section.getSubpartId())) {
                hasSubpart = true;
                if (!reqSection.equals(section)) continue;
                hasMatchingSection = true;
                continue;
            }
            if (hasMatchingConfig) continue;
            for (XSubpart subpart : config.getSubparts()) {
                if (!reqSection.getSubpartId().equals(subpart.getSubpartId())) continue;
                hasMatchingConfig = true;
                continue block0;
            }
        }
        if (hasConfig && !hasMatchingConfig) {
            return false;
        }
        if (hasSubpart && !hasMatchingSection) {
            return false;
        }
        return hasMatchingConfig || hasMatchingSection || !hasSectionReq;
    }

    public String getEnrollmentMessage() {
        return this.iMessage;
    }

    public void setEnrollmentMessage(String message) {
        this.iMessage = message;
    }

    @Override
    public String toString() {
        Object ret = super.toString();
        Iterator<XCourseId> i = this.iCourseIds.iterator();
        while (i.hasNext()) {
            XCourseId c = i.next();
            ret = (String)ret + " " + c.getCourseName();
            if (!i.hasNext()) continue;
            ret = (String)ret + ",";
        }
        if (this.isWaitlist()) {
            ret = (String)ret + " (w)";
        }
        if (this.isNoSub()) {
            ret = (String)ret + " (x)";
        }
        ret = (String)ret + " (" + this.getRequestId() + ")";
        return ret;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int nrCourses = in.readInt();
        this.iCourseIds.clear();
        for (int i = 0; i < nrCourses; ++i) {
            this.iCourseIds.add(new XCourseId(in));
        }
        this.iWaitlist = in.readBoolean();
        this.iNoSub = in.readBoolean();
        this.iTimeStamp = in.readBoolean() ? new Date(in.readLong()) : null;
        this.iWaitListedTimeStamp = in.readBoolean() ? new Date(in.readLong()) : null;
        this.iEnrollment = in.readBoolean() ? new XEnrollment(in) : null;
        int nrWaitlists = in.readInt();
        if (nrWaitlists == 0) {
            this.iSectionWaitlist = null;
        } else {
            this.iSectionWaitlist = new HashMap<XCourseId, List<XWaitListedSection>>();
            block1: for (int i = 0; i < nrWaitlists; ++i) {
                Long courseId = in.readLong();
                int nrSections = in.readInt();
                ArrayList<XWaitListedSection> sections = new ArrayList<XWaitListedSection>(nrSections);
                for (int j = 0; j < nrSections; ++j) {
                    sections.add(new XWaitListedSection(in));
                }
                for (XCourseId course : this.iCourseIds) {
                    if (!course.getCourseId().equals(courseId)) continue;
                    this.iSectionWaitlist.put(course, sections);
                    continue block1;
                }
            }
        }
        int nrOptions = in.readInt();
        if (nrOptions == 0) {
            this.iOptions = null;
        } else {
            this.iOptions = new HashMap<XCourseId, byte[]>();
            block4: for (int i = 0; i < nrOptions; ++i) {
                Long courseId = in.readLong();
                int len = in.readInt();
                byte[] data = new byte[len];
                for (int read = 0; read < len; read += in.read(data, read, len - read)) {
                }
                for (XCourseId course : this.iCourseIds) {
                    if (!course.getCourseId().equals(courseId)) continue;
                    this.iOptions.put(course, data);
                    continue block4;
                }
            }
        }
        int nrCoursePrefs = in.readInt();
        if (nrCoursePrefs == 0) {
            this.iPreferences = null;
        } else {
            this.iPreferences = new HashMap<XCourseId, List<XPreference>>();
            block7: for (int i = 0; i < nrCoursePrefs; ++i) {
                Long courseId = in.readLong();
                int nbrPrefs = in.readInt();
                ArrayList<XPreference> prefs = new ArrayList<XPreference>(nbrPrefs);
                for (int j = 0; j < nbrPrefs; ++j) {
                    prefs.add(new XPreference(in));
                }
                for (XCourseId course : this.iCourseIds) {
                    if (!course.getCourseId().equals(courseId)) continue;
                    this.iPreferences.put(course, prefs);
                    continue block7;
                }
            }
        }
        this.iMessage = (String)in.readObject();
        int nrOverrides = in.readInt();
        if (nrOverrides == 0) {
            this.iOverrides = null;
        } else {
            this.iOverrides = new HashMap<XCourseId, XOverride>();
            block10: for (int i = 0; i < nrOverrides; ++i) {
                Long courseId = in.readLong();
                XOverride override = new XOverride(in);
                for (XCourseId course : this.iCourseIds) {
                    if (!course.getCourseId().equals(courseId)) continue;
                    this.iOverrides.put(course, override);
                    continue block10;
                }
            }
        }
        this.iWaitListSwapWithCourseOffering = null;
        if (in.readBoolean()) {
            this.iWaitListSwapWithCourseOffering = new XCourseId(in);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.iCourseIds.size());
        for (XCourseId xCourseId : this.iCourseIds) {
            xCourseId.writeExternal(out);
        }
        out.writeBoolean(this.iWaitlist);
        out.writeBoolean(this.iNoSub);
        out.writeBoolean(this.iTimeStamp != null);
        if (this.iTimeStamp != null) {
            out.writeLong(this.iTimeStamp.getTime());
        }
        out.writeBoolean(this.iWaitListedTimeStamp != null);
        if (this.iWaitListedTimeStamp != null) {
            out.writeLong(this.iWaitListedTimeStamp.getTime());
        }
        out.writeBoolean(this.iEnrollment != null);
        if (this.iEnrollment != null) {
            this.iEnrollment.writeExternal(out);
        }
        out.writeInt(this.iSectionWaitlist == null ? 0 : this.iSectionWaitlist.size());
        if (this.iSectionWaitlist != null) {
            for (Map.Entry entry : this.iSectionWaitlist.entrySet()) {
                out.writeLong(((XCourseId)entry.getKey()).getCourseId());
                out.writeInt(((List)entry.getValue()).size());
                for (XWaitListedSection section : (List)entry.getValue()) {
                    section.writeExternal(out);
                }
            }
        }
        out.writeInt(this.iOptions == null ? 0 : this.iOptions.size());
        if (this.iOptions != null) {
            for (Map.Entry entry : this.iOptions.entrySet()) {
                out.writeLong(((XCourseId)entry.getKey()).getCourseId());
                byte[] value = (byte[])entry.getValue();
                out.writeInt(value.length);
                out.write(value, 0, value.length);
            }
        }
        out.writeInt(this.iPreferences == null ? 0 : this.iPreferences.size());
        if (this.iPreferences != null) {
            for (Map.Entry entry : this.iPreferences.entrySet()) {
                out.writeLong(((XCourseId)entry.getKey()).getCourseId());
                out.writeInt(((List)entry.getValue()).size());
                for (XPreference p : (List)entry.getValue()) {
                    p.writeExternal(out);
                }
            }
        }
        out.writeObject(this.iMessage);
        out.writeInt(this.iOverrides == null ? 0 : this.iOverrides.size());
        if (this.iOverrides != null) {
            for (Map.Entry entry : this.iOverrides.entrySet()) {
                out.writeLong(((XCourseId)entry.getKey()).getCourseId());
                ((XOverride)entry.getValue()).writeExternal(out);
            }
        }
        out.writeBoolean(this.iWaitListSwapWithCourseOffering != null);
        if (this.iWaitListSwapWithCourseOffering != null) {
            this.iWaitListSwapWithCourseOffering.writeExternal(out);
        }
    }

    public static class XPreference
    implements Externalizable {
        private boolean iRequired = false;
        private Long iId = null;
        private String iLabel = null;
        private XPreferenceType iType = null;

        public XPreference(org.unitime.timetable.model.CourseRequest cr, StudentSectioningPref p) {
            this.iRequired = p.isRequired();
            if (p instanceof StudentClassPref) {
                StudentClassPref scp = (StudentClassPref)p;
                this.iId = scp.getClazz().getUniqueId();
                this.iLabel = scp.getClazz().getClassPrefLabel(cr.getCourseOffering());
                this.iType = XPreferenceType.SECTION;
            } else {
                StudentInstrMthPref imp = (StudentInstrMthPref)p;
                this.iId = imp.getInstructionalMethod().getUniqueId();
                this.iLabel = imp.getInstructionalMethod().getLabel();
                this.iType = XPreferenceType.INSTR_METHOD;
            }
        }

        public XPreference(AdvisorCourseRequest acr, AdvisorSectioningPref p) {
            this.iRequired = p.isRequired();
            if (p instanceof AdvisorClassPref) {
                AdvisorClassPref scp = (AdvisorClassPref)p;
                this.iId = scp.getClazz().getUniqueId();
                this.iLabel = scp.getClazz().getClassPrefLabel(acr.getCourseOffering());
                this.iType = XPreferenceType.SECTION;
            } else {
                AdvisorInstrMthPref imp = (AdvisorInstrMthPref)p;
                this.iId = imp.getInstructionalMethod().getUniqueId();
                this.iLabel = imp.getInstructionalMethod().getLabel();
                this.iType = XPreferenceType.INSTR_METHOD;
            }
        }

        public XPreference(XPreferenceType type, Long id, String label, boolean required) {
            this.iType = type;
            this.iId = id;
            this.iLabel = label;
            this.iRequired = required;
        }

        public XPreference(Section a, Course c, boolean required) {
            this.iType = XPreferenceType.SECTION;
            this.iId = a.getId();
            this.iLabel = a.getName(c.getId());
            if (this.iLabel.length() <= 4) {
                this.iLabel = a.getSubpart().getName() + " " + this.iLabel;
            }
            this.iRequired = required;
        }

        public XPreference(CourseRequestInterface.Preference p, XPreferenceType type) {
            this.iType = type;
            this.iId = p.getId();
            this.iLabel = p.getText();
            this.iRequired = p.isRequired();
        }

        public XPreference(ObjectInput in) throws IOException, ClassNotFoundException {
            this.readExternal(in);
        }

        public boolean isRequired() {
            return this.iRequired;
        }

        public Long getUniqueId() {
            return this.iId;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public XPreferenceType getType() {
            return this.iType;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.iType.ordinal());
            out.writeBoolean(this.iRequired);
            out.writeLong(this.iId);
            out.writeObject(this.iLabel);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.iType = XPreferenceType.values()[in.readInt()];
            this.iRequired = in.readBoolean();
            this.iId = in.readLong();
            this.iLabel = (String)in.readObject();
        }
    }

    public static enum XPreferenceType {
        SECTION,
        INSTR_METHOD;

    }
}

