/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Uniform;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.DefaultCourseRequestValidator;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.StudentHoldsCheckProvider;
import org.unitime.timetable.onlinesectioning.custom.StudentPinsProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.GsonRepresentation;
import org.unitime.timetable.onlinesectioning.custom.purdue.SpecialRegistrationInterface;
import org.unitime.timetable.onlinesectioning.custom.purdue.XEInterface;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;

public class SimplifiedCourseRequestsValidationProvider
extends DefaultCourseRequestValidator
implements StudentHoldsCheckProvider,
StudentPinsProvider {
    private static Log sLog = LogFactory.getLog(SimplifiedCourseRequestsValidationProvider.class);
    private Client iClient;
    private ExternalTermProvider iExternalTermProvider;

    public SimplifiedCourseRequestsValidationProvider() {
        this.iParameterPrefix = "purdue.specreg.";
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP);
        protocols.add(Protocol.HTTPS);
        this.iClient = new Client(protocols);
        Context cx = new Context();
        cx.getParameters().add("readTimeout", this.getSpecialRegistrationApiReadTimeout());
        this.iClient.setContext(cx);
        try {
            String clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
    }

    protected String getSpecialRegistrationApiReadTimeout() {
        return ApplicationProperties.getProperty("purdue.specreg.readTimeout", "60000");
    }

    protected String getSpecialRegistrationApiSite() {
        return ApplicationProperties.getProperty("purdue.specreg.site");
    }

    protected String getSpecialRegistrationApiSiteCheckEligibility() {
        return ApplicationProperties.getProperty("purdue.specreg.site.checkEligibility", this.getSpecialRegistrationApiSite() + "/checkEligibility");
    }

    protected String getSpecialRegistrationApiKey() {
        return ApplicationProperties.getProperty("purdue.specreg.apiKey");
    }

    protected SpecialRegistrationInterface.ApiMode getSpecialRegistrationApiMode() {
        return SpecialRegistrationInterface.ApiMode.valueOf(ApplicationProperties.getProperty("purdue.specreg.mode.validation", "PREREG"));
    }

    protected String getBannerSite() {
        return ApplicationProperties.getProperty("banner.xe.site");
    }

    protected String getBannerUser(boolean admin) {
        String user;
        if (admin && (user = ApplicationProperties.getProperty("banner.xe.admin.user")) != null) {
            return user;
        }
        return ApplicationProperties.getProperty("banner.xe.user");
    }

    protected String getBannerPassword(boolean admin) {
        String pwd;
        if (admin && (pwd = ApplicationProperties.getProperty("banner.xe.admin.password")) != null) {
            return pwd;
        }
        return ApplicationProperties.getProperty("banner.xe.password");
    }

    protected String getAdminParameter() {
        return ApplicationProperties.getProperty("banner.xe.adminParameter", "systemIn");
    }

    protected String getBannerErrors() {
        return ApplicationProperties.getProperty("banner.xe.prereg.errors", "(Holds prevent registration\\.|Student Status prevents registration\\.)");
    }

    protected String getBannerTerm(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalTerm(session);
    }

    protected String getBannerCampus(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalCampus(session);
    }

    protected boolean isBannerAdmin() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.admin", "false"));
    }

    protected boolean isPreregAdmin() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.prereg.admin", "false"));
    }

    protected boolean isUseXE() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specReg.XEeligibility", "false"));
    }

    protected boolean isCheckForPin() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specReg.checkForPin", "true"));
    }

    @Override
    protected boolean isWaitListNoAlts() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.waitListNoAlts", "false"));
    }

    @Override
    protected boolean isAdvisedNoAlts() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.advisedNoAlts", "true"));
    }

    protected String getBannerId(Student student) {
        Object id = student.getExternalUniqueId();
        while (((String)id).length() < 9) {
            id = "0" + (String)id;
        }
        return id;
    }

    protected String getBannerId(XStudentId student) {
        Object id = student.getExternalId();
        while (((String)id).length() < 9) {
            id = "0" + (String)id;
        }
        return id;
    }

    protected Gson getGson(OnlineSectioningHelper helper) {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

            public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            }
        }).registerTypeAdapter(DateTime.class, (Object)new JsonDeserializer<DateTime>(){

            public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new DateTime((Object)json.getAsJsonPrimitive().getAsString(), DateTimeZone.UTC);
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(src));
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(json.getAsJsonPrimitive().getAsString());
                }
                catch (ParseException e) {
                    throw new JsonParseException(e.getMessage(), (Throwable)e);
                }
            }
        });
        if (helper.isDebugEnabled()) {
            builder.setPrettyPrinting();
        }
        return builder.create();
    }

    public boolean isDisableRegistrationWhenNotEligible() {
        return "true".equals(ApplicationProperties.getProperty("purdue.specreg.disableRegistrationWhenNotEligible", "true"));
    }

    protected boolean isValidationEnabled(Student student) {
        if (student == null) {
            return false;
        }
        StudentSectioningStatus status = student.getEffectiveStatus();
        return status == null || status.hasOption(StudentSectioningStatus.Option.reqval);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void checkEligibility(OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.EligibilityCheck check, Student student) throws SectioningException {
        if (student == null || !check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER)) {
            return;
        }
        if (!this.isValidationEnabled(student)) {
            return;
        }
        if (this.isUseXE()) {
            ClientResource resource = null;
            try {
                XStudent xs;
                boolean admin;
                String pin = helper.getPin();
                if ((pin == null || pin.isEmpty()) && student.hasReleasedPin()) {
                    pin = student.getPin();
                }
                AcademicSessionInfo session = server.getAcademicSession();
                String term = this.getBannerTerm(session);
                boolean manager = helper.getUser().getType() == OnlineSectioningLog.Entity.EntityType.MANAGER;
                boolean bl = admin = manager && this.isBannerAdmin();
                if (helper.isDebugEnabled()) {
                    helper.debug("Checking eligility for " + student.getName("last-first-middle") + " (term: " + term + ", id:" + this.getBannerId(student) + (String)(admin ? ", admin" : (pin != null ? ", pin:" + pin : "")) + ")");
                }
                resource = new ClientResource(this.getBannerSite());
                resource.setNext((Uniform)this.iClient);
                resource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.getBannerUser(manager), this.getBannerPassword(manager));
                Gson gson = this.getGson(helper);
                XEInterface.RegisterResponse original = null;
                resource.addQueryParameter("term", term);
                resource.addQueryParameter("bannerId", this.getBannerId(student));
                helper.getAction().addOptionBuilder().setKey("term").setValue(term);
                helper.getAction().addOptionBuilder().setKey("bannerId").setValue(this.getBannerId(student));
                if (admin || this.isPreregAdmin()) {
                    String param = this.getAdminParameter();
                    resource.addQueryParameter(param, "SB");
                    helper.getAction().addOptionBuilder().setKey(param).setValue("SB");
                } else if (pin != null && !pin.isEmpty()) {
                    resource.addQueryParameter("altPin", pin);
                    helper.getAction().addOptionBuilder().setKey("pin").setValue(pin);
                }
                long t0 = System.currentTimeMillis();
                try {
                    resource.get(MediaType.APPLICATION_JSON);
                }
                catch (ResourceException exception) {
                    helper.getAction().setApiException(exception.getMessage());
                    try {
                        XEInterface.ErrorResponse response = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                        helper.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                        XEInterface.Error error = response.getError();
                        if (error != null && error.message != null) {
                            throw new SectioningException(error.message);
                        }
                        if (error != null && error.description != null) {
                            throw new SectioningException(error.description);
                        }
                        if (error == null || error.errorMessage == null) throw exception;
                        throw new SectioningException(error.errorMessage);
                    }
                    catch (SectioningException e) {
                        helper.getAction().setApiException(e.getMessage());
                        throw e;
                    }
                    catch (Throwable t) {
                        throw exception;
                    }
                }
                finally {
                    helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
                }
                List current = (List)new GsonRepresentation(resource.getResponseEntity(), XEInterface.RegisterResponse.TYPE_LIST).getObject();
                helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson((Object)current));
                if (current != null && !current.isEmpty()) {
                    original = (XEInterface.RegisterResponse)current.get(0);
                }
                if (original != null && helper.isDebugEnabled()) {
                    helper.debug("Current registration: " + gson.toJson((Object)original));
                }
                if (original != null && original.maxHours != null) {
                    check.setMaxCredit(original.maxHours);
                }
                String bannerErrors = this.getBannerErrors();
                Object error = null;
                if (original != null && original.failureReasons != null) {
                    for (String m : original.failureReasons) {
                        if (bannerErrors != null && !m.matches(bannerErrors)) continue;
                        if (error == null) {
                            error = m;
                            continue;
                        }
                        error = (String)error + (((String)error).endsWith(".") ? " " : ", ") + m;
                    }
                }
                if (error != null) {
                    if (this.isDisableRegistrationWhenNotEligible()) {
                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER, helper.isAdmin());
                    }
                    check.setMessage(MESSAGES.exceptionFailedEligibilityCheck((String)error));
                }
                if (student.getUniqueId() == null || original == null || original.maxHours == null || !(original.maxHours.floatValue() > 0.0f) || original.maxHours == student.getMaxCredit()) return;
                Student dbStudent = (Student)StudentDAO.getInstance().get(student.getUniqueId(), helper.getHibSession());
                dbStudent.setMaxCredit(original.maxHours);
                helper.getHibSession().merge((Object)dbStudent);
                helper.getHibSession().flush();
                if (server instanceof DatabaseServer || (xs = server.getStudent(student.getUniqueId())) == null) return;
                xs.setMaxCredit(original.maxHours);
                server.update(xs, false);
                return;
            }
            catch (SectioningException e) {
                helper.info("Banner eligibility failed: " + e.getMessage());
                throw e;
            }
            catch (Exception e) {
                helper.warn("Banner eligibility failed: " + e.getMessage(), e);
                throw new SectioningException(e.getMessage());
            }
            finally {
                if (resource != null) {
                    if (resource.getResponse() != null) {
                        resource.getResponse().release();
                    }
                    resource.release();
                }
            }
        }
        ClientResource resource = null;
        try {
            XStudent xs;
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckEligibility());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(student));
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
            helper.getAction().addOptionBuilder().setKey("term").setValue(term);
            helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t0 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
            SpecialRegistrationInterface.CheckEligibilityResponse eligibility = new GsonRepresentation<SpecialRegistrationInterface.CheckEligibilityResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.CheckEligibilityResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Eligibility: " + gson.toJson((Object)eligibility));
            }
            helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson((Object)eligibility));
            if (SpecialRegistrationInterface.ResponseStatus.success != eligibility.status) {
                throw new SectioningException((String)(eligibility.message == null || eligibility.message.isEmpty() ? "Failed to check student eligibility (" + String.valueOf((Object)eligibility.status) + ")." : eligibility.message));
            }
            if (eligibility.data != null && ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligibilityProblems != null) {
                Object m = null;
                for (SpecialRegistrationInterface.EligibilityProblem p : ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligibilityProblems) {
                    if (m == null) {
                        m = p.message;
                        continue;
                    }
                    m = (String)m + "\n" + p.message;
                }
                if (m != null) {
                    if (this.isDisableRegistrationWhenNotEligible()) {
                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER, helper.isAdmin());
                    }
                    check.setMessage(MESSAGES.exceptionFailedEligibilityCheck((String)m));
                }
            }
            String pin = null;
            if (eligibility.data != null && ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN != null && !((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN.isEmpty() && !"NA".equals(((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN)) {
                pin = ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN;
            }
            Float maxCredit = null;
            if (eligibility.maxCredit != null && eligibility.maxCredit.floatValue() > 0.0f) {
                maxCredit = eligibility.maxCredit;
                check.setMaxCredit(eligibility.maxCredit);
            }
            if ((maxCredit == null || maxCredit.equals(student.getMaxCredit())) && (pin == null || pin.equals(student.getPin()))) return;
            Student dbStudent = (Student)StudentDAO.getInstance().get(student.getUniqueId(), helper.getHibSession());
            if (maxCredit != null) {
                dbStudent.setMaxCredit(maxCredit);
            }
            if (pin != null) {
                dbStudent.setPin(pin);
            }
            helper.getHibSession().merge((Object)dbStudent);
            helper.getHibSession().flush();
            if (server instanceof DatabaseServer || (xs = server.getStudent(student.getUniqueId())) == null) return;
            if (maxCredit != null) {
                xs.setMaxCredit(maxCredit);
            }
            if (pin != null) {
                xs.setPin(pin);
            }
            server.update(xs, false);
            return;
        }
        catch (SectioningException e) {
            helper.getAction().setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.getAction().setApiException(e.getMessage() == null ? "Null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    @Override
    public void dispose() {
        try {
            this.iClient.stop();
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getStudentHoldError(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudentId student) throws SectioningException {
        if (this.isUseXE()) {
            ClientResource resource = null;
            try {
                boolean admin;
                String pin = helper.getPin();
                if ((pin == null || pin.isEmpty()) && student instanceof XStudent && ((XStudent)student).hasReleasedPin()) {
                    pin = ((XStudent)student).getPin();
                }
                AcademicSessionInfo session = server.getAcademicSession();
                String term = this.getBannerTerm(session);
                boolean manager = helper.getUser().getType() == OnlineSectioningLog.Entity.EntityType.MANAGER;
                boolean bl = admin = manager && this.isBannerAdmin();
                if (helper.isDebugEnabled()) {
                    helper.debug("Checking eligility for " + student.getName() + " (term: " + term + ", id:" + this.getBannerId(student) + (String)(admin ? ", admin" : (pin != null ? ", pin:" + pin : "")) + ")");
                }
                resource = new ClientResource(this.getBannerSite());
                resource.setNext((Uniform)this.iClient);
                resource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.getBannerUser(manager), this.getBannerPassword(manager));
                Gson gson = this.getGson(helper);
                XEInterface.RegisterResponse original = null;
                resource.addQueryParameter("term", term);
                resource.addQueryParameter("bannerId", this.getBannerId(student));
                helper.getAction().addOptionBuilder().setKey("term").setValue(term);
                helper.getAction().addOptionBuilder().setKey("bannerId").setValue(this.getBannerId(student));
                if (admin || this.isPreregAdmin()) {
                    String param = this.getAdminParameter();
                    resource.addQueryParameter(param, "SB");
                    helper.getAction().addOptionBuilder().setKey(param).setValue("SB");
                } else if (pin != null && !pin.isEmpty()) {
                    resource.addQueryParameter("altPin", pin);
                    helper.getAction().addOptionBuilder().setKey("pin").setValue(pin);
                }
                long t0 = System.currentTimeMillis();
                try {
                    resource.get(MediaType.APPLICATION_JSON);
                }
                catch (ResourceException exception) {
                    helper.getAction().setApiException(exception.getMessage());
                    try {
                        XEInterface.ErrorResponse response = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                        helper.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                        XEInterface.Error error = response.getError();
                        if (error != null && error.message != null) {
                            throw new SectioningException(error.message);
                        }
                        if (error != null && error.description != null) {
                            throw new SectioningException(error.description);
                        }
                        if (error != null && error.errorMessage != null) {
                            throw new SectioningException(error.errorMessage);
                        }
                        throw exception;
                    }
                    catch (SectioningException e) {
                        helper.getAction().setApiException(e.getMessage());
                        throw e;
                    }
                    catch (Throwable t) {
                        throw exception;
                    }
                }
                finally {
                    if (!helper.getAction().hasApiGetTime()) {
                        helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
                    }
                }
                List current = (List)new GsonRepresentation(resource.getResponseEntity(), XEInterface.RegisterResponse.TYPE_LIST).getObject();
                helper.getAction().addOptionBuilder().setKey("holds-response").setValue(gson.toJson((Object)current));
                if (current != null && !current.isEmpty()) {
                    original = (XEInterface.RegisterResponse)current.get(0);
                }
                if (original != null && helper.isDebugEnabled()) {
                    helper.debug("Current registration: " + gson.toJson((Object)original));
                }
                String bannerErrors = this.getBannerErrors();
                Object error = null;
                if (original != null && original.failureReasons != null) {
                    for (String m : original.failureReasons) {
                        if (bannerErrors != null && !m.matches(bannerErrors)) continue;
                        if (error == null) {
                            error = m;
                            continue;
                        }
                        error = error + (((String)error).endsWith(".") ? " " : ", ") + m;
                    }
                }
                Iterator<String> iterator = error;
                return iterator;
            }
            catch (SectioningException e) {
                helper.info("Banner eligibility failed: " + e.getMessage());
                throw e;
            }
            catch (Exception e) {
                helper.warn("Banner eligibility failed: " + e.getMessage(), e);
                throw new SectioningException(e.getMessage());
            }
            finally {
                if (resource != null) {
                    if (resource.getResponse() != null) {
                        resource.getResponse().release();
                    }
                    resource.release();
                }
            }
        }
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckEligibility());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(student));
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
            helper.getAction().addOptionBuilder().setKey("term").setValue(term);
            helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t0 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            if (!helper.getAction().hasApiGetTime()) {
                helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
            }
            SpecialRegistrationInterface.CheckEligibilityResponse eligibility = new GsonRepresentation<SpecialRegistrationInterface.CheckEligibilityResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.CheckEligibilityResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Eligibility: " + gson.toJson((Object)eligibility));
            }
            helper.getAction().addOptionBuilder().setKey("holds-response").setValue(gson.toJson((Object)eligibility));
            if (SpecialRegistrationInterface.ResponseStatus.success != eligibility.status) {
                throw new SectioningException((String)(eligibility.message == null || eligibility.message.isEmpty() ? "Failed to check student eligibility (" + String.valueOf((Object)eligibility.status) + ")." : eligibility.message));
            }
            if (this.isCheckForPin() && eligibility.data != null && ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN != null && !((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN.isEmpty() && !"NA".equals(((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN)) {
                helper.getAction().addOptionBuilder().setKey("PIN").setValue(((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN);
            }
            if (eligibility.data != null && ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligibilityProblems != null) {
                Object m = null;
                for (SpecialRegistrationInterface.EligibilityProblem p : ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligibilityProblems) {
                    if (m == null) {
                        m = p.message;
                        continue;
                    }
                    m = (String)m + "\n" + p.message;
                }
                Iterator<SpecialRegistrationInterface.EligibilityProblem> iterator = m;
                return iterator;
            }
            String string = null;
            return string;
        }
        catch (SectioningException e) {
            helper.getAction().setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.getAction().setApiException(e.getMessage() == null ? "Null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    @Override
    public String retriveStudentPin(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudentId student) throws SectioningException {
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckEligibility());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(student));
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
            helper.getAction().addOptionBuilder().setKey("term").setValue(term);
            helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t0 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            if (!helper.getAction().hasApiGetTime()) {
                helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
            }
            SpecialRegistrationInterface.CheckEligibilityResponse eligibility = new GsonRepresentation<SpecialRegistrationInterface.CheckEligibilityResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.CheckEligibilityResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Eligibility: " + gson.toJson((Object)eligibility));
            }
            helper.getAction().addOptionBuilder().setKey("holds-response").setValue(gson.toJson((Object)eligibility));
            if (SpecialRegistrationInterface.ResponseStatus.success != eligibility.status) {
                throw new SectioningException((String)(eligibility.message == null || eligibility.message.isEmpty() ? "Failed to check student eligibility (" + String.valueOf((Object)eligibility.status) + ")." : eligibility.message));
            }
            if (eligibility.data != null && ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN != null && !((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN.isEmpty() && !"NA".equals(((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN)) {
                String string = ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN;
                return string;
            }
            String string = null;
            return string;
        }
        catch (SectioningException e) {
            helper.getAction().setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.getAction().setApiException(e.getMessage() == null ? "Null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }
}

