/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.constraint.DependentCourses;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.online.OnlineReservation;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.StudentSchedulingRule;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GetInfo;
import org.unitime.timetable.onlinesectioning.custom.AdvisorCourseRequestsValidationProvider;
import org.unitime.timetable.onlinesectioning.custom.CourseRequestsValidationProvider;
import org.unitime.timetable.onlinesectioning.model.XAdvisorRequest;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XDistribution;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XReservationType;
import org.unitime.timetable.onlinesectioning.model.XSchedulingRule;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.onlinesectioning.solver.FindAssignmentAction;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;
import org.unitime.timetable.util.Formats;

public class DefaultCourseRequestValidator
implements CourseRequestsValidationProvider,
AdvisorCourseRequestsValidationProvider {
    protected static StudentSectioningMessages MESSAGES = Localization.create(StudentSectioningMessages.class);
    protected static final StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);
    protected static Formats.Format<Number> sCreditFormat = Formats.getNumberFormat("0.##");
    protected String iParameterPrefix = "unitime.validation.";

    protected boolean isWaitListNoAlts() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty(this.iParameterPrefix + "waitListNoAlts", "false"));
    }

    protected boolean isAdvisedNoAlts() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty(this.iParameterPrefix + "advisedNoAlts", "true"));
    }

    @Override
    public void checkEligibility(OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.EligibilityCheck check, org.unitime.timetable.model.Student student) throws SectioningException {
    }

    protected List<CourseRequestInterface.RequestedCourse> getOverCreditRequests(CourseRequestInterface request, float maxCredit) {
        ArrayList<CourseRequestInterface.RequestedCourse> ret = new ArrayList<CourseRequestInterface.RequestedCourse>();
        float primary = 0.0f;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse() || !r.getRequestedCourse(0).hasCredit() || !((primary += r.getRequestedCourse(0).getCreditMin().floatValue()) > maxCredit)) continue;
            ret.add(r.getRequestedCourse(0));
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse() || r.getRequestedCourse().size() <= 1) continue;
            float credit = r.getRequestedCourse(0).hasCredit() ? r.getRequestedCourse(0).getCreditMin().floatValue() : 0.0f;
            for (int i = 1; i < r.getRequestedCourse().size(); ++i) {
                float alt;
                float f = alt = r.getRequestedCourse(i).hasCredit() ? r.getRequestedCourse(i).getCreditMin().floatValue() : 0.0f;
                if (!(primary - credit + alt > maxCredit)) continue;
                ret.add(r.getRequestedCourse(i));
            }
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        ArrayList<Float> credits = new ArrayList<Float>();
        float total = 0.0f;
        CourseRequestInterface.RequestedCourse last = null;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            Float credit = null;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit() || credit != null && !(credit.floatValue() < rc.getCreditMin().floatValue()) || !(total + (credit = rc.getCreditMin()).floatValue() > maxCredit)) continue;
                ret.add(rc);
            }
            if (credit != null) {
                credits.add(credit);
                total += credit.floatValue();
            }
            last = r.getRequestedCourse(0);
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        Collections.sort(credits);
        float low = credits.isEmpty() ? 0.0f : ((Float)credits.get(0)).floatValue();
        CourseRequestInterface.RequestedCourse first = null;
        for (CourseRequestInterface.Request r : request.getAlternatives()) {
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit() || !(total + rc.getCreditMin().floatValue() - low > maxCredit)) continue;
                ret.add(rc);
                break;
            }
            if (first != null) continue;
            first = r.getRequestedCourse(0);
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        ret.add(first != null ? first : last);
        return ret;
    }

    protected boolean isValidationEnabled(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student) {
        String status = student.getStatus();
        if (status == null) {
            status = server.getAcademicSession().getDefaultSectioningStatus();
        }
        if (status == null) {
            return true;
        }
        StudentSectioningStatus dbStatus = StudentSectioningStatus.getPresentStatus(status, server.getAcademicSession().getUniqueId(), helper.getHibSession());
        return dbStatus != null && dbStatus.hasOption(StudentSectioningStatus.Option.reqval);
    }

    @Override
    public void check(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request) throws SectioningException {
        XSchedulingRule rule;
        Float maxCredit;
        String minCreditLimitFilter;
        Comparable<CourseRequestInterface.RequestedCourse> parent;
        XStudent original;
        XStudent xStudent = original = request.getStudentId() == null ? null : server.getStudent(request.getStudentId());
        if (original == null) {
            return;
        }
        if (!this.isValidationEnabled(server, helper, original)) {
            return;
        }
        Integer ORD_UNITIME = 0;
        HashSet<Long> advisorCoursesNoAlt = new HashSet<Long>();
        if (original.hasAdvisorRequests() && this.isAdvisedNoAlts()) {
            for (XAdvisorRequest ar : original.getAdvisorRequests()) {
                count = 0;
                for (XAdvisorRequest x : original.getAdvisorRequests()) {
                    if (x.getPriority() != ar.getPriority()) continue;
                    ++count;
                }
                if (count != true || ar.getCourseId() == null) continue;
                advisorCoursesNoAlt.add(ar.getCourseId().getCourseId());
            }
        } else if (original.hasAdvisorRequests() && this.isWaitListNoAlts()) {
            for (XAdvisorRequest ar : original.getAdvisorRequests()) {
                if (!ar.isWaitListOrNoSub() || ar.isSubstitute()) continue;
                count = 0;
                for (XAdvisorRequest x : original.getAdvisorRequests()) {
                    if (x.getPriority() != ar.getPriority() || x.isSubstitute()) continue;
                    ++count;
                }
                if (count != 1 || ar.getCourseId() == null) continue;
                advisorCoursesNoAlt.add(ar.getCourseId().getCourseId());
            }
        }
        for (CourseRequestInterface.Request r : request.getCourses()) {
            CourseRequestInterface.RequestedCourse rc;
            if (!r.hasRequestedCourse() || r.getRequestedCourse().size() != 1 || (rc = r.getRequestedCourse(0)).getCourseId() == null || rc.isReadOnly() || advisorCoursesNoAlt.contains(rc.getCourseId()) || request.hasCourse(rc.getParentCourseId())) continue;
            request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "NO_ALT", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.courseHasNoAlt", "No alternative course provided.").replace("{course}", rc.getCourseName()), ORD_UNITIME);
        }
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (r.hasRequestedCourse() && r.getRequestedCourse().size() > 1) {
                for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                    parent = r.getCourse(rc.getParentCourseId());
                    if (parent == null) continue;
                    request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "PARENT_SAME_REQ", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.parentSameRequest", "Associated course {parent} on the same request line.").replace("{parent}", ((CourseRequestInterface.RequestedCourse)parent).getCourseName()).replace("{course}", rc.getCourseName()), ORD_UNITIME);
                }
            }
            if (r.hasRequestedCourse()) {
                for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                    CourseRequestInterface.Request a = request.getAlternativeForCourseId(rc.getParentCourseId());
                    if (a == null) continue;
                    CourseRequestInterface.RequestedCourse requestedCourse = a.getCourse(rc.getParentCourseId());
                    request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "PARENT_SUBST", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.parentSubstitute", "Associated course {parent} is requested as a substitute.").replace("{parent}", requestedCourse.getCourseName()).replace("{course}", rc.getCourseName()), ORD_UNITIME);
                }
            }
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasParentCourseId() || request.hasCourse(rc.getParentCourseId())) continue;
                parent = server.getCourse(rc.getParentCourseId());
                request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "NO_PARENT", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.noParent", "Depends on {parent}.").replace("{parent}", ((XCourseId)parent).getCourseName()).replace("{course}", rc.getCourseName()), ORD_UNITIME);
            }
        }
        for (CourseRequestInterface.Request r : request.getAlternatives()) {
            if (r.hasRequestedCourse() && r.getRequestedCourse().size() > 1) {
                for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                    parent = r.getCourse(rc.getParentCourseId());
                    if (parent == null) continue;
                    request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "PARENT_SAME_REQ", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.parentSameRequest", "Associated course {parent} on the same request line.").replace("{parent}", ((CourseRequestInterface.RequestedCourse)parent).getCourseName()).replace("{course}", rc.getCourseName()), ORD_UNITIME);
                }
            }
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasParentCourseId() || request.hasCourse(rc.getParentCourseId())) continue;
                parent = server.getCourse(rc.getParentCourseId());
                request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "NO_PARENT", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.noParent", "Depends on {parent}.").replace("{parent}", ((XCourseId)parent).getCourseName()).replace("{course}", rc.getCourseName()), ORD_UNITIME);
            }
        }
        for (int i = 0; i < request.getCourses().size(); ++i) {
            CourseRequestInterface.Request r;
            r = request.getCourse(i);
            if (!r.hasRequestedCourse() || !r.getRequestedCourse(0).isFreeTime()) continue;
            boolean hasCourse = false;
            for (int j = i + 1; j < request.getCourses().size(); ++j) {
                CourseRequestInterface.Request q = request.getCourse(j);
                if (!q.hasRequestedCourse() || !q.getRequestedCourse(0).isCourse()) continue;
                hasCourse = true;
                break;
            }
            if (!hasCourse) continue;
            Object free = "";
            for (CourseRequestInterface.FreeTime freeTime : r.getRequestedCourse(0).getFreeTime()) {
                if (!((String)free).isEmpty()) {
                    free = (String)free + ", ";
                }
                free = (String)free + freeTime.toString(CONSTANTS.shortDays(), CONSTANTS.useAmPm());
            }
            request.addConfirmationMessage(0L, CONSTANTS.freePrefix() + (String)free, "FREE-TIME", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.freeTimeHighPriority", "High priority free time"), ORD_UNITIME);
        }
        String minCreditLimit = ApplicationProperties.getProperty(this.iParameterPrefix + "minCreditCheck");
        float minCredit = 0.0f;
        block15: for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse requestedCourse : r.getRequestedCourse()) {
                if (!requestedCourse.hasCredit()) continue;
                minCredit += requestedCourse.getCreditMin().floatValue();
                continue block15;
            }
        }
        if (!request.isEmpty()) {
            request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
        }
        if (minCreditLimit != null && minCredit > 0.0f && minCredit < Float.parseFloat(minCreditLimit) && (original.getMaxCredit() == null || original.getMaxCredit().floatValue() > Float.parseFloat(minCreditLimit)) && ((minCreditLimitFilter = ApplicationProperties.getProperty(this.iParameterPrefix + "minCreditCheck.studentFilter")) == null || minCreditLimitFilter.isEmpty() || new Query(minCreditLimitFilter).match(new StatusPageSuggestionsAction.StudentMatcher(original, server.getAcademicSession().getDefaultSectioningStatus(), server, false)))) {
            request.setCreditWarning(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", minCreditLimit).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit))));
            request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_LOW);
        }
        if ((maxCredit = original.getMaxCredit()) == null) {
            maxCredit = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty(this.iParameterPrefix + "maxCreditDefault", "18")));
        }
        Set<Long> advisorWaitListedCourseIds = original.getAdvisorWaitListedCourseIds(server);
        if (maxCredit.floatValue() < request.getCredit(advisorWaitListedCourseIds)) {
            for (CourseRequestInterface.RequestedCourse requestedCourse : this.getOverCreditRequests(request, maxCredit.floatValue())) {
                request.addConfirmationMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "CREDIT", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(advisorWaitListedCourseIds)))), null, ORD_UNITIME);
            }
            request.setCreditWarning(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(advisorWaitListedCourseIds)))));
            request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_HIGH);
        }
        if ((rule = server.getSchedulingRule(original, StudentSchedulingRule.Mode.Online, helper.hasAvisorPermission(), helper.hasAdminPermission())) != null) {
            for (XRequest xRequest : original.getRequests()) {
                if (!(xRequest instanceof XCourseRequest)) continue;
                XCourseRequest cr = (XCourseRequest)xRequest;
                for (XCourseId xCourseId : cr.getCourseIds()) {
                    if (rule.matchesCourse(xCourseId, helper.getHibSession())) continue;
                    request.addConfirmationMessage(xCourseId.getCourseId(), xCourseId.getCourseName(), "NOT-RULE", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.notMatchingRuleCourse", "No {rule} option.").replace("{rule}", rule.getRuleName()).replace("{course}", xCourseId.getCourseName()), ORD_UNITIME);
                    CourseRequestInterface.RequestPriority rp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(xCourseId.getCourseId(), xCourseId.getCourseName()));
                    if (rp == null) continue;
                    rp.getRequest().getRequestedCourse(rp.getChoice()).setInactive(true);
                }
            }
        } else {
            String string = server.getConfig().getProperty("Load.OnlineOnlyStudentFilter", null);
            if (string != null && !string.isEmpty()) {
                if (new Query(string).match(new StatusPageSuggestionsAction.StudentMatcher(original, server.getAcademicSession().getDefaultSectioningStatus(), server, false))) {
                    String string2 = server.getConfig().getProperty("Load.OnlineOnlyCourseNameRegExp");
                    im = server.getConfig().getProperty("Load.OnlineOnlyInstructionalModeRegExp");
                    for (XRequest xRequest : original.getRequests()) {
                        if (!(xRequest instanceof XCourseRequest)) continue;
                        cr = (XCourseRequest)xRequest;
                        for (XCourseId xCourseId : cr.getCourseIds()) {
                            if (string2 != null && !string2.isEmpty() && !xCourseId.getCourseName().matches(string2)) {
                                request.addConfirmationMessage(xCourseId.getCourseId(), xCourseId.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", xCourseId.getCourseName()), ORD_UNITIME);
                                CourseRequestInterface.RequestPriority rp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(xCourseId.getCourseId(), xCourseId.getCourseName()));
                                if (rp == null) continue;
                                rp.getRequest().getRequestedCourse(rp.getChoice()).setInactive(true);
                                continue;
                            }
                            if (im == null) continue;
                            boolean hasMatchingConfig = false;
                            offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(xCourseId.getOfferingId(), helper.getHibSession());
                            if (offering != null) {
                                for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                                    configIm = config.getEffectiveInstructionalMethod();
                                    if (im.isEmpty()) {
                                        if (configIm != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                        hasMatchingConfig = true;
                                        continue;
                                    }
                                    if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(im)) continue;
                                    hasMatchingConfig = true;
                                }
                            }
                            if (hasMatchingConfig) continue;
                            request.addConfirmationMessage(xCourseId.getCourseId(), xCourseId.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", xCourseId.getCourseName()), ORD_UNITIME);
                            rp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(xCourseId.getCourseId(), xCourseId.getCourseName()));
                            if (rp == null) continue;
                            ((CourseRequestInterface.RequestPriority)rp).getRequest().getRequestedCourse(((CourseRequestInterface.RequestPriority)rp).getChoice()).setInactive(true);
                        }
                    }
                } else if (server.getConfig().getPropertyBoolean("Load.OnlineOnlyExclusiveCourses", false)) {
                    String string3 = server.getConfig().getProperty("Load.OnlineOnlyCourseNameRegExp");
                    im = server.getConfig().getProperty("Load.ResidentialInstructionalModeRegExp");
                    for (XRequest xRequest : original.getRequests()) {
                        if (!(xRequest instanceof XCourseRequest)) continue;
                        cr = (XCourseRequest)xRequest;
                        for (XCourseId xCourseId : cr.getCourseIds()) {
                            if (string3 != null && !string3.isEmpty() && xCourseId.getCourseName().matches(string3)) {
                                request.addConfirmationMessage(xCourseId.getCourseId(), xCourseId.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", xCourseId.getCourseName()), ORD_UNITIME);
                                CourseRequestInterface.RequestPriority rp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(xCourseId.getCourseId(), xCourseId.getCourseName()));
                                if (rp == null) continue;
                                rp.getRequest().getRequestedCourse(rp.getChoice()).setInactive(true);
                                continue;
                            }
                            if (im == null) continue;
                            boolean hasMatchingConfig = false;
                            offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(xCourseId.getOfferingId(), helper.getHibSession());
                            if (offering != null) {
                                for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                                    configIm = config.getEffectiveInstructionalMethod();
                                    if (im.isEmpty()) {
                                        if (configIm != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                        hasMatchingConfig = true;
                                        continue;
                                    }
                                    if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(im)) continue;
                                    hasMatchingConfig = true;
                                }
                            }
                            if (hasMatchingConfig) continue;
                            request.addConfirmationMessage(xCourseId.getCourseId(), xCourseId.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", xCourseId.getCourseName()), ORD_UNITIME);
                            rp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(xCourseId.getCourseId(), xCourseId.getCourseName()));
                            if (rp == null) continue;
                            ((CourseRequestInterface.RequestPriority)rp).getRequest().getRequestedCourse(((CourseRequestInterface.RequestPriority)rp).getChoice()).setInactive(true);
                        }
                    }
                }
            }
        }
        if (!(server instanceof DatabaseServer)) {
            HashMap<XSection, XCourseId> hashMap = new HashMap<XSection, XCourseId>();
            for (XRequest r : original.getRequests()) {
                if (r.isAlternative() || !(r instanceof XCourseRequest)) continue;
                XCourseRequest cr = (XCourseRequest)r;
                for (XCourseId course : cr.getCourseIds()) {
                    XOffering offering = server.getOffering(course.getOfferingId());
                    if (offering != null && offering.getConfigs().size() == 1) {
                        for (XSubpart subpart : offering.getConfigs().get(0).getSubparts()) {
                            if (subpart.getSections().size() != 1) continue;
                            XSection section = subpart.getSections().get(0);
                            for (XSection other : hashMap.keySet()) {
                                if (!section.isOverlapping(offering.getDistributions(), other)) continue;
                                request.addConfirmationMessage(course.getCourseId(), course.getCourseName(), "OVERLAP", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.courseOverlaps", "Conflicts with {other}.").replace("{course}", course.getCourseName()).replace("{other}", ((XCourseId)hashMap.get(other)).getCourseName()), ORD_UNITIME);
                            }
                            if (cr.getCourseIds().size() != 1) continue;
                            hashMap.put(section, course);
                        }
                    }
                    if (!offering.hasInconsistentRequirements(original, cr, course, server.getAcademicSession())) continue;
                    request.addConfirmationMessage(course.getCourseId(), course.getCourseName(), "STUD_PREF", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.inconsistentStudPref", "Not available due to preferences selected.").replace("{course}", course.getCourseName()), ORD_UNITIME);
                }
            }
        }
        if (server instanceof DatabaseServer) {
            InstructionalOffering io;
            for (CourseRequestInterface.Request request2 : request.getCourses()) {
                if (!request2.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse rc : request2.getRequestedCourse()) {
                    CourseOffering courseOffering;
                    if (rc.getCourseId() == null || rc.isReadOnly() || (io = (courseOffering = (CourseOffering)CourseOfferingDAO.getInstance().get(rc.getCourseId(), helper.getHibSession())) == null ? null : courseOffering.getInstructionalOffering()) == null || !io.hasSchedulingDisclaimer()) continue;
                    if (io.hasMultipleSchedulingDisclaimers()) {
                        for (InstrOfferingConfig instrOfferingConfig : io.getInstrOfferingConfigs()) {
                            if (!instrOfferingConfig.hasSchedulingDisclaimer() || rule != null && !rule.matchesInstructionalMethod(instrOfferingConfig.getInstructionalMethod())) continue;
                            request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "DISCLAIMER", (String)(instrOfferingConfig.getInstructionalMethod() == null ? "" : instrOfferingConfig.getInstructionalMethod().getLabel() + ": ") + instrOfferingConfig.getSchedulingDisclaimer(), ORD_UNITIME);
                        }
                        continue;
                    }
                    request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "DISCLAIMER", io.getFirstSchedulingDisclaimer(), ORD_UNITIME);
                }
            }
            for (CourseRequestInterface.Request request3 : request.getAlternatives()) {
                if (!request3.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse rc : request3.getRequestedCourse()) {
                    CourseOffering courseOffering;
                    if (rc.getCourseId() == null || rc.isReadOnly() || (io = (courseOffering = (CourseOffering)CourseOfferingDAO.getInstance().get(rc.getCourseId(), helper.getHibSession())) == null ? null : courseOffering.getInstructionalOffering()) == null || !io.hasSchedulingDisclaimer()) continue;
                    if (io.hasMultipleSchedulingDisclaimers()) {
                        for (InstrOfferingConfig instrOfferingConfig : io.getInstrOfferingConfigs()) {
                            if (!instrOfferingConfig.hasSchedulingDisclaimer() || rule != null && !rule.matchesInstructionalMethod(instrOfferingConfig.getInstructionalMethod())) continue;
                            request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "DISCLAIMER", (String)(instrOfferingConfig.getInstructionalMethod() == null ? "" : instrOfferingConfig.getInstructionalMethod().getLabel() + ": ") + instrOfferingConfig.getSchedulingDisclaimer(), ORD_UNITIME);
                        }
                        continue;
                    }
                    request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "DISCLAIMER", io.getFirstSchedulingDisclaimer(), ORD_UNITIME);
                }
            }
        } else {
            XCourseRequest cr;
            XOffering offering;
            for (CourseRequestInterface.Request request4 : request.getCourses()) {
                if (!request4.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse rc : request4.getRequestedCourse()) {
                    XCourse xCourse;
                    if (rc.getCourseId() == null || rc.isReadOnly() || (offering = (xCourse = server.getCourse(rc.getCourseId())) == null ? null : server.getOffering(xCourse.getOfferingId())) == null || !offering.hasSchedulingDisclaimer()) continue;
                    if (offering.hasMultipleSchedulingDisclaimers()) {
                        cr = original.getRequestForCourse(xCourse.getCourseId());
                        XEnrollment xEnrollment = cr == null ? null : cr.getEnrollment();
                        for (XConfig config : offering.getConfigs()) {
                            if (!config.hasSchedulingDisclaimer() || rule != null && !rule.matchesInstructionalMethod(config.getInstructionalMethod()) || !DefaultCourseRequestValidator.isAvailable(original, offering, xCourse, config, xEnrollment, rc)) continue;
                            request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "DISCLAIMER", (String)(config.getInstructionalMethod() == null ? "" : config.getInstructionalMethod().getLabel() + ": ") + config.getSchedulingDisclaimer(), ORD_UNITIME);
                        }
                        continue;
                    }
                    request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "DISCLAIMER", offering.getFirstSchedulingDisclaimer(), ORD_UNITIME);
                }
            }
            for (CourseRequestInterface.Request request5 : request.getAlternatives()) {
                if (!request5.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse rc : request5.getRequestedCourse()) {
                    XCourse xCourse;
                    if (rc.getCourseId() == null || rc.isReadOnly() || (offering = (xCourse = server.getCourse(rc.getCourseId())) == null ? null : server.getOffering(xCourse.getOfferingId())) == null || !offering.hasSchedulingDisclaimer()) continue;
                    if (offering.hasMultipleSchedulingDisclaimers()) {
                        cr = original.getRequestForCourse(xCourse.getCourseId());
                        XEnrollment xEnrollment = cr == null ? null : cr.getEnrollment();
                        for (XConfig config : offering.getConfigs()) {
                            if (!config.hasSchedulingDisclaimer() || rule != null && !rule.matchesInstructionalMethod(config.getInstructionalMethod()) || !DefaultCourseRequestValidator.isAvailable(original, offering, xCourse, config, xEnrollment, rc)) continue;
                            request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "DISCLAIMER", (String)(config.getInstructionalMethod() == null ? "" : config.getInstructionalMethod().getLabel() + ": ") + config.getSchedulingDisclaimer(), ORD_UNITIME);
                        }
                        continue;
                    }
                    request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "DISCLAIMER", offering.getFirstSchedulingDisclaimer(), ORD_UNITIME);
                }
            }
        }
    }

    @Override
    public boolean updateStudent(OnlineSectioningServer server, OnlineSectioningHelper helper, org.unitime.timetable.model.Student student, OnlineSectioningLog.Action.Builder action) throws SectioningException {
        return false;
    }

    @Override
    public boolean revalidateStudent(OnlineSectioningServer server, OnlineSectioningHelper helper, org.unitime.timetable.model.Student student, OnlineSectioningLog.Action.Builder action) throws SectioningException {
        return false;
    }

    protected static boolean isEnabledForStudentScheduling(XConfig config) {
        if (config.getSubparts().isEmpty()) {
            return false;
        }
        for (XSubpart subpart : config.getSubparts()) {
            if (DefaultCourseRequestValidator.isEnabledForStudentScheduling(subpart)) continue;
            return false;
        }
        return true;
    }

    protected static boolean isEnabledForStudentScheduling(XSubpart subpart) {
        for (XSection section : subpart.getSections()) {
            if (!section.isEnabledForScheduling() || section.isCancelled()) continue;
            return true;
        }
        return false;
    }

    protected static boolean meetsRequiredPrefs(XConfig config, CourseRequestInterface.RequestedCourse rc) {
        if (rc == null || !rc.hasRequiredIntructionalMethods() && !rc.hasRequiredClasses()) {
            return true;
        }
        if (rc.hasRequiredIntructionalMethods() && config.getInstructionalMethod() != null && rc.isSelectedIntructionalMethod(config.getInstructionalMethod().getUniqueId(), true)) {
            return true;
        }
        if (rc.hasRequiredClasses()) {
            for (CourseRequestInterface.Preference p : rc.getSelectedClasses()) {
                if (!p.isRequired() || config.getSection(p.getId()) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAvailable(XStudent student, XOffering offering, XCourse course, XConfig config, XEnrollment enrollment, CourseRequestInterface.RequestedCourse rc) {
        boolean hasCourse;
        boolean hasMustBeUsed = false;
        boolean hasReservation = false;
        boolean allowDisabled = false;
        for (XReservation r : offering.getReservations()) {
            boolean mustBeUsed;
            if (student != null && !r.isApplicable(student, course)) continue;
            boolean bl = mustBeUsed = r.mustBeUsed() && (r.isAlwaysExpired() || !r.isExpired());
            if (mustBeUsed && !hasMustBeUsed) {
                hasReservation = false;
                hasMustBeUsed = true;
                allowDisabled = false;
            }
            if (hasMustBeUsed && !mustBeUsed || !r.isIncluded(offering, config.getConfigId(), null)) continue;
            hasReservation = true;
            if (!r.isAllowDisabled()) continue;
            allowDisabled = true;
        }
        if (hasMustBeUsed && !hasReservation) {
            return false;
        }
        boolean hasConfig = enrollment != null && config.getConfigId().equals(enrollment.getConfigId());
        boolean bl = hasCourse = enrollment != null && course.getCourseId().equals(enrollment.getCourseId());
        if (!hasCourse && !hasReservation && offering.getUnreservedSpace(null) <= 0) {
            return false;
        }
        if (!hasConfig && !hasReservation && offering.getUnreservedConfigSpace(config.getConfigId(), null) <= 0) {
            return false;
        }
        if (!(hasConfig || allowDisabled || DefaultCourseRequestValidator.isEnabledForStudentScheduling(config))) {
            return false;
        }
        return hasConfig || DefaultCourseRequestValidator.meetsRequiredPrefs(config, rc);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validate(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request, CourseRequestInterface.CheckCoursesResponse response) throws SectioningException {
        Set<Integer> conf;
        void var30_123;
        void var31_150;
        String minCreditLimitFilter;
        void var31_148;
        boolean bl;
        boolean bl2;
        boolean bl3;
        XCourse parent;
        XCourseRequest acr;
        XCourseRequest cr;
        boolean bl4;
        XStudent original;
        XStudent xStudent = original = request.getStudentId() == null ? null : server.getStudent(request.getStudentId());
        if (original == null) {
            throw new PageAccessException(MESSAGES.exceptionEnrollNotStudent(server.getAcademicSession().toString()));
        }
        if (!this.isValidationEnabled(server, helper, original)) {
            return;
        }
        Integer CONF_NONE = null;
        Integer CONF_UNITIME = 0;
        HashSet<Long> coursesWithNotAlt = new HashSet<Long>();
        for (XRequest xRequest : original.getRequests()) {
            XCourseRequest xCourseRequest;
            if (!(xRequest instanceof XCourseRequest) || (xCourseRequest = (XCourseRequest)xRequest).getCourseIds().size() != 1 || xCourseRequest.isAlternative()) continue;
            coursesWithNotAlt.add(xCourseRequest.getCourseIds().get(0).getCourseId());
        }
        HashSet<Long> advisorCoursesNoAlt = new HashSet<Long>();
        if (original.hasAdvisorRequests() && this.isAdvisedNoAlts()) {
            for (XAdvisorRequest xAdvisorRequest : original.getAdvisorRequests()) {
                count = 0;
                for (XAdvisorRequest xAdvisorRequest2 : original.getAdvisorRequests()) {
                    if (xAdvisorRequest2.getPriority() != xAdvisorRequest.getPriority()) continue;
                    ++count;
                }
                if (count != true || xAdvisorRequest.getCourseId() == null) continue;
                advisorCoursesNoAlt.add(xAdvisorRequest.getCourseId().getCourseId());
            }
        } else if (original.hasAdvisorRequests() && this.isWaitListNoAlts()) {
            for (XAdvisorRequest xAdvisorRequest : original.getAdvisorRequests()) {
                if (!xAdvisorRequest.isWaitListOrNoSub() || xAdvisorRequest.isSubstitute()) continue;
                count = 0;
                for (XAdvisorRequest xAdvisorRequest3 : original.getAdvisorRequests()) {
                    if (xAdvisorRequest3.getPriority() != xAdvisorRequest.getPriority() || xAdvisorRequest3.isSubstitute()) continue;
                    ++count;
                }
                if (count != 1 || xAdvisorRequest.getCourseId() == null) continue;
                advisorCoursesNoAlt.add(xAdvisorRequest.getCourseId().getCourseId());
            }
        }
        boolean bl5 = false;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            CourseRequestInterface.RequestedCourse rc;
            if (!r.hasRequestedCourse() || r.getRequestedCourse().size() != 1 || (rc = r.getRequestedCourse(0)).getCourseId() == null || rc.isReadOnly() || advisorCoursesNoAlt.contains(rc.getCourseId()) || request.hasCourse(rc.getParentCourseId())) continue;
            response.addMessage(rc.getCourseId(), rc.getCourseName(), "NO_ALT", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.courseHasNoAlt", "No alternative course provided.").replace("{course}", rc.getCourseName()), !coursesWithNotAlt.contains(rc.getCourseId()) ? CONF_UNITIME : CONF_NONE);
            if (coursesWithNotAlt.contains(rc.getCourseId())) continue;
            bl4 = true;
        }
        boolean bl6 = false;
        boolean questionParentSubstitute = false;
        boolean questionNoParent = false;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (r.hasRequestedCourse() && r.getRequestedCourse().size() > 1) {
                for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                    CourseRequestInterface.RequestedCourse parent2 = r.getCourse(rc.getParentCourseId());
                    if (parent2 == null) continue;
                    XCourseRequest cr2 = original.getRequestForCourse(rc.getCourseId());
                    boolean alreadyExist = cr2 != null && cr2.hasCourse(rc.getParentCourseId());
                    response.addMessage(rc.getCourseId(), rc.getCourseName(), "PARENT_SAME_REQ", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.parentSameRequest", "Associated course {parent} on the same request line.").replace("{parent}", parent2.getCourseName()).replace("{course}", rc.getCourseName()), !alreadyExist ? CONF_UNITIME : CONF_NONE);
                    if (alreadyExist) continue;
                    boolean bl7 = true;
                }
            }
            if (r.hasRequestedCourse()) {
                for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                    CourseRequestInterface.Request a = request.getAlternativeForCourseId(rc.getParentCourseId());
                    if (a == null) continue;
                    CourseRequestInterface.RequestedCourse parent3 = a.getCourse(rc.getParentCourseId());
                    XCourseRequest cr4 = original.getRequestForCourse(rc.getCourseId());
                    XCourseRequest acr2 = original.getRequestForCourse(rc.getParentCourseId());
                    boolean alreadyExist = cr4 != null && acr2 != null && !cr4.isAlternative() && acr2.isAlternative();
                    response.addMessage(rc.getCourseId(), rc.getCourseName(), "PARENT_SUBST", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.parentSubstitute", "Associated course {parent} is requested as a substitute.").replace("{parent}", parent3.getCourseName()).replace("{course}", rc.getCourseName()), !alreadyExist ? CONF_UNITIME : CONF_NONE);
                    if (alreadyExist) continue;
                    questionParentSubstitute = true;
                }
            }
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasParentCourseId() || request.hasCourse(rc.getParentCourseId())) continue;
                cr = original.getRequestForCourse(rc.getCourseId());
                acr = original.getRequestForCourse(rc.getParentCourseId());
                boolean alreadyExist = cr != null && acr == null;
                parent = server.getCourse(rc.getParentCourseId());
                response.addMessage(rc.getCourseId(), rc.getCourseName(), "NO_PARENT", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.noParent", "Depends on {parent}.").replace("{parent}", parent.getCourseName()).replace("{course}", rc.getCourseName()), !alreadyExist ? CONF_UNITIME : CONF_NONE);
                if (alreadyExist) continue;
                questionNoParent = true;
            }
        }
        for (CourseRequestInterface.Request r : request.getAlternatives()) {
            boolean alreadyExist;
            if (r.hasRequestedCourse() && r.getRequestedCourse().size() > 1) {
                for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                    CourseRequestInterface.RequestedCourse parent2 = r.getCourse(rc.getParentCourseId());
                    if (parent2 == null) continue;
                    XCourseRequest cr2 = original.getRequestForCourse(rc.getCourseId());
                    alreadyExist = cr2 != null && cr2.hasCourse(rc.getParentCourseId());
                    response.addMessage(rc.getCourseId(), rc.getCourseName(), "PARENT_SAME_REQ", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.parentSameRequest", "Associated course {parent} on the same request line.").replace("{parent}", parent2.getCourseName()).replace("{course}", rc.getCourseName()), !alreadyExist ? CONF_UNITIME : CONF_NONE);
                    if (alreadyExist) continue;
                    bl3 = true;
                }
            }
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasParentCourseId() || request.hasCourse(rc.getParentCourseId())) continue;
                cr = original.getRequestForCourse(rc.getCourseId());
                acr = original.getRequestForCourse(rc.getParentCourseId());
                alreadyExist = cr != null && acr == null;
                parent = server.getCourse(rc.getParentCourseId());
                response.addMessage(rc.getCourseId(), rc.getCourseName(), "NO_PARENT", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.noParent", "Depends on {parent}.").replace("{parent}", parent.getCourseName()).replace("{course}", rc.getCourseName()), !alreadyExist ? CONF_UNITIME : CONF_NONE);
                if (alreadyExist) continue;
                questionNoParent = true;
            }
        }
        boolean bl8 = false;
        boolean questionInconStuPref = false;
        if (!(server instanceof DatabaseServer)) {
            OnlineSectioningModel model = new OnlineSectioningModel(server.getConfig(), server.getOverExpectedCriterion());
            model.setDayOfWeekOffset(server.getAcademicSession().getDayOfWeekOffset());
            boolean linkedClassesMustBeUsed = server.getConfig().getPropertyBoolean("LinkedClasses.mustBeUsed", false);
            AssignmentMap assignment = new AssignmentMap();
            Student student = new Student(request.getStudentId().longValue());
            student.setExternalId(original.getExternalId());
            student.setName(original.getName());
            student.setNeedShortDistances(original.hasAccomodation(server.getDistanceMetric().getShortDistanceAccommodationReference()));
            student.setAllowDisabled(original.isAllowDisabled());
            student.setClassFirstDate(original.getClassStartDate());
            student.setClassLastDate(original.getClassEndDate());
            student.setBackToBackPreference(original.getBackToBackPreference());
            student.setModalityPreference(original.getModalityPreference());
            HashMap<Long, Section> classTable = new HashMap<Long, Section>();
            HashSet<XDistribution> distributions = new HashSet<XDistribution>();
            boolean hasAssignment = false;
            for (XRequest reqest : original.getRequests()) {
                if (!(reqest instanceof XCourseRequest) || ((XCourseRequest)reqest).getEnrollment() == null) continue;
                hasAssignment = true;
                break;
            }
            HashMap<Long, Course> courseTable = new HashMap<Long, Course>();
            HashMap parentCourses = new HashMap();
            for (CourseRequestInterface.Request request2 : request.getCourses()) {
                FindAssignmentAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, request2, false, false, classTable, courseTable, parentCourses, distributions, hasAssignment, true, helper);
            }
            for (CourseRequestInterface.Request request3 : request.getAlternatives()) {
                FindAssignmentAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, request3, true, false, classTable, courseTable, parentCourses, distributions, hasAssignment, true, helper);
            }
            boolean hasParent = false;
            for (Map.Entry entry : parentCourses.entrySet()) {
                Course course = (Course)courseTable.get(entry.getKey());
                Course parent4 = (Course)courseTable.get(entry.getValue());
                if (course == null || parent4 == null) continue;
                course.setParent(parent4);
                hasParent = true;
            }
            if (hasParent && "true".equalsIgnoreCase(ApplicationProperties.getProperty(this.iParameterPrefix + "checkDependentCourses", "true"))) {
                model.addGlobalConstraint((GlobalConstraint)new DependentCourses());
            }
            if ("true".equalsIgnoreCase(ApplicationProperties.getProperty(this.iParameterPrefix + "checkUnavailabilitiesFromOtherSessions", "false"))) {
                if (server.getConfig().getPropertyBoolean("General.CheckUnavailabilitiesFromOtherSessions", false)) {
                    GetInfo.fillInUnavailabilitiesFromOtherSessions(student, server, helper);
                } else if (server.getConfig().getPropertyBoolean("General.CheckUnavailabilitiesFromOtherSessionsUsingDatabase", false)) {
                    GetInfo.fillInUnavailabilitiesFromOtherSessionsUsingDatabase(student, server, helper);
                }
            }
            model.addStudent(student);
            model.setStudentQuality(new StudentQuality(server.getDistanceMetric(), model.getProperties()));
            for (XDistribution xDistribution : distributions) {
                if (xDistribution.getDistributionType() != XDistributionType.LinkedSections) continue;
                ArrayList<Section> sections = new ArrayList<Section>();
                for (Long l : xDistribution.getSectionIds()) {
                    Section section = (Section)classTable.get(l);
                    if (section == null) continue;
                    sections.add(section);
                }
                if (sections.size() < 2) continue;
                model.addLinkedSections(linkedClassesMustBeUsed, sections);
            }
            if ("true".equalsIgnoreCase(ApplicationProperties.getProperty(this.iParameterPrefix + "dummyReservation", "false"))) {
                for (Request request4 : student.getRequests()) {
                    if (!(request4 instanceof CourseRequest)) continue;
                    CourseRequest cr6 = (CourseRequest)request4;
                    for (Course course : cr6.getCourses()) {
                        new OnlineReservation(XReservationType.Dummy.ordinal(), -3L, course.getOffering(), 5000, true, 1, true, true, true, true, true);
                    }
                }
            }
            HashMap<Section, Course> hashMap = new HashMap<Section, Course>();
            for (Request r : student.getRequests()) {
                if (r.isAlternative() || !(r instanceof CourseRequest)) continue;
                CourseRequest cr3 = (CourseRequest)r;
                for (Course course : cr3.getCourses()) {
                    if (course.getOffering().getConfigs().size() != 1) continue;
                    for (Subpart subpart : ((Config)course.getOffering().getConfigs().get(0)).getSubparts()) {
                        if (subpart.getSections().size() != 1) continue;
                        Section section = (Section)subpart.getSections().get(0);
                        for (Section other : hashMap.keySet()) {
                            if (!section.isOverlapping((SctAssignment)other)) continue;
                            boolean confirm = (original.getRequestForCourse(course.getId()) == null || original.getRequestForCourse(((Course)hashMap.get(other)).getId()) == null) && cr3.getCourses().size() == 1;
                            response.addMessage(course.getId(), course.getName(), "OVERLAP", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.courseOverlaps", "Conflicts with {other}.").replace("{course}", course.getName()).replace("{other}", ((Course)hashMap.get(other)).getName()), confirm ? CONF_UNITIME : CONF_NONE);
                            if (!confirm) continue;
                            bl2 = true;
                        }
                        if (cr3.getCourses().size() != 1) continue;
                        hashMap.put(section, course);
                    }
                }
            }
            for (Request r : student.getRequests()) {
                if (!(r instanceof CourseRequest)) continue;
                CourseRequest cr5 = (CourseRequest)r;
                for (Course course : cr5.getCourses()) {
                    if (!SectioningRequest.hasInconsistentRequirements(cr5, course.getId())) continue;
                    boolean confirm = original.getRequestForCourse(course.getId()) == null;
                    response.addMessage(course.getId(), course.getName(), "STUD_PREF", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.inconsistentStudPref", "Not available due to preferences selected.").replace("{course}", course.getName()), confirm ? CONF_UNITIME : CONF_NONE);
                    if (!confirm) continue;
                    questionInconStuPref = true;
                }
            }
        }
        boolean questionDropCritical = false;
        boolean dropImportant = false;
        boolean dropVital = false;
        boolean dropCritical = false;
        for (XRequest r : original.getRequests()) {
            XCourseRequest cr7;
            if (!(r instanceof XCourseRequest) || !(cr7 = (XCourseRequest)r).isCritical() || cr7.isAlternative() || cr7.getCourseIds().isEmpty()) continue;
            boolean hasCourse = false;
            for (XCourseId course : cr7.getCourseIds()) {
                if (request.getRequestPriority(new CourseRequestInterface.RequestedCourse(course.getCourseId(), course.getCourseName())) == null) continue;
                hasCourse = true;
                break;
            }
            if (hasCourse) continue;
            XCourseId course = cr7.getCourseIds().get(0);
            if (cr7.getCritical() == 2) {
                response.addMessage(course.getCourseId(), course.getCourseName(), "DROP_CRIT", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.courseDropCrit", "Important course has been removed.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                dropImportant = true;
            } else if (cr7.getCritical() == 3) {
                response.addMessage(course.getCourseId(), course.getCourseName(), "DROP_CRIT", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.courseDropCrit", "Vital course has been removed.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                dropVital = true;
            } else {
                response.addMessage(course.getCourseId(), course.getCourseName(), "DROP_CRIT", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.courseDropCrit", "Critical course has been removed.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                dropCritical = true;
            }
            questionDropCritical = true;
        }
        boolean questionMissingAdvisorCritical = false;
        boolean missCritical = false;
        boolean missImportant = false;
        boolean missVital = false;
        CourseDemand.Critical advCritical = CourseDemand.Critical.fromText(ApplicationProperty.AdvisorCourseRequestsAllowCritical.valueOfSession(server.getAcademicSession().getUniqueId()));
        if (original.hasAdvisorRequests()) {
            for (XAdvisorRequest xAdvisorRequest : original.getAdvisorRequests()) {
                CourseRequestInterface.RequestPriority requestPriority;
                if (xAdvisorRequest.getAlternative() != 0 || xAdvisorRequest.isSubstitute() || !xAdvisorRequest.isCritical() || !xAdvisorRequest.hasCourseId() || (requestPriority = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(xAdvisorRequest.getCourseId().getCourseId(), xAdvisorRequest.getCourseId().getCourseName()))) != null && !requestPriority.isAlternative()) continue;
                boolean hasAlt = false;
                for (XAdvisorRequest xAdvisorRequest4 : original.getAdvisorRequests()) {
                    CourseRequestInterface.RequestPriority requestPriority2;
                    if (xAdvisorRequest4.getPriority() != xAdvisorRequest.getPriority() || !xAdvisorRequest4.hasCourseId() || xAdvisorRequest4.isSubstitute() || !xAdvisorRequest4.isCritical() || xAdvisorRequest.getAlternative() == 0 || (requestPriority2 = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(xAdvisorRequest4.getCourseId().getCourseId(), xAdvisorRequest4.getCourseId().getCourseName()))) == null || requestPriority2.isAlternative()) continue;
                    hasAlt = true;
                    break;
                }
                if (hasAlt) continue;
                if (advCritical == CourseDemand.Critical.IMPORTANT || xAdvisorRequest.getCritical() == 2) {
                    response.addMessage(xAdvisorRequest.getCourseId().getCourseId(), xAdvisorRequest.getCourseId().getCourseName(), "DROP_CRIT", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.courseMissingAdvisedCritical", "Missing important course that has been recommended by the advisor.").replace("{course}", xAdvisorRequest.getCourseId().getCourseName()), CONF_UNITIME);
                    missImportant = true;
                } else if (advCritical == CourseDemand.Critical.VITAL || xAdvisorRequest.getCritical() == 3) {
                    response.addMessage(xAdvisorRequest.getCourseId().getCourseId(), xAdvisorRequest.getCourseId().getCourseName(), "DROP_CRIT", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.courseMissingAdvisedCritical", "Missing vital course that has been recommended by the advisor.").replace("{course}", xAdvisorRequest.getCourseId().getCourseName()), CONF_UNITIME);
                    missVital = true;
                } else {
                    response.addMessage(xAdvisorRequest.getCourseId().getCourseId(), xAdvisorRequest.getCourseId().getCourseName(), "DROP_CRIT", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.courseMissingAdvisedCritical", "Missing critical course that has been recommended by the advisor.").replace("{course}", xAdvisorRequest.getCourseId().getCourseName()), CONF_UNITIME);
                    missCritical = true;
                }
                questionMissingAdvisorCritical = true;
            }
        }
        boolean questionRestrictionsNotMet = false;
        XSchedulingRule xSchedulingRule = server.getSchedulingRule(original, StudentSchedulingRule.Mode.Online, helper.hasAvisorPermission(), helper.hasAdminPermission());
        boolean bl9 = false;
        if (xSchedulingRule != null) {
            for (CourseRequestInterface.Request r : request.getCourses()) {
                if (!r.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse requestedCourse : r.getRequestedCourse()) {
                    CourseOffering co;
                    if (requestedCourse.getCourseId() == null || (co = (CourseOffering)CourseOfferingDAO.getInstance().get(requestedCourse.getCourseId(), helper.getHibSession())) == null || xSchedulingRule.matchesCourse(co)) continue;
                    boolean confirm = original.getRequestForCourse(requestedCourse.getCourseId()) == null;
                    response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "NOT-RULE", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.notMatchingRuleCourse", "No {rule} option.").replace("{rule}", xSchedulingRule.getRuleName()).replace("{course}", requestedCourse.getCourseName()), confirm ? CONF_UNITIME : CONF_NONE);
                    if (!confirm) continue;
                    questionRestrictionsNotMet = true;
                }
            }
        } else {
            String filter = server.getConfig().getProperty("Load.OnlineOnlyStudentFilter", null);
            if (filter != null && !filter.isEmpty()) {
                if (new Query(filter).match(new StatusPageSuggestionsAction.StudentMatcher(original, server.getAcademicSession().getDefaultSectioningStatus(), server, false))) {
                    bl = true;
                    cn = server.getConfig().getProperty("Load.OnlineOnlyCourseNameRegExp");
                    String string = server.getConfig().getProperty("Load.OnlineOnlyInstructionalModeRegExp");
                    for (CourseRequestInterface.Request r : request.getCourses()) {
                        if (!r.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse requestedCourse : r.getRequestedCourse()) {
                            if (requestedCourse.getCourseId() == null) continue;
                            if (cn != null && !cn.isEmpty() && !requestedCourse.getCourseName().matches(cn)) {
                                boolean confirm = original.getRequestForCourse(requestedCourse.getCourseId()) == null;
                                response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", requestedCourse.getCourseName()), confirm ? CONF_UNITIME : CONF_NONE);
                                if (!confirm) continue;
                                questionRestrictionsNotMet = true;
                                continue;
                            }
                            if (string == null) continue;
                            boolean hasMatchingConfig = false;
                            co = (CourseOffering)CourseOfferingDAO.getInstance().get(requestedCourse.getCourseId(), helper.getHibSession());
                            if (co != null) {
                                for (InstrOfferingConfig config : co.getInstructionalOffering().getInstrOfferingConfigs()) {
                                    configIm = config.getEffectiveInstructionalMethod();
                                    if (string.isEmpty()) {
                                        if (config.getInstructionalMethod() != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                        hasMatchingConfig = true;
                                        continue;
                                    }
                                    if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(string)) continue;
                                    hasMatchingConfig = true;
                                }
                            }
                            if (hasMatchingConfig) continue;
                            boolean confirm = original.getRequestForCourse(requestedCourse.getCourseId()) == null;
                            response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", requestedCourse.getCourseName()), confirm ? CONF_UNITIME : CONF_NONE);
                            if (!confirm) continue;
                            questionRestrictionsNotMet = true;
                        }
                    }
                    for (CourseRequestInterface.Request r : request.getAlternatives()) {
                        if (!r.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse requestedCourse : r.getRequestedCourse()) {
                            if (requestedCourse.getCourseId() == null) continue;
                            if (cn != null && !cn.isEmpty() && !requestedCourse.getCourseName().matches(cn)) {
                                boolean confirm = original.getRequestForCourse(requestedCourse.getCourseId()) == null;
                                response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", requestedCourse.getCourseName()), confirm ? CONF_UNITIME : CONF_NONE);
                                if (!confirm) continue;
                                questionRestrictionsNotMet = true;
                                continue;
                            }
                            if (string == null) continue;
                            boolean hasMatchingConfig = false;
                            co = (CourseOffering)CourseOfferingDAO.getInstance().get(requestedCourse.getCourseId(), helper.getHibSession());
                            if (co != null) {
                                for (InstrOfferingConfig config : co.getInstructionalOffering().getInstrOfferingConfigs()) {
                                    configIm = config.getEffectiveInstructionalMethod();
                                    if (string.isEmpty()) {
                                        if (configIm != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                        hasMatchingConfig = true;
                                        continue;
                                    }
                                    if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(string)) continue;
                                    hasMatchingConfig = true;
                                }
                            }
                            if (hasMatchingConfig) continue;
                            boolean confirm = original.getRequestForCourse(requestedCourse.getCourseId()) == null;
                            response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", requestedCourse.getCourseName()), confirm ? CONF_UNITIME : CONF_NONE);
                            if (!confirm) continue;
                            questionRestrictionsNotMet = true;
                        }
                    }
                } else if (server.getConfig().getPropertyBoolean("Load.OnlineOnlyExclusiveCourses", false)) {
                    cn = server.getConfig().getProperty("Load.OnlineOnlyCourseNameRegExp");
                    String string = server.getConfig().getProperty("Load.ResidentialInstructionalModeRegExp");
                    for (CourseRequestInterface.Request r : request.getCourses()) {
                        if (!r.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse requestedCourse : r.getRequestedCourse()) {
                            if (requestedCourse.getCourseId() == null) continue;
                            if (cn != null && !cn.isEmpty() && requestedCourse.getCourseName().matches(cn)) {
                                boolean confirm = original.getRequestForCourse(requestedCourse.getCourseId()) == null;
                                response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", requestedCourse.getCourseName()), confirm ? CONF_UNITIME : CONF_NONE);
                                if (!confirm) continue;
                                questionRestrictionsNotMet = true;
                                continue;
                            }
                            if (string == null) continue;
                            boolean hasMatchingConfig = false;
                            co = (CourseOffering)CourseOfferingDAO.getInstance().get(requestedCourse.getCourseId(), helper.getHibSession());
                            if (co != null) {
                                for (InstrOfferingConfig config : co.getInstructionalOffering().getInstrOfferingConfigs()) {
                                    configIm = config.getEffectiveInstructionalMethod();
                                    if (string.isEmpty()) {
                                        if (configIm != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                        hasMatchingConfig = true;
                                        continue;
                                    }
                                    if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(string)) continue;
                                    hasMatchingConfig = true;
                                }
                            }
                            if (hasMatchingConfig) continue;
                            boolean confirm = original.getRequestForCourse(requestedCourse.getCourseId()) == null;
                            response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", requestedCourse.getCourseName()), confirm ? CONF_UNITIME : CONF_NONE);
                            if (!confirm) continue;
                            questionRestrictionsNotMet = true;
                        }
                    }
                    for (CourseRequestInterface.Request r : request.getAlternatives()) {
                        if (!r.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse requestedCourse : r.getRequestedCourse()) {
                            if (requestedCourse.getCourseId() == null) continue;
                            if (cn != null && !cn.isEmpty() && requestedCourse.getCourseName().matches(cn)) {
                                boolean confirm = original.getRequestForCourse(requestedCourse.getCourseId()) == null;
                                response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", requestedCourse.getCourseName()), confirm ? CONF_UNITIME : CONF_NONE);
                                if (!confirm) continue;
                                questionRestrictionsNotMet = true;
                                continue;
                            }
                            if (string == null) continue;
                            boolean hasMatchingConfig = false;
                            co = (CourseOffering)CourseOfferingDAO.getInstance().get(requestedCourse.getCourseId(), helper.getHibSession());
                            if (co != null) {
                                for (InstrOfferingConfig config : co.getInstructionalOffering().getInstrOfferingConfigs()) {
                                    configIm = config.getEffectiveInstructionalMethod();
                                    if (string.isEmpty()) {
                                        if (configIm != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                        hasMatchingConfig = true;
                                        continue;
                                    }
                                    if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(string)) continue;
                                    hasMatchingConfig = true;
                                }
                            }
                            if (hasMatchingConfig) continue;
                            boolean confirm = original.getRequestForCourse(requestedCourse.getCourseId()) == null;
                            response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", requestedCourse.getCourseName()), confirm ? CONF_UNITIME : CONF_NONE);
                            if (!confirm) continue;
                            questionRestrictionsNotMet = true;
                        }
                    }
                }
            }
        }
        boolean questionFreeTime = false;
        for (int i = 0; i < request.getCourses().size(); ++i) {
            boolean bl10;
            CourseRequestInterface.Request request5 = request.getCourse(i);
            if (!request5.hasRequestedCourse() || !request5.getRequestedCourse(0).isFreeTime()) continue;
            boolean bl11 = false;
            for (int j = i + 1; j < request.getCourses().size(); ++j) {
                CourseRequestInterface.Request q = request.getCourse(j);
                if (!q.hasRequestedCourse() || !q.getRequestedCourse(0).isCourse()) continue;
                bl10 = true;
            }
            Object free = "";
            boolean confirm = false;
            block47: for (CourseRequestInterface.FreeTime ft : request5.getRequestedCourse(0).getFreeTime()) {
                if (!((String)free).isEmpty()) {
                    free = (String)free + ", ";
                }
                free = (String)free + ft.toString(CONSTANTS.shortDays(), CONSTANTS.useAmPm());
                if (confirm) continue;
                XFreeTimeRequest ftr = original.getRequestForFreeTime(ft);
                if (ftr == null) {
                    confirm = true;
                    continue;
                }
                if (!bl10) continue;
                for (int j = i + 1; j < request.getCourses().size(); ++j) {
                    Object cr8;
                    CourseRequestInterface.Request q = request.getCourse(j);
                    if (!q.hasRequestedCourse() || !q.getRequestedCourse(0).isCourse() || (cr8 = original.getRequestForCourse(q.getRequestedCourse(0).getCourseId())) != null && ((XRequest)cr8).getPriority() >= ftr.getPriority()) continue;
                    confirm = true;
                    continue block47;
                }
            }
            if (bl10) {
                response.addMessage(0L, CONSTANTS.freePrefix() + (String)free, "FREE-TIME", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.freeTimeHighPriority", "High priority free time"), confirm ? CONF_UNITIME : CONF_NONE);
            }
            if (!confirm) continue;
            questionFreeTime = true;
        }
        HashSet<Long> originalCourses = new HashSet<Long>();
        for (XRequest xRequest : original.getRequests()) {
            if (!(xRequest instanceof XCourseRequest)) continue;
            for (XCourseId c : ((XCourseRequest)xRequest).getCourseIds()) {
                originalCourses.add(c.getCourseId());
            }
        }
        boolean bl12 = false;
        if (server instanceof DatabaseServer) {
            InstructionalOffering io;
            for (CourseRequestInterface.Request r : request.getCourses()) {
                if (!r.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse requestedCourse : r.getRequestedCourse()) {
                    boolean bl13;
                    CourseOffering co;
                    if (requestedCourse.getCourseId() == null || requestedCourse.isReadOnly() || (io = (co = (CourseOffering)CourseOfferingDAO.getInstance().get(requestedCourse.getCourseId(), helper.getHibSession())) == null ? null : co.getInstructionalOffering()) == null || !io.hasSchedulingDisclaimer()) continue;
                    if (io.hasMultipleSchedulingDisclaimers()) {
                        for (InstrOfferingConfig config : io.getInstrOfferingConfigs()) {
                            if (!config.hasSchedulingDisclaimer() || xSchedulingRule != null && !xSchedulingRule.matchesInstructionalMethod(config.getInstructionalMethod())) continue;
                            response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "DISCLAIMER", (String)(config.getInstructionalMethod() == null ? "" : config.getInstructionalMethod().getLabel() + ": ") + config.getSchedulingDisclaimer(), originalCourses.contains(requestedCourse.getCourseId()) ? CONF_NONE : CONF_UNITIME);
                            if (originalCourses.contains(requestedCourse.getCourseId())) continue;
                            bl13 = true;
                        }
                        continue;
                    }
                    response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "DISCLAIMER", io.getFirstSchedulingDisclaimer(), originalCourses.contains(requestedCourse.getCourseId()) ? CONF_NONE : CONF_UNITIME);
                    if (originalCourses.contains(requestedCourse.getCourseId())) continue;
                    bl13 = true;
                }
            }
            for (CourseRequestInterface.Request r : request.getAlternatives()) {
                if (!r.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse requestedCourse : r.getRequestedCourse()) {
                    boolean bl14;
                    CourseOffering co;
                    if (requestedCourse.getCourseId() == null || requestedCourse.isReadOnly() || (io = (co = (CourseOffering)CourseOfferingDAO.getInstance().get(requestedCourse.getCourseId(), helper.getHibSession())) == null ? null : co.getInstructionalOffering()) == null || !io.hasSchedulingDisclaimer()) continue;
                    if (io.hasMultipleSchedulingDisclaimers()) {
                        for (InstrOfferingConfig config : io.getInstrOfferingConfigs()) {
                            if (!config.hasSchedulingDisclaimer() || xSchedulingRule != null && !xSchedulingRule.matchesInstructionalMethod(config.getInstructionalMethod())) continue;
                            response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "DISCLAIMER", (String)(config.getInstructionalMethod() == null ? "" : config.getInstructionalMethod().getLabel() + ": ") + config.getSchedulingDisclaimer(), originalCourses.contains(requestedCourse.getCourseId()) ? CONF_NONE : CONF_UNITIME);
                            if (originalCourses.contains(requestedCourse.getCourseId())) continue;
                            bl14 = true;
                        }
                        continue;
                    }
                    response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "DISCLAIMER", io.getFirstSchedulingDisclaimer(), originalCourses.contains(requestedCourse.getCourseId()) ? CONF_NONE : CONF_UNITIME);
                    if (originalCourses.contains(requestedCourse.getCourseId())) continue;
                    bl14 = true;
                }
            }
        } else {
            XEnrollment enrollment;
            Iterator<CourseRequestInterface.Request> offering;
            for (CourseRequestInterface.Request r : request.getCourses()) {
                if (!r.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse requestedCourse : r.getRequestedCourse()) {
                    boolean bl15;
                    XCourse course;
                    if (requestedCourse.getCourseId() == null || requestedCourse.isReadOnly() || (offering = (course = server.getCourse(requestedCourse.getCourseId())) == null ? null : server.getOffering(course.getOfferingId())) == null || !((XOffering)((Object)offering)).hasSchedulingDisclaimer()) continue;
                    if (((XOffering)((Object)offering)).hasMultipleSchedulingDisclaimers()) {
                        XCourseRequest cr9 = original.getRequestForCourse(course.getCourseId());
                        enrollment = cr9 == null ? null : cr9.getEnrollment();
                        for (XConfig config : ((XOffering)((Object)offering)).getConfigs()) {
                            if (!config.hasSchedulingDisclaimer() || xSchedulingRule != null && !xSchedulingRule.matchesInstructionalMethod(config.getInstructionalMethod()) || !DefaultCourseRequestValidator.isAvailable(original, offering, course, config, enrollment, requestedCourse)) continue;
                            response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "DISCLAIMER", (String)(config.getInstructionalMethod() == null ? "" : config.getInstructionalMethod().getLabel() + ": ") + config.getSchedulingDisclaimer(), originalCourses.contains(requestedCourse.getCourseId()) ? CONF_NONE : CONF_UNITIME);
                            if (originalCourses.contains(requestedCourse.getCourseId())) continue;
                            bl15 = true;
                        }
                        continue;
                    }
                    response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "DISCLAIMER", ((XOffering)((Object)offering)).getFirstSchedulingDisclaimer(), originalCourses.contains(requestedCourse.getCourseId()) ? CONF_NONE : CONF_UNITIME);
                    if (originalCourses.contains(requestedCourse.getCourseId())) continue;
                    bl15 = true;
                }
            }
            for (CourseRequestInterface.Request r : request.getAlternatives()) {
                if (!r.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse requestedCourse : r.getRequestedCourse()) {
                    boolean bl16;
                    XCourse course;
                    if (requestedCourse.getCourseId() == null || requestedCourse.isReadOnly() || (offering = (course = server.getCourse(requestedCourse.getCourseId())) == null ? null : server.getOffering(course.getOfferingId())) == null || !((XOffering)((Object)offering)).hasSchedulingDisclaimer()) continue;
                    if (((XOffering)((Object)offering)).hasMultipleSchedulingDisclaimers()) {
                        XCourseRequest cr10 = original.getRequestForCourse(course.getCourseId());
                        enrollment = cr10 == null ? null : cr10.getEnrollment();
                        for (XConfig config : ((XOffering)((Object)offering)).getConfigs()) {
                            if (!config.hasSchedulingDisclaimer() || xSchedulingRule != null && !xSchedulingRule.matchesInstructionalMethod(config.getInstructionalMethod()) || !DefaultCourseRequestValidator.isAvailable(original, offering, course, config, enrollment, requestedCourse)) continue;
                            response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "DISCLAIMER", (String)(config.getInstructionalMethod() == null ? "" : config.getInstructionalMethod().getLabel() + ": ") + config.getSchedulingDisclaimer(), originalCourses.contains(requestedCourse.getCourseId()) ? CONF_NONE : CONF_UNITIME);
                            if (originalCourses.contains(requestedCourse.getCourseId())) continue;
                            bl16 = true;
                        }
                        continue;
                    }
                    response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "DISCLAIMER", ((XOffering)((Object)offering)).getFirstSchedulingDisclaimer(), originalCourses.contains(requestedCourse.getCourseId()) ? CONF_NONE : CONF_UNITIME);
                    if (originalCourses.contains(requestedCourse.getCourseId())) continue;
                    bl16 = true;
                }
            }
        }
        Object var31_146 = null;
        Float maxCredit = original.getMaxCredit();
        if (maxCredit == null) {
            maxCredit = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty(this.iParameterPrefix + "maxCreditDefault", "18")));
        }
        Set<Long> advisorWaitListedCourseIds = original.getAdvisorWaitListedCourseIds(server);
        if (maxCredit != null && request.getCredit(advisorWaitListedCourseIds) > maxCredit.floatValue()) {
            for (CourseRequestInterface.RequestedCourse rc : this.getOverCreditRequests(request, maxCredit.floatValue())) {
                response.addMessage(rc.getCourseId(), rc.getCourseName(), "CREDIT", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(advisorWaitListedCourseIds)))), CONF_NONE);
            }
            response.setCreditWarning(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(advisorWaitListedCourseIds)))));
            response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_HIGH);
            String string = ApplicationProperties.getProperty(this.iParameterPrefix + "messages.maxCreditError", "Maximum of {max} credit hours exceeded.\nYou may not be able to get a full schedule.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(advisorWaitListedCourseIds))));
        }
        String string = ApplicationProperties.getProperty(this.iParameterPrefix + "minCreditCheck");
        float minCredit = 0.0f;
        block64: for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit()) continue;
                minCredit += rc.getCreditMin().floatValue();
                continue block64;
            }
        }
        if (var31_148 == null && string != null && minCredit < Float.parseFloat(string) && (maxCredit == null || maxCredit.floatValue() > Float.parseFloat(string)) && ((minCreditLimitFilter = ApplicationProperties.getProperty(this.iParameterPrefix + "minCreditCheck.studentFilter")) == null || minCreditLimitFilter.isEmpty() || new Query(minCreditLimitFilter).match(new StatusPageSuggestionsAction.StudentMatcher(original, server.getAcademicSession().getDefaultSectioningStatus(), server, false)))) {
            String string2 = ApplicationProperties.getProperty(this.iParameterPrefix + "messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", string).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit)));
            response.setCreditWarning(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", string).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit))));
            response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_LOW);
        }
        if (response.getConfirms().contains(CONF_UNITIME)) {
            response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.unitimeProblemsFound", "The following issues have been detected:"), CONF_UNITIME, -1);
            response.addConfirmation("", CONF_UNITIME, 1);
        }
        int line = 2;
        if (var31_150 != null) {
            response.addConfirmation((String)var31_150, CONF_UNITIME, line++);
        }
        if (bl4) {
            response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.noAlternatives", (line > 2 ? "\n" : "") + "One or more of the newly requested courses have no alternatives provided. You may not be able to get a full schedule because you did not provide an alternative course."), CONF_UNITIME, line++);
        }
        if (bl3) {
            response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.question.parentSameRequest", (line > 2 ? "\n" : "") + "A course and its associated course are on the same request line. You will not be able to get both courses."), CONF_UNITIME, line++);
        }
        if (questionParentSubstitute) {
            response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.question.parentSubstitute", (line > 2 ? "\n" : "") + "An associated course is requested as a substitute. You may not be able to get both courses."), CONF_UNITIME, line++);
        }
        if (questionNoParent) {
            response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.question.noParent", (line > 2 ? "\n" : "") + "A course depends on another course. You will not be able to get the course if you do not request the associated course unless you have already taken the associated course in the past."), CONF_UNITIME, line++);
        }
        if (bl2) {
            response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.timeConflicts", (line > 2 ? "\n" : "") + "Two or more single section courses are conflicting with each other. You will likely not be able to get the conflicting course, so please provide an alternative course if possible."), CONF_UNITIME, line++);
        }
        if (questionInconStuPref) {
            response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.inconsistentStudPref", (line > 2 ? "\n" : "") + "One or more courses are not available due to the selected preferences."), CONF_UNITIME, line++);
        }
        if (questionDropCritical) {
            if (dropVital && !dropCritical && !dropImportant) {
                response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.dropCritical", (line > 2 ? "\n" : "") + "One or more vital courses have been removed. This may prohibit progress towards degree. Please consult with your academic advisor."), CONF_UNITIME, line++);
            } else if (dropImportant && !dropVital && !dropCritical) {
                response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.dropCritical", (line > 2 ? "\n" : "") + "One or more important courses have been removed. This may prohibit progress towards degree. Please consult with your academic advisor."), CONF_UNITIME, line++);
            } else if (advCritical != CourseDemand.Critical.NORMAL) {
                response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.dropCritical", (line > 2 ? "\n" : "") + "One or more critical courses have been removed. This may prohibit progress towards degree. Please consult with your academic advisor."), CONF_UNITIME, line++);
            } else {
                response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.dropCritical", (line > 2 ? "\n" : "") + "One or more courses that are marked as critical in your degree plan have been removed. This may prohibit progress towards degree. Please consult with your academic advisor."), CONF_UNITIME, line++);
            }
        }
        if (questionMissingAdvisorCritical) {
            if (advCritical == CourseDemand.Critical.IMPORTANT || missImportant && !missCritical && !missVital) {
                response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.missingAdvisedCritical", (line > 2 ? "\n" : "") + "One or more courses that are marked by your advisor as important have not been requested. This may prohibit progress towards degree. Please see you advisor course requests and/or consult with your academic advisor."), CONF_UNITIME, line++);
            } else if (advCritical == CourseDemand.Critical.VITAL || missVital && !missCritical && !missImportant) {
                response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.missingAdvisedCritical", (line > 2 ? "\n" : "") + "One or more courses that are marked by your advisor as vital have not been requested. This may prohibit progress towards degree. Please see you advisor course requests and/or consult with your academic advisor."), CONF_UNITIME, line++);
            } else if (advCritical == CourseDemand.Critical.CRITICAL) {
                response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.missingAdvisedCritical", (line > 2 ? "\n" : "") + "One or more courses that are marked by your advisor as critical have not been requested. This may prohibit progress towards degree. Please see you advisor course requests and/or consult with your academic advisor."), CONF_UNITIME, line++);
            } else {
                response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.missingAdvisedCritical", (line > 2 ? "\n" : "") + "One or more courses that are marked as critical in your degree plan and that have been listed by your advisor have not been requested. This may prohibit progress towards degree. Please see you advisor course requests and/or consult with your academic advisor."), CONF_UNITIME, line++);
            }
        }
        if (questionRestrictionsNotMet) {
            if (xSchedulingRule != null) {
                response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.ruleNotMet", (line > 2 ? "\n" : "") + "One or more of the newly requested courses have no {rule} option at the moment. You may not be able to get a full schedule because becasue you are not allowed to take these courses.".replace("{rule}", xSchedulingRule.getRuleName())), CONF_UNITIME, line++);
            } else if (bl) {
                response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.onlineOnlyNotMet", (line > 2 ? "\n" : "") + "One or more of the newly requested courses have no online-only option at the moment. You may not be able to get a full schedule because becasue you are not allowed to take these courses."), CONF_UNITIME, line++);
            } else {
                response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.residentialNotMet", (line > 2 ? "\n" : "") + "One or more of the newly requested courses have no residential option at the moment. You may not be able to get a full schedule because becasue you are not allowed to take these courses."), CONF_UNITIME, line++);
            }
        }
        if (questionFreeTime) {
            response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.freeTimeRequested", (line > 2 ? "\n" : "") + "Free time requests will be considered as time blocks during the pre-registration process. When possible, classes should be avoided during free time. However, if a free time request is placed higher than a course, the course cannot be attended during free time and you may not receive a full schedule."), CONF_UNITIME, line++);
        }
        if (line > 2 || var30_123 != false) {
            response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.confirmation", "\nDo you want to proceed?"), CONF_UNITIME, line++);
        }
        if ((conf = response.getConfirms()).contains(CONF_UNITIME)) {
            response.setConfirmation(CONF_UNITIME, ApplicationProperties.getProperty(this.iParameterPrefix + "confirm.unitimeDialogName", "Warning Confirmations"), ApplicationProperties.getProperty(this.iParameterPrefix + "confirm.unitimeYesButton", "Accept & Submit"), ApplicationProperties.getProperty(this.iParameterPrefix + "confirm.unitimeNoButton", "Cancel Submit"), ApplicationProperties.getProperty(this.iParameterPrefix + "confirm.unitimeYesButtonTitle", "Accept the above warning(s) and submit the Course Requests"), ApplicationProperties.getProperty(this.iParameterPrefix + "confirm.unitimeNoButtonTitle", "Go back to editing your Course Requests"));
        }
    }

    @Override
    public void submit(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request) throws SectioningException {
    }

    @Override
    public Collection<Long> updateStudents(OnlineSectioningServer server, OnlineSectioningHelper helper, List<org.unitime.timetable.model.Student> students) throws SectioningException {
        return null;
    }

    @Override
    public void dispose() {
    }

    protected boolean isAdvisorValidationEnabled(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, String status) {
        if (status == null) {
            status = student.getStatus();
        } else if (status.isEmpty()) {
            status = server.getAcademicSession().getDefaultSectioningStatus();
        }
        if (status == null) {
            status = server.getAcademicSession().getDefaultSectioningStatus();
        }
        if (status == null) {
            return true;
        }
        StudentSectioningStatus dbStatus = StudentSectioningStatus.getPresentStatus(status, server.getAcademicSession().getUniqueId(), helper.getHibSession());
        return dbStatus != null && dbStatus.hasOption(StudentSectioningStatus.Option.reqval) || dbStatus.hasOption(StudentSectioningStatus.Option.specreg);
    }

    @Override
    public void validateAdvisorRecommendations(OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.AdvisingStudentDetails details, CourseRequestInterface.CheckCoursesResponse response) throws SectioningException {
        Set<Integer> set;
        String minCreditLimitFilter;
        boolean bl;
        Comparable<CourseRequestInterface.RequestedCourse> parent;
        XStudent original;
        XStudent xStudent = original = details.getStudentId() == null ? null : server.getStudent(details.getStudentId());
        if (original == null) {
            throw new PageAccessException(MESSAGES.exceptionEnrollNotStudent(server.getAcademicSession().toString()));
        }
        if (!this.isAdvisorValidationEnabled(server, helper, original, details.getStatus() == null ? null : details.getStatus().getReference())) {
            return;
        }
        CourseRequestInterface request = details.getRequest();
        Integer CONF_UNITIME = 0;
        HashSet<Long> courseIds = new HashSet<Long>();
        for (CourseRequestInterface.Request request2 : request.getCourses()) {
            if (!request2.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : request2.getRequestedCourse()) {
                if (!rc.hasCourseId() || courseIds.add(rc.getCourseId())) continue;
                response.addError(rc.getCourseId(), rc.getCourseName(), "DUPL", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.duplicateCourse", "Course {course} used multiple times.").replace("{course}", rc.getCourseName()));
                if (response.hasErrorMessage()) continue;
                response.setErrorMessage(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.duplicateCourse", "Course {course} used multiple times.").replace("{course}", rc.getCourseName()));
            }
        }
        boolean questionNoAlt = false;
        if (!this.isAdvisedNoAlts()) {
            for (CourseRequestInterface.Request r : request.getCourses()) {
                CourseRequestInterface.RequestedCourse rc;
                if (!r.hasRequestedCourse() || r.getRequestedCourse().size() != 1 || (r.isWaitList() || r.isNoSub()) && this.isWaitListNoAlts() || (rc = r.getRequestedCourse(0)).getCourseId() == null || rc.isReadOnly() || request.hasCourse(rc.getParentCourseId())) continue;
                response.addMessage(rc.getCourseId(), rc.getCourseName(), "NO_ALT", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.courseHasNoAlt", "No alternative course provided.").replace("{course}", rc.getCourseName()), CONF_UNITIME);
                questionNoAlt = true;
            }
        }
        boolean bl2 = false;
        boolean questionParentSubstitute = false;
        boolean questionNoParent = false;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (r.hasRequestedCourse() && r.getRequestedCourse().size() > 1) {
                for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                    parent = r.getCourse(rc.getParentCourseId());
                    if (parent == null) continue;
                    response.addMessage(rc.getCourseId(), rc.getCourseName(), "PARENT_SAME_REQ", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.parentSameRequest", "Associated course {parent} on the same request line.").replace("{parent}", ((CourseRequestInterface.RequestedCourse)parent).getCourseName()).replace("{course}", rc.getCourseName()), CONF_UNITIME);
                    boolean bl3 = true;
                }
            }
            if (r.hasRequestedCourse()) {
                for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                    CourseRequestInterface.Request a = request.getAlternativeForCourseId(rc.getParentCourseId());
                    if (a == null) continue;
                    CourseRequestInterface.RequestedCourse parent2 = a.getCourse(rc.getParentCourseId());
                    response.addMessage(rc.getCourseId(), rc.getCourseName(), "PARENT_SUBST", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.parentSubstitute", "Associated course {parent} is requested as a substitute.").replace("{parent}", parent2.getCourseName()).replace("{course}", rc.getCourseName()), CONF_UNITIME);
                    questionParentSubstitute = true;
                }
            }
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasParentCourseId() || request.hasCourse(rc.getParentCourseId())) continue;
                parent = server.getCourse(rc.getParentCourseId());
                response.addMessage(rc.getCourseId(), rc.getCourseName(), "NO_PARENT", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.noParent", "Depends on {parent}.").replace("{parent}", ((XCourseId)parent).getCourseName()).replace("{course}", rc.getCourseName()), CONF_UNITIME);
                questionNoParent = true;
            }
        }
        for (CourseRequestInterface.Request r : request.getAlternatives()) {
            if (r.hasRequestedCourse() && r.getRequestedCourse().size() > 1) {
                for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                    parent = r.getCourse(rc.getParentCourseId());
                    if (parent == null) continue;
                    response.addMessage(rc.getCourseId(), rc.getCourseName(), "PARENT_SAME_REQ", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.parentSameRequest", "Associated course {parent} on the same request line.").replace("{parent}", ((CourseRequestInterface.RequestedCourse)parent).getCourseName()).replace("{course}", rc.getCourseName()), CONF_UNITIME);
                    bl = true;
                }
            }
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasParentCourseId() || request.hasCourse(rc.getParentCourseId())) continue;
                parent = server.getCourse(rc.getParentCourseId());
                response.addMessage(rc.getCourseId(), rc.getCourseName(), "NO_PARENT", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.noParent", "Depends on {parent}.").replace("{parent}", ((XCourseId)parent).getCourseName()).replace("{course}", rc.getCourseName()), CONF_UNITIME);
                questionNoParent = true;
            }
        }
        boolean questionTimeConflict = false;
        boolean questionInconStuPref = false;
        if (!(server instanceof DatabaseServer)) {
            CourseRequest cr;
            OnlineSectioningModel model = new OnlineSectioningModel(server.getConfig(), server.getOverExpectedCriterion());
            model.setDayOfWeekOffset(server.getAcademicSession().getDayOfWeekOffset());
            boolean linkedClassesMustBeUsed = server.getConfig().getPropertyBoolean("LinkedClasses.mustBeUsed", false);
            AssignmentMap assignment = new AssignmentMap();
            Student student = new Student(request.getStudentId().longValue());
            student.setExternalId(original.getExternalId());
            student.setName(original.getName());
            student.setNeedShortDistances(original.hasAccomodation(server.getDistanceMetric().getShortDistanceAccommodationReference()));
            student.setAllowDisabled(original.isAllowDisabled());
            student.setClassFirstDate(original.getClassStartDate());
            student.setClassLastDate(original.getClassEndDate());
            student.setBackToBackPreference(original.getBackToBackPreference());
            student.setModalityPreference(original.getModalityPreference());
            HashMap<Long, Section> classTable = new HashMap<Long, Section>();
            HashSet distributions = new HashSet();
            boolean hasAssignment = false;
            for (XRequest reqest : original.getRequests()) {
                if (!(reqest instanceof XCourseRequest) || ((XCourseRequest)reqest).getEnrollment() == null) continue;
                hasAssignment = true;
                break;
            }
            HashMap<Long, Course> courseTable = new HashMap<Long, Course>();
            HashMap parentCourses = new HashMap();
            for (CourseRequestInterface.Request request3 : request.getCourses()) {
                FindAssignmentAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, request3, false, false, classTable, courseTable, parentCourses, distributions, hasAssignment, true, helper);
            }
            for (CourseRequestInterface.Request request4 : request.getAlternatives()) {
                FindAssignmentAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, request4, true, false, classTable, courseTable, parentCourses, distributions, hasAssignment, true, helper);
            }
            boolean hasParent = false;
            for (Map.Entry entry : parentCourses.entrySet()) {
                Course course = (Course)courseTable.get(entry.getKey());
                Course parent3 = (Course)courseTable.get(entry.getValue());
                if (course == null || parent3 == null) continue;
                course.setParent(parent3);
                hasParent = true;
            }
            if (hasParent && "true".equalsIgnoreCase(ApplicationProperties.getProperty(this.iParameterPrefix + "checkDependentCourses", "true"))) {
                model.addGlobalConstraint((GlobalConstraint)new DependentCourses());
            }
            if ("true".equalsIgnoreCase(ApplicationProperties.getProperty(this.iParameterPrefix + "checkUnavailabilitiesFromOtherSessions", "false"))) {
                if (server.getConfig().getPropertyBoolean("General.CheckUnavailabilitiesFromOtherSessions", false)) {
                    GetInfo.fillInUnavailabilitiesFromOtherSessions(student, server, helper);
                } else if (server.getConfig().getPropertyBoolean("General.CheckUnavailabilitiesFromOtherSessionsUsingDatabase", false)) {
                    GetInfo.fillInUnavailabilitiesFromOtherSessionsUsingDatabase(student, server, helper);
                }
            }
            model.addStudent(student);
            model.setStudentQuality(new StudentQuality(server.getDistanceMetric(), model.getProperties()));
            Iterator iterator = distributions.iterator();
            while (iterator.hasNext()) {
                XDistribution xDistribution = (XDistribution)iterator.next();
                if (xDistribution.getDistributionType() != XDistributionType.LinkedSections) continue;
                ArrayList<Section> sections = new ArrayList<Section>();
                for (Long sectionId : xDistribution.getSectionIds()) {
                    Section x = (Section)classTable.get(sectionId);
                    if (x == null) continue;
                    sections.add(x);
                }
                if (sections.size() < 2) continue;
                model.addLinkedSections(linkedClassesMustBeUsed, sections);
            }
            if ("true".equalsIgnoreCase(ApplicationProperties.getProperty(this.iParameterPrefix + "dummyReservation", "false"))) {
                for (Request request5 : student.getRequests()) {
                    if (!(request5 instanceof CourseRequest)) continue;
                    CourseRequest cr2 = (CourseRequest)request5;
                    for (Object course : cr2.getCourses()) {
                        new OnlineReservation(XReservationType.Dummy.ordinal(), -3L, course.getOffering(), 5000, true, 1, true, true, true, true, true);
                    }
                }
            }
            HashMap<Section, Course> hashMap = new HashMap<Section, Course>();
            for (Request r : student.getRequests()) {
                if (r.isAlternative() || !(r instanceof CourseRequest)) continue;
                cr = (CourseRequest)r;
                for (Course course : cr.getCourses()) {
                    if (course.getOffering().getConfigs().size() != 1) continue;
                    for (Subpart subpart : ((Config)course.getOffering().getConfigs().get(0)).getSubparts()) {
                        if (subpart.getSections().size() != 1) continue;
                        Section section = (Section)subpart.getSections().get(0);
                        for (Section other : hashMap.keySet()) {
                            if (!section.isOverlapping((SctAssignment)other)) continue;
                            response.addMessage(course.getId(), course.getName(), "OVERLAP", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.courseOverlaps", "Conflicts with {other}.").replace("{course}", course.getName()).replace("{other}", ((Course)hashMap.get(other)).getName()), CONF_UNITIME);
                            questionTimeConflict = true;
                        }
                        if (cr.getCourses().size() != 1) continue;
                        hashMap.put(section, course);
                    }
                }
            }
            for (Request r : student.getRequests()) {
                if (!(r instanceof CourseRequest)) continue;
                cr = (CourseRequest)r;
                for (Course course : cr.getCourses()) {
                    if (!SectioningRequest.hasInconsistentRequirements(cr, course.getId())) continue;
                    response.addMessage(course.getId(), course.getName(), "STUD_PREF", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.inconsistentStudPref", "Not available due to preferences selected.").replace("{course}", course.getName()), CONF_UNITIME);
                    questionInconStuPref = true;
                }
            }
        }
        boolean questionRestrictionsNotMet = false;
        XSchedulingRule rule = server.getSchedulingRule(original, StudentSchedulingRule.Mode.Online, helper.hasAvisorPermission(), helper.hasAdminPermission());
        boolean onlineOnly = false;
        if (rule != null) {
            for (CourseRequestInterface.Request r : request.getCourses()) {
                if (!r.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse course : r.getRequestedCourse()) {
                    CourseOffering co;
                    if (course.getCourseId() == null || (co = (CourseOffering)CourseOfferingDAO.getInstance().get(course.getCourseId(), helper.getHibSession())) == null || rule.matchesCourse(co)) continue;
                    response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-RULE", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.notMatchingRuleCourse", "No {rule} option.").replace("{rule}", rule.getRuleName()).replace("{course}", course.getCourseName()), CONF_UNITIME);
                    questionRestrictionsNotMet = true;
                }
            }
        } else {
            String filter = server.getConfig().getProperty("Load.OnlineOnlyStudentFilter", null);
            if (filter != null && !filter.isEmpty()) {
                if (new Query(filter).match(new StatusPageSuggestionsAction.StudentMatcher(original, server.getAcademicSession().getDefaultSectioningStatus(), server, false))) {
                    onlineOnly = true;
                    cn = server.getConfig().getProperty("Load.OnlineOnlyCourseNameRegExp");
                    im = server.getConfig().getProperty("Load.OnlineOnlyInstructionalModeRegExp");
                    for (CourseRequestInterface.Request r : request.getCourses()) {
                        if (!r.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse course : r.getRequestedCourse()) {
                            boolean bl4;
                            if (course.getCourseId() == null) continue;
                            if (cn != null && !cn.isEmpty() && !course.getCourseName().matches(cn)) {
                                response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                                questionRestrictionsNotMet = true;
                                continue;
                            }
                            if (im == null) continue;
                            boolean bl5 = false;
                            CourseOffering courseOffering = (CourseOffering)CourseOfferingDAO.getInstance().get(course.getCourseId(), helper.getHibSession());
                            if (courseOffering != null) {
                                for (InstrOfferingConfig config : courseOffering.getInstructionalOffering().getInstrOfferingConfigs()) {
                                    configIm = config.getEffectiveInstructionalMethod();
                                    if (im.isEmpty()) {
                                        if (config.getInstructionalMethod() != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                        bl4 = true;
                                        continue;
                                    }
                                    if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(im)) continue;
                                    bl4 = true;
                                }
                            }
                            if (bl4) continue;
                            response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                            questionRestrictionsNotMet = true;
                        }
                    }
                    for (CourseRequestInterface.Request r : request.getAlternatives()) {
                        if (!r.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse course : r.getRequestedCourse()) {
                            boolean bl6;
                            if (course.getCourseId() == null) continue;
                            if (cn != null && !cn.isEmpty() && !course.getCourseName().matches(cn)) {
                                response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                                questionRestrictionsNotMet = true;
                                continue;
                            }
                            if (im == null) continue;
                            boolean bl7 = false;
                            CourseOffering courseOffering = (CourseOffering)CourseOfferingDAO.getInstance().get(course.getCourseId(), helper.getHibSession());
                            if (courseOffering != null) {
                                for (InstrOfferingConfig config : courseOffering.getInstructionalOffering().getInstrOfferingConfigs()) {
                                    configIm = config.getEffectiveInstructionalMethod();
                                    if (im.isEmpty()) {
                                        if (configIm != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                        bl6 = true;
                                        continue;
                                    }
                                    if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(im)) continue;
                                    bl6 = true;
                                }
                            }
                            if (bl6) continue;
                            response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                            questionRestrictionsNotMet = true;
                        }
                    }
                } else if (server.getConfig().getPropertyBoolean("Load.OnlineOnlyExclusiveCourses", false)) {
                    cn = server.getConfig().getProperty("Load.OnlineOnlyCourseNameRegExp");
                    im = server.getConfig().getProperty("Load.ResidentialInstructionalModeRegExp");
                    for (CourseRequestInterface.Request r : request.getCourses()) {
                        if (!r.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse course : r.getRequestedCourse()) {
                            boolean bl8;
                            if (course.getCourseId() == null) continue;
                            if (cn != null && !cn.isEmpty() && course.getCourseName().matches(cn)) {
                                response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                                questionRestrictionsNotMet = true;
                                continue;
                            }
                            if (im == null) continue;
                            boolean bl9 = false;
                            CourseOffering courseOffering = (CourseOffering)CourseOfferingDAO.getInstance().get(course.getCourseId(), helper.getHibSession());
                            if (courseOffering != null) {
                                for (InstrOfferingConfig config : courseOffering.getInstructionalOffering().getInstrOfferingConfigs()) {
                                    configIm = config.getEffectiveInstructionalMethod();
                                    if (im.isEmpty()) {
                                        if (configIm != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                        bl8 = true;
                                        continue;
                                    }
                                    if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(im)) continue;
                                    bl8 = true;
                                }
                            }
                            if (bl8) continue;
                            response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                            questionRestrictionsNotMet = true;
                        }
                    }
                    for (CourseRequestInterface.Request r : request.getAlternatives()) {
                        if (!r.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse course : r.getRequestedCourse()) {
                            boolean bl10;
                            if (course.getCourseId() == null) continue;
                            if (cn != null && !cn.isEmpty() && course.getCourseName().matches(cn)) {
                                response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                                questionRestrictionsNotMet = true;
                                continue;
                            }
                            if (im == null) continue;
                            boolean bl11 = false;
                            CourseOffering courseOffering = (CourseOffering)CourseOfferingDAO.getInstance().get(course.getCourseId(), helper.getHibSession());
                            if (courseOffering != null) {
                                for (InstrOfferingConfig config : courseOffering.getInstructionalOffering().getInstrOfferingConfigs()) {
                                    configIm = config.getEffectiveInstructionalMethod();
                                    if (im.isEmpty()) {
                                        if (configIm != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                        bl10 = true;
                                        continue;
                                    }
                                    if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(im)) continue;
                                    bl10 = true;
                                }
                            }
                            if (bl10) continue;
                            response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                            questionRestrictionsNotMet = true;
                        }
                    }
                }
            }
        }
        boolean questionFreeTime = false;
        for (int i = 0; i < request.getCourses().size(); ++i) {
            CourseRequestInterface.Request r = request.getCourse(i);
            if (!r.hasRequestedCourse() || !r.getRequestedCourse(0).isFreeTime()) continue;
            boolean hasCourse = false;
            for (int j = i + 1; j < request.getCourses().size(); ++j) {
                CourseRequestInterface.Request q = request.getCourse(j);
                if (!q.hasRequestedCourse() || !q.getRequestedCourse(0).hasCourseId()) continue;
                hasCourse = true;
            }
            Object free = "";
            for (CourseRequestInterface.FreeTime ft : r.getRequestedCourse(0).getFreeTime()) {
                if (!((String)free).isEmpty()) {
                    free = free + ", ";
                }
                free = free + ft.toString(CONSTANTS.shortDays(), CONSTANTS.useAmPm());
            }
            if (hasCourse) {
                response.addMessage(0L, CONSTANTS.freePrefix() + free, "FREE-TIME", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.freeTimeHighPriority", "High priority free time"), CONF_UNITIME);
            }
            questionFreeTime = true;
        }
        boolean questionDisclaimer = false;
        if (server instanceof DatabaseServer) {
            for (CourseRequestInterface.Request r : request.getCourses()) {
                if (!r.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                    CourseOffering co;
                    InstructionalOffering instructionalOffering;
                    if (rc.getCourseId() == null || rc.isReadOnly() || (instructionalOffering = (co = (CourseOffering)CourseOfferingDAO.getInstance().get(rc.getCourseId(), helper.getHibSession())) == null ? null : co.getInstructionalOffering()) == null || !instructionalOffering.hasSchedulingDisclaimer()) continue;
                    if (instructionalOffering.hasMultipleSchedulingDisclaimers()) {
                        for (InstrOfferingConfig config : instructionalOffering.getInstrOfferingConfigs()) {
                            if (!config.hasSchedulingDisclaimer() || rule != null && !rule.matchesInstructionalMethod(config.getInstructionalMethod())) continue;
                            response.addMessage(rc.getCourseId(), rc.getCourseName(), "DISCLAIMER", (String)(config.getInstructionalMethod() == null ? "" : config.getInstructionalMethod().getLabel() + ": ") + config.getSchedulingDisclaimer(), CONF_UNITIME);
                            questionDisclaimer = true;
                        }
                        continue;
                    }
                    response.addMessage(rc.getCourseId(), rc.getCourseName(), "DISCLAIMER", instructionalOffering.getFirstSchedulingDisclaimer(), CONF_UNITIME);
                    questionDisclaimer = true;
                }
            }
            for (CourseRequestInterface.Request r : request.getAlternatives()) {
                if (!r.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                    CourseOffering co;
                    InstructionalOffering instructionalOffering;
                    if (rc.getCourseId() == null || rc.isReadOnly() || (instructionalOffering = (co = (CourseOffering)CourseOfferingDAO.getInstance().get(rc.getCourseId(), helper.getHibSession())) == null ? null : co.getInstructionalOffering()) == null || !instructionalOffering.hasSchedulingDisclaimer()) continue;
                    if (instructionalOffering.hasMultipleSchedulingDisclaimers()) {
                        for (InstrOfferingConfig config : instructionalOffering.getInstrOfferingConfigs()) {
                            if (!config.hasSchedulingDisclaimer() || rule != null && !rule.matchesInstructionalMethod(config.getInstructionalMethod())) continue;
                            response.addMessage(rc.getCourseId(), rc.getCourseName(), "DISCLAIMER", (String)(config.getInstructionalMethod() == null ? "" : config.getInstructionalMethod().getLabel() + ": ") + config.getSchedulingDisclaimer(), CONF_UNITIME);
                            questionDisclaimer = true;
                        }
                        continue;
                    }
                    response.addMessage(rc.getCourseId(), rc.getCourseName(), "DISCLAIMER", instructionalOffering.getFirstSchedulingDisclaimer(), CONF_UNITIME);
                    questionDisclaimer = true;
                }
            }
        } else {
            XEnrollment enrollment;
            for (CourseRequestInterface.Request r : request.getCourses()) {
                if (!r.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                    XCourse course;
                    XOffering xOffering;
                    if (rc.getCourseId() == null || rc.isReadOnly() || (xOffering = (course = server.getCourse(rc.getCourseId())) == null ? null : server.getOffering(course.getOfferingId())) == null || !xOffering.hasSchedulingDisclaimer()) continue;
                    if (xOffering.hasMultipleSchedulingDisclaimers()) {
                        XCourseRequest xCourseRequest = original.getRequestForCourse(course.getCourseId());
                        enrollment = xCourseRequest == null ? null : xCourseRequest.getEnrollment();
                        for (XConfig config : xOffering.getConfigs()) {
                            if (!config.hasSchedulingDisclaimer() || rule != null && !rule.matchesInstructionalMethod(config.getInstructionalMethod()) || !DefaultCourseRequestValidator.isAvailable(original, xOffering, course, config, enrollment, rc)) continue;
                            response.addMessage(rc.getCourseId(), rc.getCourseName(), "DISCLAIMER", (String)(config.getInstructionalMethod() == null ? "" : config.getInstructionalMethod().getLabel() + ": ") + config.getSchedulingDisclaimer(), CONF_UNITIME);
                            questionDisclaimer = true;
                        }
                        continue;
                    }
                    response.addMessage(rc.getCourseId(), rc.getCourseName(), "DISCLAIMER", xOffering.getFirstSchedulingDisclaimer(), CONF_UNITIME);
                    questionDisclaimer = true;
                }
            }
            for (CourseRequestInterface.Request r : request.getAlternatives()) {
                if (!r.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                    XCourse course;
                    XOffering xOffering;
                    if (rc.getCourseId() == null || rc.isReadOnly() || (xOffering = (course = server.getCourse(rc.getCourseId())) == null ? null : server.getOffering(course.getOfferingId())) == null || !xOffering.hasSchedulingDisclaimer()) continue;
                    if (xOffering.hasMultipleSchedulingDisclaimers()) {
                        XCourseRequest xCourseRequest = original.getRequestForCourse(course.getCourseId());
                        enrollment = xCourseRequest == null ? null : xCourseRequest.getEnrollment();
                        for (XConfig config : xOffering.getConfigs()) {
                            if (!config.hasSchedulingDisclaimer() || rule != null && !rule.matchesInstructionalMethod(config.getInstructionalMethod()) || !DefaultCourseRequestValidator.isAvailable(original, xOffering, course, config, enrollment, rc)) continue;
                            response.addMessage(rc.getCourseId(), rc.getCourseName(), "DISCLAIMER", (String)(config.getInstructionalMethod() == null ? "" : config.getInstructionalMethod().getLabel() + ": ") + config.getSchedulingDisclaimer(), CONF_UNITIME);
                            questionDisclaimer = true;
                        }
                        continue;
                    }
                    response.addMessage(rc.getCourseId(), rc.getCourseName(), "DISCLAIMER", xOffering.getFirstSchedulingDisclaimer(), CONF_UNITIME);
                    questionDisclaimer = true;
                }
            }
        }
        String creditError = null;
        Float maxCredit = original.getMaxCredit();
        if (maxCredit == null) {
            maxCredit = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty(this.iParameterPrefix + "maxCreditDefault", "18")));
        }
        request.setWaitListMode(details.getWaitListMode());
        if (maxCredit != null && request.getCredit(null) > maxCredit.floatValue()) {
            for (CourseRequestInterface.RequestedCourse rc : this.getOverCreditRequests(request, maxCredit.floatValue())) {
                response.addMessage(rc.getCourseId(), rc.getCourseName(), "CREDIT", ApplicationProperties.getProperty(this.iParameterPrefix + "messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(null)))), CONF_UNITIME);
            }
            response.setCreditWarning(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(null)))));
            response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_HIGH);
            creditError = ApplicationProperties.getProperty(this.iParameterPrefix + "messages.acr.maxCreditError", "Maximum of {max} credit hours exceeded.\nThe student may not be able to get a full schedule.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(null))));
        }
        String minCreditLimit = ApplicationProperties.getProperty(this.iParameterPrefix + "minCreditCheck");
        float minCredit = 0.0f;
        block54: for (CourseRequestInterface.Request request6 : request.getCourses()) {
            if (request6.hasAdvisorCredit()) {
                minCredit += request6.getAdvisorCreditMin();
                continue;
            }
            if (!request6.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : request6.getRequestedCourse()) {
                if (!rc.hasCredit()) continue;
                minCredit += rc.getCreditMin().floatValue();
                continue block54;
            }
        }
        if (creditError == null && minCreditLimit != null && minCredit < Float.parseFloat(minCreditLimit) && (maxCredit == null || maxCredit.floatValue() > Float.parseFloat(minCreditLimit)) && ((minCreditLimitFilter = ApplicationProperties.getProperty(this.iParameterPrefix + "minCreditCheck.studentFilter")) == null || minCreditLimitFilter.isEmpty() || new Query(minCreditLimitFilter).match(new StatusPageSuggestionsAction.StudentMatcher(original, server.getAcademicSession().getDefaultSectioningStatus(), server, false)))) {
            creditError = ApplicationProperties.getProperty(this.iParameterPrefix + "messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", minCreditLimit).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit)));
            response.setCreditWarning(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", minCreditLimit).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit))));
            response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_LOW);
        }
        if (response.getConfirms().contains(CONF_UNITIME)) {
            response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.unitimeProblemsFound", "The following issues have been detected:"), CONF_UNITIME, -1);
            response.addConfirmation("", CONF_UNITIME, 1);
        }
        int line = 2;
        if (creditError != null) {
            response.addConfirmation(creditError, CONF_UNITIME, line++);
        }
        if (questionNoAlt) {
            response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.acr.noAlternatives", (line > 2 ? "\n" : "") + "One or more of the recommended courses have no alternatives provided. The student may not be able to get a full schedule."), CONF_UNITIME, line++);
        }
        if (bl) {
            response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.acr.parentSameRequest", (line > 2 ? "\n" : "") + "A course and its associated course are on the same request line. The student will not be able to get both courses."), CONF_UNITIME, line++);
        }
        if (questionParentSubstitute) {
            response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.acr.parentSubstitute", (line > 2 ? "\n" : "") + "An associated course is requested as a substitute. The student may not be able to get both courses."), CONF_UNITIME, line++);
        }
        if (questionNoParent) {
            response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.acr.noParent", (line > 2 ? "\n" : "") + "A course depends on another course. The student will not be able to get the course if they do not request the associated course, unless they have already taken the associated course in the past."), CONF_UNITIME, line++);
        }
        if (questionTimeConflict) {
            response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.acr.timeConflicts", (line > 2 ? "\n" : "") + "Two or more single section courses are conflicting with each other. The student will likely not be able to get the conflicting course, so please provide an alternative course if possible."), CONF_UNITIME, line++);
        }
        if (questionInconStuPref) {
            response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.acr.inconsistentStudPref", (line > 2 ? "\n" : "") + "One or more courses are not available due to the selected preferences."), CONF_UNITIME, line++);
        }
        if (questionRestrictionsNotMet) {
            if (rule != null) {
                response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.acr.ruleNotMet", (line > 2 ? "\n" : "") + "One or more of the recommended courses have no {rule} option at the moment. The student may not be able to get a full schedule.".replace("{rule}", rule.getRuleName())), CONF_UNITIME, line++);
            } else if (onlineOnly) {
                response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.acr.onlineOnlyNotMet", (line > 2 ? "\n" : "") + "One or more of the recommended courses have no online-only option at the moment. The student may not be able to get a full schedule."), CONF_UNITIME, line++);
            } else {
                response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.acr.residentialNotMet", (line > 2 ? "\n" : "") + "One or more of the recommended courses have no residential option at the moment. The student may not be able to get a full schedule."), CONF_UNITIME, line++);
            }
        }
        if (questionFreeTime) {
            response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.acr.freeTimeRequested", (line > 2 ? "\n" : "") + "Free time requests will be considered as time blocks during the pre-registration process. When possible, classes should be avoided during free time. However, if a free time request is placed higher than a course, the course cannot be attended during free time and the student may not receive a full schedule."), CONF_UNITIME, line++);
        }
        if (line > 2 || questionDisclaimer) {
            response.addConfirmation(ApplicationProperties.getProperty(this.iParameterPrefix + "messages.confirmation", "\nDo you want to proceed?"), CONF_UNITIME, line++);
        }
        if ((set = response.getConfirms()).contains(CONF_UNITIME)) {
            response.setConfirmation(CONF_UNITIME, ApplicationProperties.getProperty(this.iParameterPrefix + "confirm.acr.unitimeDialogName", "Warning Confirmations"), ApplicationProperties.getProperty(this.iParameterPrefix + "confirm.acr.unitimeYesButton", "Accept & Submit"), ApplicationProperties.getProperty(this.iParameterPrefix + "confirm.acr.unitimeNoButton", "Cancel Submit"), ApplicationProperties.getProperty(this.iParameterPrefix + "confirm.acr.unitimeYesButtonTitle", "Accept the above warning(s) and submit the Advisor Course Recommendations"), ApplicationProperties.getProperty(this.iParameterPrefix + "confirm.acr.unitimeNoButtonTitle", "Go back to editing your Advisor Course Recommendations"));
        }
    }
}

