/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.CacheMode;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.model.OnlineSectioningLog;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.dao.OnlineSectioningLogDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;

public class OnlineSectioningLogger
extends Thread {
    private static Log sLog = LogFactory.getLog(OnlineSectioningLogger.class);
    protected static StudentSectioningConstants CONST = Localization.create(StudentSectioningConstants.class);
    private List<OnlineSectioningLog.Action> iActions = new Vector<OnlineSectioningLog.Action>();
    private boolean iActive = false;
    private boolean iEnabled = false;
    private int iLogLimit = -1;
    private PrintWriter iOut = null;
    private static OnlineSectioningLogger sInstance = null;

    public static OnlineSectioningLogger getInstance() {
        if (sInstance == null) {
            OnlineSectioningLogger.startLogger();
        }
        return sInstance;
    }

    public static void startLogger() {
        if (sInstance == null) {
            sInstance = new OnlineSectioningLogger();
            sInstance.start();
        }
    }

    public static void stopLogger() {
        if (sInstance != null) {
            OnlineSectioningLogger.sInstance.iActive = false;
            sInstance.interrupt();
            try {
                sInstance.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            sInstance = null;
        }
    }

    private OnlineSectioningLogger() {
        super("OnlineSectioningLogger");
        this.setDaemon(true);
        this.iEnabled = ApplicationProperty.OnlineSchedulingLoggingEnabled.isTrue();
        this.iLogLimit = ApplicationProperty.OnlineSchedulingLogLimit.intValue();
        try {
            if (ApplicationProperty.OnlineSchedulingLogFile.value() != null) {
                this.iOut = new PrintWriter(new FileWriter(new File(ApplicationProperty.OnlineSchedulingLogFile.value()), true));
            }
        }
        catch (IOException e) {
            sLog.warn((Object)("Unable to create sectioning log: " + e.getMessage()), (Throwable)e);
        }
    }

    public boolean isEnabled() {
        return this.iEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.iEnabled = enabled;
    }

    public boolean isActive() {
        return this.iActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(OnlineSectioningLog.Log log) {
        if (log == null || !this.isEnabled() || !this.isActive()) {
            return;
        }
        for (OnlineSectioningLog.Action action : log.getActionList()) {
            if (!action.hasStartTime() || !action.hasStudent() || !action.hasOperation() || !action.hasSession() || !ApplicationProperty.OnlineSchedulingLogOperation.isTrue(action.getOperation()) || !ApplicationProperty.OnlineSchedulingLogOperation.isTrue(action.getOperation() + "." + (action.hasResult() ? action.getResult().name() : "NULL"))) continue;
            Object object = this.iActions;
            synchronized (object) {
                if (this.iLogLimit <= 0 || this.iActions.size() < this.iLogLimit) {
                    this.iActions.add(action);
                }
            }
            if (this.iOut == null) continue;
            object = this.iOut;
            synchronized (object) {
                this.iOut.print(OnlineSectioningLog.Log.newBuilder().addAction(action).build().toString());
                this.iOut.flush();
            }
        }
    }

    protected static String getRequestMessage(OnlineSectioningLog.Action action) {
        Object request = "";
        int notAlt = 0;
        int lastFT = -1;
        for (OnlineSectioningLog.Request r : action.getRequestCount() > 0 ? action.getRequestList() : action.getRecommendationList()) {
            if (!r.getAlternative()) {
                notAlt = r.getPriority() + 1;
            }
            int idx = 0;
            for (OnlineSectioningLog.Time f : r.getFreeTimeList()) {
                request = idx == 0 ? (String)request + (String)(lastFT == r.getPriority() ? ", " : (((String)request).isEmpty() ? "" : "\n") + (String)(r.getAlternative() ? "A" + (1 + r.getPriority() - notAlt) : String.valueOf(1 + r.getPriority())) + ". " + CONST.freePrefix() + " ") : (String)request + ", ";
                ++idx;
                request = (String)request + DayCode.toString(f.getDays()) + " " + OnlineSectioningLogger.time(f.getStart()) + " - " + OnlineSectioningLogger.time(f.getStart() + f.getLength());
                lastFT = r.getPriority();
            }
            if (!r.getFreeTimeList().isEmpty()) continue;
            for (OnlineSectioningLog.Entity e : r.getCourseList()) {
                request = idx == 0 ? (String)request + (((String)request).isEmpty() ? "" : "\n") + (String)(r.getAlternative() ? "A" + (1 + r.getPriority() - notAlt) : String.valueOf(1 + r.getPriority())) + ". " : (String)request + ", ";
                ++idx;
                request = (String)request + e.getName();
            }
            if (r.getWaitList()) {
                request = (String)request + " (w)";
                continue;
            }
            if (!r.getNoSubs()) continue;
            request = (String)request + " (s)";
        }
        return request;
    }

    protected static String getSelectedMessage(OnlineSectioningLog.Action action) {
        Object selected = "";
        for (OnlineSectioningLog.Request r : action.getRequestList()) {
            for (OnlineSectioningLog.Section s : r.getSectionList()) {
                if (s.getPreference() != OnlineSectioningLog.Section.Preference.SELECTED) continue;
                if (!((String)selected).isEmpty()) {
                    selected = (String)selected + "\n";
                }
                Object loc = "";
                for (OnlineSectioningLog.Entity e : s.getLocationList()) {
                    if (!((String)loc).isEmpty()) {
                        loc = (String)loc + ", ";
                    }
                    loc = (String)loc + e.getName();
                }
                Object instr = "";
                for (OnlineSectioningLog.Entity e : s.getInstructorList()) {
                    if (!((String)instr).isEmpty()) {
                        instr = (String)instr + ", ";
                    }
                    instr = (String)instr + e.getName();
                }
                selected = (String)selected + s.getCourse().getName() + " " + s.getSubpart().getName() + " " + s.getClazz().getName() + " " + (String)(s.hasTime() ? DayCode.toString(s.getTime().getDays()) + " " + OnlineSectioningLogger.time(s.getTime().getStart()) + " - " + OnlineSectioningLogger.time(s.getTime().getStart() + s.getTime().getLength()) : "") + " " + (String)loc;
            }
        }
        return selected;
    }

    protected static String getEnrollmentMessage(OnlineSectioningLog.Action action) {
        OnlineSectioningLog.Enrollment enrl = null;
        Iterator<OnlineSectioningLog.Enrollment> iterator = action.getEnrollmentList().iterator();
        while (iterator.hasNext()) {
            OnlineSectioningLog.Enrollment e;
            enrl = e = iterator.next();
            if (!("check-offering".equals(action.getOperation()) && e.getType() == OnlineSectioningLog.Enrollment.EnrollmentType.COMPUTED || "reload-offering".equals(action.getOperation()) && e.getType() == OnlineSectioningLog.Enrollment.EnrollmentType.COMPUTED) && e.getType() != OnlineSectioningLog.Enrollment.EnrollmentType.REQUESTED) continue;
            break;
        }
        Object enrollment = "";
        if (enrl != null) {
            for (OnlineSectioningLog.Section s : enrl.getSectionList()) {
                if (!s.hasCourse()) continue;
                if (!((String)enrollment).isEmpty()) {
                    enrollment = (String)enrollment + "\n";
                }
                Object loc = "";
                for (OnlineSectioningLog.Entity r : s.getLocationList()) {
                    if (!((String)loc).isEmpty()) {
                        loc = (String)loc + ", ";
                    }
                    loc = (String)loc + r.getName();
                }
                Object instr = "";
                for (OnlineSectioningLog.Entity r : s.getInstructorList()) {
                    if (!((String)instr).isEmpty()) {
                        instr = (String)instr + ", ";
                    }
                    instr = (String)instr + r.getName();
                }
                enrollment = (String)enrollment + s.getCourse().getName() + " " + s.getSubpart().getName() + " " + s.getClazz().getName() + " " + (String)(s.hasTime() ? DayCode.toString(s.getTime().getDays()) + " " + OnlineSectioningLogger.time(s.getTime().getStart()) : "") + " " + (String)loc;
            }
        }
        return enrollment;
    }

    public static String getMessage(OnlineSectioningLog.Action action) {
        Object message = "";
        int level = 1;
        for (OnlineSectioningLog.Message m : action.getMessageList()) {
            if (!m.hasLevel() || !((String)message).isEmpty() && level > m.getLevel().getNumber()) continue;
            if (m.hasText()) {
                message = (String)(level != m.getLevel().getNumber() || ((String)message).isEmpty() ? "" : (String)message + "\n") + m.getText();
                level = m.getLevel().getNumber();
                continue;
            }
            if (!m.hasException()) continue;
            message = (String)(level != m.getLevel().getNumber() || ((String)message).isEmpty() ? "" : (String)message + "\n") + m.getException();
            level = m.getLevel().getNumber();
        }
        if (action.hasResult() && OnlineSectioningLog.Action.ResultType.FAILURE.equals((Object)action.getResult()) && !((String)message).isEmpty()) {
            return message;
        }
        if ("suggestions".equals(action.getOperation())) {
            String selected = OnlineSectioningLogger.getSelectedMessage(action);
            return selected.isEmpty() ? message : selected;
        }
        if ("section".equals(action.getOperation())) {
            String request = OnlineSectioningLogger.getRequestMessage(action);
            return request.isEmpty() ? message : request;
        }
        if ("check-offering".equals(action.getOperation()) && action.hasResult() && !OnlineSectioningLog.Action.ResultType.SUCCESS.equals((Object)action.getResult()) && !((String)message).isEmpty()) {
            return message;
        }
        if ("reload-offering".equals(action.getOperation()) && action.hasResult() && !OnlineSectioningLog.Action.ResultType.SUCCESS.equals((Object)action.getResult()) && !((String)message).isEmpty()) {
            return message;
        }
        String enrollment = OnlineSectioningLogger.getEnrollmentMessage(action);
        if (!enrollment.isEmpty()) {
            return enrollment;
        }
        String request = OnlineSectioningLogger.getRequestMessage(action);
        return request.isEmpty() ? message : request;
    }

    protected static String time(int slot) {
        int h = slot / 12;
        int m = 5 * (slot % 12);
        if (CONST.useAmPm()) {
            return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
        }
        return h + ":" + (m < 10 ? "0" : "") + m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        sLog.info((Object)"Online Sectioning Logger is up.");
        try {
            this.iActive = true;
            do {
                try {
                    OnlineSectioningLogger.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ArrayList<OnlineSectioningLog.Action> actionsToSave = null;
                List<OnlineSectioningLog.Action> list = this.iActions;
                synchronized (list) {
                    if (!this.iActions.isEmpty()) {
                        actionsToSave = new ArrayList<OnlineSectioningLog.Action>(this.iActions);
                        this.iActions.clear();
                    }
                }
                try {
                    if (actionsToSave == null) continue;
                    sLog.debug((Object)("Persisting " + actionsToSave.size() + " actions..."));
                    if (this.iLogLimit > 0 && actionsToSave.size() >= this.iLogLimit) {
                        sLog.warn((Object)("The limit of " + this.iLogLimit + " unpersisted log messages was reached, some messages have been dropped."));
                    }
                    hibSession.setCacheMode(CacheMode.IGNORE);
                    try (org.hibernate.Session hibSession = OnlineSectioningLogDAO.getInstance().createNewSession();){
                        Hashtable<Long, Session> sessions = new Hashtable<Long, Session>();
                        for (OnlineSectioningLog.Action q : actionsToSave) {
                            OnlineSectioningLog log;
                            block34: {
                                String studentExternalId;
                                log = new OnlineSectioningLog();
                                log.setAction(q.toByteArray());
                                log.setOperation(q.getOperation());
                                String string = studentExternalId = q.getStudent().hasExternalId() ? q.getStudent().getExternalId() : null;
                                if (studentExternalId == null || studentExternalId.isEmpty()) {
                                    Student student = (Student)StudentDAO.getInstance().get(q.getStudent().getUniqueId(), hibSession);
                                    if (student == null) continue;
                                    studentExternalId = student.getExternalUniqueId();
                                }
                                log.setStudent(studentExternalId);
                                log.setTimeStamp(new Date(q.getStartTime()));
                                if (q.hasResult()) {
                                    log.setResult(q.getResult().getNumber());
                                }
                                if (q.hasUser() && q.getUser().hasExternalId()) {
                                    log.setUser(q.getUser().getExternalId());
                                }
                                if (q.hasCpuTime()) {
                                    log.setCpuTime(q.getCpuTime());
                                }
                                if (q.hasStartTime() && q.hasEndTime()) {
                                    log.setWallTime(q.getEndTime() - q.getStartTime());
                                }
                                if (q.hasApiGetTime()) {
                                    log.setApiGetTime(q.getApiGetTime());
                                }
                                if (q.hasApiPostTime()) {
                                    log.setApiPostTime(q.getApiPostTime());
                                }
                                if (q.hasApiException()) {
                                    log.setApiException(q.getApiException() != null && q.getApiException().length() > 255 ? q.getApiException().substring(0, 255) : q.getApiException());
                                }
                                try {
                                    String message = OnlineSectioningLogger.getMessage(q);
                                    if (message != null && !message.isEmpty()) {
                                        log.setMessage((String)(message.length() > 255 ? message.substring(0, 252) + "..." : message));
                                    }
                                }
                                catch (Exception e) {
                                    if (q.getMessageList().isEmpty()) break block34;
                                    String message = null;
                                    int level = 0;
                                    for (OnlineSectioningLog.Message m : q.getMessageList()) {
                                        if (message != null && !message.isEmpty() && (!m.hasLevel() || level > m.getLevel().getNumber())) continue;
                                        if (m.hasText()) {
                                            message = m.getText();
                                            level = m.getLevel().getNumber();
                                            continue;
                                        }
                                        if (!m.hasException()) continue;
                                        message = m.getException();
                                        level = m.getLevel().getNumber();
                                    }
                                    if (message == null || message.isEmpty()) break block34;
                                    log.setMessage((String)(message.length() > 255 ? message.substring(0, 252) + "..." : message));
                                }
                            }
                            Long sessionId = q.getSession().getUniqueId();
                            Session session = (Session)sessions.get(sessionId);
                            if (session == null) {
                                session = (Session)SessionDAO.getInstance().get(sessionId, hibSession);
                                sessions.put(sessionId, session);
                            }
                            log.setSession(session);
                            hibSession.persist((Object)log);
                        }
                        hibSession.flush();
                    }
                }
                catch (Throwable t) {
                    sLog.warn((Object)("Failed to save " + actionsToSave.size() + " log actions: " + t.getMessage()), t);
                }
            } while (this.iActive);
        }
        catch (Throwable t) {
            sLog.error((Object)("Online Sectioning Logger failed: " + t.getMessage()), t);
        }
        finally {
            this.iActive = false;
            if (this.iOut != null) {
                this.iOut.flush();
                this.iOut.close();
            }
        }
        sLog.info((Object)"Online Sectioning Logger is down.");
    }
}

