/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.comparators;

import java.util.Comparator;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;

public class SchedulingSubpartComparator
implements Comparator {
    private Long subjectUID;

    public SchedulingSubpartComparator(Long subjectUID) {
        this.subjectUID = subjectUID;
    }

    public SchedulingSubpartComparator() {
        this(null);
    }

    public boolean isParent(SchedulingSubpart s1, SchedulingSubpart s2) {
        SchedulingSubpart p1 = s1.getParentSubpart();
        if (p1 == null) {
            return false;
        }
        if (p1.equals(s2)) {
            return true;
        }
        return this.isParent(p1, s2);
    }

    public int compare(Object o1, Object o2) {
        int cmp;
        SchedulingSubpart s1 = (SchedulingSubpart)o1;
        SchedulingSubpart s2 = (SchedulingSubpart)o2;
        if (!s1.getInstrOfferingConfig().equals(s2.getInstrOfferingConfig())) {
            InstrOfferingConfigComparator cmp2 = new InstrOfferingConfigComparator(this.subjectUID);
            return cmp2.compare(s1.getInstrOfferingConfig(), s2.getInstrOfferingConfig());
        }
        if (this.isParent(s1, s2)) {
            return 1;
        }
        if (this.isParent(s2, s1)) {
            return -1;
        }
        if (s1.getParentSubpart() != null || s2.getParentSubpart() != null) {
            SchedulingSubpart p1 = s1;
            int d1 = 0;
            while (p1.getParentSubpart() != null) {
                p1 = p1.getParentSubpart();
                ++d1;
            }
            SchedulingSubpart p2 = s2;
            int d2 = 0;
            while (p2.getParentSubpart() != null) {
                p2 = p2.getParentSubpart();
                ++d2;
            }
            if (d1 < d2) {
                int cmp3 = this.compare(s1, s2.getParentSubpart());
                if (cmp3 != 0) {
                    return cmp3;
                }
            } else if (d1 > d2) {
                int cmp4 = this.compare(s1.getParentSubpart(), s2);
                if (cmp4 != 0) {
                    return cmp4;
                }
            } else {
                int cmp5 = this.compare(s1.getParentSubpart(), s2.getParentSubpart());
                if (cmp5 != 0) {
                    return cmp5;
                }
            }
        }
        if ((cmp = s1.getItype().getItype().compareTo(s2.getItype().getItype())) != 0) {
            return cmp;
        }
        return s1.getUniqueId().compareTo(s2.getUniqueId());
    }

    public Long getSubjectUID() {
        return this.subjectUID;
    }

    public void setSubjectUID(Long subjectUID) {
        this.subjectUID = subjectUID;
    }
}

