/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.comparators;

import java.util.Comparator;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.util.NameFormat;

public class OfferingCoordinatorComparator
implements Comparator<OfferingCoordinator> {
    private CompareBy iCompareBy = CompareBy.PCT_SHARE;
    private NameFormat iNameFormat = NameFormat.defaultFormat();

    public OfferingCoordinatorComparator() {
    }

    public OfferingCoordinatorComparator(SessionContext cx) {
        if (cx != null && ApplicationProperty.InstructorsDropdownFollowNameFormatting.isTrue()) {
            this.setNameFormat(UserProperty.NameFormat.get(cx.getUser()));
        }
    }

    public OfferingCoordinatorComparator setCompareBy(CompareBy compareBy) {
        this.iCompareBy = compareBy;
        return this;
    }

    public OfferingCoordinatorComparator setNameFormat(NameFormat nf) {
        this.iNameFormat = nf;
        return this;
    }

    public OfferingCoordinatorComparator setNameFormat(String nf) {
        this.iNameFormat = NameFormat.fromReference(nf);
        return this;
    }

    @Override
    public int compare(OfferingCoordinator o1, OfferingCoordinator o2) {
        if (this.iCompareBy == CompareBy.PCT_SHARE && !o1.getPercentShare().equals(o2.getPercentShare())) {
            return o2.getPercentShare().compareTo(o1.getPercentShare());
        }
        int cmp = this.iNameFormat.format(o1.getInstructor()).compareToIgnoreCase(this.iNameFormat.format(o2.getInstructor()));
        if (cmp != 0) {
            return cmp;
        }
        return o1.compareTo(o2);
    }

    public static enum CompareBy {
        NAME,
        PCT_SHARE;

    }
}

