/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.comparators;

import java.util.Comparator;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.util.NameFormat;

public class InstructorComparator
implements Comparator<ClassInstructor> {
    private CompareBy iCompareBy = CompareBy.LEAD;
    private NameFormat iNameFormat = NameFormat.defaultFormat();

    public InstructorComparator() {
    }

    public InstructorComparator(SessionContext cx) {
        if (cx != null && ApplicationProperty.InstructorsDropdownFollowNameFormatting.isTrue()) {
            this.setNameFormat(UserProperty.NameFormat.get(cx.getUser()));
        }
    }

    public InstructorComparator setCompareBy(CompareBy compareBy) {
        this.iCompareBy = compareBy;
        return this;
    }

    public InstructorComparator setNameFormat(NameFormat nf) {
        this.iNameFormat = nf;
        return this;
    }

    public InstructorComparator setNameFormat(String nf) {
        this.iNameFormat = NameFormat.fromReference(nf);
        return this;
    }

    public static int compareStrings(String s1, String s2) {
        return (s1 == null ? "" : s1.toUpperCase()).compareTo(s2 == null ? "" : s2.toUpperCase());
    }

    @Override
    public int compare(ClassInstructor ci1, ClassInstructor ci2) {
        if (ci1.getUniqueId().equals(ci2.getUniqueId())) {
            return 0;
        }
        if (this.iCompareBy == CompareBy.LEAD && !ci1.isLead().equals(ci2.isLead())) {
            return ci1.isLead() != false ? -1 : 1;
        }
        if (!(this.iCompareBy != CompareBy.LEAD && this.iCompareBy != CompareBy.PCT_SHARE || ci1.getPercentShare().equals(ci2.getPercentShare()))) {
            return ci2.getPercentShare().compareTo(ci1.getPercentShare());
        }
        int cmp = this.iNameFormat.format(ci1.getInstructor()).compareToIgnoreCase(this.iNameFormat.format(ci2.getInstructor()));
        if (cmp != 0) {
            return cmp;
        }
        cmp = (ci1.getResponsibility() == null ? "" : ci1.getResponsibility().getAbbreviation()).compareToIgnoreCase(ci2.getResponsibility() == null ? "" : ci2.getResponsibility().getAbbreviation());
        if (cmp != 0) {
            return cmp;
        }
        return ci1.getInstructor().getUniqueId().compareTo(ci2.getInstructor().getUniqueId());
    }

    public static enum CompareBy {
        NAME,
        LEAD,
        PCT_SHARE;

    }
}

