/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAreaClassificationMinor;

@MappedSuperclass
public abstract class BaseStudentAreaClassificationMinor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Student iStudent;
    private AcademicArea iAcademicArea;
    private AcademicClassification iAcademicClassification;
    private PosMinor iMinor;

    public BaseStudentAreaClassificationMinor() {
    }

    public BaseStudentAreaClassificationMinor(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="student_id", nullable=false)
    public Student getStudent() {
        return this.iStudent;
    }

    public void setStudent(Student student) {
        this.iStudent = student;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="acad_area_id", nullable=false)
    public AcademicArea getAcademicArea() {
        return this.iAcademicArea;
    }

    public void setAcademicArea(AcademicArea academicArea) {
        this.iAcademicArea = academicArea;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="acad_clasf_id", nullable=false)
    public AcademicClassification getAcademicClassification() {
        return this.iAcademicClassification;
    }

    public void setAcademicClassification(AcademicClassification academicClassification) {
        this.iAcademicClassification = academicClassification;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="minor_id", nullable=false)
    public PosMinor getMinor() {
        return this.iMinor;
    }

    public void setMinor(PosMinor minor) {
        this.iMinor = minor;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof StudentAreaClassificationMinor)) {
            return false;
        }
        if (this.getUniqueId() == null || ((StudentAreaClassificationMinor)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((StudentAreaClassificationMinor)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "StudentAreaClassificationMinor[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "StudentAreaClassificationMinor[\n\tAcademicArea: " + String.valueOf(this.getAcademicArea()) + "\n\tAcademicClassification: " + String.valueOf(this.getAcademicClassification()) + "\n\tMinor: " + String.valueOf(this.getMinor()) + "\n\tStudent: " + String.valueOf(this.getStudent()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

