/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverParameterGroup;

@MappedSuperclass
public abstract class BaseSolverParameterGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iName;
    private String iDescription;
    private Integer iOrder;
    private Integer iType;
    private Set<SolverParameterDef> iParameters;

    public BaseSolverParameterGroup() {
    }

    public BaseSolverParameterGroup(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="solver_parameter_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="name", nullable=true, length=100)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="description", nullable=true, length=1000)
    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String description) {
        this.iDescription = description;
    }

    @Column(name="ord", nullable=true, length=4)
    public Integer getOrder() {
        return this.iOrder;
    }

    public void setOrder(Integer order) {
        this.iOrder = order;
    }

    @Column(name="param_type", nullable=true, length=10)
    public Integer getType() {
        return this.iType;
    }

    public void setType(Integer type) {
        this.iType = type;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="group", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<SolverParameterDef> getParameters() {
        return this.iParameters;
    }

    public void setParameters(Set<SolverParameterDef> parameters) {
        this.iParameters = parameters;
    }

    public void addToParameters(SolverParameterDef solverParameterDef) {
        if (this.iParameters == null) {
            this.iParameters = new HashSet<SolverParameterDef>();
        }
        this.iParameters.add(solverParameterDef);
    }

    @Deprecated
    public void addToparameters(SolverParameterDef solverParameterDef) {
        this.addToParameters(solverParameterDef);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SolverParameterGroup)) {
            return false;
        }
        if (this.getUniqueId() == null || ((SolverParameterGroup)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((SolverParameterGroup)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "SolverParameterGroup[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "SolverParameterGroup[\n\tDescription: " + this.getDescription() + "\n\tName: " + this.getName() + "\n\tOrder: " + this.getOrder() + "\n\tType: " + this.getType() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

