/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.timetable.model.Script;
import org.unitime.timetable.model.ScriptParameter;
import org.unitime.timetable.model.base.ScriptParameterId;

@MappedSuperclass
@IdClass(value=ScriptParameterId.class)
public abstract class BaseScriptParameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Script iScript;
    private String iName;
    private String iLabel;
    private String iType;
    private String iDefaultValue;

    @Id
    @ManyToOne(optional=false)
    @JoinColumn(name="script_id")
    public Script getScript() {
        return this.iScript;
    }

    public void setScript(Script script) {
        this.iScript = script;
    }

    @Id
    @Column(name="name", length=128)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="label", nullable=true, length=256)
    public String getLabel() {
        return this.iLabel;
    }

    public void setLabel(String label) {
        this.iLabel = label;
    }

    @Column(name="type", nullable=false, length=2048)
    public String getType() {
        return this.iType;
    }

    public void setType(String type) {
        this.iType = type;
    }

    @Column(name="default_value", nullable=true, length=2048)
    public String getDefaultValue() {
        return this.iDefaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.iDefaultValue = defaultValue;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ScriptParameter)) {
            return false;
        }
        ScriptParameter scriptParameter = (ScriptParameter)o;
        if (this.getScript() == null || scriptParameter.getScript() == null || !this.getScript().equals(scriptParameter.getScript())) {
            return false;
        }
        return this.getName() != null && scriptParameter.getName() != null && this.getName().equals(scriptParameter.getName());
    }

    public int hashCode() {
        if (this.getScript() == null || this.getName() == null) {
            return super.hashCode();
        }
        return this.getScript().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        return "ScriptParameter[" + String.valueOf(this.getScript()) + ", " + this.getName() + "]";
    }

    public String toDebugString() {
        return "ScriptParameter[\n\tDefaultValue: " + this.getDefaultValue() + "\n\tLabel: " + this.getLabel() + "\n\tName: " + this.getName() + "\n\tScript: " + String.valueOf(this.getScript()) + "\n\tType: " + this.getType() + "]";
    }
}

