/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Script;
import org.unitime.timetable.model.ScriptParameter;

@MappedSuperclass
public abstract class BaseScript
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iName;
    private String iDescription;
    private String iEngine;
    private String iPermission;
    private String iScript;
    private Set<ScriptParameter> iParameters;

    public BaseScript() {
    }

    public BaseScript(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="name", nullable=false, length=128)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="description", nullable=true, length=1024)
    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String description) {
        this.iDescription = description;
    }

    @Column(name="engine", nullable=false, length=32)
    public String getEngine() {
        return this.iEngine;
    }

    public void setEngine(String engine) {
        this.iEngine = engine;
    }

    @Column(name="permission", nullable=true, length=128)
    public String getPermission() {
        return this.iPermission;
    }

    public void setPermission(String permission) {
        this.iPermission = permission;
    }

    @Column(name="script", nullable=false)
    public String getScript() {
        return this.iScript;
    }

    public void setScript(String script) {
        this.iScript = script;
    }

    @OneToMany(mappedBy="script", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<ScriptParameter> getParameters() {
        return this.iParameters;
    }

    public void setParameters(Set<ScriptParameter> parameters) {
        this.iParameters = parameters;
    }

    public void addToParameters(ScriptParameter scriptParameter) {
        if (this.iParameters == null) {
            this.iParameters = new HashSet<ScriptParameter>();
        }
        this.iParameters.add(scriptParameter);
    }

    @Deprecated
    public void addToparameters(ScriptParameter scriptParameter) {
        this.addToParameters(scriptParameter);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Script)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Script)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Script)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "Script[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "Script[\n\tDescription: " + this.getDescription() + "\n\tEngine: " + this.getEngine() + "\n\tName: " + this.getName() + "\n\tPermission: " + this.getPermission() + "\n\tScript: " + this.getScript() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

