/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.SchedulingSubpart;

@MappedSuperclass
public abstract class BaseSchedulingSubpart
extends PreferenceGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer iMinutesPerWk;
    private Boolean iAutoSpreadInTime;
    private Boolean iStudentAllowOverlap;
    private String iSchedulingSubpartSuffixCache;
    private Long iUniqueIdRolledForwardFrom;
    private ItypeDesc iItype;
    private SchedulingSubpart iParentSubpart;
    private InstrOfferingConfig iInstrOfferingConfig;
    private DatePattern iDatePattern;
    private Set<SchedulingSubpart> iChildSubparts;
    private Set<Class_> iClasses;
    private Set<CourseCreditUnitConfig> iCreditConfigs;

    public BaseSchedulingSubpart() {
    }

    public BaseSchedulingSubpart(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Column(name="min_per_wk", nullable=false, length=4)
    public Integer getMinutesPerWk() {
        return this.iMinutesPerWk;
    }

    public void setMinutesPerWk(Integer minutesPerWk) {
        this.iMinutesPerWk = minutesPerWk;
    }

    @Column(name="auto_time_spread", nullable=false)
    public Boolean isAutoSpreadInTime() {
        return this.iAutoSpreadInTime;
    }

    @Transient
    public Boolean getAutoSpreadInTime() {
        return this.iAutoSpreadInTime;
    }

    public void setAutoSpreadInTime(Boolean autoSpreadInTime) {
        this.iAutoSpreadInTime = autoSpreadInTime;
    }

    @Column(name="student_allow_overlap", nullable=false)
    public Boolean isStudentAllowOverlap() {
        return this.iStudentAllowOverlap;
    }

    @Transient
    public Boolean getStudentAllowOverlap() {
        return this.iStudentAllowOverlap;
    }

    public void setStudentAllowOverlap(Boolean studentAllowOverlap) {
        this.iStudentAllowOverlap = studentAllowOverlap;
    }

    @Column(name="subpart_suffix", nullable=true, length=5)
    public String getSchedulingSubpartSuffixCache() {
        return this.iSchedulingSubpartSuffixCache;
    }

    public void setSchedulingSubpartSuffixCache(String schedulingSubpartSuffixCache) {
        this.iSchedulingSubpartSuffixCache = schedulingSubpartSuffixCache;
    }

    @Column(name="uid_rolled_fwd_from", nullable=true, length=20)
    public Long getUniqueIdRolledForwardFrom() {
        return this.iUniqueIdRolledForwardFrom;
    }

    public void setUniqueIdRolledForwardFrom(Long uniqueIdRolledForwardFrom) {
        this.iUniqueIdRolledForwardFrom = uniqueIdRolledForwardFrom;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="itype", nullable=false)
    public ItypeDesc getItype() {
        return this.iItype;
    }

    public void setItype(ItypeDesc itype) {
        this.iItype = itype;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="parent", nullable=true)
    public SchedulingSubpart getParentSubpart() {
        return this.iParentSubpart;
    }

    public void setParentSubpart(SchedulingSubpart parentSubpart) {
        this.iParentSubpart = parentSubpart;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="config_id", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public InstrOfferingConfig getInstrOfferingConfig() {
        return this.iInstrOfferingConfig;
    }

    public void setInstrOfferingConfig(InstrOfferingConfig instrOfferingConfig) {
        this.iInstrOfferingConfig = instrOfferingConfig;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="date_pattern_id", nullable=true)
    public DatePattern getDatePattern() {
        return this.iDatePattern;
    }

    public void setDatePattern(DatePattern datePattern) {
        this.iDatePattern = datePattern;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="parentSubpart")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<SchedulingSubpart> getChildSubparts() {
        return this.iChildSubparts;
    }

    public void setChildSubparts(Set<SchedulingSubpart> childSubparts) {
        this.iChildSubparts = childSubparts;
    }

    public void addToChildSubparts(SchedulingSubpart schedulingSubpart) {
        if (this.iChildSubparts == null) {
            this.iChildSubparts = new HashSet<SchedulingSubpart>();
        }
        this.iChildSubparts.add(schedulingSubpart);
    }

    @Deprecated
    public void addTochildSubparts(SchedulingSubpart schedulingSubpart) {
        this.addToChildSubparts(schedulingSubpart);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="schedulingSubpart", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Class_> getClasses() {
        return this.iClasses;
    }

    public void setClasses(Set<Class_> classes) {
        this.iClasses = classes;
    }

    public void addToClasses(Class_ class_) {
        if (this.iClasses == null) {
            this.iClasses = new HashSet<Class_>();
        }
        this.iClasses.add(class_);
    }

    @Deprecated
    public void addToclasses(Class_ class_) {
        this.addToClasses(class_);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="subpartOwner", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<CourseCreditUnitConfig> getCreditConfigs() {
        return this.iCreditConfigs;
    }

    public void setCreditConfigs(Set<CourseCreditUnitConfig> creditConfigs) {
        this.iCreditConfigs = creditConfigs;
    }

    public void addToCreditConfigs(CourseCreditUnitConfig courseCreditUnitConfig) {
        if (this.iCreditConfigs == null) {
            this.iCreditConfigs = new HashSet<CourseCreditUnitConfig>();
        }
        this.iCreditConfigs.add(courseCreditUnitConfig);
    }

    @Deprecated
    public void addTocreditConfigs(CourseCreditUnitConfig courseCreditUnitConfig) {
        this.addToCreditConfigs(courseCreditUnitConfig);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof SchedulingSubpart)) {
            return false;
        }
        if (this.getUniqueId() == null || ((SchedulingSubpart)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((SchedulingSubpart)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "SchedulingSubpart[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "SchedulingSubpart[\n\tAutoSpreadInTime: " + this.getAutoSpreadInTime() + "\n\tDatePattern: " + String.valueOf(this.getDatePattern()) + "\n\tInstrOfferingConfig: " + String.valueOf(this.getInstrOfferingConfig()) + "\n\tItype: " + String.valueOf(this.getItype()) + "\n\tMinutesPerWk: " + this.getMinutesPerWk() + "\n\tParentSubpart: " + String.valueOf(this.getParentSubpart()) + "\n\tSchedulingSubpartSuffixCache: " + this.getSchedulingSubpartSuffixCache() + "\n\tStudentAllowOverlap: " + this.getStudentAllowOverlap() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tUniqueIdRolledForwardFrom: " + this.getUniqueIdRolledForwardFrom() + "]";
    }
}

