/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import org.hibernate.annotations.Formula;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.PitCourseOffering;
import org.unitime.timetable.model.PitInstructionalOffering;
import org.unitime.timetable.model.SubjectArea;

@MappedSuperclass
public abstract class BasePitCourseOffering
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iSubjectAreaAbbv;
    private String iCourseNbr;
    private Boolean iIsControl;
    private String iPermId;
    private Integer iProjectedDemand;
    private Integer iNbrExpectedStudents;
    private Integer iDemand;
    private Integer iEnrollment;
    private String iTitle;
    private String iExternalUniqueId;
    private Long iUniqueIdRolledForwardFrom;
    private SubjectArea iSubjectArea;
    private CourseOffering iCourseOffering;
    private PitInstructionalOffering iPitInstructionalOffering;
    private CourseType iCourseType;

    public BasePitCourseOffering() {
    }

    public BasePitCourseOffering(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="point_in_time_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Formula(value=" ( select sa.subject_area_abbreviation from %SCHEMA%.subject_area sa where sa.uniqueid = subject_area_id ) ")
    public String getSubjectAreaAbbv() {
        return this.iSubjectAreaAbbv;
    }

    public void setSubjectAreaAbbv(String subjectAreaAbbv) {
        this.iSubjectAreaAbbv = subjectAreaAbbv;
    }

    @Column(name="course_nbr", nullable=false, length=10)
    public String getCourseNbr() {
        return this.iCourseNbr;
    }

    public void setCourseNbr(String courseNbr) {
        this.iCourseNbr = courseNbr;
    }

    @Column(name="is_control", nullable=false)
    public Boolean isIsControl() {
        return this.iIsControl;
    }

    @Transient
    public Boolean getIsControl() {
        return this.iIsControl;
    }

    public void setIsControl(Boolean isControl) {
        this.iIsControl = isControl;
    }

    @Column(name="perm_id", nullable=true, length=20)
    public String getPermId() {
        return this.iPermId;
    }

    public void setPermId(String permId) {
        this.iPermId = permId;
    }

    @Column(name="proj_demand", nullable=true, length=5)
    public Integer getProjectedDemand() {
        return this.iProjectedDemand;
    }

    public void setProjectedDemand(Integer projectedDemand) {
        this.iProjectedDemand = projectedDemand;
    }

    @Column(name="nbr_expected_stdents", nullable=false, length=10)
    public Integer getNbrExpectedStudents() {
        return this.iNbrExpectedStudents;
    }

    public void setNbrExpectedStudents(Integer nbrExpectedStudents) {
        this.iNbrExpectedStudents = nbrExpectedStudents;
    }

    @Column(name="lastlike_demand", nullable=false, length=10)
    public Integer getDemand() {
        return this.iDemand;
    }

    public void setDemand(Integer demand) {
        this.iDemand = demand;
    }

    @Formula(value="(select count(distinct e.pit_student_id) from %SCHEMA%.pit_student_class_enrl e where e.pit_course_offering_id = uniqueid)")
    public Integer getEnrollment() {
        return this.iEnrollment;
    }

    public void setEnrollment(Integer enrollment) {
        this.iEnrollment = enrollment;
    }

    @Column(name="title", nullable=true, length=200)
    public String getTitle() {
        return this.iTitle;
    }

    public void setTitle(String title) {
        this.iTitle = title;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="uid_rolled_fwd_from", nullable=true, length=20)
    public Long getUniqueIdRolledForwardFrom() {
        return this.iUniqueIdRolledForwardFrom;
    }

    public void setUniqueIdRolledForwardFrom(Long uniqueIdRolledForwardFrom) {
        this.iUniqueIdRolledForwardFrom = uniqueIdRolledForwardFrom;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="subject_area_id", nullable=false)
    public SubjectArea getSubjectArea() {
        return this.iSubjectArea;
    }

    public void setSubjectArea(SubjectArea subjectArea) {
        this.iSubjectArea = subjectArea;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="course_offering_id", nullable=true)
    public CourseOffering getCourseOffering() {
        return this.iCourseOffering;
    }

    public void setCourseOffering(CourseOffering courseOffering) {
        this.iCourseOffering = courseOffering;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="pit_instr_offr_id", nullable=false)
    public PitInstructionalOffering getPitInstructionalOffering() {
        return this.iPitInstructionalOffering;
    }

    public void setPitInstructionalOffering(PitInstructionalOffering pitInstructionalOffering) {
        this.iPitInstructionalOffering = pitInstructionalOffering;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="course_type_id", nullable=true)
    public CourseType getCourseType() {
        return this.iCourseType;
    }

    public void setCourseType(CourseType courseType) {
        this.iCourseType = courseType;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PitCourseOffering)) {
            return false;
        }
        if (this.getUniqueId() == null || ((PitCourseOffering)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((PitCourseOffering)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "PitCourseOffering[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "PitCourseOffering[\n\tCourseNbr: " + this.getCourseNbr() + "\n\tCourseOffering: " + String.valueOf(this.getCourseOffering()) + "\n\tCourseType: " + String.valueOf(this.getCourseType()) + "\n\tDemand: " + this.getDemand() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tIsControl: " + this.getIsControl() + "\n\tNbrExpectedStudents: " + this.getNbrExpectedStudents() + "\n\tPermId: " + this.getPermId() + "\n\tPitInstructionalOffering: " + String.valueOf(this.getPitInstructionalOffering()) + "\n\tProjectedDemand: " + this.getProjectedDemand() + "\n\tSubjectArea: " + String.valueOf(this.getSubjectArea()) + "\n\tTitle: " + this.getTitle() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tUniqueIdRolledForwardFrom: " + this.getUniqueIdRolledForwardFrom() + "]";
    }
}

